
#ifndef __RP_ETC_H__
#define __RP_ETC_H__

#ifdef __cplusplus
extern "C" {
#endif

#define ARM_R_LITTLE 	0
#define ARM_R_BIG		1
#define ARM_W_LITTLE	0
#define ARM_W_BIG		1

#define RP_R_LITTLE 	0
#define RP_R_BIG		1
#define RP_W_LITTLE	0
#define RP_W_BIG	1


#define AUDIO_ENDIAN	0xE010700C

/////////////////////////////////////////////////////////////
//APIs

void GPIO_Set_I2S0();
void SYSC_SetAudioBlockPowerOn();
void SYSC_SetAudioBlockPowerOff(void);
void SYSC_SetAudioEndian(unsigned char bRP_ReadConvert, unsigned char bRP_WriteConvert,
						    unsigned char bARM_ReadConvert, unsigned char bARM_WriteConvert);


u8 AudioEPLL_Set(unsigned int samplingfreq, unsigned int rfs);
char AudioEPLL_SetReturnDividers(unsigned int samplingfreq, unsigned int rfs, unsigned char* pDivI2SA, unsigned char* pPSVAL);

unsigned int EndianConvert(unsigned int Lfoo);

void memcpy2(void* ud, void* us, u32 bs);

#ifdef __cplusplus
}
#endif


#endif //__RP_ETC_H__


