#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "rpetc.h"

//


void memcpy2(void* ud, void* us, u32 bs)
{

#if 0
	unsigned int * pud=(unsigned int * )ud;
	unsigned int* pus=(unsigned int * )us;
	unsigned int bsize=bs;
	while (bsize--) *pud++ = *pus++;
#elif 0
 	memcpy(ud, us, bs);
#elif 0
	_single_memcpy((u32 *)ud, (u32 *)us, bs);
#elif 1
	_burst8_memcpy((u32 *)ud, (u32 *)us, bs);
#endif
}




//0xEA00002A
//input : LittleEndian (EA <<24 | 00<16 | 00<8 | 2A)  or Bigendian
//output : BigEndian   (EA <<0 | 00<8 | 00<16 | 2A<<24) or Little endian
unsigned int EndianConvert(unsigned int Lfoo)
{
#if 1
	unsigned char i1, i2, i3, i4;
	unsigned int BigEndian;
	i1 = (Lfoo>>24);//msb
	i2 = Lfoo>>16;
	i3 = Lfoo>>8;
	i4 = Lfoo>>0;//lsb
	BigEndian = i4<<24 | i3<<16 | i2<<8 | i1;
	return BigEndian;
#else
	return (  Lfoo<<24 | (Lfoo&0xFF00)<<8 | (Lfoo&0xFF0000)>>8 | Lfoo>>24);
#endif
}




u8 AudioEPLL_Set(unsigned int samplingfreq, unsigned int rfs)
{
	u32 uRegValue, uDivider;
	if(samplingfreq == 44100)
	{
		if(rfs==384)
		{

#if 0//fpga	
			uRegValue = (1<<31) | (17<<16) | (0x3<<8) | (0x1<<0); // Fout=34MHz,      44100, 384fs *2
			//[27] vsel, [24:16] m, [13:8] p , [2:0] s
			uDivider=2;
#else//smdk
			uRegValue = (1<<31) | (1<<27) | (271<<16) | (12<<8) | (3<<0); // Fout=67.7376MHz,      44100, 384fs *4
			//[27] vsel, [24:16] m, [13:8] p , [2:0] s
			uDivider=4;
#endif
		}
		else 
		{
			uRegValue = (1<<31) | (11<<16) | (0x3<<8) | (0x1<<0); // Fout=22MHz,      44100, 256fs *2
			uDivider=2;
	//		uRegValue = (1<<31) | (12<<16) | (0x4<<8) | (0x0<<0); // Fout=36MHz,      44000, 256fs *2
	//		uDivider=3;
		}


	} else 	if(samplingfreq == 48000)
	{
		if(rfs==384)
		{
			uRegValue = (1<<31) | (12<<16) | (0x4<<8) | (0x0<<0); // Fout=36MHz,      48000, 384fs *2
			uDivider=2;
		}
		else
		{
			uRegValue = (1<<31) | (8<<16) | (0x4<<8) | (0x0<<0); // Fout=24MHz,      48000, 256fs *2
			uDivider=2;
		}
	} else
	 return 1;

	SYSC_SetPLLReg( eEPLL, uRegValue);
	return uDivider;
}


//DivI2SA : 1~16
//uPSVAL : 1~64
//return 1 : ok.
//return -1 : divider value is overflow
//return -2 : divider value is not made
//return -5 : sampling frequency is not on lists.
char AudioEPLL_SetReturnDividers(unsigned int samplingfreq, unsigned int rfs, unsigned char* pDivI2SA, unsigned char* pPSVAL)
{
	u32 uRegValue, uDivider;
	u8 uDivI2SA, uPSVAL;
	if(samplingfreq == 44100)
	{
		if(rfs==384)
		{
			uRegValue = (1<<31) | (17<<16) | (0x3<<8) | (0x1<<0); // Fout=34MHz,      44100, 384fs *2
			uDivider=2;
		}
		else 
		{
			uRegValue = (1<<31) | (11<<16) | (0x3<<8) | (0x1<<0); // Fout=22MHz,      44100, 256fs *2
			uDivider=2;
	//		uRegValue = (1<<31) | (12<<16) | (0x4<<8) | (0x0<<0); // Fout=36MHz,      44000, 256fs *2
	//		uDivider=3;
		}


	} else 	if(samplingfreq == 48000)
	{
		if(rfs==384)
		{
			uRegValue = (1<<31) | (12<<16) | (0x4<<8) | (0x0<<0); // Fout=36MHz,      48000, 384fs *2
			uDivider=2;
		}
		else
		{
			uRegValue = (1<<31) | (8<<16) | (0x4<<8) | (0x0<<0); // Fout=24MHz,      48000, 256fs *2
			uDivider=2;
		}
	} else
	 return -5;

	if(uDivider<=16) {
		*pDivI2SA =	uDivider;
		*pPSVAL =	1;
	} else 	if(uDivider<=64) {
		*pDivI2SA =	1;
		*pPSVAL =	uDivider;
	} else if(uDivider<=1024) {

		return -2;//implementing...

	} else return -1;

	SYSC_SetPLLReg( eEPLL, uRegValue);
	return 1;
}

#include "gpio.h"

void GPIO_Set_I2S0()
{
#if 0
	Outp32(0xE0200220, 0x2222222);
#else
	u8 bAPmaster = 1;
	u8 bCDCLKout= 1;

	GPIO_SetFunctionEach(eGPIO_I,eGPIO_0,eGFunc_0);//IIS lrclk
	GPIO_SetFunctionEach(eGPIO_I,eGPIO_1,eGFunc_0);//cdlclk
	GPIO_SetFunctionEach(eGPIO_I,eGPIO_2,eGFunc_0);//sclk
	GPIO_SetFunctionEach(eGPIO_I,eGPIO_3,eGFunc_0);//sdi
	GPIO_SetFunctionEach(eGPIO_I,eGPIO_4,eGFunc_0);//sdo[0]

	GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_0,eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_1,eGPUDdis);			
	GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_2,eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_3,eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_4,eGPUDdis);// pull-up/down disable

	if(bCDCLKout) GPIO_SetDSEach(eGPIO_I,eGPIO_1,3);//4X - codec clk out
	else	 	GPIO_SetDSEach(eGPIO_I,eGPIO_1,0);//1X - codec clk in

	if(bAPmaster) GPIO_SetDSEach(eGPIO_I,eGPIO_0,3);//4X - sclk out for Codec primary in case of recording from codec line in
	else	 	GPIO_SetDSEach(eGPIO_I,eGPIO_0,0);//1X - sclk clk in
#endif

}


void GPIO_Set_I2S1()
{
	u8 bAPmaster = 1;
	u8 bCDCLKout= 1;
#if 0
	Outp32(0xE0200060, 0x22222);//gpc0
#else
	Outp32(0xE0200060, 0x22222);//gpc0

	if(bCDCLKout) GPIO_SetDSEach(eGPIO_C0,eGPIO_1,3);//4X - codec clk out
	else	 	GPIO_SetDSEach(eGPIO_C0,eGPIO_1,0);//1X - codec clk in

	if(bAPmaster) GPIO_SetDSEach(eGPIO_C0,eGPIO_0,3);//4X - sclk out for Codec secondary in case of recording from codec line in
 	else GPIO_SetDSEach(eGPIO_C0,eGPIO_0,0);//1X - sclk in
#endif

}

void GPIO_Set_I2S2()
{
	u8 bAPmaster = 1;
	u8 bCDCLKout= 1;
#if 0
	Outp32(0xE0200080, 0x44444);//gpc1
#else
	Outp32(0xE0200080, 0x44444);//gpc1

	if(bCDCLKout) GPIO_SetDSEach(eGPIO_C1,eGPIO_1,3);//4X - codec clk out
	else	 	GPIO_SetDSEach(eGPIO_C1,eGPIO_1,0);//1X - codec clk in

	if(bAPmaster) GPIO_SetDSEach(eGPIO_C1,eGPIO_0,3);//4X - sclk out for Codec secondary in case of recording from codec line in
 	else GPIO_SetDSEach(eGPIO_C1,eGPIO_0,0);//1X - sclk in
#endif
}

void SYSC_SCLK_AUDIO1_EPLL()
{
	Outp32(0xE0100218, 0x70);//clk_src6[7:4] : 0-i2scdclk1, 3-sclk_usbph0, 4-sclk_usbph1, 7-sclk_epll
}

void SYSC_SCLK_AUDIO1_I2S1CDCLKIN()
{
	Outp32(0xE0100218, 0x0);//clk_src6[7:4] : 0-i2scdclk1, 3-sclk_usbph0, 4-sclk_usbph1, 7-sclk_epll
}



void SYSC_SCLK_AUDIO2_EPLL()
{
	Outp32(0xE0100218, 0x700);//clk_src6[11:8] : 0-i2scdclk2, 3-sclk_usbph0, 4-sclk_usbph1, 7-sclk_epll
}

void SYSC_SCLK_AUDIO2_I2S2CDCLKIN()
{
	Outp32(0xE0100218, 0x0);//clk_src6[11:8] : 0-i2scdclk2, 3-sclk_usbph0, 4-sclk_usbph1, 7-sclk_epll
}

//Power on Audio Block at Normal mode and wait.
//NORMAL_CFG[7] : 1 ON, 0 :OFF
void SYSC_SetAudioBlockPowerOn()
{
	unsigned int temp = Inp32(0xE010C010);
	temp |= (1<<7);
	Outp32(0xE010C010, temp);
}



void SYSC_SetAudioBlockPowerOff(void)
{
	unsigned int temp = Inp32(0xE010C010);
	temp &= ~(1<<7);
	Outp32(0xE010C010, temp);
}





// 1 : convert endianness when ARM write to input buffer (Little endian bitstream -> Big endian bitstream which RP can read)
// 0 : do not convert when ARM write to input buffer. (can used by ARM spare area, when RP does not used)
void SYSC_SetAudioEndian(unsigned char bRP_ReadConvert, unsigned char bRP_WriteConvert,
						    unsigned char bARM_ReadConvert, unsigned char bARM_WriteConvert)
{
	unsigned int temp;

	bRP_ReadConvert=(bRP_ReadConvert>1)?0:bRP_ReadConvert;
	bRP_WriteConvert=(bRP_WriteConvert>1)?0:bRP_WriteConvert;
	bARM_ReadConvert=(bARM_ReadConvert>1)?0:bARM_ReadConvert;
	bARM_WriteConvert=(bARM_WriteConvert>1)?0:bARM_WriteConvert;

	temp = bRP_ReadConvert<<3 | bRP_WriteConvert<<2| bARM_ReadConvert<<1 | bARM_WriteConvert;
	Outp32( AUDIO_ENDIAN, temp);

}
