
#ifndef __RPCOMMBOX_H__
#define __RPCOMMBOX_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "assaddr.h"


//defines
#define IBUF_MAX_BYTE	(18*1024)
#define IBUF_MAX_WORD	(IBUF_MAX_BYTE/4)

#define OBUF_MAX_BYTE	(9*1024)
#define OBUF_MAX_WORD	(OBUF_MAX_BYTE/4)

#define IBUF_DRAM_MAX_BYTE		(128*1024)

//Commbox
#define 	RP_INTERRUPT				(COMMBOX+0x00)//added
#define 	RP_INTERRUPT_CODE			(COMMBOX+0x04)//0x4 ==> extended
#define 	RP_PARAM0_INT_INFO			(COMMBOX+0x08)//added
#define 	RP_PARAM1_FRAME_NUM			(COMMBOX+0x0c)
#define 	RP_PARAM2_ERRCODE		(COMMBOX+0x10)//added
#define 	RP_INST_START_ADDR		(COMMBOX+0x14)

#define 	RP_RESET			(COMMBOX+0x100)
#define 	RP_PENDING			(COMMBOX+0x104)
#define 	RP_OBUF_FRAME_WSIZE			(COMMBOX+0x108)//debug

#define 	RP_PAR1_OBUF0_ADDR			(COMMBOX+0x114)
#define 	RP_PAR2_OBUF1_ADDR			(COMMBOX+0x118)
#define 	RP_PAR3_IBITSTREAM0_ADDR		(COMMBOX+0x11C)//added
#define 	RP_PAR4_IBITSTREAM1_ADDR		(COMMBOX+0x120)//added
#define 	RP_PAR5_IBITSTREAM_BSIZE			(COMMBOX+0x124)//added
#define 	RP_PAR6_BITSTREAM_TOT_BSIZE			(COMMBOX+0x128)
#define 	RP_PAR7_RP_BOOTINTERNAL		(COMMBOX+0x12C)

#define 	RP_PAR8_OS_SAMPLE_FREQ				(COMMBOX+0x130)
#define 	RP_PAR9_SW_STOP_WMA_INFO		(COMMBOX+0x134)
#define 	RP_PAR10_PCM_TYPE		(COMMBOX+0x138)//-> read from I2S reg.

#define 	RP_ENDIAN_CONVERTER		(COMMBOX+0x208)



//Defines for following functions.
//void RP_SetCommbox(...)
// bit defines was wrong, but when rp set i2s blc_s  mixer mixed 24bit rp + 16bit os => 16bit out. so it worked.
// correction like below is needed
#define RP_PCM_24BIT	1
#define RP_PCM_16BIT	0
#define RP_PCM_8BIT	2
#define RP_IMEM_ADDR_NULL	0


//void RP_Reset(unsigned char bBootfromInternal)
#define RP_InstCodeAtIMEM	1
#define RP_InstCodeAtDRAM	0

	
/////////////////////////////////////////////////////////////
//APIs
void RP_ClearIntReadIntCode(unsigned int * pcurrIntCode, unsigned int * pcurrIntInfo);
void RP_SetCommbox(
				unsigned int uBitstreamBsize, unsigned char uPcm_Bit, //Input bitstream information
				unsigned int uAddrInputBuff0,unsigned int uAddrInputBuff1, unsigned int uBsizeInputBuff,//input buffer informations
				unsigned int uImemAddrDram//fill when it is needed
				);
void RP_Reset(unsigned char bBootfromInternal);
void RP_StartRunning();

#ifdef __cplusplus
}
#endif


#endif //__RPCOMMBOX_H__


