#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"

#include "assaddr.h"
#include "rpcommbox.h"
//



//this function clear interrupt pending, return  interrupt code and informations
void RP_ClearIntReadIntCode(unsigned int * pcurrIntCode, unsigned int * pcurrIntInfo)
{
	Outp32( RP_INTERRUPT, 0);//,  0: clear interrupt	

	*pcurrIntCode=Inp32( RP_INTERRUPT_CODE);
	*pcurrIntInfo=Inp32( RP_PARAM0_INT_INFO);
}



// call this function at first for init, reset RP
// and also call this function playing another song after finishing one song.
//
//ex : RP_Reset(RP_InstCodeAtIMEM);
void RP_Reset(unsigned char bBootfromInternal)
{
	Outp32( RP_PENDING, 1);
	Outp32( RP_PAR7_RP_BOOTINTERNAL, bBootfromInternal);//set boot mode prior to reset
	Outp32( RP_RESET, 0x0);
}


//uPcm_Bit : 0-16bit  1-24bit  2-8bit
//	RP_PCM_24BIT / RP_PCM_16BIT / RP_PCM_8BIT
//
//uImemAddrDram : >0 , instrunction bianry is located in the dram.  
//				  : RP_IMEM_ADDR_NULL , instruction binary is located in IMEM
void RP_SetCommbox(
				unsigned int uBitstreamBsize, unsigned char uPcm_Bit, //Input bitstream information
				unsigned int uAddrInputBuff0,unsigned int uAddrInputBuff1, unsigned int uBsizeInputBuff,//input buffer informations
				unsigned int uImemAddrDram//fill when it is needed
				)
{
	//init for rp refer, arm refer)
	Outp32( RP_PAR9_SW_STOP_WMA_INFO, 0);//added 090319 - SW sol - since wma info for random access, make aac/mp3 exit
	Outp32( RP_PARAM1_FRAME_NUM, 0);//added 090322 - AP

	Outp32( RP_PAR1_OBUF0_ADDR, OBUF0_ADDR);
	Outp32( RP_PAR2_OBUF1_ADDR, OBUF1_ADDR);
	Outp32( RP_PAR3_IBITSTREAM0_ADDR, uAddrInputBuff0);
	Outp32( RP_PAR4_IBITSTREAM1_ADDR, uAddrInputBuff1);//
	Outp32( RP_PAR5_IBITSTREAM_BSIZE, uBsizeInputBuff);
	Outp32( RP_PAR6_BITSTREAM_TOT_BSIZE, uBitstreamBsize);
	//Outp32( RP_PAR7_RP_BOOTINTERNAL, 0 or 1);	//already set when doing rp resetinit
	if(uImemAddrDram!=RP_IMEM_ADDR_NULL)	Outp32( RP_INST_START_ADDR, uImemAddrDram);

	//[1:0] - b'00 : 44100Hz, b'01 : 48000 Hz
	//Outp32( RP_PAR8_OS_SAMPLE_FREQ, uOSsamplingFreq);//9. ARM let RP know Current OS Sampling Frequency
	Outp32( RP_PAR10_PCM_TYPE, uPcm_Bit);
}



//Set just before starting RP
void RP_StartRunning()
{
	Outp32( RP_PENDING, 0x0);//RP_PENDING
}
