#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"

#include "rpetc.h"
#include "pcmutils.h"
#include "audiocodecs.h"

#include "assclkcon.h"
#include "i2sv5_1.h"


//Test defines
#include "i2sv5_1_test.h"

//pri tx polling (ok)
//24ch 2ch  master epll out
void TestI2Sv5_1_testcase11()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
	AudioEPLL_Set(44100,384);
	//AudioEPLL_SetReturnDividers(samplefreq, 384, &DivI2SA, &prescalervalue);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	//AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_Main_CLK);
	//AudioSS_CLKCON_SetDivider(DivI2SA-1,1-1);//(i2sclk, audio bus)
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 24, RFS_384fs, BFS_32fs, CDCLK_Out, 1-1);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 24, RFS_NA, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}


//pri tx polling (ok)
//16ch 2ch master cdclk in, xxti operating
void TestI2Sv5_1_testcase22()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_IISCDCLK0);
	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	//AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_I2S_iCLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}


//pri tx polling 
//16ch 2ch slave cdclk in, xxti operating

// add capacitor to lrclk is needed!!! for EVT0
void TestI2Sv5_1_testcase43()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS);//I2SCLK gating.
//	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
//	AudioSS_CLKCON_SetTypicalConf(I2S_Slave, MOUTI2SA_GATING);
//	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_Main_CLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2STX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   0, 16, RFS_256fs, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}


// 12Mhz osc , Codec pll, ap slave. - 48000 Hz
void TestI2Sv5_1_testcase41()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
//	AudioSS_CLKCON_SetTypicalConf(I2S_Slave, MOUTI2SA_GATING);
//	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);

	AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_Main_CLK);


	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2STX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   48000, 16, RFS_256fs, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}


// 24Mhz xclkout , Codec pll ,ap slave. - 44100 Hz
void TestI2Sv5_1_testcase42()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	Outp32(0xE0100500, 0x12001);//XUSBXTI, enable.
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
//	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS);//I2SCLK gating.
//	AudioSS_CLKCON_SetTypicalConf(I2S_Slave, MOUTI2SA_GATING);
//	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);

	AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_Main_CLK);


	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2STX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   44100, 16, RFS_256fs, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}




//rx polling(ok)
void TestI2Sv5_1_testcase54()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS);//I2SCLK gating.
	AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_Main_CLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2SRX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMInwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   0, 16, RFS_256fs, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_LinkStart();	
	I2Sv5_1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif

}



void TestI2Sv5_1_testcase53()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_IISCDCLK0);
	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	//AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_I2S_iCLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2SRX, I2SFormat, 0, 0, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMInwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_LinkStart();	
	I2Sv5_1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif

}



