#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"

#include "rpetc.h"
#include "pcmutils.h"
#include "audiocodecs.h"

#include "assclkcon.h"
#include "i2sv5_1.h"


//Test defines
#include "i2sv5_1_test.h"



#include "SfrReadWriten.h"

REGINFOn		sRegInfoI2S0[] = 
{ 
    //01234567890123                 
	{"rIISCON0 [17]- interrupt status ",	0xeee30000, 31-1, RW, 0x8040Ce00, DPPB, 0x797007f,0},		
	{"rIISMOD0  			",	0xeee30004, 32-1, RW, 0x0  , DPPB, 0xDF3F7FFE,0},
	{"rIISFIC0  			",	0xeee30008, 31-1, RW, 0x0  , DPPB, 0x00008080,0},	
	{"rIISPSR0  			",	0xeee3000c, 16-1, RW, 0x0  , DPPB, 0xbf00,0},
	{"rIISTXD0  			",	0xeee30010, 32-1, WO, 0x0  , DPDB, 0,0},	
	{"rIISRXD0  			",	0xeee30014, 32-1, RO, 0x0  , DPDB, 0,0},	
	{"rIISFICS0  			",	0xeee30018, 16-1, RW, 0x0  , DPPB, 0x8000,0},
	{"rIISTXDS0  			",	0xeee3001C, 32-1, WO, 0x0  , DPDB, 0,0},	
	{"rIISAHB0  			",	0xeee30020, 28-1, RW, 0x0  , DPPB, 0xf0f006b,0},
	{"rIISSTR0  			",	0xeee30024, 32-1, RW, 0x0  , DPDB, 0,0},	
	{"rIISSIZE0  			",	0xeee30028, 32-16, RW, 0x7fff0000  , DPPB, 0xFFFF0000,0},	
	{"rIISTRNCNT0 		",	0xeee3002c, 24-1, RO, 0x0  , DPDB, 0,0},	
	{"rIISLVLADDR0 		",	0xeee30030, 32-1, RW, 0x0  , DPPB, 0x1,0},	
	{"rIISLVLADDR1 		",	0xeee30034, 32-1, RW, 0x0  , DPPB, 0x1,0},	
	{"rIISLVLADDR2 		",	0xeee30038, 32-1, RW, 0x0  , DPPB, 0x1,0},	
	{"rIISLVLADDR3 		",	0xeee3003c, 32-1, RW, 0x0  , DPPB, 0x1,0},	

	{"rIISSTR1  			",	0xeee30040, 32-1, RW, 0x0  , DPDB, 0,0},	
};
// I2S v5.1 SFR test
//
void TestI2Sv5_1_testcase0(void)
{

	Outp32( AUDIO_ENDIAN, 0x0);//ENDIAN_MUX

	Outp32( ASS_CLK_GATE, 0x7F);//
	Outp32(ASS_CLK_SRC, 0x0);//
	Outp32(ASS_CLK_DIV, 0x0);//

	Outp32( IIS_CON, 0);//reset
	Outp32( IIS_CON, 1<<31);//set

	TestSFRn(sRegInfoI2S0, sizeof(sRegInfoI2S0)/sizeof(REGINFOn));
}


//pri tx polling (ok)
//16ch 2ch  master epll out
void TestI2Sv5_1_testcase1()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
	AudioEPLL_Set(44100,384);
	//AudioEPLL_SetReturnDividers(samplefreq, 384, &DivI2SA, &prescalervalue);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	//AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_Main_CLK);
	//AudioSS_CLKCON_SetDivider(DivI2SA-1,1-1);//(i2sclk, audio bus)
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 1-1);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}



//pri tx polling (ok)
//16ch 2ch master cdclk in, xxti operating
void TestI2Sv5_1_testcase2()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_IISCDCLK0);
	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	//AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_I2S_iCLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}



//pri tx polling (ing...)
//16ch 2ch  slave epll out
//
// add capacitor to lrclk is needed!!! for EVT0
void TestI2Sv5_1_testcase3()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
	AudioEPLL_Set(44100,384);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_Main_CLK);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out,0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   0, 16, RFS_384fs, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}



//pri tx polling 
//16ch 2ch slave cdclk in, xxti operating

// add capacitor to lrclk is needed!!! for EVT0
void TestI2Sv5_1_testcase4()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&samplefreq,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS);//I2SCLK gating.
//	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
//	AudioSS_CLKCON_SetTypicalConf(I2S_Slave, MOUTI2SA_GATING);
//	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_Main_CLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   0, 16, RFS_384fs, 0xff);//SampleRate-0

#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
#endif

}



//rx polling(ok.)
void TestI2Sv5_1_testcase5()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2SRX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMInwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_LinkStart();	
	I2Sv5_1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif

}




//rx polling(ok)
void TestI2Sv5_1_testcase51()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Slave, I2SRX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMInwithVol(PRIMARY_PORT, I2S_Master, I2SFormat,   0, 16, RFS_384fs, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_LinkStart();	
	I2Sv5_1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif

}


void TestI2Sv5_1_testcase52()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_IISCDCLK0);
	AudioSS_CLKCON_ChangeCLKMUX(MUX_XXTI);
	//AudioSS_CLKCON_SetSource(MUX_XXTI, Main_CLK, MUXI2SA_I2S_iCLK);
	AudioSS_CLKCON_SetDivider(1-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2SRX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMInwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_LinkStart();	
	I2Sv5_1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif

}




//sec tx polling (ok)
void TestI2Sv5_1_testcase6()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	I2SV5_1_Init_TXsecondary(16, OPMUX_APB);
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXsecondaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Secondary(pcmdataaddr, pcmdatasizeb/4);
#endif

}

 
//pri tx polling
//16bit 5.1ch
void TestI2Sv5_1_testcase7()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 1, 1, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);
#endif

}



//pri tx polling
//24bit 5.1ch
void TestI2Sv5_1_testcase8()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//system setting
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 1, 1, 24, RFS_384fs, BFS_48fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 24, RFS_NA, 0xff);//SampleRate-0

	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
#if I2S0_TEST==I2S0_DMA
	TZPC_NonSecureInit();
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);
#else
	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);
#endif
}




////////////////////////////////////////////////////////////////////
//
// auto test
//
////////////////////////////////////////////////////////////////////
extern unsigned int ptada[];

//pri tx polling
void TestI2Sv5_1_autotestTXPollingcore()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//include from header
	j=2;//totch
	samplefreq=22050;//samplerate,
	k=16;//bitperch,
	pcmdatasizeb=171008;
	pcmdataaddr=(unsigned int)&ptada;

	AudioEPLL_Set(44100,384);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	//AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_Main_CLK);
	//AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)-fpga
	AudioSS_CLKCON_SetDivider(8-1,1-1);//(i2sclk, audio bus)-smdk.

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	I2SV5_1_Fill_TXprimaryBuffer(&pcmdataaddr, &pcmdatasizeb);	
	I2SV5_1_LinkStart();	
	I2Sv5_1_playbyCPU_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)
}



//pri tx DMA core
//16ch 2ch  master epll out
void TestI2Sv5_1_autotestTXDMAcore()
{
	unsigned int pcmdataaddr;	unsigned int pcmdatasizeb;
	unsigned int  samplefreq;
	unsigned short j,k;
	unsigned char DivI2SA, prescalervalue;//1~16, 1~64

	TZPC_NonSecureInit();

	//system setting
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	//include from header
	j=2;//totch
	samplefreq=22050;//samplerate,
	k=16;//bitperch,
	pcmdatasizeb=171008;
	pcmdataaddr=(unsigned int)&ptada;


	AudioEPLL_Set(44100,384);

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	//AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_Main_CLK);
	//AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)-fpga
	AudioSS_CLKCON_SetDivider(8-1,1-1);//(i2sclk, audio bus)-smdk.

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0

	//dma set, link start 
	I2Sv5_1_playbyDMA_Primary(pcmdataaddr, pcmdatasizeb/4);//16 bitok, 24bit ok. (big/little)

}




#include "Autotest_api.h"



//pri tx polling (ok)
//16ch 2ch  master epll out
bool TestI2Sv5_1_autotest()
{
	Disp("\n***************************");
	Disp("\nSMDK CFG pin Check");
	Disp("\n***************************");
	Disp("\n set CFGB11  : [off][on][on][off][off][off]");	


	TestI2Sv5_1_autotestTXPollingcore();


	return AUTO_askresult(-1, "Did you hear the tada sound playing?");
}




//pri tx DMA
//16ch 2ch  master epll out
bool TestI2Sv5_1_autotest2()
{
	Disp("\n***************************");
	Disp("\nSMDK CFG pin Check");
	Disp("\n***************************");
	Disp("\n2. CFGB11  : [off][on][on][off][off][off]");	

	TestI2Sv5_1_autotestTXDMAcore();

	return AUTO_askresult(-1, "Did you hear the tada sound playing?");
}




