
#ifndef __I2SV5_1_TEST_H__
#define __I2SV5_1_TEST_H__

#ifdef __cplusplus
extern "C" {
#endif

//#define PCM_IN_WAVEFILE_ADDRESS	0x44200000
#define PCM_IN_WAVEFILE_ADDRESS	0x42000000

#define I2S0_POLLING 0
#define I2S0_DMA 	1

#define I2S0_TEST I2S0_DMA

extern void TZPC_NonSecureInit(void);


#define I2S0_TXP_FIFO_EMPTY 32
extern void I2Sv5_1_playbyCPU_Primary(u32 uPcmDataAddr, u32 uPcmDataWSize);
#define I2S0_RX_FIFO_FULL	8
extern void I2Sv5_1_recbyCPU(u32 uPcmDataAddr, u32 uPcmDataWSize);

#define I2S0_TXS_FIFO_EMPTY	16
extern void I2Sv5_1_playbyCPU_Secondary(u32 uPcmDataAddr, u32 uPcmDataWSize);

extern unsigned int g_I2S0PlayTXPDone ;
extern unsigned int g_I2S0RecDone ;
extern unsigned int g_I2S0PlayTXSDone ;
extern DMAC 		oI2S0DmaTXP;
extern DMAC 		oI2S0DmaRX;
extern DMAC 		oI2S0DmaTXS;
extern void __irq ISR_I2Sv5_1_DMAPlayDone(void);
extern void I2Sv5_1_playbyDMA_Primary(u32 uPcmDataAddr, u32 uPcmDataWSize);
extern void __irq ISR_I2Sv5_1_DMARecDone(void);
extern void I2Sv5_1_recbyDMA(u32 uPcmDataAddr, u32 uPcmDataWSize);





///////////////////////////////////////////////////////////////////
//     test cases
//

//Basic test : i2sv5_1_test1.c
extern void TestI2Sv5_1_testcase0();
extern void TestI2Sv5_1_testcase1();
extern void TestI2Sv5_1_testcase3();
extern void TestI2Sv5_1_testcase5();
extern void TestI2Sv5_1_testcase51();
extern void TestI2Sv5_1_testcase6();
extern void TestI2Sv5_1_testcase7();
extern void TestI2Sv5_1_testcase8();
extern void TestI2Sv5_1_testcase2();
extern void TestI2Sv5_1_testcase4();
extern void TestI2Sv5_1_testcase52();
extern void TestI2Sv5_1_autotestTXPollingcore();
extern u8 APP_PlayingWavFileUsingAudioSubSysemAuto();
extern void TestI2Sv5_1_autotestTXDMAcore();

//Detail test : i2sv5_1_test2.c
extern void TestI2Sv5_1_testcase22();
extern void TestI2Sv5_1_testcase53();
extern void TestI2Sv5_1_testcase43();
extern void TestI2Sv5_1_testcase54();
extern void TestI2Sv5_1_testcase41();
extern void TestI2Sv5_1_testcase42();
extern void TestI2Sv5_1_testcase11();



#ifdef __cplusplus
}
#endif


#endif //__I2SV5_1_TEST_H__


