#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"

#include "rpetc.h"
#include "pcmutils.h"
#include "audiocodecs.h"

#include "assclkcon.h"
#include "i2sv5_1.h"

//Test defines
#include "i2sv5_1_test.h"

#if 1
#define I2S0_TX_NUM_PDMA	NUM_PDMA0
#define I2S0_TX_DMA_CH	DMA_07
#define I2S0_RX_NUM_PDMA	NUM_PDMA1
#define I2S0_RX_DMA_CH	DMA_10
#define I2S0_TXS_NUM_PDMA	NUM_PDMA1
#define I2S0_TXS_DMA_CH	DMA_11
#else
#define I2S0_TX_NUM_PDMA	NUM_PDMA1
#define I2S0_TX_DMA_CH	DMA_10
#define I2S0_RX_NUM_PDMA	NUM_PDMA0
#define I2S0_RX_DMA_CH	DMA_07
#define I2S0_TXS_NUM_PDMA	NUM_PDMA0
#define I2S0_TXS_DMA_CH	DMA_06
#endif

//
//polling
void I2Sv5_1_playbyCPU_Primary(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	unsigned int temp;
	unsigned int * pPcmAddr = (unsigned int *)uPcmDataAddr;
	int i,j;


	j=0;
	while(uPcmDataWSize>I2S0_TXP_FIFO_EMPTY)//ok
	{
		do {
			temp=Inp32 ( IIS_FIC);			
		} while (((temp>>8)&0x7F) >I2S0_TXP_FIFO_EMPTY);//fifocnt = temp>>8;

		for(i=0;i<I2S0_TXP_FIFO_EMPTY;i++)  Outp32( IIS_TXD, *pPcmAddr++);
		uPcmDataWSize=uPcmDataWSize-I2S0_TXP_FIFO_EMPTY;
		j++;
		if(j%100==0) Disp(".");
	}
}


unsigned int g_I2S0PlayTXPDone ;
unsigned int g_I2S0RecDone ;
unsigned int g_I2S0PlayTXSDone ;
DMAC 		oI2S0DmaTXP;
DMAC 		oI2S0DmaRX;
DMAC 		oI2S0DmaTXS;
void __irq ISR_I2Sv5_1_DMAPlayDone(void)
{
	u32 uDmaIntStatus;
		
	INTC_Disable(I2S0_TX_NUM_PDMA);
	UART_Printf("\n[OUT DMA DONE !]");
	
	// Interrupt Clear
	DMA_GetIntrSrc(&uDmaIntStatus, &oI2S0DmaTXP);
	DMA_ClearIntPending(uDmaIntStatus, &oI2S0DmaTXP);
	DMA_StopCh( &oI2S0DmaTXP );
	INTC_ClearVectAddr();

	g_I2S0PlayTXPDone = 1;

}

void I2Sv5_1_playbyDMA_Primary1(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	s8 uChar;
	g_I2S0PlayTXPDone=0;	

	Disp("[IRQ setting]\n");	
//	INTC_ClearVectAddr();
	INTC_SetVectAddr(I2S0_TX_NUM_PDMA ,ISR_I2Sv5_1_DMAPlayDone);
	INTC_Enable(I2S0_TX_NUM_PDMA);

	Disp("[DMA setting]\n");
	DMA_SetCh(I2S0_TX_DMA_CH,&oI2S0DmaTXP);
	DMA_InitCh(WORD , I2S0_TX, DMA_M2P, SINGLE, &oI2S0DmaTXP);
#if 0
	I2SV5_1_ActiveEXTDMA(1, 0, 0);//TX_P
	DMA_StartCh((u32)uPcmDataAddr, (u32)IIS_TXD,uPcmDataWSize, &oI2S0Dma);
	I2SV5_1_Wait_TXprimaryBufferFull();
	I2SV5_1_LinkStart();	
#else
	I2SV5_1_ActiveEXTDMA(1, 0, 0);//TX_P
	I2SV5_1_LinkStart();	
	DMA_StartCh((u32)uPcmDataAddr, (u32)IIS_TXD,uPcmDataWSize, &oI2S0DmaTXP);
#endif
	
	Disp("playing started\n");
	Disp("playing...\n");	
	while(g_I2S0PlayTXPDone==0)
	{		
		uChar = UART_GetKey();
		
		if( (uChar == 'x') | (uChar == 'X'))  
		{
			Disp("User Break~!!\n");
			break;
		}	
	}
	
	Disp("playing finished\n");
	;//wait until fifo emtpy.
	//Outp32( I2S1_CON, 0);	
	DMA_StopCh( &oI2S0DmaTXP );

}



void I2Sv5_1_playbyDMA_Primary(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	s8 uChar;
	g_I2S0PlayTXPDone=0;	

	Disp("[IRQ setting]\n");	
//	INTC_ClearVectAddr();
	INTC_SetVectAddr(I2S0_TX_NUM_PDMA ,ISR_I2Sv5_1_DMAPlayDone);
	INTC_Enable(I2S0_TX_NUM_PDMA);

	Disp("[DMA setting]\n");
	DMA_SetCh(I2S0_TX_DMA_CH,&oI2S0DmaTXP);
	DMA_InitCh(WORD , I2S0_TX, DMA_M2P, SINGLE, &oI2S0DmaTXP);

	Disp("[I2S0 start play]\n");
	I2SV5_1_ActiveEXTDMA(1, 0, 0);//TX_P
	I2SV5_1_LinkStart();	

	DMA_StartCh((u32)uPcmDataAddr, (u32)IIS_TXD,uPcmDataWSize*4, &oI2S0DmaTXP);//must be byte size from new function
	
	Disp("playing started\n");
	Disp("playing...\n");	
	while(g_I2S0PlayTXPDone==0)
	{		
		uChar = UART_GetKey();
		
		if( (uChar == 'x') | (uChar == 'X'))  
		{
			Disp("User Break~!!\n");
			break;
		}	
	}
	
	Disp("playing finished\n");
	;//wait until fifo emtpy.
	//Outp32( IIS_CON, 0);
	DMA_StopCh( &oI2S0DmaTXP );
}


void __irq ISR_I2Sv5_1_DMARecDone(void)
{
	u32 uDmaIntStatus;

	INTC_Disable(I2S0_RX_NUM_PDMA);

	g_I2S0RecDone = 1;
	
	// Interrupt Clear
	DMA_GetIntrSrc(&uDmaIntStatus, &oI2S0DmaRX);
	DMA_ClearIntPending(uDmaIntStatus, &oI2S0DmaRX);
	DMA_StopCh( &oI2S0DmaRX ); // Stop DMA	
	INTC_ClearVectAddr();

}


void I2Sv5_1_recbyDMA(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	s8 uChar;
	g_I2S0RecDone=0;	

	Disp("[IRQ setting]\n");	
	INTC_SetVectAddr(I2S0_RX_NUM_PDMA ,ISR_I2Sv5_1_DMARecDone);
	INTC_Enable(I2S0_RX_NUM_PDMA);

	Disp("[DMA setting]\n");
	DMA_SetCh(I2S0_RX_DMA_CH,&oI2S0DmaRX);
	DMA_InitCh(WORD , I2S0_RX, DMA_P2M, SINGLE, &oI2S0DmaRX);
	I2SV5_1_ActiveEXTDMA(0, 0, 1);//RX
	I2SV5_1_LinkStart();	

	DMA_StartCh((u32)IIS_RXD, (u32)uPcmDataAddr, uPcmDataWSize, &oI2S0DmaRX);
	
	Disp("recording started\n");
	Disp("recording...\n");	
	while(g_I2S0RecDone==0)
	{		
		uChar = UART_GetKey();
		
		if( (uChar == 'x') | (uChar == 'X'))  
		{
			Disp("User Break~!!\n");
			break;
		}	
	}
	
	Disp("playing finished\n");
	;//wait until fifo emtpy.
	Outp32( IIS_CON, 0x80000000);	
	DMA_StopCh( &oI2S0DmaRX );
}




//polling
void I2Sv5_1_recbyCPU(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	unsigned int temp;
	unsigned int * pPcmAddr = (unsigned int *)uPcmDataAddr;
	int i,j;

	j=0;
	while(uPcmDataWSize>I2S0_RX_FIFO_FULL)//ok
	{
		do {
			temp=Inp32 ( IIS_FIC);			
		} while ((temp&0x7F) <I2S0_RX_FIFO_FULL); //wait until for RX fifo is full more than 8 words
		
		for(i=0;i<I2S0_RX_FIFO_FULL;i++)  *pPcmAddr++=Inp32( IIS_RXD);
		uPcmDataWSize=uPcmDataWSize-I2S0_RX_FIFO_FULL;
		j++;
		if(j%400==0) Disp(".");
	}

}

//
//polling
void I2Sv5_1_playbyCPU_Secondary(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	unsigned int temp;
	unsigned int * pPcmAddr = (unsigned int *)uPcmDataAddr;
	int i,j;

	j=0;
	while(uPcmDataWSize>I2S0_TXS_FIFO_EMPTY)//ok
	{
		do {
			temp=Inp32 ( IIS_FICS);			
		} while (((temp>>8)&0x7F) >I2S0_TXS_FIFO_EMPTY);//fifocnt = temp>>8;

		for(i=0;i<I2S0_TXS_FIFO_EMPTY;i++)  Outp32( IIS_TXDS, *pPcmAddr++);
		uPcmDataWSize=uPcmDataWSize-I2S0_TXS_FIFO_EMPTY;
		j++;
		if(j%100==0) Disp(".");
	}
}


void dummyi2s0fn() 
{
}

////////////////////////////////////////////////////////////////////
//
// test call function
//
////////////////////////////////////////////////////////////////////

const testFuncMenu g_aI2S0TestFunc[] =
{	
//Basic test : i2sv5_1_test1.c
	dummyi2s0fn,						"///////// Basic test  //////// ",
	TestI2Sv5_1_testcase0,				"I2S0 SFR R/W test    ",

	//playing : EPLL
	TestI2Sv5_1_testcase1,				"PRIM Master TxP 384fs ( epll out / EPLL Audio SS)    ",
	TestI2Sv5_1_testcase3,				"PRIM Slave Tx 384fs ( epll out / EPLL Audio SS)    ",
	TestI2Sv5_1_testcase5,				"PRIM Master Rx 384fs ( epll out / EPLL Audio SS)    ",
	TestI2Sv5_1_testcase51,				"PRIM Slave Rx 384fs ( epll out / EPLL Audio SS)    ",

	TestI2Sv5_1_testcase6,				"PRIM Master TxS 44100Hz 384fs ( epll out / EPLL Audio SS)    ",
	TestI2Sv5_1_testcase7,				"PRIM Master Tx 384fs 32fs 16bit 5.1ch ( epll out / EPLL Audio SS)    ",
	TestI2Sv5_1_testcase8,				"PRIM Master Tx 384fs 48fs 24bit 5.1ch ( epll out / EPLL Audio SS)    ",	

	//playing : CDCLK in (44.1Khz)
	TestI2Sv5_1_testcase2,				"PRIM Master TxP 44100Hz 384fs ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase4,				"PRIM Slave Tx 44100Hz 384fs ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase52,				"PRIM Master Rx 44100Hz 384fs ( CDCLK in/XTI Audio SS)    ",

	//autotest
	TestI2Sv5_1_autotestTXPollingcore,	"autotest polling",
	APP_PlayingWavFileUsingAudioSubSysemAuto, "autotest idma",
	TestI2Sv5_1_autotestTXDMAcore,		"autotest dma",

//Detail test : i2sv5_1_test2.c
	dummyi2s0fn,						"///////// Detail test  //////// ",
	//8Khz test (CDCLK in)
	TestI2Sv5_1_testcase22,				"PRIM Master TxP 8000Hz 256fs ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase53,				"PRIM Master Rx 8000Hz 256fs ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase43,				"PRIM Slave Tx 8000Hz 256fs ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase54,				"PRIM Slave Rx 8000Hz 256fs ( CDCLK in/XTI Audio SS)    ",

	//slave aging.
	TestI2Sv5_1_testcase41,				"PRIM Slave Tx 44100Hz 256fs (12MHz OSC, Codec PLL) ( CDCLK in/XTI Audio SS)    ",
	TestI2Sv5_1_testcase42,				"PRIM Slave Tx 44100Hz 256fs (24MHz XCLKOUT, Codec  PLL) ( CDCLK in/XTI Audio SS)    ",

	//etc
	TestI2Sv5_1_testcase11,				"24bit 2ch",

	0,0
};


void I2S0v5_1_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	u32 uSizeLists=sizeof(g_aI2S0TestFunc);
	
	while(1)
	{
		UART_Printf("\n\n================== I2S0 v5.1 Function Test  =====================\n\n");	
		
		for (uCountFunc=0; (u32)(g_aI2S0TestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aI2S0TestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel = UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(uSizeLists/8-1))
			(g_aI2S0TestFunc[iSel].func) ();
	}
}	


