
#ifndef __I2SV5_1_H__
#define __I2SV5_1_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "audiodefines.h"




#define	IISBASE			0xEEE30000

#define	IIS_CON		(IISBASE+0)
#define	IIS_MOD		(IISBASE+0x4)
#define	IIS_FIC		(IISBASE+0x8)
#define	IIS_PSR		(IISBASE+0xC)
#define	IIS_FICS	(IISBASE+0x18)

#define	IIS_TXD		(IISBASE+0x10)
#define	IIS_RXD		(IISBASE+0x14)
#define	IIS_TXDS	(IISBASE+0x1C)

#define	IIS_AHB		(IISBASE+0x20)
#define	IIS_STR0	(IISBASE+0x24)
#define	IIS_SIZE	(IISBASE+0x28)
#define	IIS_STR1	(IISBASE+0x40)
#define	IIS_TRNCNT	(IISBASE+0x2C)

#define IIS_LVL_INTADDR (IISBASE+0x30)


enum I2S_INT
{
	I2S_INT_UDR_TXn=17, //Underrun
	I2S_INT_OVR_RX=26,
	I2S_INT_UDR_TXS=24,
	I2S_INT_LV0 = 0,
	I2S_INT_LV1 = 1,
	I2S_INT_LV2 = 2,
	I2S_INT_LV3 = 3,
	I2S_INT_IDMA_DONE =4,
	I2S_INT_NOINT=0xff
};




//void I2SV5_1_Start_TXsecondaryIDMA(u32 uStartAddress0, u32 uStartAddress1,
//					 u32 uTransferBSize, u32 bInitDmaIndex, u8 bDisableDmadoneInt)
#define NOT_USE_BUFFER1	0

#define INIT_DMAINDEX		1
#define NOINIT_DMAINDEX	0

#define DIS_DMADONE_INT	1
#define EN_DMADONE_INT	0


//void I2SV5_1_Init_TXsecondary(unsigned char uBitperCh_S, bool useIDMA);
#define OPMUX_APB	0
#define OPMUX_IDMA	1

/////////////////////////////////////////////////////////////
//APIs
void I2SV5_1_Init(I2SOPMode eI2SOpmode, I2SDIR eTXR, SerialDataFormat eFormat, unsigned char SD1, unsigned char SD2, 
				 unsigned char uBitperCh, I2S_RFSLength	eRFS, I2S_BFSLength eBFS, I2S_CDCLKCON eCDCLKIn,
				unsigned char uPSVALA);
void I2SV5_1_Init_TXsecondary(unsigned char uBitperCh_S, bool useIDMA);
void I2SV5_1_LinkStart();
void I2SV5_1_Wait_TXprimaryBufferFull();
void I2STX_TXS_Pause();
void I2STX_TXS_Continue();




#ifdef __cplusplus
}
#endif


#endif //__I2SV5_1_H__


