#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "audiocodecs.h"
#include "i2sv5_1.h"

//

//Input : uBitperCh of link bit length - 16,24,8 - final mixed sound TX output or RX input
//ex: I2SV5_1_Init(APMaster, I2SFormat, 0, 0, //SD1,SD2
//				 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);
void I2SV5_1_Init(I2SOPMode eI2SOpmode, I2SDIR eTXR, SerialDataFormat eFormat, unsigned char SD1, unsigned char SD2, 
				 unsigned char uBitperCh, I2S_RFSLength	eRFS, I2S_BFSLength eBFS, I2S_CDCLKCON eCDCLKIn,
				unsigned char uPSVALA)
{
	unsigned temp;
	unsigned char uBLC=(uBitperCh==24)?2:
					   (uBitperCh==8)?1:0;//0-16bit
	eFormat=(eFormat>LSBJustified)?I2SFormat:eFormat;
	SD2=(SD2>1)?0:SD2;
	SD1=(SD1>1)?0:SD1;
	eTXR=(eTXR>2)?0:eTXR;	
	eCDCLKIn=(eCDCLKIn>1)?0:eCDCLKIn;	
	uPSVALA=(uPSVALA>63)?0:uPSVALA;	

	Outp32( IIS_CON, 0);//IIS_CON, reset
	Outp32( IIS_CON, 0x80000000);//IIS_CON, set
	temp = ( 3<<30| 1<<28 |uBLC<<26|uBLC<<24|SD2<<17|SD1<<16|uBLC<<13| eCDCLKIn<<12|eI2SOpmode<<11|1<<10 |
		     eTXR<<8|eFormat<<5 | eRFS<<3 | eBFS<<1);//master, 384fs, 48fs, [12-0]cdclk out
	Outp32( IIS_MOD, temp);//IIS_MOD
	Outp32(IIS_AHB, (1<<7|0) );//IIS_AHB, [7] IDMA index init, [0]stop
	Outp32( IIS_PSR, 1<<15 | uPSVALA<<8);//IIS_PSR, en, %1

	Outp32( IIS_FIC, 1<<15);//IIS_FIC, tx flush
	Outp32( IIS_FIC, 0);//IIS_FIC
	Outp32( IIS_FICS, 1<<15);//IIS_FICS, tx_s flush
	Outp32( IIS_FICS, 0);//IIS_FICS,
	Outp32( IIS_FIC, 1<<7);//rx flush
	Outp32( IIS_FIC, 0);

}




void I2SV5_1_Init_TXprimary( unsigned char uBitperCh_P)
{
	unsigned char uBLC_P_TXx=(uBitperCh_P==24)?2:
					   (uBitperCh_P==8)?1:0;//0-16bit

	unsigned int temp;

	temp = Inp32(IIS_MOD);
	temp = temp& ~(3<<24);
	temp = temp | (uBLC_P_TXx<<24);
	Outp32(IIS_MOD, temp);
}


//input : useIDMA - 0 : PDMA ,1: IDMA
//#define OPMUX_APB	0
//#define OPMUX_IDMA	1
void I2SV5_1_Init_TXsecondary(unsigned char uBitperCh_S, bool useIDMA)
{
	unsigned char uBLC_S_TXs=(uBitperCh_S==24)?2:
					   (uBitperCh_S==8)?1:0;//0-16bit

	unsigned int temp;
	useIDMA=(useIDMA>1)? 0: useIDMA;

	temp = Inp32(IIS_MOD);
	temp &= ~(3<<26| 1<<28);
	temp |=  (uBLC_S_TXs<<26 | useIDMA<<28);
	Outp32(IIS_MOD, temp);
}


//input : TX_P_PDMAactive, RX_PDMAactive, TX_S_PDMAactive
//active External DMA(PDMA0 or 1)
void I2SV5_1_ActiveEXTDMA(unsigned int TX_P, unsigned int TX_S, unsigned int RX)
{
	unsigned int temp;
	temp = Inp32(IIS_CON);
	temp &= ~(1<<18|1<<2| 1<<1);
	temp |=  (TX_S<<18|TX_P<<2| RX<<1);
	Outp32(IIS_CON, temp);
}

void I2SV5_1_LinkStart()
{
	unsigned int temp;
	temp = Inp32(IIS_CON);
	temp &= ~(1<<0);
	temp |=  (1<<0);
	Outp32( IIS_CON, temp);//IIS_CON, underrun interrupt, start link,
}


void	I2SV5_1_Fill_TXprimaryBuffer(u32* uPcmDataAddr, u32* uPcmDataBSize)
{
	unsigned int * pPcmAddr = (unsigned int *)(*uPcmDataAddr);
	int i;
	for(i=0;i<64;i++) {
		Outp32( IIS_TXD, *pPcmAddr++);
		*uPcmDataBSize=*uPcmDataBSize-4;
	}

	*uPcmDataAddr=(unsigned int )pPcmAddr;

}

void	I2SV5_1_Fill_TXsecondaryBuffer(u32* uPcmDataAddr, u32* uPcmDataBSize)
{
	unsigned int * pPcmAddr = (unsigned int *)(*uPcmDataAddr);
	int i;
	for(i=0;i<64;i++) {
		Outp32( IIS_TXDS, *pPcmAddr++);
		*uPcmDataBSize=*uPcmDataBSize-4;
	}

	*uPcmDataAddr=(unsigned int )pPcmAddr;
}


void I2SV5_1_Wait_TXprimaryBufferFull()
{
	int i;
	while( (Inp32(IIS_CON) & 0x100)==0x000 )//wait during tx0 not full 
	{
		i++;
		if(i>0x2000000) {
			Disp("tx fifo time out \n");
			break;	
		}
	}	
}

//
//uStartAddress1 : 0(single buffers) or other value 
//bgenerate dma done interrupt
void I2SV5_1_Start_TXsecondaryIDMA(u32 uStartAddress0, u32 uStartAddress1,
					 u32 uTransferBSize, u32 bInitDmaIndex, u8 bDisableDmadoneInt)
{
	unsigned int temp;	
	u32 uDMAinit;
	u8 bEnDoubleBuffer;
	uDMAinit = (bInitDmaIndex==1)? 1:0;
	bEnDoubleBuffer = (uStartAddress1==0)? 0 : 1;
	bDisableDmadoneInt = (bDisableDmadoneInt>1)? 0 : 1;
	
	Outp32( IIS_STR0, uStartAddress0);
	Outp32( IIS_STR1, uStartAddress1);	
	Outp32( IIS_SIZE, (uTransferBSize/4)<<16);// [0] check.  ok.

	temp = Inp32(IIS_AHB);
	temp |=(uDMAinit<<7) | (bEnDoubleBuffer<<6) | (1<<5) | (bDisableDmadoneInt<<3) |1 ;
	Outp32( IIS_AHB, temp );//now start...
}


void I2STXS_Continue()
{
	unsigned int temp;
	temp=Inp32 ( IIS_AHB);
	temp |=  (1<<5|1);
	Outp32( IIS_AHB, temp);//dma start, dma autoreload on [dma source index change]

}



void I2STXS_Pause()
{
	unsigned int temp, sizew;
	//txs pause
	temp=Inp32 ( IIS_AHB);
	temp &=  ~(1<<5)	;		
	Outp32( IIS_AHB, temp);//autoreload off+at finish, dma stop

}



void I2S_EnableInterrupt(unsigned int eInt, u32 uTriggerAddr, bool bIsStop)
{
	if (eInt<4) //LV Interrupt
	{
//		Assert((uTriggerAddr&0x3ff) == 0);
		u32 x;
		Outp32(IIS_LVL_INTADDR+(u32)eInt*4, uTriggerAddr|(bIsStop?1:0));
		x=Inp32(IIS_AHB);
		x |= (1<<((u32)eInt+24));
		Outp32(IIS_AHB, x);
	}
}

void I2S_ClearIntPending(unsigned int eLv)
{
	u32 uReg;
	if (eLv<4) // LV Interrupt
	{
		uReg=Inp32(IIS_AHB);
		uReg |= (1<<((u32)eLv+16)); //iis level n clear
		Outp32(IIS_AHB, uReg);
	}
	else if(eLv==I2S_INT_IDMA_DONE)
	{
		uReg=Inp32(IIS_AHB);
		uReg |= (1<<1);//iis dma clear
		Outp32(IIS_AHB, uReg);
	}
}



bool I2S_GetIntStatus(unsigned int * peInt)
{
	u32 uReg;
	uReg=Inp32(IIS_CON);
	if (uReg&(1<<I2S_INT_UDR_TXn))
	{
		*peInt = I2S_INT_UDR_TXn;
	}
	else if (uReg&(1<<I2S_INT_OVR_RX))
	{
		*peInt= I2S_INT_OVR_RX;
	}
	else if (uReg&(1<<I2S_INT_UDR_TXS))
	{
		*peInt = I2S_INT_UDR_TXS;
	}
	else
	{
		uReg=Inp32(IIS_AHB);
		if (uReg&(1<<2))
			*peInt = I2S_INT_IDMA_DONE;
		else if (uReg&(1<<20))
			*peInt = I2S_INT_LV0;
		else if (uReg&(1<<21))
			*peInt = I2S_INT_LV1;
		else if (uReg&(1<<22))
			*peInt = I2S_INT_LV2;
		else if (uReg&(1<<23))
			*peInt = I2S_INT_LV3;
		else
			return 0;
	}
	return 1;
}


void I2STCUtil(u8 bprintCnt, u8 bwaitTillEnd)
{
	unsigned int temp;
	unsigned int tc;

	temp=Inp32( IIS_SIZE);

	tc=	(  (temp>>16) & 0xffff) ;

	Disp("tc : %d- ", tc);

	temp= Inp32 ( IIS_TRNCNT);
	Disp("%d- ", temp);

	if(bwaitTillEnd==1)
	{
		do{
			temp=Inp32 ( IIS_TRNCNT);
			if(bprintCnt==1) Disp("%d- ", temp);
		}while( temp < tc);
	}
}
