#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"

#include "assaddr.h"
#include "asscommbox.h"
//



//select SRAM(IMEM, DMEM) address mode.
//
//input : bNonContinousMode
// 1 : non continouse mode for RP decode
// 0 : continouse mode for ARM decode
// ex : RP_SetSramMode(RP_NON_CONTSRAM_FOR_RPDECODE)
void RP_SetSramMode(unsigned char bNonContinousMode)
{
	unsigned int temp = Inp32(RP_ENDIAN_CONVERTER);
	temp = temp & ~(1<<3);

	//	Assert(bNonContinousMode<<1);

	temp |= (bNonContinousMode<<3);

	Outp32( RP_ENDIAN_CONVERTER, temp);
	//sram optoin[3] - b1 : non continouse mode
	//endian convert [0] inbuffer0, [1] inbuffer1
}


// Set before filling input buffers
//
//input : bInbuf0/1Convert
// 1 : convert endianness when ARM write to input buffer (Little endian bitstream -> Big endian bitstream which RP can read)
// 0 : do not convert when ARM write to input buffer. (can used by ARM spare area, when RP does not used)
void RP_SetInBuffersEndianConveter(unsigned char bInbuf1Convert, unsigned char bInbuf0Convert)
{
	unsigned int temp = Inp32(RP_ENDIAN_CONVERTER);
	temp = temp & ~(3<<0);
	//	Assert(bInbuf1Convert<<1 && bInbuf0Convert<<1);

	temp |= bInbuf1Convert<<1 | bInbuf0Convert;

	Outp32( RP_ENDIAN_CONVERTER, temp);
	//sram optoin[3] - b1 : non continouse mode
	//endian convert [0] inbuffer0, [1] inbuffer1
}



//function name should be changed as below
void AudioSS_COMMBOX_SetSRAM(unsigned char bNonContinousMode)
{
	RP_SetSramMode(bNonContinousMode);
}

void AudioSS_COMMBOX_SetIBUFFERS(unsigned char bInbuf1EndianConvert, unsigned char bInbuf0EndianConvert)
{
	RP_SetInBuffersEndianConveter(bInbuf1EndianConvert, bInbuf0EndianConvert);
}
