
#ifndef __AUDIOSS_DD_H__
#define __AUDIOSS_DD_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "assaddr.h"

#define	ASS_CLK_SRC		(ASS_CLKCON_BASE)
#define	ASS_CLK_DIV		(ASS_CLKCON_BASE+0x4)
#define	ASS_CLK_GATE		(ASS_CLKCON_BASE+0x8)


typedef enum
{
	MUX_XXTI= 0,
	MUX_FOUT_EPLL= 1,
}CLKMUX_ASS;

typedef enum
{
	Main_CLK= 0,
	I2S_iCLK= 1,
}MUXBUS;

typedef enum
{
	MUXI2SA_Main_CLK= 0,
	MUXI2SA_I2S_iCLK= 1,
	MUXI2SA_SCLK_AUDIO0= 2,
}MUXI2SA;

typedef enum
{
	ALL_BLOCKS_MASK				= 0x0,
	HCLK_RPCORE_IMEM_DMEM_PASS	= 1<<0,
	HCLK_InOutBUF_PASS			= 1<<1,
	HCLK_DMAX_DMA_PASS			= 1<<2,
	HCLK_ODO_HWA_PASS			= 1<<3,
	HCLK_UART_PASS				= 1<<4,
	HCLK_I2SV5_1_PASS				= 1<<5,
	I2SCLK_PASS					= 1<<6,
	ALL_BLOCKS_PASS				= 0x7F,
}AUDIOSS_GATES;


typedef enum
{
	MOUTI2SA_MainCLK_FOUTEPLL= 0,
	MOUTI2SA_IISCDCLK0= 1,
	MOUTI2SA_GATING= 10,
}MOUTI2SA;


//APIs
void AudioSS_CLKCON_SetSource(CLKMUX_ASS eCLKMUX_ASS, MUXBUS eMUXBUS, MUXI2SA eMUXI2SA);
void AudioSS_CLKCON_SetDivider(unsigned char uDIVI2S_A, unsigned char uDIVAUD_BUS);
void AudioSS_CLKCON_ChangeDiv_AudBus(unsigned char uDIVAUD_BUS);
void AudioSS_CLKCON_SetGate(unsigned char uGateBlocks);
unsigned char AudioSS_CLKCON_GetGate();
void AudioSS_CLKCON_ChangeCLKMUX(CLKMUX_ASS eCLKMUX_ASS);


#include "audiodefines.h"
void AudioSS_CLKCON_SetTypicalConf(I2SOPMode eI2SOpmode, MOUTI2SA eMoutI2SA );



#ifdef __cplusplus
}
#endif


#endif //__AUDIOSS_DD_H__


