#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "rpapp.h"
#include "rpaudioss_dd.h"


u8 g_ASS_bEligibleForDeepIdle;//set at app, get at app.
u8 g_ASS_bTimeoutCnt;

extern unsigned int g_StreamLocW;//wordunit.
extern unsigned int g_IBUF_Index;//0 : IBUF0, 1 : IBUF1, //total number of interrupt during playing one file
extern unsigned int g_bitstreamBsize;
extern unsigned int *g_pbitstream;
extern int g_AgingPlayingtime;
extern int g_errornum;
extern u32	g_uSignalRPInbuffEmpty;

extern unsigned int g_currINTtype;
extern unsigned int g_currINTparam;

void AudioSS_DD_SetDeepIdleCondition()
{
	g_ASS_bTimeoutCnt=ASS_TIMEOUTCNT;
}



//bEligible : 1 - Eligible for Deep Idle(pure MP3/AAC) 0 - not Eligible for deep idle
void AudioSS_DD_SetDeepIdleEligible(u8 bEligible)
{
	g_ASS_bEligibleForDeepIdle=bEligible;
}

u8 AudioSS_DD_GetDeepIdleEligible(u8 bEligible)
{
	return g_ASS_bEligibleForDeepIdle;
}

void AudioSS_DD_DeepIdleTimeoutClear()
{
	g_ASS_bTimeoutCnt=0;

}


void AudioSS_DD_DeepIdleCntIncrease()
{
	g_ASS_bTimeoutCnt++;
}


//return 0 : false , 1: true
u8 AudioSS_DD_DeepIdleIsTimeout()
{
	if(g_ASS_bTimeoutCnt>=ASS_TIMEOUTCNT)
	 	return true;
	else 
		return false;
}

u8 AudioSS_DD_DeepIdleResetTimeout()
{
	if(g_ASS_bTimeoutCnt>=ASS_RESETTIMEOUTCNT)
	 	return true;
	else 
		return false;
}


//  input 0~15 value mean clock source is divided by 1~16.
void AudioSS_DD_DeepIdleControl(unsigned int InBufFillEnded,  unsigned char  uDIVAUD_BUS_DeepIdle )
{

	if(InBufFillEnded == RPINT_HANDLE_INBUF_FILL_END) AudioSS_DD_DeepIdleCntIncrease();


	if(AudioSS_DD_DeepIdleResetTimeout()==true) AudioSS_DD_DeepIdleTimeoutClear();

	//if playing mode is eligible for deep idle mode
	// then enter to deep idle mode
	if(AudioSS_DD_DeepIdleIsTimeout()==true&& g_ASS_bEligibleForDeepIdle)//
	{
		AudioSS_DD_Backup();
		AudioSS_CLKCON_ChangeDiv_AudBus(uDIVAUD_BUS_DeepIdle);

		//MUST check Additional interrupt is pended. before entering to deep idle.
		SYSC_SetIdleModeConfig(eCFG_RET, eCFG_OFF, eCFG_OFF, eCFG_DEEP);
		//if any interrupt did not occur,  no more interrupt pending,
		if(g_currINTtype==0 && g_currINTparam==0&&g_uSignalRPInbuffEmpty==0) {
//		if(g_currINTtype==0 && g_currINTparam==0) {
			Outp32(0xE0200c64,0x0);//eint31 data : 0
			SYSC_StartPowerMode(eMODE_DEEPIDLE, SW_WFI, true);	
		}
	}
}



void AudioSS_DD_Recover()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;		

	//Loop(play information : streamloc, deepidleeligible)
	g_StreamLocW=pinfo->uStreamLocB/4;
	g_bitstreamBsize=pinfo->uStreamSizeB;	
	g_pbitstream=pinfo->pbitstream;
	g_AgingPlayingtime=pinfo->AgingPlayingtime;
	g_errornum=pinfo->g_errornum;

	g_IBUF_Index=pinfo->uIBUF_Index;//before 03/16
	g_ASS_bEligibleForDeepIdle=pinfo->bEligibleForDeepIdle;
	g_ASS_bTimeoutCnt=pinfo->uASS_bTimeoutCnt;
	g_uSignalRPInbuffEmpty=pinfo->uSignalRPInbuffEmpty;
}

void AudioSS_DD_Backup()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;

	//Loop(play information : streamloc)
	pinfo->uStreamLocB= g_StreamLocW*4;
	pinfo->uStreamSizeB=g_bitstreamBsize;	
	pinfo->pbitstream=g_pbitstream;
	pinfo->AgingPlayingtime=g_AgingPlayingtime;
	pinfo->g_errornum=g_errornum;
	pinfo->bEligibleForDeepIdle=g_ASS_bEligibleForDeepIdle;

	pinfo->uIBUF_Index=g_IBUF_Index;//before 03/16
	pinfo->uASS_bTimeoutCnt=g_ASS_bTimeoutCnt;
	pinfo->uSignalRPInbuffEmpty=g_uSignalRPInbuffEmpty;
}

