
#ifndef __RPAPP_H__
#define __RPAPP_H__

#ifdef __cplusplus
extern "C" {
#endif

//16MB+0~20MB : use 19MB
#define RPAPP_CURRENT_BITSTREAM_BUFFER_MAX_BSIZE	(19*1024*1024)
//#define RPAPP_CURRENT_BITSTREAM_BUFFER_MAX_BSIZE	(576*1024)
//#define RPAPP_CURRENT_BITSTREAM_BUFFER_MAX_WSIZE	(576*1024/4)

/////////////////////////////////////////////////////////////
//Memory map

#define RP_DRAM_GV_BASEADDR		0x40000000//DRAM base 

//-5MB+0MB~5MB : this area moved for large file test
	#define RP_PLAYER_INFO				(RP_DRAM_GV_BASEADDR+0xB00000)//0x40b00000
	#define RP_PLAYLISTS_INFO_NUM		(RP_DRAM_GV_BASEADDR+0xC00000)//0x40c00000
	#define RP_PLAYLISTS_INFO			(RP_DRAM_GV_BASEADDR+0xC00004)//0x40c00004
#ifdef USE_DRAM_AS_INBUFF
	#define	IBUF0_ADDR					(RP_DRAM_GV_BASEADDR+0xD00000)//0x40d00000
	#define	IBUF1_ADDR					(IBUF0_ADDR+IBUF_MAX_BYTE)//1MB //0x40e00000
#endif
	#define RANDOMACCESS_INST			(RP_DRAM_GV_BASEADDR+0xF40000)//0x40f40000 Big endian of current inst code //developing
	#define RANDOMACCESS_DATA			(RP_DRAM_GV_BASEADDR+0xF80000)//0x40f80000 Big endian //developing
	#define IMEM_ADDR_DRAM			(RP_DRAM_GV_BASEADDR+0xFC0000)//0x40fc0000


//#define RP_DRAM_BASEADDR		0x21000000//DRAM base + 16MB
#define RP_DRAM_BASEADDR		0x41000000//DRAM base + 16MB

//Common Memory map  Start
//16MB+0~15MB
	#define BITSTREM_BSIZE_ADDR		(RP_DRAM_BASEADDR)//bsize + extra information, BITSTREM_INFORMATION
	#define BITSTREM_ST_TAGS			(RP_DRAM_BASEADDR+0x200)//developing...
	#define BITSTREM_ST_ADDR			(RP_DRAM_BASEADDR+0x400)


//16MB+20MB~108MB
	#define RP_MASS_STORAGE0_BASE		(RP_DRAM_BASEADDR+0x1400000)//0x22400000
	#define RP_MASS_STORAGE1_BASE		(RP_DRAM_BASEADDR+0x1E00000)//0x22E00000
	#define RP_MASS_STORAGE2_BASE		(RP_DRAM_BASEADDR+0x2800000)//0x23800000
	#define RP_MASS_STORAGE3_BASE		(RP_DRAM_BASEADDR+0x3200000)//0x24200000
	#define RP_MASS_STORAGE4_BASE		(RP_DRAM_BASEADDR+0x3C00000)//0x24C00000
	#define RP_MASS_STORAGE5_BASE		(RP_DRAM_BASEADDR+0x4100000)//0x25100000
	#define RP_MASS_STORAGE6_BASE		(RP_DRAM_BASEADDR+0x4600000)//0x25600000
	#define RP_MASS_STORAGE7_BASE		(RP_DRAM_BASEADDR+0x4b00000)//0x25b00000

	#define RP_MASS_STORAGE8_BASE		(RP_DRAM_BASEADDR+0x5000000)//0x26000000
      //or
	#define PCM_OUT_ADDRESS			RP_MASS_STORAGE0_BASE
	#define PCM_IN_WAVEFILE_ADDRESS	RP_MASS_STORAGE3_BASE

//16MB+108MB~110MB : RP code regions - little endian	
	#define INST_ST_BSIZE_ADDR_MP3	(RP_DRAM_BASEADDR+0x6a00000)//0x27a00000
	#define DATA_ST_BSIZE_ADDR_MP3	(RP_DRAM_BASEADDR+0x6b00000)//0x27b00000
	#define INST_ST_ADDR_MP3			(RP_DRAM_BASEADDR+0x6a00004)//0x27a00004
	#define DATA_ST_ADDR_MP3			(RP_DRAM_BASEADDR+0x6b00004)//0x27b00004

	#define INST_ST_BSIZE_ADDR_AAC	(RP_DRAM_BASEADDR+0x6a40000)//0x27a40000
	#define DATA_ST_BSIZE_ADDR_AAC	(RP_DRAM_BASEADDR+0x6b40000)//0x27b40000
	#define INST_ST_ADDR_AAC			(RP_DRAM_BASEADDR+0x6a40004)//0x27a40004
	#define DATA_ST_ADDR_AAC			(RP_DRAM_BASEADDR+0x6b40004)//0x27b40004

	#define INST_ST_BSIZE_ADDR_WMA	(RP_DRAM_BASEADDR+0x6a80000)//0x27a80000
	#define DATA_ST_BSIZE_ADDR_WMA	(RP_DRAM_BASEADDR+0x6b80000)//0x27b80000
	#define INST_ST_ADDR_WMA			(RP_DRAM_BASEADDR+0x6a80004)//0x27a80004
	#define DATA_ST_ADDR_WMA			(RP_DRAM_BASEADDR+0x6b80004)//0x27b80004


//End of Address map
/////////////////////////////////////////////////////////////

typedef struct 
{
	unsigned int uSizeB;
	unsigned int uSamplingFreq;
	unsigned int uFormat;//1:mp3, 2:aac-lc, 3:wma
	unsigned int uLocinMedia;//address in dram, word aligned.-media start address + former size
	char Filename[256];
}RPPLAYLIST_STRUCT;// 256+16


/*
typedef struct 
{
	unsigned int  	uEachTagSizeB;
	char 	TagValidBit[256];
}RPBITSTREAM_TAG;//260
*/


typedef struct 
{
	//device driver level
	unsigned int 	ufunctionNum;
	unsigned char uASS_bTimeoutCnt;

	//player level
	unsigned int 	uPlayingFileStartIndex;
	unsigned int 	uPlayingFileNums;
	unsigned int 	uPlayingFileCurrentIndex;
	unsigned char	uPlayerRepeat;//0 : false, 1: all repeat , 2 : same song repeat

	//player loop level
	unsigned int uSignalRPInbuffEmpty;
	u8 			bEligibleForDeepIdle;
	unsigned int  	uStreamSizeB;//word aligned, round up, 
							  // it stream size is 10Byte, when this should be adjusted to 12Byte.
	unsigned int  	uStreamLocB;
	unsigned int  	uIBUF_Index;
	unsigned int  	uRandompercent;
	unsigned int * pbitstream;
	unsigned int  	AgingPlayingtime;
	unsigned int  	g_errornum;
//	unsigned int  	g_Playerstatus;
	unsigned int  	g_PlayerIndex;
//	RPPLAYLIST_STRUCT* 	uCurrentFilename;//or index in playinglists.
//	RPPLAYLIST_STRUCT* 	uNextFilename;
//	RPPLAYLIST_STRUCT* 	uPrevFilename;
}RPPLAYER_INFO;

/////////////////////////////////////////////////////////////



#define RPCONT_EXIT	0
#define RPCONT_QUIT	-1
#define RPCONT_RANDOM_ACCESS	2

//void RPAPP_loadInstDataBinary(bool buseSWEndianConv, unsigned char InputBianaryEndian);
#define SW_ENDIAN_CONV 1//real scenario (or use Big endian binary code)
#define HW_ENDIAN_CONV 0
#define RP_LITTLE_ENDIAN_BINARY 0
#define RP_BIG_ENDIAN_BINARY 1


//int RPAPP_interrupthandler(unsigned int * pbitstream, unsigned int *uStreamLocW, unsigned int bitstreamBsize);
#define RPINT_HANDLE_PLAY_END	0
#define RPINT_HANDLE_NORMAL	1
#define RPINT_HANDLE_INBUF_FILL_END	2

//unsigned int RPAPP_control_DI(unsigned int * randompercent);
#define RPAPP_CON_PAUSE		3
#define RPAPP_CON_CONTINUE	4



/////////////////////////////////////////////////////////////
//Local functions
void VolumeDown();
void VolumeUp();
void __irq ISR_RPInbuff_Empty(void);
/////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////
//APIs

void RPAPP_loadbitstream();
void RPAPP_DispInfo(unsigned int RandomAccessPercent);
int RPAPP_MakePlayinglists();
void RPAPP_showbitstreamsSelect();
void RPAPP_showCurrentBitstreamInfo();
void RPAPP_SetRepeatcontrol(u8 control);
u8 RPAPP_GetRepeatcontrol();
int  RPAPP_Playingcontrol(int retControl);
unsigned int RPAPP_control_DI(unsigned int * randompercent);

int RPAPP_interrupthandler(unsigned int * pbitstream, unsigned int *uStreamLocW, unsigned int bitstreamBsize);
void RPAPP_fill_Ibuffs(unsigned int * pbitstream, unsigned int *puStreamLocW);
void RPAPP_loadInstDataBinary(bool buseSWEndianConv, unsigned char InputBianaryEndian);
void RPAPP_GetBitstreamInfos(bool bDoRandomAccess, unsigned int RandomAccessPercent,
								unsigned int **ppbitstream, unsigned int *pbitstreamBsize );

/////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
//need change function name, or move file location.
unsigned int EndianConvert(unsigned int Lfoo);
void RP_SetEINTwakup();
void memcpy2(void* ud, void* us, u32 bs);
void RP_SetEINTwakup();
void RP_SetEINTwakupRestore();

/////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif


#endif //__RPSYSCON_H__


