#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "intc.h"
#include "gpio.h"

#include "stopwatch.h"
#include "audiocodecs.h"
#include "i2sv5_1.h"
#include "rpcommbox.h"
#include "rpetc.h"
#include "rpapp.h"


//
unsigned int g_StreamLocW;//wordunit.
unsigned int g_IBUF_Index;//0 : IBUF0, 1 : IBUF1, //total number of interrupt during playing one file
unsigned int g_bitstreamBsize;
unsigned int *g_pbitstream;
int g_AgingPlayingtime;
int g_errornum;

u32	g_uSignalRPInbuffEmpty;
unsigned int g_currINTtype;
unsigned int g_currINTparam;



////////////////////////////////////////////////////////////////////////////////////////////
//
//	Local functions
//
////////////////////////////////////////////////////////////////////////////////////////////




///////////////////////////// volume control////////////////////////////////
//vol : 00 -infinite (mute)
//       01 - -127.5dB
//      fe - -0.5dB
//       ff - 0dB
void VolumeSet(u8 uVol)
{
	WM8580_VolumeSet(uVol);
}

u8 g_uVol=0xfF;// to control volume, when call SetI2SandCodec, call as SetI2SandCodec(g_uVol);

void VolumeUp()
{
	g_uVol=(g_uVol+10>0xff)?0xff:g_uVol+10;
	VolumeSet(g_uVol);

}
void VolumeDown()
{
	g_uVol=(g_uVol-10<0)?0:g_uVol-10;		
	VolumeSet(g_uVol);
}


////////////////////////////////////////////////////////////////////////////////////////////
//
//	RP app APIs
//
////////////////////////////////////////////////////////////////////////////////////////////

void RPAPP_loadbitstream()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	RPPLAYLIST_STRUCT *pPlayLists=(RPPLAYLIST_STRUCT * )RP_PLAYLISTS_INFO;
	unsigned int uMp3FileSize;
	unsigned int i=pinfo->uPlayingFileCurrentIndex;

	uMp3FileSize=pPlayLists[i].uSizeB;
	if(uMp3FileSize>RPAPP_CURRENT_BITSTREAM_BUFFER_MAX_BSIZE)
	{
		uMp3FileSize=RPAPP_CURRENT_BITSTREAM_BUFFER_MAX_BSIZE;
		Disp("Copying to current stream buffer space(19MB only)...\n");		
	}else
		Disp("Copying to current stream buffer space...\n");
	memcpy2((void*)BITSTREM_ST_ADDR, (void *)pPlayLists[i].uLocinMedia, uMp3FileSize);
	Outp32(BITSTREM_BSIZE_ADDR ,uMp3FileSize);
	//Set currently playing bit stream information
}



void RPAPP_loadInstDataBinary(bool buseSWEndianConv, unsigned char InputBianaryEndian)
{
	unsigned int InstCodeSizeB;
	unsigned int DataCodeSizeB;
	unsigned int temp, i;


	InstCodeSizeB = Inp32( INST_ST_BSIZE_ADDR_MP3);
	DataCodeSizeB = Inp32(DATA_ST_BSIZE_ADDR_MP3);

	if(InputBianaryEndian==RP_LITTLE_ENDIAN_BINARY)
	{
		if(buseSWEndianConv==false) {
			SYSC_SetAudioEndian(RP_R_LITTLE,RP_W_LITTLE,ARM_R_BIG,ARM_W_BIG);//this makes i2s0 tx primary endian converting malfunction.
									    // ==> must use Big endian bianary
			memcpy2( (void *)IMEM_ADDR, (void *)INST_ST_ADDR_MP3, InstCodeSizeB);
			memcpy2( (void *)DMEM_ADDR, (void *)DATA_ST_ADDR_MP3, DataCodeSizeB);
			SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);

			Disp("test purpose only, At real set, Must use Big endian binary\n");

		} else {
			for( i=0; i<InstCodeSizeB/4; i++)  	{
				temp = Inp32(INST_ST_ADDR_MP3+i*4);
				temp = EndianConvert(temp);//little -> big
				Outp32( IMEM_ADDR+i*4, temp);
			}

			for( i=0; i<DataCodeSizeB/4; i++)  	{
				temp = Inp32(DATA_ST_ADDR_MP3+i*4);
				temp = EndianConvert(temp);//little -> big
				Outp32( DMEM_ADDR+i*4, temp);
			}
		}
	} else
	{
		memcpy2( (void *)IMEM_ADDR, (void *)INST_ST_ADDR_MP3, InstCodeSizeB);
		memcpy2( (void *)DMEM_ADDR, (void *)DATA_ST_ADDR_MP3, DataCodeSizeB);
	}

	Disp("\nRP inst(%d kbyte), data(%d Kbyte) loading end(MP3 play)\n", InstCodeSizeB/1024, DataCodeSizeB/1024);	
}


void RPAPP_fill_Ibuffs(unsigned int * pbitstream, unsigned int *puStreamLocW)
{
	unsigned int StreamLocW=*puStreamLocW;

	memcpy2((void*)IBUF0_ADDR, (void *)(pbitstream+StreamLocW), IBUF_MAX_BYTE);
	StreamLocW = StreamLocW + IBUF_MAX_BYTE/4;	
	memcpy2((void*)IBUF1_ADDR, (void *)(pbitstream+StreamLocW), IBUF_MAX_BYTE);
	StreamLocW = StreamLocW + IBUF_MAX_BYTE/4;

	*puStreamLocW=StreamLocW;
}


unsigned int RPMassAddr[]=
{
	RP_MASS_STORAGE0_BASE,
	RP_MASS_STORAGE1_BASE,
	RP_MASS_STORAGE2_BASE,
	RP_MASS_STORAGE3_BASE,
	RP_MASS_STORAGE4_BASE,
	RP_MASS_STORAGE5_BASE,
	RP_MASS_STORAGE6_BASE,
	RP_MASS_STORAGE7_BASE,
};

//if bitstream lists defined as header file, then return num of lists.
int RPAPP_MakePlayinglists()
{
	RPPLAYLIST_STRUCT *pPlayLists=(RPPLAYLIST_STRUCT * )RP_PLAYLISTS_INFO;
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	int Listsize;
	unsigned int baseaddress0,baseaddress4,baseaddress400;
	unsigned int value0,value4;
	int i;

	Listsize=Inp32(RP_PLAYLISTS_INFO_NUM);
	for(i=0;i<Listsize;i++) {
		baseaddress0=RPMassAddr[i];
		baseaddress4=baseaddress0+4;
		baseaddress400=baseaddress0+0x400;
		value0=Inp32(baseaddress0);//byte size of bitstream
		value4=Inp32(baseaddress4);//format, sampling freq.

		pPlayLists[i].uSamplingFreq=value4&0xffff;
		pPlayLists[i].uFormat=(value4>>16)&0x3;//1:mp3, 2:aac-lc, 3:wma
		pPlayLists[i].uLocinMedia=baseaddress400;
		pPlayLists[i].uSizeB=value0;
	}
	//manual setting.
	strcpy(pPlayLists[0].Filename,"bitstream0");
	strcpy(pPlayLists[1].Filename,"bitstream1");
	strcpy(pPlayLists[2].Filename,"bitstream2");
	strcpy(pPlayLists[3].Filename,"bitstream3");
	strcpy(pPlayLists[4].Filename,"bitstream4");
	strcpy(pPlayLists[5].Filename,"bitstream5");
	strcpy(pPlayLists[6].Filename,"bitstream6");
	strcpy(pPlayLists[7].Filename,"bitstream7");


	pinfo->uPlayingFileNums=Listsize;

	return Listsize;
}


char *BitstreamKinds[] ={
"MP3","AAC-LC","WMA"};
void RPAPP_showbitstreamsSelect()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	RPPLAYLIST_STRUCT *pPlayLists=(RPPLAYLIST_STRUCT * )RP_PLAYLISTS_INFO;
	unsigned int uSel, uStart, uListsize;
	int i;

	uListsize=pinfo->uPlayingFileNums;

	Disp("[num] 	filename  	Samplefreq 	format 	loc 		sizeb\n");
	for(i=0; i<uListsize; i++)
	Disp("[%d]	%s	%d		%s	0x%x	%d\n", i+1, pPlayLists[i].Filename, pPlayLists[i].uSamplingFreq,
					 BitstreamKinds[pPlayLists[i].uFormat-1], pPlayLists[i].uLocinMedia, pPlayLists[i].uSizeB);

	Disp("please enter start test number : (1[D]~%d)", uListsize );
	uSel = UART_GetIntNum();
	//uSel = 1;
	uStart = (uSel>0 && uSel<=uListsize)? uSel-1 : 0;

	//init index
	pinfo->uPlayingFileStartIndex=uStart;
	pinfo->uPlayingFileCurrentIndex=uStart;
	pinfo->uPlayerRepeat=0;//repeat
}

void RPAPP_showCurrentBitstreamInfo()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	RPPLAYLIST_STRUCT *pPlayLists=(RPPLAYLIST_STRUCT * )RP_PLAYLISTS_INFO;

 	int i = pinfo->uPlayingFileCurrentIndex;

	Disp("[%d]	%s	%d		%s	0x%x	%d\n", i+1, pPlayLists[pinfo->uPlayingFileCurrentIndex].Filename, pPlayLists[i].uSamplingFreq,
					 BitstreamKinds[pPlayLists[i].uFormat-1], pPlayLists[i].uLocinMedia, pPlayLists[i].uSizeB);


}



//input : bDoRandomAccess, inputRandomAccessPercent
//Output : ppbitstream, puStreamLocW
void RPAPP_GetBitstreamInfos(bool bDoRandomAccess, unsigned int RandomAccessPercent,
								unsigned int **ppbitstream, unsigned int *pbitstreamBsize )
{
	unsigned int * pbitstream;
	unsigned int * plocbitstreamBsize;
	unsigned int bitstreamBsize;
	unsigned int playoffsetB;

	pbitstream = (unsigned int *)BITSTREM_ST_ADDR;
	plocbitstreamBsize = (unsigned int *)BITSTREM_BSIZE_ADDR;
	bitstreamBsize = *plocbitstreamBsize;

	//calculation of new random access point.
	//example : playing from 40%~ 100%.
	//-------[=======]
	//0           40%          100%
	if(bDoRandomAccess==false)RandomAccessPercent=0;
	playoffsetB = bitstreamBsize *(RandomAccessPercent)/100;
	playoffsetB = playoffsetB -(playoffsetB % 4);//word align
	pbitstream = pbitstream + playoffsetB/4;

	bitstreamBsize = bitstreamBsize -playoffsetB;
	//end of calculation

	*ppbitstream= pbitstream;
	*pbitstreamBsize = bitstreamBsize + (4-(bitstreamBsize%4) );//word align
}



//0 : no repeat , 1: all repeat , 2 : current song repeat
void RPAPP_SetRepeatcontrol(u8 control)
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	pinfo->uPlayerRepeat=control;
}

u8 RPAPP_GetRepeatcontrol()
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;
	return pinfo->uPlayerRepeat;
}


void RPAPP_DispInfo(unsigned int RandomAccessPercent)
{
	u8 repeatstatus;

	Disp("\nplaying offset : %d percent\n", RandomAccessPercent);
	Disp("Control : [p] pause [c] continue                    [x] exit  [q] quit playing lists\n");
	Disp("          [,]move backward [.]move forward \n");
	Disp("   	    [+]volume up [-] volume down\n");
	Disp("   	    [e] no repeat [r] all repeat [t] one song repeat\n");
	Disp("	   [l] enter to Low power mode\n");

	repeatstatus=RPAPP_GetRepeatcontrol();
	Disp("Status : repeat[%s]\n", (repeatstatus==0)?"no repeat" : 
							  (repeatstatus==1)?"all repeat" : "one song repeat");

}



//return : 0 - exit, -1 - quit, 2 : random access. 
unsigned int RPAPP_control_DI(unsigned int * randompercent)
{
	unsigned char ch=UART_GetKey();

	if(ch !=0) AudioSS_DD_DeepIdleTimeoutClear();
	else return 1;

	if(ch == 'p' ) {
		I2STXS_Pause();
		Outp32( RP_PENDING, 0x1);
	} else if(ch == 'c' ) {
		Outp32( RP_PENDING, 0);
		I2STXS_Continue();			
	}else if(ch == ',' ) { //<
		I2STXS_Pause();
		Outp32( RP_PENDING, 0x1);// 1: pending
		*randompercent =(*randompercent>10)? *randompercent-10: 0;			
		return RPCONT_RANDOM_ACCESS;
	}else if(ch == '.' ) {//>
		I2STXS_Pause();
		Outp32( RP_PENDING, 0x1);// 1: pending
		*randompercent =(*randompercent<90)? *randompercent+10: 99;
		return RPCONT_RANDOM_ACCESS;
	}
	else if(ch == '+' ) VolumeUp();
	else if(ch == '-' ) 	VolumeDown();
	else if(ch == 'x' ) {
		I2STXS_Pause();
		Outp32( RP_PENDING, 0x1);// 1: pending
		return RPCONT_EXIT;
	}
	else if(ch == 'q' ) {
		I2STXS_Pause();
		Outp32( RP_PENDING, 0x1);// 1: pending
		return RPCONT_QUIT;
	}
	else if(ch == 'e' ) RPAPP_SetRepeatcontrol(0);
	else if(ch == 'r' ) RPAPP_SetRepeatcontrol(1);
	else if(ch == 't' ) RPAPP_SetRepeatcontrol(2);
	else if(ch == 'l' ) 	AudioSS_DD_SetDeepIdleCondition(true);

	return 1;
}


// unsigned char g_bINT_Hander_finished=false;
// unsigned char g_bISR_RPpendingByISR=false;
// @ISR : If interrupt is occur, before interrupt handle is not finished,
//		 (g_bINT_Hander_finished==false)
//            then pending RP, set g_bRPpendingByISR = true.
// @Int Handler : At the end of interrupt handler, 
//	         if RP is pended by ISR(g_bRPpendingByISR==true), 
//		   then continue RP


//////////
// Input : 	NONE
// Output : 	NONE
// Version : v0.1
// getting inbuffer index would be good. 
void __irq ISR_RPInbuff_Empty(void)
{
	INTC_Disable(NUM_AUDIO);//AUDIO_SS

#if 0
	Outp32( RP_INTERRUPT, 0);//,  0: clear interrupt	
	g_currINTtype=Inp32( RP_INTERRUPT_CODE);
	g_currINTparam=Inp32( RP_PARAM0_INT_INFO);
#else
	RP_ClearIntReadIntCode(&g_currINTtype, &g_currINTparam);	
#endif	
	if( (g_currINTtype&0x4) ==4 )	g_uSignalRPInbuffEmpty++;

	Disp(".");


	INTC_ClearVectAddr();
	INTC_Enable(NUM_AUDIO);
}

//return : 0 - end(done)  1 : normal.
int RPAPP_interrupthandler(unsigned int * pbitstream, unsigned int *uStreamLocW, unsigned int bitstreamBsize)
{
	unsigned int temp;
	//Interrupt base
	if( (g_currINTtype&0x4) == 4 && g_currINTparam==1)//request, data empty (huge, 1min interval)
	{
		unsigned int StreamLocW=*uStreamLocW;
		unsigned int uInbuffIndex = (g_currINTtype>>6)&0x1 ; //added 090322 AP - inbuff index
		int  ibufcopybsize = ( (StreamLocW*4+ IBUF_MAX_BYTE)  <= bitstreamBsize )? IBUF_MAX_BYTE : (bitstreamBsize-StreamLocW*4 );

		g_currINTtype=0;
		g_currINTparam=0;
		if(ibufcopybsize >0 )
		{
			uInbuffIndex = g_IBUF_Index%2;//SW manage input index(mp3/aac/wma). old scheme before 090316
			if(uInbuffIndex==0) memcpy2((void*)IBUF0_ADDR, (void *)(pbitstream+StreamLocW), IBUF_MAX_BYTE);
			else 			memcpy2((void*)IBUF1_ADDR, (void *)(pbitstream+StreamLocW), IBUF_MAX_BYTE);
			StreamLocW = StreamLocW + IBUF_MAX_BYTE/4;	
			*uStreamLocW =StreamLocW;
		} else
			Disp("nothing copy to input buffer\n");

		g_IBUF_Index++;
		temp=Inp32 ( RP_PARAM1_FRAME_NUM);//0xc
		Disp("[%d] current decoded cum. tot frame number is %d  @%f\n", g_uSignalRPInbuffEmpty, temp, PWMTIMER_ReadStopwatch(0,0));
		g_uSignalRPInbuffEmpty--;//test to more than one interrupt

		return RPINT_HANDLE_INBUF_FILL_END;		
	}else if( g_currINTtype == 1)//end(done)
	{
		Disp("End of playing\n");
		return RPINT_HANDLE_PLAY_END;
	}

	return RPINT_HANDLE_NORMAL;
}



//return : -1 break;
int  RPAPP_Playingcontrol(int retControl)
{
	RPPLAYER_INFO* pinfo=(RPPLAYER_INFO *)RP_PLAYER_INFO;

	if(retControl==RPCONT_RANDOM_ACCESS)  //random access, same song repeat
		return 0;
	else if(retControl==RPCONT_QUIT)  //quit player
		return -1;


	//repeat?
	if(pinfo->uPlayerRepeat==2)	//same song repeat
		return 0;
	else if( (pinfo->uPlayingFileCurrentIndex+1) == pinfo->uPlayingFileNums)
	{
	//All playing lists are ended
		if(pinfo->uPlayerRepeat==1){//all song repeat
			pinfo->uPlayingFileCurrentIndex=pinfo->uPlayingFileStartIndex;
			return 1;
		}else						//end of custom player
			return -1;
	}
	else 
		pinfo->uPlayingFileCurrentIndex++;

	return 0;
}


////////////////////////////////////////////////////////////////////////////////////////////
//
//	need change function name, or move file location.
//
////////////////////////////////////////////////////////////////////////////////////////////


static __irq void Isr_EInt1RP(void)
{
//	INTC_Disable(NUM_EINT1);
	Disp("-E-");

	// interrupt clear in EINT SFR
	GPIO_EINT30ClrPend(1);
	INTC_ClearVectAddr();
//	INTC_Enable(NUM_EINT1);

}

void RP_SetEINTwakup()
{
	// Set wakeup interrupt for GPIO as EINT
	INTC_SetVectAddr(NUM_EINT1, Isr_EInt1RP);
	GPIO_SetEint30(1, Falling_Edge, eEnFLT, 0x1f); // EINT1, falling edge, enable filter, filter width
	
	GPIO_SetFunctionEach(eGPIO_H0, eGPIO_1, eGINT);
	GPIO_EINT30UnMask(NUM_EINT1);

	// Set all wakeup source to be unmasked
	SYSC_SetWakeupMask(eWAKEUP_ALL , false); // unmask all wakeup sources

	// Set interrupt controller
	INTC_Enable(NUM_EINT1);
}

void RP_SetEINTwakupRestore()
{
	// Set wakeup interrupt for GPIO as EINT
	INTC_SetVectAddr(NUM_EINT1, Isr_EInt1RP);

	GPIO_SetFunctionEach(eGPIO_H0, eGPIO_1, eGINT);
	// Set interrupt controller
	INTC_Enable(NUM_EINT1);
}



