#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
//#include "uart.h"
#include "sysc.h"
#include "gpio.h"
//#include "dma.h"
#include "intc.h"
#include "stopwatch.h"

#include "audiocodecs.h"
#include "asscommbox.h"
#include "rpcommbox.h"
#include "assclkcon.h"
#include "i2sv5_1.h"
#include "rpetc.h"
#include "rpaudioss_dd.h"
#include "rpapp.h"
//
extern unsigned int g_StreamLocW;//wordunit.
extern unsigned int g_IBUF_Index;//0 : IBUF0, 1 : IBUF1, //total number of interrupt during playing one file
extern unsigned int g_bitstreamBsize;
extern unsigned int *g_pbitstream;

extern u32	g_uSignalRPInbuffEmpty;
extern unsigned int g_currINTtype;
extern unsigned int g_currINTparam;



void RP_INTDeepIdleTestCase1(bool bwakedup);


void AudioSS_OSpremain3()
{
	u8 bDeepIdlewakedup;
	u32 temp;
	temp=SYSC_GetResetStatusReg();
	bDeepIdlewakedup =(temp&(1<<19)) ? true:false;
	if(bDeepIdlewakedup==false) {
		INTC_Init();
		GPIO_Init();
		OpenConsole(1);

		CalibrateDelay();

		//jump to test function
		Disp("\n[Entering test case1 func...]\n");
		RP_INTDeepIdleTestCase1(false);
	}else {

		GPIO_Init();
		OpenConsole(3);

		//jump to test function
		RP_INTDeepIdleTestCase1(true);
	}


}


//Storage(orginal size)
//current bitstream buffer(14MB MAX)
//input buffer(18KB)


//make simple version : to debug
void RP_INTDeepIdleTestCase1(bool bwakedup)
{
	u8 bAudiossWakedup, bEintWakedup;
	unsigned int RandomAccessPercent=0;
	int ret=0, ret1=0, ret2=0;

	bAudiossWakedup=SYSC_GetWakeupStatus(eWAKEUP_I2S);
	bEintWakedup=SYSC_GetWakeupStatus(eWAKEUP_EINT);
	SYSC_ClearWakeupStatus(eWAKEUP_I2S);
	SYSC_ClearWakeupStatus(eWAKEUP_EINT);	


	if(bwakedup==false)
	{
		Outp32(0xE0200c60,0x10000000);//eint31 control: output to monitoring 
		Outp32(0xE0200c64,0x80);//eint31 data : 1

		//Init AudioSS, I2S0 v5.1(prob, at OS init)
		AudioEPLL_Set(44100,384);
		SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
		SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

		Disp("[AudioSS CLKCON set]\n");
		AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
		AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
		AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

		Disp("[I2S /Codec set]\n");
		I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
		GPIO_Set_I2S0();
		WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0
		I2SV5_1_LinkStart();

		//1. open custom player	
		AudioSS_CLKCON_SetGate(ALL_BLOCKS_PASS); // set running block when RP decode (debug)
//		AudioSS_CLKCON_SetGate(ALL_BLOCKS_PASS|~(HCLK_UART_PASS)); // set running block when RP decode (release)

		AudioSS_DD_DeepIdleTimeoutClear();
		AudioSS_DD_SetDeepIdleEligible(true);
		INTC_SetVectAddr(NUM_AUDIO,ISR_RPInbuff_Empty);//Check depending for  platform
		INTC_Enable(NUM_AUDIO);
		RP_SetEINTwakup();
		Disp("[bitstream are in dram]\n");//should be loaded to dram at trace32.
		RPAPP_MakePlayinglists();
		RPAPP_showbitstreamsSelect();
		RPAPP_SetRepeatcontrol(1);//all repeat

	}else
	{
		//continuing from deep idle.
		Outp32(0xE0200c64,0x80);//eint31 data : 1//-> should locate in boot code to monitor.
		AudioSS_DD_Recover();//should located before enable interrupt
		AudioSS_CLKCON_ChangeDiv_AudBus(1-1);//audio bus clock in normal mode should be maximized for fast dma copy then enter to deep idle.
		if(bEintWakedup) 	AudioSS_DD_DeepIdleTimeoutClear();	
//		INTC_Init2();
		INTC_SetVectAddr(NUM_AUDIO,ISR_RPInbuff_Empty);//Essential!!!
		INTC_Enable(NUM_AUDIO);
		RP_SetEINTwakupRestore();
	}

	//2. custom player loop
	while(1)
	{
		//3. Playing one file
		if(bwakedup==false)
		{
			//first set commbox and etc
			g_StreamLocW=0;
			g_currINTtype=0;
			g_IBUF_Index=0;	
			g_uSignalRPInbuffEmpty=0;

			RP_Reset(RP_InstCodeAtIMEM);

			if(ret1==RPCONT_RANDOM_ACCESS)
				RPAPP_GetBitstreamInfos( true, RandomAccessPercent, &g_pbitstream, &g_bitstreamBsize );
			else
			{
				RPAPP_loadbitstream();//load bistream from storage to current bitstream buffer(14MB MAX)
				RPAPP_GetBitstreamInfos( false, RandomAccessPercent, &g_pbitstream, &g_bitstreamBsize );

				Disp("[Load RP binary]\n");
				AudioSS_COMMBOX_SetSRAM(RP_NON_CONTSRAM_FOR_RPDECODE);
				RPAPP_loadInstDataBinary(SW_ENDIAN_CONV, RP_LITTLE_ENDIAN_BINARY);
			}

			RP_SetCommbox(g_bitstreamBsize, RP_PCM_16BIT, IBUF0_ADDR, IBUF1_ADDR, IBUF_MAX_BYTE,
							 RP_IMEM_ADDR_NULL);
			Disp("[Fill input buffers]\n");
			AudioSS_COMMBOX_SetIBUFFERS(1,1);
			RPAPP_fill_Ibuffs(g_pbitstream, &g_StreamLocW);

			Disp("[play start]\n");	
			RP_StartRunning();
			PWMTIMER_Start(0);
			PWMTIMER_StartStopwatch(0,0);

			RPAPP_showCurrentBitstreamInfo();
			RPAPP_DispInfo(RandomAccessPercent);

		}else
		{
			//continuing from deep idle
			bwakedup=false;//for next file playing.
		}

		while(1)
		{
			//get user input & handle interrupt
			ret1=RPAPP_control_DI(&RandomAccessPercent);
			if(ret1==RPCONT_EXIT||ret1==RPCONT_RANDOM_ACCESS) break;
			ret2=RPAPP_interrupthandler(g_pbitstream, &g_StreamLocW, g_bitstreamBsize);
			if(ret2==RPINT_HANDLE_PLAY_END) break;
			//AudioSS_DD_DeepIdleControl(ret2, 3-1);//audiobus div at deepidle
		}

		//4. playing lists control after one song play
		ret=RPAPP_Playingcontrol(ret1);
		if(ret==-1) break;
	}

	//5. exit custom player
	INTC_Disable(NUM_AUDIO);
	INTC_ClearVectAddr();
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
}



void Test_RPDecode_MP3PlayingDeepIdle()
{
	RP_INTDeepIdleTestCase1(false);
}




////////////////////////////////////////////////////////////////////
//
// test call function
//
////////////////////////////////////////////////////////////////////

const testFuncMenu g_aRPDecodeTestFunc[] =
{	
	Test_RPDecode_MP3PlayingDeepIdle,				"Deep Idle playing    ",
	0,0
};


void RPDecode_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	u32 uSizeLists=sizeof(g_aRPDecodeTestFunc);
	
	while(1)
	{
		UART_Printf("\n\n================== RPDecode Function Test  =====================\n\n");
		
		for (uCountFunc=0; (u32)(g_aRPDecodeTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aRPDecodeTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel = UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(uSizeLists/8-1))
			(g_aRPDecodeTestFunc[iSel].func) ();
	}
}	

