
#ifndef __DECODEDAPP_H__
#define __DECODEDAPP_H__

#ifdef __cplusplus
extern "C" {
#endif

//SRAMmode option
#define USE_SINGLE_PHYSICAL_BUFFER 1
#define USE_DUAL_PHYSICAL_BUFFERS 2

//
#define	APP_I2S_INT_LV0		0//=I2S_INT_LV0
#define	APP_I2S_INT_LV1		1//=I2S_INT_LV1
#define	APP_I2S_INT_NOINT	0xff//=I2S_INT_NOINT



//single buffer, by 2 level interrupt => using as Double buffers
//with internal dma autoreload
//<--------------------------------> use 160Kb
//  one phiscial buffer
//<--------------------------------> 
//                              |                         |
//                             LV0                     LV1
//  virtual buffer0              virtual buffer1
//   80 KB  (0.4644sec for 44100Hz)
//   80 KB  (0.4266sec for 48000Hz)
//   16 KB  (0.0929sec for 44100Hz)
//   16 KB  (0.085sec for 48000Hz)

//physical buffer information
#define SRAM_BUFFER_ADDR		(0xc0000000)
#define SRAM_BUFF_TOTBSIZE		(160*1024)//160KB

// virtual buffer information
#define VIR_UNIT_BUFF_BSIZE	(SRAM_BUFF_TOTBSIZE/2)
#define VIR_BUFFER0_ADDR		(SRAM_BUFFER_ADDR)
#define VIR_BUFFER1_ADDR		(VIR_BUFFER0_ADDR+VIR_UNIT_BUFF_BSIZE)


/////////////////////////////////////////////////////////////
//APIs

//first set EPLL, Audio Sub system and I2Sv5.1 and Audio Codec chip
//SRAMmode : 
//	- USE_SINGLE_PHYSICAL_BUFFER  :  using physical buffer buffer
//	- USE_DUAL_PHYSICAL_BUFFER:  :  using two physical buffers
void AudioSS_PCM_PlayerInit(unsigned char SRAMmode);

//uPhysicalBufferAddr1 : NOT_USE_BUFFER1 or 0=> will use single physical buffer
//					   or physical buffer address(larger than 0) => will use dual physical buffer
//						  for the value, refer the Audio SS user's manual
//
// uIDMATransferBSize :
//       - single buffer :  one physical buffer buffer size,  
//       - dual buffer :  first physical buffer size among two phisical buffers
void AudioSS_PCM_PlayerStart(unsigned int uPhysicalBufferAddr0, unsigned int uPhysicalBufferAddr1, unsigned int uIDMATransferBSize,
								    unsigned int uVirtualBufferAddr0, unsigned int uVirtualBufferAddr1);

//finish until internal dma finishing. and close Audio Sub system. 
void AudioSS_PCM_PlayerFinish();




#ifdef __cplusplus
}
#endif


#endif //__DECODEDAPP_H__


