#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
//#include "uart.h"
#include "sysc.h"
#include "gpio.h"
//#include "dma.h"
#include "intc.h"
//#include "stopwatch.h"


#include "audiocodecs.h"
#include "asscommbox.h"
#include "rpcommbox.h"
#include "assclkcon.h"
#include "i2sv5_1.h"
#include "rpetc.h"
#include "decodedapp.h"
//


unsigned int g_I2sCurInt;
bool g_bIdmaDone;


void __irq ISR_I2Stest(void)
{
	unsigned int eIntI2S;
	
	INTC_Disable(NUM_I2S0);
	if ( I2S_GetIntStatus(&eIntI2S) )
	{
		g_I2sCurInt=eIntI2S;
		switch(eIntI2S)
		{
			case I2S_INT_LV0:
				Disp("[LV0]");break;
			case I2S_INT_LV1:
				Disp("[LV1]");break;
			case I2S_INT_LV2:
				Disp("[LV2]");break;
			case I2S_INT_LV3:
				Disp("[LV3]");break;
			case I2S_INT_IDMA_DONE:
				g_bIdmaDone=1;
				Disp("[IDMA_DONE]");break;
			case I2S_INT_UDR_TXn:
				Disp("[TX_UDR]");break;
			case I2S_INT_OVR_RX:
				Disp("[RX_UDR]");break;
			case I2S_INT_UDR_TXS:
				Disp("[TXS_UDR]");break;
 		}
		I2S_ClearIntPending(eIntI2S);
	}
	else
		Disp("Unkown Interrupt\n");


	INTC_ClearVectAddr();
	INTC_Enable(NUM_I2S0);

}




//first set EPLL, Audio Sub system and I2Sv5.1 and Audio Codec chip
//SRAMmode : 
//	- USE_SINGLE_PHYSICAL_BUFFER  :  using physical buffer buffer
//	- USE_DUAL_PHYSICAL_BUFFER:  :  using two physical buffers
void AudioSS_PCM_PlayerInit(unsigned char SRAMmode)
{
	bool bsrammode;
	//Init AudioSS, I2S0 v5.1
	AudioEPLL_Set(44100,384);
	SYSC_SetAudioBlockPowerOn();//I2S0 v5.1, RP
	SYSC_SetAudioEndian(RP_R_BIG,RP_W_BIG,ARM_R_LITTLE,ARM_W_LITTLE);//to access i2sv5.1, clkcon.(commbox)

	Disp("[AudioSS CLKCON set]\n");
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
//	AudioSS_CLKCON_SetDivider(2-1,1-1);//(i2sclk, audio bus)
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)

	Disp("[I2S /Codec set]\n");
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);//SD1-0,SD2-0, PreSaler_Value-0
	GPIO_Set_I2S0();
	WM8580_CodecInitPCMOutwithVol(PRIMARY_PORT, I2S_Slave, I2SFormat,   0, 16, RFS_NA, 0xff);//SampleRate-0
	I2SV5_1_LinkStart();

	//1. open custom player	
	AudioSS_CLKCON_SetGate(HCLK_RPCORE_IMEM_DMEM_PASS|HCLK_I2SV5_1_PASS|I2SCLK_PASS);// set running block when ARM decode
	INTC_SetVectAddr(NUM_I2S0, ISR_I2Stest);//Check depending on 
	INTC_Enable(NUM_I2S0);

	RP_Reset(RP_InstCodeAtIMEM);
	bsrammode=(SRAMmode==USE_SINGLE_PHYSICAL_BUFFER)?RP_CONTSRAM_FOR_ARMDECODE : RP_NON_CONTSRAM_FOR_RPDECODE;
	AudioSS_COMMBOX_SetSRAM(bsrammode);//160KB 
}



//uPhysicalBufferAddr1 : NOT_USE_BUFFER1 => will use single physical buffer
//					   or physical buffer address => will use dual physical buffer
//
// uIDMATransferBSize :
//       - single buffer :  one physical buffer buffer size,  
//       - dual buffer :  first physical buffer size among two phisical buffers
void AudioSS_PCM_PlayerStart(unsigned int uPhysicalBufferAddr0, unsigned int uPhysicalBufferAddr1, unsigned int uIDMATransferBSize,
								    unsigned int uVirtualBufferAddr0, unsigned int uVirtualBufferAddr1)
{
	//phisical buffer setting : one buffer
	I2SV5_1_Start_TXsecondaryIDMA(uPhysicalBufferAddr0, uPhysicalBufferAddr1,  uIDMATransferBSize, INIT_DMAINDEX, DIS_DMADONE_INT);

	//level interrupt setting : two points => use as double buffers
	I2S_EnableInterrupt(I2S_INT_LV0, uVirtualBufferAddr1, 0);
	I2S_EnableInterrupt(I2S_INT_LV1, uVirtualBufferAddr0, 0);

}

void AudioSS_PCM_PlayerFinish()
{
	//exit routine
	I2STXS_Pause();	
//	I2STCUtil(1, 1);

	//exit custom player
	INTC_Disable(NUM_I2S0);
	INTC_ClearVectAddr();
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
}



