
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
//#include "dma.h"
#include "intc.h"
#include "pcmutils.h"//for pcm parser


//header / variable needed
#include "decodedapp.h"
extern unsigned int g_I2sCurInt;//this value is Set @ ISR, defined at decodedapp.c
//


//Test defines
#define PCM_IN_WAVEFILE_ADDRESS	0x44200000



//User define
unsigned int g_APPStreamLocW;//wordunit.
unsigned int g_APPbitstreamBsize;
unsigned int *g_pAPPbitstream;
//End of user define





//User functions.
void UserAPPInit(unsigned int uBufferAddr0, unsigned int uBufferAddr1, unsigned int uBuffer0BSize, unsigned int uBuffer1BSize)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int i;
	unsigned short j,k;
	unsigned int temp;
	unsigned int uTOT_BUFFS_BSIZE=(uBuffer0BSize+uBuffer1BSize);

	g_APPStreamLocW=0;
	//parse file(file loaded from trace32 @0x24200000)
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);
	g_pAPPbitstream = (unsigned int *)pcmdataaddr;
	temp=pcmdatasizeb%(uTOT_BUFFS_BSIZE);//to make   end at buf1.
	g_APPbitstreamBsize=pcmdatasizeb-temp;


	Disp("[Fill decoded pcm]\n");
	memcpy2((void*)uBufferAddr0, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer0BSize);
	g_APPStreamLocW = g_APPStreamLocW + uBuffer0BSize/4;
	memcpy2((void*)uBufferAddr1, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer1BSize);
	g_APPStreamLocW = g_APPStreamLocW + uBuffer1BSize/4;
}


void UserAPPInthandler(unsigned int uBufferAddr0, unsigned int uBufferAddr1, unsigned int uBuffer0BSize, unsigned int uBuffer1BSize)
{
	u8 bendcondition=0;
	g_I2sCurInt = APP_I2S_INT_NOINT;

	while( 1)
	{	
		while( g_I2sCurInt==APP_I2S_INT_NOINT) ;
		
		if(bendcondition==1) {
			Disp("nothing to copy\n");
			break;
		}

		if (g_I2sCurInt==APP_I2S_INT_LV0)
		{
			memcpy2((void*)uBufferAddr0, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer0BSize);
			g_APPStreamLocW += (uBuffer0BSize/4);//word size
			Disp("fill to buff0\n");
		}
		else if (g_I2sCurInt==APP_I2S_INT_LV1)
		{
			memcpy2((void*)uBufferAddr1, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer1BSize);
			g_APPStreamLocW += (uBuffer1BSize/4);//word size
			Disp("fill to buff1\n");
		}				
		else
			continue;

		g_I2sCurInt = APP_I2S_INT_NOINT;

		if ( g_APPStreamLocW>= (g_APPbitstreamBsize/4)  ) 	bendcondition=1;
	}
}
//end of user functions.


//Playing decoded pcm data by AudioSubsystem SRAM and I2Sv5.1
//without power mode
//
// User can change UserAPPInit and UserAPPIntHandler
//
// notice : AudioSS_PCM_PlayerFinish will wait for one virtual buffer size(max) (0.170~0.93 sec)
//          to finish once, AudioSS_PCM_PlayerQuit api is needed(possible upon request)
//
void APP_PlayingWavFileUsingAudioSubSysem()
{


	AudioSS_PCM_PlayerInit(USE_SINGLE_PHYSICAL_BUFFER);	//first set EPLL, Audio Sub system and I2Sv5.1 and Audio Codec chip, Set SRAM option

	UserAPPInit(VIR_BUFFER0_ADDR, VIR_BUFFER1_ADDR, VIR_UNIT_BUFF_BSIZE,VIR_UNIT_BUFF_BSIZE);				//load pcm, fill two buffers

	AudioSS_PCM_PlayerStart(SRAM_BUFFER_ADDR, 0, SRAM_BUFF_TOTBSIZE,
							  VIR_BUFFER0_ADDR, VIR_BUFFER1_ADDR);	//set I2Sv5.1 internal dma and start. : 0-NOT_USE_BUFFER1

	Disp("[Playing started...]\n");
	UserAPPInthandler(VIR_BUFFER0_ADDR, VIR_BUFFER1_ADDR, VIR_UNIT_BUFF_BSIZE, VIR_UNIT_BUFF_BSIZE);		//fill buffer when one buffer is empty

	AudioSS_PCM_PlayerFinish();	//finish until internal dma finishing. and close Audio Sub system. 
}




//auto test

#define SRAM_BUFF_TOTBSIZE2		(32*1024)//32KB for autotest
#define VIR_UNIT_BUFF_BSIZE2	(SRAM_BUFF_TOTBSIZE2/2)
#define VIR_BUFFER0_ADDR2		(SRAM_BUFFER_ADDR)
#define VIR_BUFFER1_ADDR2		(VIR_BUFFER0_ADDR+VIR_UNIT_BUFF_BSIZE2)

extern unsigned int ptada[];

//User functions.
void UserAPPInit2(unsigned int uBufferAddr0, unsigned int uBufferAddr1, unsigned int uBuffer0BSize, unsigned int uBuffer1BSize)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int samplefreq;
	unsigned short j,k;
	unsigned int temp;
	unsigned int uTOT_BUFFS_BSIZE=(uBuffer0BSize+uBuffer1BSize);

	g_APPStreamLocW=0;

	//include from header
	j=2;//totch
	samplefreq=22050;//samplerate,
	k=16;//bitperch,
	pcmdatasizeb=171008;
	pcmdataaddr=(unsigned int)&ptada;

	g_pAPPbitstream = (unsigned int *)pcmdataaddr;
	temp=pcmdatasizeb%(uTOT_BUFFS_BSIZE);//to make   end at buf1.
	g_APPbitstreamBsize=pcmdatasizeb-temp;

	Disp("[Fill decoded pcm]\n");
	memcpy2((void*)uBufferAddr0, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer0BSize);
	g_APPStreamLocW = g_APPStreamLocW + uBuffer0BSize/4;
	memcpy2((void*)uBufferAddr1, (void *)(g_pAPPbitstream+g_APPStreamLocW), uBuffer1BSize);
	g_APPStreamLocW = g_APPStreamLocW + uBuffer1BSize/4;
}


void UserAPPInthandler2(unsigned int uBufferAddr0, unsigned int uBufferAddr1, unsigned int uBuffer0BSize, unsigned int uBuffer1BSize)
{
	int  obufcopybsize ;
	g_I2sCurInt = APP_I2S_INT_NOINT;

	while( 1)
	{	
		while( g_I2sCurInt==APP_I2S_INT_NOINT) ;
		
		if (g_I2sCurInt==APP_I2S_INT_LV0)
		{
			obufcopybsize = ( (g_APPStreamLocW*4+ uBuffer0BSize)  <= g_APPbitstreamBsize )? uBuffer0BSize : (g_APPbitstreamBsize-g_APPStreamLocW*4 );

			if(obufcopybsize>0) {
				memcpy2((void*)uBufferAddr0, (void *)(g_pAPPbitstream+g_APPStreamLocW), obufcopybsize);
				g_APPStreamLocW += (obufcopybsize/4);//word size
				Disp("fill to buff0\n");
			} else {
				Disp("nothing to copy\n");
				break;
			}

		}
		else if (g_I2sCurInt==APP_I2S_INT_LV1)
		{
			obufcopybsize = ( (g_APPStreamLocW*4+ uBuffer1BSize)  <= g_APPbitstreamBsize )? uBuffer1BSize : (g_APPbitstreamBsize-g_APPStreamLocW*4 );

			if(obufcopybsize>0) {
				memcpy2((void*)uBufferAddr1, (void *)(g_pAPPbitstream+g_APPStreamLocW), obufcopybsize);
				g_APPStreamLocW += (obufcopybsize/4);//word size
				Disp("fill to buff1\n");
			} else {
				Disp("nothing to copy\n");
				break;
			}
		}				
		else
			continue;

		g_I2sCurInt = APP_I2S_INT_NOINT;

	}
}

u8 APP_PlayingWavFileUsingAudioSubSysemAuto()
{
	Disp("\n***************************");
	Disp("\nSMDK CFG pin Check");
	Disp("\n***************************");
	Disp("\n2. CFGB11  : [off][on][on][off][off][off]");	

	AudioSS_PCM_PlayerInit(USE_SINGLE_PHYSICAL_BUFFER);	//first set EPLL, Audio Sub system and I2Sv5.1 and Audio Codec chip, Set SRAM option
	//for 22050hz
	//AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)
	AudioSS_CLKCON_SetDivider(8-1,1-1);//(i2sclk, audio bus)//for smdk 67.738MHz / 4/2


	UserAPPInit2(VIR_BUFFER0_ADDR2, VIR_BUFFER1_ADDR2, VIR_UNIT_BUFF_BSIZE2,VIR_UNIT_BUFF_BSIZE2);				//pcm in header, fill two buffers
//	UserAPPInit(VIR_BUFFER0_ADDR2, VIR_BUFFER1_ADDR2, VIR_UNIT_BUFF_BSIZE2,VIR_UNIT_BUFF_BSIZE2);				//load pcm, fill two buffers(	parse file(file loaded from trace32 @0x24200000))

	AudioSS_PCM_PlayerStart(SRAM_BUFFER_ADDR, 0, SRAM_BUFF_TOTBSIZE2,
							  VIR_BUFFER0_ADDR2, VIR_BUFFER1_ADDR2);	//set I2Sv5.1 internal dma and start. : 0-NOT_USE_BUFFER1

	Disp("[Playing started...]\n");

	//pwm timer check.
	UserAPPInthandler2(VIR_BUFFER0_ADDR2, VIR_BUFFER1_ADDR2, VIR_UNIT_BUFF_BSIZE2, VIR_UNIT_BUFF_BSIZE2);		//fill buffer when one buffer is empty

	//pwm timer check end.

	AudioSS_PCM_PlayerFinish();	//finish until internal dma finishing. and close Audio Sub system. 

	return 1;
}




////////////////////////////////////////////////////////////////////
//
// App call function
//
////////////////////////////////////////////////////////////////////

const testFuncMenu g_aDecodedPCMTestFunc[] =
{	
	APP_PlayingWavFileUsingAudioSubSysem,				"Decoded PCM playing Using Audio Sub System   ",

	0,0
};


void AudioSS_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	u32 uSizeLists=sizeof(g_aDecodedPCMTestFunc);
	
	while(1)
	{
		UART_Printf("\n\n================== Audio SS PCM playing App case  =====================\n\n");	
		
		for (uCountFunc=0; (u32)(g_aDecodedPCMTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aDecodedPCMTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel = UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(uSizeLists/8-1))
			(g_aDecodedPCMTestFunc[iSel].func) ();
	}
}	

