/**************************************************************************************
* 
*	File Name : timer_watch.c
*  
*	File Description : PWM stopwatch api
*	Version : 0.00
* 
*	History"
*	- Created(Dongjin Kim 2009/04/10)
**************************************************************************************/


//v210
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "def.h"
#include "timer.h"
#include "intc.h"
#include "sysc.h"
#include "gpio.h"


#define PCLK_DEFINE	g_uPclkPsys



/////////////////////////////////////////////////////
//
//  
// PWM Stopwatch  ver 0.0 by Dongjin Kim
// 
/////////////////////////////////////////////////////

#define MAX_COUNT	0xffffffff
#define TIMER0_FREQ	1000000//1us order
#define TIMER0_PERIOD	(0.000001)// -1us

#define NUM_TIMER	2
#define NUM_STOPWATCH_PER_TIMER	10

//timer clock = pclk/{ (prescaler value+1)*(divider value) }
//prescaler value+1 = pclk/timer clock  | where divider value is 1.

//timer,  10 stop watchs per each timer
// 0: timer0 - 1us.   max  4294sec =>  71 min 
void PWMTIMER_Start(int timer)
{
	int sPreScaler;

	sPreScaler = PCLK_DEFINE/TIMER0_FREQ-1;
//	Assert( (1<=sPreScaler) && (sPreScaler<=255) );
		
	Outp32(rTCON, 0); // timer0 stop
	Outp32(rTCFG0, sPreScaler<<0); // preScalerFor0&1[7:0], preScalerFor2&3[15:8]
	Outp32(rTCFG1, 0); // divider0[3:0] (0=1/2, 1=1/4, 2=1/8, 3=1/16), divider1,2,3,4
	Outp32(rTCNTB0, MAX_COUNT);
	Outp32(rTCMPB0, 0x1);
	Outp32(rTCON, (0<<3)|(1<<1)|(0<<0)); // timer0 manual update
	Outp32(rTCON, (0<<3)|(0<<1)|(1<<0)); // timer0 start, one-shot
		// autoReload[3], inverted[2], manualUpdate[1], start[0]
}


u32 uCntInit[NUM_TIMER][NUM_STOPWATCH_PER_TIMER];

void PWMTIMER_StartStopwatch(int timer, int index)
{
	u32 temp;	
	temp=Inp32(rTCNTO0);
	uCntInit[timer][index] = temp;
}


//two timer,  10 stop watchs per each timer
// 0: timer0 - unit 1us
//return floating sec unit.
float PWMTIMER_ReadStopwatch(int timer, int index)
{
	u32 curcnt;	
	u32 diffcnt;		
	float unittime;

	
	curcnt=Inp32(rTCNTO0);
	diffcnt = uCntInit[timer][index]-curcnt;
	unittime = (float)diffcnt*TIMER0_PERIOD;

	if(curcnt==0) {//finished or expired
		Disp("finished or expired\n");
	}

//	Disp("%x\n", uCntInit[timer][index]);
//	Disp("%x\n", curcnt);
//	Disp("=%x\n", diffcnt);	
	
	return unittime;
}


