#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#include "pcmutils.h"
#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"


#include "tada.h"
#include "pcmvoice.h"
#include "sin1khz.h"

void Parser_32to24(u32* rhs_pStartAddr, u32 rhs_uSize, u32 *rhs_pNewAddr)
{
	u8* pBufferAddr = (u8 *)rhs_pNewAddr;				//able to change
	u8* pTempAddr = (u8 *)rhs_pStartAddr;
	s32 uSize = (rhs_uSize/4)*3;						//for word access
	s32 uCnt = 0;
	
	do
	{
		for (uCnt = 0;uCnt < 3;uCnt++)
		{
			*pBufferAddr++ = *pTempAddr++;			
			uSize--;
		}
		pTempAddr++;
	}while(uSize >= 0);
	UART_Printf("End Address is 0x%x\n", (u32) pBufferAddr);
}

void Parser_24to32(u32* rhs_pStartAddr, u32 rhs_uSize, u32 *rhs_pNewAddr)
{
	u8* pBufferAddr = (u8 *)rhs_pNewAddr;				//able to change
	u8* pTempAddr = (u8 *)rhs_pStartAddr;
	s32 uSize = (rhs_uSize/3)*4;						//for word access
	s32 uCnt = 0;
	
	do
	{
		for (uCnt = 0;uCnt < 3;uCnt++)
		{
			*pBufferAddr++ = *pTempAddr++;			
			uSize--;
		}
		*pBufferAddr++ = 0;
	}while(uSize >= 0);
}

void Decomp32to24(u32* rhs_pStartAddr, u32 rhs_uSize, u32 *rhs_pNewAddr)
{
	u32* pBufferAddr = rhs_pNewAddr;				//able to change
	u32* pTempAddr = rhs_pStartAddr;
	s32 sSize = rhs_uSize;
	u32 uTemp;	
	
	do
	{
		uTemp = *pTempAddr;
		uTemp = uTemp >> 8;
		*pBufferAddr++ = uTemp;
		sSize = sSize - 4;		
	}while(sSize >= 0);

}



//pcm : little endian continous format => little endian fifo format(2byte, 4byte seperated format) 
// converting and copy
//          L         R        L          R 
//ex) byte# 0        1        2          3 	    		8bit
//			0 1      2 3      4 5        6 7    		16bit
//          0 1 2    3 4 5    6 7 8      9 10 11 		24bit
//          0 1 2 3  4 5 6 7  8 9 10 11  12 13 14 15	32bit

//orgsize : byte
u8 PCM_ContinuousPCM2FifoFormat_converting(unsigned int destaddr, unsigned int* destsizeByte, int destbit,
						unsigned int orgaddr, int orgsizeByte, int orgbit)
{
	unsigned char* 	pstartaddr=(unsigned char *)destaddr;
	unsigned int* pdestaddr = (unsigned int* )destaddr;
	unsigned char* porgaddr = (unsigned char* )orgaddr;
	int i;	
	u8 bprint=0;

	printf("original is pcm continous format!!!\n");
	if(orgbit == 8)
	{
		printf("not yet supported\n");
		return;
	}
	
	if(orgbit == 16)
	{
		if(destbit == 24)
		{
			for(i=0; i<orgsizeByte; i+=2)
			{
				*pdestaddr = (porgaddr[i]<<8) | (porgaddr[i+1]<<16);		
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
				
			}
		}
		else
		if(destbit == 16 || destbit == 8)
		{
			for(i=0; i<orgsizeByte; i+=4)
			{
				*pdestaddr = (porgaddr[i]<<0) | (porgaddr[i+1]<<8) | (porgaddr[i+2]<<16) | (porgaddr[i+3]<<24);
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}
			
		}
	}
	else
	if(orgbit == 24)
	{
		if(destbit == 24)
		{
			for(i=0; i<orgsizeByte; i+=3)
			{
				*pdestaddr = (porgaddr[i]<<0) |(porgaddr[i+1]<<8) | (porgaddr[i+2]<<16);		
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}
		}
		else
		if(destbit == 16)
		{
			for(i=0; i<orgsizeByte; i+=6)
			{
				*pdestaddr = (porgaddr[i+1]<<0) | (porgaddr[i+2]<<8) |  (porgaddr[i+4]<<16) | (porgaddr[i+5]<<24);		
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}			
		}
		else
		if(destbit == 8)
		{
			for(i=0; i<orgsizeByte; i+=12)
			{
				*pdestaddr = (porgaddr[i+2]<<0) | (porgaddr[i+5]<<8) |  (porgaddr[i+8]<<16) | (porgaddr[i+11]<<24);		
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}			
		}
		
	}
	else
	if(orgbit == 32)
	{
		if(destbit == 24)
		{
			for(i=0; i<orgsizeByte; i+=4)
			{
				*pdestaddr = (porgaddr[i+1]<<0) | (porgaddr[i+2]<<8) | (porgaddr[i+3]<<16);
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}
		}			
		else
		if(destbit == 16 || destbit == 8)
		{
			for(i=0; i<orgsizeByte; i+=8)
			{
				*pdestaddr = (porgaddr[i+2]<<0) | (porgaddr[i+3]<<8) |  (porgaddr[i+6]<<16) | (porgaddr[i+7]<<24);		
				pdestaddr++;
				if(bprint)Disp("%x : %x\n", pdestaddr, *pdestaddr);
			}			
		}
	}	
	
	*destsizeByte = (unsigned int)((unsigned char* )pdestaddr - (unsigned char* )pstartaddr);		
	
	Disp("Converting from %d bit(size:0x%x-%d byte) to %d bit(size:0x%x %dbyte) is finished\n",
			orgbit, orgsizeByte, orgsizeByte, destbit, *destsizeByte, *destsizeByte);
	
	return 1;
}


u8 PCM_Resampling96to64(unsigned int destaddr, unsigned int* destsizeByte, 
						unsigned int orgaddr, int orgsizeByte)
{
	unsigned char* 	pstartaddr=(unsigned char *)destaddr;
	unsigned int* pdestaddr = (unsigned int* )destaddr;
	unsigned int* porgaddr = (unsigned int* )orgaddr;
	int i;	
	unsigned int  orgsizeWord = (orgsizeByte-orgsizeByte%6)/4;
	unsigned int  downsampleratio;


	unsigned int 	destSamplerate=64000;
	unsigned int 	orgSamplerate=96000;
	int 			orgbit=24;

	int 			unitcnt;//0,1,2
	
	unitcnt=0;
	for(i=0; i<orgsizeWord; i+=2)
	{
		if(unitcnt!=2)
		{
			*pdestaddr = porgaddr[i];
			pdestaddr++;
			*pdestaddr = porgaddr[i+1];
			pdestaddr++;
			
		}		
		unitcnt = (unitcnt>=2)? 0 : unitcnt+1;
	}

	
	*destsizeByte = (unsigned int)((unsigned char* )pdestaddr - (unsigned char* )pstartaddr);		
	
	Disp("Resampling %d bit from %d Hz(size:0x%x) to %d Hz(size:0x%x) is finished\n",
			orgbit, orgSamplerate, orgsizeByte, destSamplerate, *destsizeByte);
	
	return 1;
}




//pcm : little endian continous format => little endian fifo format(2byte, 4byte seperated format) 
// converting and copy
//          L         R        L          R 
//ex) byte# 0 1      2 3      4 5        6 7    		16bit
//          0 1 2    3 4 5    6 7 8      9 10 11 		24bit
//          0 1 2 3  4 5 6 7  8 9 10 11  12 13 14 15	32bit

//orgsize : byte
u8 PCM_Resampling(unsigned int destaddr, unsigned int* destsizeByte, unsigned int destSamplerate,
						unsigned int orgaddr, int orgsizeByte, unsigned int orgSamplerate, int orgbit)
{
	unsigned char* 	pstartaddr=(unsigned char *)destaddr;
	unsigned int* pdestaddr = (unsigned int* )destaddr;
	unsigned short int* pdestaddrHalf = (unsigned short int* )destaddr;
	unsigned int* porgaddr = (unsigned int* )orgaddr;
	int i;	
	unsigned int  orgsizeWord = orgsizeByte/4;
	unsigned int  orgsizeHalfWord = orgsizeByte/2;
	unsigned int  downsampleratio;
	
	//
	if(destSamplerate == orgSamplerate) 
	{
		Disp("same sampling rate, return\n");
		return;		
	}
	
	//downsampling
	downsampleratio = orgSamplerate / destSamplerate;
	if(downsampleratio<1) 
	{
		Disp("downsampling is supported, \n");
		return;
	}
	
	if(orgSamplerate==96000 && destSamplerate ==64000 && orgbit==24)
		return PCM_Resampling96to64(destaddr, destsizeByte, orgaddr, orgsizeByte);
	
	if(downsampleratio * destSamplerate != orgSamplerate)
	{
		Disp("please choose destSamplerate as a propotional of orgsamplerate(%d)\n", orgSamplerate );
		return;
	}
	
	if(orgbit == 16)
	{
		for(i=0; i<orgsizeWord; i+=downsampleratio)
		{
			*pdestaddr = porgaddr[i];
			pdestaddr++;
		}
	}
	else
	if(orgbit == 24)
	{
		for(i=0; i<orgsizeWord; i+=2*downsampleratio)
		{
			*pdestaddr = porgaddr[i];
			pdestaddr++;
			*pdestaddr = porgaddr[i+1];
			pdestaddr++;
		}
	}
	else	
	if(orgbit == 8)
	{
		for(i=0; i<orgsizeHalfWord; i+=downsampleratio )
		{
			*pdestaddrHalf = porgaddr[i];
			pdestaddrHalf++;
		}
	}	
	
	if(orgbit == 16 || orgbit == 24)
		*destsizeByte = (unsigned int)((unsigned char* )pdestaddr - (unsigned char* )pstartaddr);		
	else
		*destsizeByte = (unsigned int)((unsigned char* )pdestaddrHalf - (unsigned char* )pstartaddr);		
	
	Disp("Resampling %d bit from %d Hz(size:0x%x - %dbyte) to %d Hz(size:0x%x - %d byte) is finished\n",
			orgbit, orgSamplerate, orgsizeByte, orgsizeByte, destSamplerate, *destsizeByte, *destsizeByte);
	
	return 1;
}

u8 Wave_Parser(u32 uWaveStartAddr, u8* uTotch, u32* uSampleRate, u8* uBitperch, u32* uSize, u32* uWaveDataAddr)
{
	u8* pch=(u8 *)(uWaveStartAddr+8);//8 is wave loc offset
	u16* u16data=(u16 *)(uWaveStartAddr+0x16);
	u32* u32data=(u32 *)(uWaveStartAddr+0x18);
	
	if(pch[0] == 'W' && pch[1] == 'A' && pch[2] == 'V' && pch[3] == 'E')
	{
		*uTotch = *u16data;
		*uSampleRate = *u32data;
		
		*uBitperch=*(unsigned short *)(uWaveStartAddr+0x22);
		
		
		pch=(unsigned char *)(uWaveStartAddr+0x28-4);
		if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')
		{
			*uSize = *(unsigned int *)(uWaveStartAddr+0x28);
			*uWaveDataAddr = (uWaveStartAddr+0x28+4);			
		}
		else
		{
			pch=(unsigned char *)(uWaveStartAddr+0x40-4);
			if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
			{
				*uSize = *(unsigned int *)(uWaveStartAddr+0x40);
				*uWaveDataAddr = (uWaveStartAddr+0x40+4);				
			}
			else
			{
			
				pch=(unsigned char *)(uWaveStartAddr+0x4c-4);
				if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
				{
					*uSize = *(unsigned int *)(uWaveStartAddr+0x4c);
					*uWaveDataAddr = (uWaveStartAddr+0x4c+4);				
				}
				else
				{			
					pch=(unsigned char *)(uWaveStartAddr+0x7c-4);
					if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
					{
						*uSize = *(unsigned int *)(uWaveStartAddr+0x7c);
						*uWaveDataAddr = (uWaveStartAddr+0x7c+4);					
					}
					else
						*uSize = 0;
				}
			}
			
		}		
		
		UART_Printf("wave parsed result : totch : %d, samplerate : %d, bitperch : %d, size : %d byte",
				*uTotch, *uSampleRate, *uBitperch, *uSize);
		return 1;
	}
	else return 0;

}

//output : return success/fail
//         pcmdata address
bool PCM_waveparser(unsigned int uWaveStartAddr,
					unsigned short* uTotch,
					unsigned int*	uSampleRate,
					unsigned short* uBitperch,
					unsigned int*	uSize,
					
					unsigned int *uWaveDataAddr
					)
{
	unsigned char* pch=(unsigned char *)(uWaveStartAddr+8);//8 is wave loc offset
	unsigned short* u16data=(unsigned short *)(uWaveStartAddr+0x16);
	unsigned int* 	u32data=(unsigned int *)(uWaveStartAddr+0x18);
	
	if(pch[0] == 'W' && pch[1] == 'A' && pch[2] == 'V' && pch[3] == 'E')
	{
		*uTotch = *u16data;
		*uSampleRate = *u32data;
		
		*uBitperch=*(unsigned short *)(uWaveStartAddr+0x22);
		
		
		pch=(unsigned char *)(uWaveStartAddr+0x28-4);
		if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')
		{
			*uSize = *(unsigned int *)(uWaveStartAddr+0x28);
			*uWaveDataAddr = (uWaveStartAddr+0x28+4);			
		}
		else
		{


			pch=(unsigned char *)(uWaveStartAddr+0x34-4);
			if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
			{
				*uSize = *(unsigned int *)(uWaveStartAddr+0x34);
				*uWaveDataAddr = (uWaveStartAddr+0x34+4);				
			}
			else
			{
				pch=(unsigned char *)(uWaveStartAddr+0x40-4);
				if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
				{
					*uSize = *(unsigned int *)(uWaveStartAddr+0x40);
					*uWaveDataAddr = (uWaveStartAddr+0x40+4);				
				}
				else
				{
				
					pch=(unsigned char *)(uWaveStartAddr+0x4c-4);
					if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
					{
						*uSize = *(unsigned int *)(uWaveStartAddr+0x4c);
						*uWaveDataAddr = (uWaveStartAddr+0x4c+4);				
					}
					else
					{			
						pch=(unsigned char *)(uWaveStartAddr+0x7c-4);
						if(pch[0] == 'd' && pch[1] == 'a' && pch[2] == 't' && pch[3] == 'a')		
						{
							*uSize = *(unsigned int *)(uWaveStartAddr+0x7c);
							*uWaveDataAddr = (uWaveStartAddr+0x7c+4);					
						}
						else
							*uSize = 0;
					}
				}
			}
				
		}		
		
		//printf-semi hosting?
		Disp("wave parsed result : totch-%d, samplerate-%d, bitperch-%d, size-%d byte",
				*uTotch, *uSampleRate, *uBitperch, *uSize);
		
		return 1;
	}
	else return 0;
}




//uSize : byte
void PCM_Data_init(unsigned int uBufferAddr, unsigned int uSize)
{
	int iIndex;
	unsigned int wordSize = uSize/4;
	// Reg_Buf Memory init	
	for(iIndex=0;iIndex<wordSize;iIndex+=1)
	{
		*( (unsigned int*)(uBufferAddr)+iIndex)=0x0;
	}
	Disp("\n Check 0x%x Memory Init and Press Ant Key! \n", uBufferAddr);
}


//	*(rec_buf+0)="TSET";
//	*(rec_buf+1)="S2I_";
//uSize : byte
void PCM_Data_making(unsigned int uBufferAddr, unsigned int uSize, unsigned int Tagone, unsigned int Tagtwo)
{
	int i;
    unsigned int *rec_buf = (unsigned int *)uBufferAddr; 
    unsigned int wordSize = uSize/4;
	
	if(wordSize < 0xffff) //if [31:16] is not occupied by data
	{
		for(i=0;i<wordSize;i++)
		{
			*(rec_buf+i)= ( (0xffff-i)<<16)| (i&0xffff);
		}		
	}
	else
	{
		for(i=0;i<wordSize;i++)
		{
			*(rec_buf+i)=i;
		}
		
	}
	
	*(rec_buf+0)=Tagone;
	*(rec_buf+1)=Tagtwo;
}

//offset
//StartAddr                          EndAddr
//     Tag1 Tag2
//      ^
//      retAddr
//<--> offset
//      <------------------------------------> size to compare : totsize-offset
//<------------------------------------------> totsize
unsigned int PCM_ReturnStartAddr(unsigned int Startaddr, unsigned int Tagone, unsigned int Tagtwo, unsigned int* Offset)
{
	unsigned int * bufaddr = (unsigned int *)Startaddr;
	unsigned int * bufaddr1,  *bufaddr2;
	unsigned int retAddr;
	unsigned int j;
	int i;
	
	for(i=0; i<100; i++)
	{
		bufaddr1=bufaddr+i;
		bufaddr2=bufaddr+i+1;
		
		if( *bufaddr1 == Tagone && *bufaddr2 == Tagtwo) 
		{
			retAddr = (unsigned int) bufaddr1;			
			j= retAddr - Startaddr;
			*Offset =j;
			return retAddr ;
		}
	}
	return 0;
}


//input : ao -source address,  a1 - dest address, words-words size to compare, bhalfword-compare only LSB 16bit.
//output : bool -match(1) / not match(0)
u8 PCM_Compare32(u32 a0, u32 a1, u32 words, u8 bprint, u8 bhalfword)
{
	u32* pD0 = (u32 *)a0;
	u32* pD1 = (u32 *)a1;
	int i,j;
	u8 ret = TRUE;
	
	j=0;
	for (i=0; i<words; i++)
	{
	
		if(bhalfword)
		{
			if ( (*pD0 & 0xffff) != (*pD1&0xffff) )  {
				ret = FALSE;
				j++;
				if(bprint && j<20 )Disp(" %08x=%08x : %08x=%08x\n", pD0, *pD0, pD1, *pD1);
			}
		}
		else
		{
			if (*pD0 != *pD1) {
				ret = FALSE;
				j++;
				if(bprint && j<20 )Disp(" %08x=%08x : %08x=%08x\n", pD0, *pD0, pD1, *pD1);
			}
		}
		pD0++;
		pD1++;
	}

	return ret;
}


