#ifndef __AUDIODEFINES_H__
#define __AUDIODEFINES_H__
 
  
 #include "def.h"
#include "v210_sfr.h" 
  
#ifdef __cplusplus
extern "C" {
#endif

//////////////////////////////////////////////////
//
//	Common(Codec chip, Audio IPs)
//
//////////////////////////////////////////////////
typedef enum
{
	RFS_256fs = 0,		//8, 16
	RFS_512fs = 1,		//8, 16
	RFS_384fs = 2,		//8,16,24bit
	RFS_768fs = 3, 		//8,16,24bit
	RFS_NA = 10,		//not applicable.
}I2S_LRCLKLength;		//RFS

typedef enum
{
	I2SFormat 				= 0,
	MSBJustified 				= 1,
	LSBJustified 				= 2,
	AFTER_PCMSYNC_HIGH 	= 3,
	DURING_PCMSYNC_HIGH 	= 4,
	ACLinkSlot34				= 5,
	ACLinkSlot6				= 6,
}SerialDataFormat;


typedef enum
{
	I2S_Master = 0,
	I2S_Slave = 1,
}I2SOPMode;


typedef enum 
{
	I2STX=0,
	 I2SRX=1,
	 I2STRX=2,
}I2SDIR;

typedef enum 
{
	RCLK_PCLK=0,
	 RCLK_I2SCLK=1,
}I2SRCLK;

typedef enum
{
	CDCLK_Out = 0,
	CDCLK_In = 1,
}I2S_CDCLKCON;

typedef enum
{
	BFS_32fs = 0,
	BFS_48fs = 1,
	BFS_16fs = 2,
	BFS_24fs = 3,
}I2S_BFSLength;


typedef I2S_LRCLKLength		I2S_RFSLength;//i2sv5.1, i2s1,2


//////////////////////////////////////////////////
//
//	Audio IPs
//
//////////////////////////////////////////////////
typedef enum
{
	eAUDIO_MOUT_EPLL = 0,
	eAUDIO_DOUT_MPLL = 1,
	eAUDIO_FIN = 2,
	eAUDIO_I2SCDCLK = 3,	
	eAUDIO_PCMCDCLK = 4,
	eAUDIO_MOUT_HPLL = 5,
}AUDIO_CLKSRC;

typedef enum
{
	AUDIO_CLK0 = 0,//I2S0, PCM0
	AUDIO_CLK1 = 1,//IS1, PCM1
	AUDIO_CLK2 = 2,	//I2S2
}AUDIO_CLKNum;


typedef enum
{
	AUDIO_GPIOPORT0		 = 0,	//I2S0
	AUDIO_GPIOPORT1		 = 1,	//IS1, PCM1
	AUDIO_GPIOPORT2		 = 2,	//PCM0, I2S2
	AUDIO_GPIOPORT_NONE	 = 3	//port no select.
}AUDIO_GPIOPORT;

//////////////////////////////////////////////////
//
//	Codec chip
//
//////////////////////////////////////////////////
typedef enum
{
	PRIMARY_PORT 		= 0,
	SECONDARY_PORT 			= 1,
}CODECport;
//	SMDK_PCM 			= 1,
//	SMDK_AC97 			= 2,
	
typedef enum
{
	Master = 0,
	Slave = 1,
}OPMode;



//////////////////////////////////////////////////
//
//	Not defined
//
//////////////////////////////////////////////////

typedef enum
{
	LINEIN 	= 0,
	MICIN	= 1,
}AudioSource;

typedef enum
{
	Word16 	= 0,
	Word8	= 1,
	Word24	= 2,
	Word20	= 3,
}PCMWordLength;

typedef enum
{
	CodecSource_I2S = 0,
	CodecSource_OSC = 1
}CodecClkSource;


//-----------------------------------------------------
//jspark add for ac97
//-----------------------------------------------------
typedef enum
{
	AK2430 = 0,
	WM9713 = 1,		//There is some noise in WM9713 ADC Path on PCM interface
	WM8753 = 2, 
	STAC9767 = 3,
	WM8580 = 4,
	WM8990 = 5,
}AudioCodec;

typedef enum
{
	AUDIO_Tx = 0,
	AUDIO_Rx = 1,
	AUDIO_TxRx = 3	
}AUDIO_Interface;

typedef enum
{
	CodecPort_1st 		= 0,
	CodecPort_2nd 		= 1,
	CodecPort_3rd 		= 2,
}CodecPort;
//-----------------------------------------------------




//--------------------------------------------------------------




#ifdef __cplusplus
}
#endif

#endif /*__AUDIODEFINES_H__*/

