#ifndef __AUDIOCODECS_H__
#define __AUDIOCODECS_H__
 
  
#include "def.h"
#include "v210_sfr.h" 
#include "audiodefines.h" 
  
#ifdef __cplusplus
extern "C" {
#endif

#if 0 //jspark
#define WM8580				5
#endif

#define WM8580MASTERCLK	CDCLK_I2SCDCLK
#define WM8753MASTERCLK	CDCLK_I2SCDCLK
#define CDCLK_I2SCDCLK		0
#define CDCLK_OSC			1
#define CDCLK_I2SMULTI		2


#define WM8580_ID_WR		0x36
#define WM8753ID			0x34
#define WM8580ID			0x36
#define WM8990ID			0x34	//In SMDK 6400 Rev0.2, IIC Line of WM8753 or WM8580  shoud be disconnected when WM8990 is connected

#define WM9713_MAXVOL		0x0
#define WM9713_MINVOL		0x20



//--------------------------------------------------------------

#define MUTEON	1
#define MUTEOFF	0

#define MUTEGPIOINIT	1
#define MUTEGPIODEINIT	0


void WM8580_CodecInitPCMOutwithVol(
							CODECport eCodecPort,
							I2SOPMode eCodecOpmode,//slave(AP is master), master(AP is slave)
							SerialDataFormat eFormat,//i2s
							u32 uSampleRate,
							u8 uBitsPerSample,
							I2S_RFSLength	eMasterRFS,//when codec is master
							u8 uVol);
void WM8580_CodecInitPCMInwithVol(
							CODECport eCodecPort,
							I2SOPMode eCodecOpmode,//slave(AP is master), master(AP is slave)
							SerialDataFormat eFormat,//i2s
							u32 uSampleRate,
							u8 uBitsPerSample,
							I2S_RFSLength	eMasterRFS,//when codec is master
							u8 uVol);
//

void WM8580_CodecMute(u8 bIICinit, u8 bMute);
void WM8580_CodecInitPCMIn(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, AudioSource eSource, CODECport eCodecPort, I2S_LRCLKLength	eRFS);
void WM8580_CodecInitPCMOut(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, CODECport eCodecPort, I2S_LRCLKLength	eRFS);

#ifdef __cplusplus
}
#endif

#endif /*__AUDIOCODECS_H__*/

