#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#include "audiocodecs.h"
#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"

#include "ac97.h"
#include "iic.h"



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//for WM8580
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//jspark
u8 WM8580_IICRead( unsigned char reg_addr)
{
	//not implemented
}

//	WM Codec Data Format For IIC
//	- Device Address[7Bit] +RD/WR[1Bit] : 0x34 or 0x36
//	- Control Byte1[8bit] : Register Addr[6:0] <<1 | Data[8]
//	- Control Byte2[8bit] : Data[7:0]
//
//	WM Codec Data type For C Coding
//	- slv_addr : 8bit
//	- reg_addr : 7bit
//	- data : 9bit
void WM8580_IICWrite( unsigned char reg_addr, unsigned short data)
{
	char D[2+1];
	D[0] = (reg_addr<<1 | (unsigned char)(data>>8));
	D[1] = (unsigned char)data;

	I2C_General_IP_Write(WM8580_ID_WR, 2, D);
}

void WM8580_IICOpen()
{
	I2C_General_IP_Init();
}

void WM8580_IICClose()
{
	I2C_General_IP_DeInit();
}


void WM8580_CodecInitPCMIn(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, AudioSource eSource, CODECport eCodecPort, I2S_LRCLKLength	eRFS)
{
	
	u32  uBitInput, uBitSpl, uFmt;
	u32 uBitinput2, uRfs, uBfs,tmp;

	if(eWordLen==Word16 ||eWordLen==Word8) 		uBitSpl=0;
	else if(eWordLen==Word24) 		uBitSpl=2;
	else Assert(0);

	if (eFormat == I2SFormat) 		uFmt = 2;
	else if (eFormat == MSBJustified) 	uFmt = 1;
	else if (eFormat == LSBJustified) 	uFmt = 0;
	else if (eFormat == AFTER_PCMSYNC_HIGH) 	uFmt = (1<<5)|3; //DSP B
	else if (eFormat == DURING_PCMSYNC_HIGH) uFmt = (1<<5)|(1<<4)|3;
						//DSP A [5]bit clock inversion, [4] pcm mode [1:0] select pcm
	uBitInput = (uBitSpl<<2)|(uFmt<<0);

	uRfs= (eRFS == RFS_256fs)? 2 : 
		  (eRFS == RFS_384fs)? 3 :
		  (eRFS == RFS_512fs)? 4 :
							  5;//768fs
	uBfs = 2;//32fs
	uBitinput2 = (uBfs<<3 |uRfs );


	WM8580_IICOpen();

	WM8580_IICWrite(0x35, 0x000);//53								//Reset WM8580	
	WM8580_IICWrite(0x32, 0x07c);//50								//Power Down 1 : ADC Enable, DACs Disable, Digital Interfase Enable	
	if ( eOpmode == Master)WM8580_IICWrite(0x33, 0x03f);//51								//Power Down 2 : OSC, PLL and SPDI/F Clk Disabled
		
	if ( eCodecPort == PRIMARY_PORT )								//Primary Audio Interface : I2S Multichannel
	{
		WM8580_IICWrite(0x08, 0x03c);//08							//CLKSEL : MCLK is source of All DACs, ADC & SPDI MCLK
		if ( eOpmode == Master)									//Master : 6410		Slave : WM8580
		{			
			WM8580_IICWrite(0x09, uBitinput2);//09						//PAIF 1	Slave Reciever	 			
			WM8580_IICWrite(0x0a, uBitinput2);//10						//PAIF 2	Slave Transmiter	
		}		
		else if ( eOpmode == Slave)								//Master : WM8580 Slave : 6410
		{
			WM8580_IICWrite(0x09, (1<<5|uBitinput2) );			//PAIF 1	Master Reciever	  [5] master, RFS, BFS
			WM8580_IICWrite(0x0a, (1<<5|uBitinput2) );			//PAIF 2	Slave Transmiter	  [5] master, RFS, BFS
		}		
		WM8580_IICWrite(0x1d, 0x140);//29							//ADC Control 1		
		WM8580_IICWrite(13, (1<<8)| uBitInput);//13		//Codec PRIM [8] SDO source (ADC), [5:0]PRIM SDO Audio format			
		//14 SAIF disabled(reset value)
	}
	else if ( eCodecPort == SECONDARY_PORT )	//Secondry Audio Interface : I2S, PCM IF
	{
		WM8580_IICWrite(0x08, 0x01c);//08							//CLKSEL : MCLK is source of All ADC, DAC & SPDIF
		//for secondary interface!!!
		if ( eOpmode == Master)									// Master : 6410	Slave : WM8580	
		{	
			#if 1 //jspark added
			WM8580_IICWrite(0x0b, 0x0c0 | uRfs);//11						//SAIF 1	Slave Interface	 						
			WM8580_IICWrite(0x1d, 0x000| uRfs<<5);//29					//ADC Control 1								
			#else
			WM8580_IICWrite(0x0b, 0x0c0);//11						//SAIF 1	Slave Interface	 			
			WM8580_IICWrite(0x1d, 0x140);//29							//ADC Control 1					
			#endif
		}		
		else if ( eOpmode == Slave)								//Master : WM8580 	Slave : 6410
		{
			WM8580_IICWrite(0x0b, (3<<6|1<<5|uBitinput2) );//11		//SAIF 1	Slave [6]clock source : MCLK  [5] master,  RFS, BFS
		}	
		
		WM8580_IICWrite(0x0e, (1<<7)|(1<<6) | uBitInput);//14		//Codec SAIF [7]SDO source (ADC), [6] SAIF enable, SAIF Audio format
		WM8580_IICWrite(0x0d, (2<<7)| uBitInput);//13		//Codec PRIM [8:7] SDO source (SAIF), [5:0]PRIM SDO Audio format			
		//R13 setting is essential!!!
	}	


	WM8580_IICClose();

}


void WM8580_CodecInitPCMOut(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, CODECport eCodecPort, I2S_LRCLKLength	eRFS)
{
	u32  uBitInput, uBitSpl, uFmt;
	u32 uBitinput2, uRfs, uBfs;
	if(eWordLen==Word16 ||eWordLen==Word8) 		uBitSpl=0;
	else if(eWordLen==Word24) 		uBitSpl=2;
	else Assert(0);

	if (eFormat == I2SFormat) 		uFmt = 2;
	else if (eFormat == MSBJustified) 	uFmt = 1;
	else if (eFormat == LSBJustified) 	uFmt = 0;
	else if (eFormat == AFTER_PCMSYNC_HIGH) 	uFmt = (1<<5)|3; //DSP B
	else if (eFormat == DURING_PCMSYNC_HIGH) uFmt = (1<<5)|(1<<4)|3;
						//DSP A [5]bit clock inversion, [4] pcm mode [1:0] select pcm
	uBitInput = (uBitSpl<<2)|(uFmt<<0);

	uRfs= (eRFS == RFS_256fs)? 2 : 
		  (eRFS == RFS_384fs)? 3 :
		  (eRFS == RFS_512fs)? 4 :
							  5;//768fs
	uBfs = 1;//32fs
	uBitinput2 = (uBfs<<3 |uRfs );


	WM8580_IICOpen();

	WM8580_IICWrite(0x35, 0x000);//53								//Reset WM8580
//	WM8580_IICWrite(19, 1<<4);//						//mute on power on.
	
	if ( eCodecPort == PRIMARY_PORT )								//Primary Audio Interface : I2S Multichannel
	{
		WM8580_IICWrite(0x32, 0x022);//50						//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 
		WM8580_IICWrite(0x33, 0x03f);//51						//Power Down 2: OSC, PLL and SPDI/F Clk Disabled
		WM8580_IICWrite(0x08, 0x030);//08							//CLKSEL : All ADC, DAC & SPDIF CLk source are MCLK		
		if ( eOpmode == Master)									//Master : 6410		Slave : WM8580
		{
			WM8580_IICWrite(0x09, 0);//09;					//PAIF 1	
			WM8580_IICWrite(0x0a, 0);//10					//PAIF 2	
		}	
		else if ( eOpmode == Slave)								// Master : WM8580 	Slave : 6410
		{
			WM8580_IICWrite(0x09, (1<<5|uBitinput2) );//09			//PAIF 1	Master Reciever	  [5] master, RFS, BFS
			WM8580_IICWrite(0x0a, (1<<5|uBitinput2) );//10			//PAIF 2	Master Transmiter[5] master,  RFS, BFS
		}	
		WM8580_IICWrite(0x16, 0x089);							//IZD mute detection enable, all dac zero flag on, left=left, right=right
		WM8580_IICWrite(12, (3<<7)|uBitInput);					//PAIF 3	CODEC Pri SDI format
	}
	else if ( eCodecPort == SECONDARY_PORT )	//Secondry Audio Interface : I2S Multichannel
	{
		WM8580_IICWrite(0x32, 0x03a);//50							//Power Down 1: ADC Disable, DAC1 Enable, DAC2 and DAC3 are disable, Digital Interface Enable 
		if ( eOpmode == Master)
			WM8580_IICWrite(0x33, 0x038);//51							//Power Down 2: OSC, PLL Enable, SPDI/F Clk Disabled
			
		WM8580_IICWrite(0x08, 0x01c);//08							//CLKSEL : All ADC, DAC & SPDIF CLk source are MCLK		
		
			//for secondary interface!!!
		if ( eOpmode == Master)									// Master : 6410	Slave : WM8580
		{
			WM8580_IICWrite(0x0b, 3<<6);//11					//SAIF 1	Master Transmiter Reciever
		}		
		else if ( eOpmode == Slave)								// Master : WM8580 	Slave : 6410
		{
			WM8580_IICWrite(0x0b, (3<<6|1<<5|uBitinput2) );//11		//SAIF 1	Slave [6]clock source : MCLK  [5] master,  RFS, BFS
		}	
		
		WM8580_IICWrite(14, (1<<7|1<<6|uBitInput) );//14			//SAIF 2	Codec sec format, [8:7]ADC source(don't care), [6]sec if enable.
		WM8580_IICWrite(12, (2<<7)|uBitInput);//12			//PAIF 3	CODEC Pri SDI format(don't care), [8:7]DAC1 source : SAIF

	}
	// Add to DAC Control upto FIFO control of S3C6400
	//WM8580_IICWrite(0x0f, 0x024);				//DAC Control 1


	if (eFormat == DURING_PCMSYNC_HIGH ||   eFormat == AFTER_PCMSYNC_HIGH) 
		WM8580_IICWrite(0x10, 0x005);				//DAC Control 2			Left & Right DAC Souce : Left Channel
	else
		WM8580_IICWrite(0x10, 0x009);				//DAC Control 2			Left DAC : Left Channel, Right DAC : Right Channel
		
	WM8580_IICWrite(28, 0x1FF);  				//volume control	
	//WM8580_IICWrite(28, 0x1cF);  				//volume control	

//	WM8580_IICWrite(19, 0<<4);//						//mute on power on.
	WM8580_IICClose();
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//for 8580(additional)
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//vol : 00 -infinite (mute)
//       01 - -127.5dB
//      fe - -0.5dB
//       ff - 0dB
void WM8580_VolumeSet(u8 uVol)
{
	
	WM8580_IICOpen();

	Disp("vol:%x\n", uVol);

	WM8580_IICWrite(53, 0x000);				// Reset WM8580
	WM8580_IICWrite(50, 0x002);				// All Digital running, ADC disable, DAC1,2,3 enable, DACs under control of DACPD[3:0]

	WM8580_IICWrite(28, 1<<8 | uVol);//Volume control 

	WM8580_IICWrite(12, (3<<7)|(0<<2)|(2<<0));	

	WM8580_IICClose();
}


// hardware mute on/off
// bmute : 1 - mute, 0 - unmute
void WM8580_HWmute(u8 bmute)
{
	if(bmute ==1) {
		//set gpio out as 1

	}else {
		//set gpio out as 0
	}
}


// hardware mute GPIO init/deinit
// binit : 1 - init, 0 - deinit.
void WM8580_HWmute_GPIO(u8 binit)
{
	if(binit ==1) {
		//set gpio out , save old function
		//pad name is xeint9 , which gpio?

	}else {
		//restore as old function.
	}
}



void WM8580_CodecInitPCMOutwithVol(
							CODECport eCodecPort,
							I2SOPMode eCodecOpmode,//slave(AP is master), master(AP is slave)
							SerialDataFormat eFormat,//i2s
							u32 uSampleRate,
							u8 uBitsPerSample,
							I2S_RFSLength	eMasterRFS,//when codec is master
							u8 uVol)
{
	u32 uMasterRFSBFS, uRfs, uBfs;//lsb 5bits
	u32  uBitsFormat, uBitSpl, uFmt;//lsb 6bits
	u32 uR16;

	if ( eCodecOpmode == I2S_Master) {
		uRfs= (eMasterRFS == RFS_256fs)? 2 : 
			  (eMasterRFS == RFS_384fs)? 3 :
			  (eMasterRFS == RFS_512fs)? 4 :
								  5;//768fs
		uBfs = 1;//32fs
		uMasterRFSBFS= (uBfs<<3 |uRfs );
	}
	if (eFormat == I2SFormat) 		uFmt = 2;
	else if (eFormat == MSBJustified) 	uFmt = 1;
	else if (eFormat == LSBJustified) 	uFmt = 0;
	else if (eFormat == AFTER_PCMSYNC_HIGH) 	uFmt = (1<<5)|3; //DSP B
	else if (eFormat == DURING_PCMSYNC_HIGH) uFmt = (1<<5)|(1<<4)|3; 	//DSP A [5]bit clock inversion, [4] pcm mode [1:0] select pcm
	uBitSpl = (uBitsPerSample==16 ||uBitsPerSample==8)? 0 : 
			(uBitsPerSample==24)? 2 : 0;
	uBitsFormat = (uBitSpl<<2)|(uFmt<<0);

	uR16= (eFormat == DURING_PCMSYNC_HIGH)?0x005://Left & Right DAC Souce : Left Channel
		    (eFormat == AFTER_PCMSYNC_HIGH) ?0x005://Left & Right DAC Souce : Left Channel
											0x009;//Left DAC : Left Channel, Right DAC : Right Channel				

	WM8580_HWmute(MUTEON);
	WM8580_IICOpen();
	if ( eCodecPort == PRIMARY_PORT )//Primary Audio Interface
	{

		if ( eCodecOpmode == I2S_Slave)//Master : AP chip	Slave : WM8580
		{
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
			WM8580_IICWrite(0x32, 0x022);//50					//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 
			WM8580_IICWrite(0x08, 0x030);//08					//CLKSEL : All ADC, DAC & SPDIF CLk source are MCLK		
			WM8580_IICWrite(0x09, 0);//09;						//PAIF 1	
			WM8580_IICWrite(0x0a, 0);//10						//PAIF 2		
			WM8580_IICWrite(0x16, 0x089);//22					//IZD mute detection enable, all dac zero flag on, left=left, right=right
			WM8580_IICWrite(0x0c, (3<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format
			WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
			WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control
		}	
		else if ( eCodecOpmode == I2S_Master)	// Master : WM8580 	Slave : AP chip
		{
			if(uSampleRate==0)
			{
				//AP or extclk give to Codec chip MCLK.

				//2450 work - but sinewave distortion.
				WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
				WM8580_IICWrite(0x32, 0x022);//50					//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 
				WM8580_IICWrite(0x09, (1<<5|uMasterRFSBFS) );//09	//PAIF 1	Master Reciever	  [5] master, RFS, BFS
				WM8580_IICWrite(0x0c, (3<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format
				WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
				WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control
			} else if(uSampleRate==48000)
			{
				//OSC 12MHz give to XTI, XTO

				WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
				WM8580_IICWrite(0x32, 0x022);//50					//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 

				WM8580_IICWrite(0x33, 0x03c);//51					//Power Down 2 : pll enabled, osc enabled.
				//12.288MHz 
				//PLL A K-Value : C49BA -- 00 1100 0100 1001  1011 1010 
				//									-----------
				//						    ----------		
				//PLL A N-Value :	8
				WM8580_IICWrite(0x00, 0x1ba);// 0				//PLL A K-Value : 1 1011 1010 [8:0]
				WM8580_IICWrite(0x01, 0x024);// 1				//PLL A K-Value : 00 0100 100 [17:9]
				WM8580_IICWrite(0x02, 0x083);// 2				//PLL A N-Value : 8,  PLL A K-Value : 0011 [21:18]
				WM8580_IICWrite(0x03, 0x014);// 3				//PLL A [4:3] freq mode-10,  [2]:1 , [1] post scale-0, [0] prescale-0.

				WM8580_IICWrite(0x07, 0x1b0);//07					//clkout : [6:5] :01ouput pllaclk. [8:7] 11 oscclk
				WM8580_IICWrite(0x08, 0x055);//08					//CLKSEL : All ADC, DAC & SPDIF CLk source are PLLACLK
				WM8580_IICWrite(0x09, (1<<6|1<<5|uMasterRFSBFS) );//09	//PAIF 1	Master Reciever	  [5] master, RFS, BFS
				WM8580_IICWrite(0x0c, (3<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format
				WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
				WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control
			} else if(uSampleRate==44100)
			{
				//AP XCLKOUT 24MHz give to XTI

				WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
				WM8580_IICWrite(0x32, 0x022);//50					//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 

				WM8580_IICWrite(0x33, 0x03d);//51					//Power Down 2 : pll enabled, osc disabled.
				//11.2896MHz 
				//PLL A K-Value : 21B089 -- 10 0001 1011 0000  1000 1001 
				//									      -----------
				//						          ----------		
				//PLL A N-Value :	8
				WM8580_IICWrite(0x00, 0x089);// 0				//PLL A K-Value : 0 1000 1001 [8:0]
				WM8580_IICWrite(0x01, 0x0d8);// 1				//PLL A K-Value : 01 1011 000 [17:9]
				WM8580_IICWrite(0x02, 0x078);// 2				//PLL A N-Value : 7,  PLL A K-Value : 1000 [21:18]
				WM8580_IICWrite(0x03, 0x015);// 3				//PLL A [4:3] freq mode-10,  [2]:1 , [1] post scale-0, [0] prescale.-1

				WM8580_IICWrite(0x07, 0x1b0);//07					//clkout : [6:5] :01ouput pllaclk. [8:7] 11 oscclk
				WM8580_IICWrite(0x08, 0x055);//08					//CLKSEL : All ADC, DAC & SPDIF CLk source are PLLACLK
				WM8580_IICWrite(0x09, (1<<6|1<<5|uMasterRFSBFS) );//09	//PAIF 1	Master Reciever	  [5] master, RFS, BFS
				WM8580_IICWrite(0x0c, (3<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format
				WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
				WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control

			}


		}
	}
	else if ( eCodecPort == SECONDARY_PORT )	//Secondry Audio Interface
	{
		if ( eCodecOpmode == I2S_Slave)//Master : AP chip	Slave : WM8580
		{
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
			WM8580_IICWrite(0x32, 0x03a);//50					//Power Down 1: ADC Disable, DAC1 Enable, DAC2 and DAC3 are disable, Digital Interface Enable 
			//WM8580_IICWrite(0x33, 0x038);//51					//Power Down 2: OSC, PLL Enable, SPDI/F Clk Disabled
			WM8580_IICWrite(0x08, 0x01c);//08					//CLKSEL : All ADC, DAC & SPDIF CLk source are MCLK	[for secondary interface!!!]
			///WM8580_IICWrite(0x0b, 0xc0);//11					//SAIF 1	Master Transmiter Reciever
							  //typical : 0xc0 - SAIF master clk : mclk clk, slave, dont' care master rfs, bfs
			WM8580_IICWrite(0x0e, (1<<7|1<<6|uBitsFormat) );//14	//SAIF 2	Codec sec format, [8:7]ADC source(don't care), [6]sec if enable.
			WM8580_IICWrite(0x0c, (2<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format(don't care), [8:7]DAC1 source : SAIF

			//additional
			WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
			WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control
		} else if ( eCodecOpmode == I2S_Master)// Master : WM8580 	Slave : AP chip
		{
			//confirmed by Wolfson
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580
			WM8580_IICWrite(0x32, 0x03a);//50					//Power Down 1: ADC Disable, DAC1 Enable, DAC2 and DAC3 are disable, Digital Interface Enable 
			WM8580_IICWrite(0x08, 0x01c);//08					//CLKSEL : All ADC, DAC & SPDIF CLk source are MCLK	[for secondary interface!!!]		
			WM8580_IICWrite(0x0b, (3<<6|1<<5|uMasterRFSBFS) );//11	//SAIF 1	Slave [6]clock source : MCLK  [5] master,  RFS, BFS
								    //typical : 0xeb -384fs, 32fs
								    //             0xea - 256fs, 32fs
								    //             0xe2 - 256fs, 64fs(n/a for ap chip)
								    //             0xe3 - 384fs, 64fs(n/a for ap chip)
			WM8580_IICWrite(0x0e, (1<<7|1<<6|uBitsFormat) );//14	//SAIF 2	Codec sec format, [8:7]ADC source(don't care), [6]sec if enable.
								   //typical : 0xc2 - enable saif, saiftx src=adc digital output, i2s format, 16bit
			WM8580_IICWrite(0x0c, (2<<7)|uBitsFormat);//12		//PAIF 3	CODEC Pri SDI format(don't care), [8:7]DAC1 source : SAIF
									//typical : 0x102 - DAC1 src = saif data

			//additional
			WM8580_IICWrite(0x10, uR16);//16						//DAC Control 2			Left , Right DAC Souce 
			WM8580_IICWrite(0x1c, 1<<8| uVol);//28  				//volume control
		}

	}
	WM8580_IICClose();
	WM8580_HWmute(MUTEOFF);
}


void WM8580_CodecInitPCMInwithVol(
							CODECport eCodecPort,
							I2SOPMode eCodecOpmode,//slave(AP is master), master(AP is slave)
							SerialDataFormat eFormat,//i2s
							u32 uSampleRate,
							u8 uBitsPerSample,
							I2S_RFSLength	eMasterRFS,//when codec is master
							u8 uVol)
{
	u32 uMasterRFSBFS, uRfs, uBfs;//lsb 5bits  	//uBitInput->uBitsFormat
	u32  uBitsFormat, uBitSpl, uFmt;//lsb 6bits   	//uBitinput2=>uMasterRFSBFS

	if ( eCodecOpmode == I2S_Master) {
		uRfs= (eMasterRFS == RFS_256fs)? 2 : 
			  (eMasterRFS == RFS_384fs)? 3 :
			  (eMasterRFS == RFS_512fs)? 4 :
								  5;//768fs
		uBfs = 1;//32fs
		uMasterRFSBFS= (uBfs<<3 |uRfs );//typical b1011 - 0xb
	}
	if (eFormat == I2SFormat) 		uFmt = 2;
	else if (eFormat == MSBJustified) 	uFmt = 1;
	else if (eFormat == LSBJustified) 	uFmt = 0;
	else if (eFormat == AFTER_PCMSYNC_HIGH) 	uFmt = (1<<5)|3; //DSP B
	else if (eFormat == DURING_PCMSYNC_HIGH) uFmt = (1<<5)|(1<<4)|3; 	//DSP A [5]bit clock inversion, [4] pcm mode [1:0] select pcm
	uBitSpl = (uBitsPerSample==16 ||uBitsPerSample==8)? 0 : 
			(uBitsPerSample==24)? 2 : 0;
	uBitsFormat = (uBitSpl<<2)|(uFmt<<0);

	WM8580_HWmute(MUTEON);
	WM8580_IICOpen();

	if ( eCodecPort == PRIMARY_PORT )//Primary Audio Interface : I2S Multichannel
	{
		if ( eCodecOpmode == I2S_Slave)//Master : AP chip		Slave : WM8580
		{		
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580	
			WM8580_IICWrite(0x32, 0x07c);//50					//Power Down 1 : ADC Enable, DACs Disable, Digital Interfase Enable	
			//WM8580_IICWrite(0x33, 0x03f);//51					//Power Down 2 : OSC, PLL and SPDI/F Clk Disabled
			WM8580_IICWrite(0x08, 0x03c);//08					//CLKSEL : MCLK is source of All DACs, ADC & SPDI MCLK
			WM8580_IICWrite(0x09, 0);//09						//PAIF 1	Slave Reciever	 			
			WM8580_IICWrite(0x0a, 0);//10						//PAIF 2	Slave Transmiter	
			//WM8580_IICWrite(0x1d, 0x140);//29					//ADC Control 1		
			WM8580_IICWrite(0x0d, (1<<7)| uBitsFormat);//13		//Codec PRIM [7] SDO source (ADC), [5:0]PRIM SDO Audio format			
			//14 SAIF disabled(reset value)	
		}		
		else if ( eCodecOpmode == I2S_Master)	//Master : WM8580 Slave : 6410
		{
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580	
			WM8580_IICWrite(0x32, 0x07c);//50					//Power Down 1 : ADC Enable, DACs Disable, Digital Interfase Enable	
			//2450 : recorded data is googd - but lrclk is starange
			WM8580_IICWrite(0x0a, (1<<5|uMasterRFSBFS) );//10	//PAIF 2	Slave Transmiter	  [5] master, RFS, BFS
			WM8580_IICWrite(0x0d, (1<<7)| uBitsFormat);//13		//Codec PRIM [7] SDO source (ADC), [5:0]PRIM SDO Audio format		
			//14 SAIF disabled(reset value)
		}		
	}
	else if ( eCodecPort == SECONDARY_PORT )	//Secondry Audio Interface : I2S, PCM IF
	{
		if ( eCodecOpmode == I2S_Slave)// Master : AP chip	Slave : WM8580	
		{	
			//confirmed by Wolfson
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580	
			WM8580_IICWrite(0x32, 0x07c);//50					//Power Down 1 : ADC Enable, DACs Disable, Digital Interfase Enable	
			WM8580_IICWrite(0x08, 0x01c);//08					//CLKSEL : MCLK is source of All ADC, DAC & SPDIF [for secondary interface!!!]	
			//WM8580_IICWrite(0x0b, 0x0c0);//11					//SAIF 1	Slave Interface	 			
								    //typical : 0xc0 - SAIF master clk : mclk clk, slave, dont' care master rfs, bfs
			WM8580_IICWrite(0x0e, (1<<7)|(1<<6) |uBitsFormat);//14	//Codec SAIF [7]SDO source (ADC), [6] SAIF enable, SAIF Audio format
								   //typical : 0xc2 - enable saif, saiftx src=adc digital output, i2s format, 16bit
								   //typical : 0xc3 - enable saif, saiftx src=adc digital output, DSP A, dsp, 16bit
			WM8580_IICWrite(0x0d, (2<<7)| uBitsFormat);//13		//Codec PRIM [8:7] SDO source (SAIF), [5:0]PRIM SDO Audio format 
																//        [R13 setting is essential!!!]			
								   //typical : 0x102 - paif src is not adc 
		}		
		else if ( eCodecOpmode == I2S_Master)//Master : WM8580 	Slave : AP chip
		{
			//confirmed by Wolfson
			WM8580_IICWrite(0x35, 0x000);//53					//Reset WM8580	
			WM8580_IICWrite(0x32, 0x07c);//50					//Power Down 1 : ADC Enable, DACs Disable, Digital Interfase Enable	
			WM8580_IICWrite(0x08, 0x01c);//08					//CLKSEL : MCLK is source of All ADC, DAC & SPDIF [for secondary interface!!!]	
			WM8580_IICWrite(0x0b, (3<<6|1<<5|uMasterRFSBFS) );//11	//SAIF 1	Slave [6]clock source : MCLK  [5] master,  RFS, BFS
								    //typical : 0xeb -384fs, 32fs   - SAIF master clk : mclk clk
								    //             0xea - 256fs, 32fs
								    //             0xe2 - 256fs, 64fs(n/a for ap chip)
								    //             0xe3 - 384fs, 64fs(n/a for ap chip)
			WM8580_IICWrite(0x0e, (1<<7)|(1<<6) | uBitsFormat);//14	//Codec SAIF [7]SDO source (ADC), [6] SAIF enable, SAIF Audio format
								   //typical : 0xc2 - enable saif, saiftx src=adc digital output, i2s format, 16bit
			WM8580_IICWrite(0x0d, (2<<7)| uBitsFormat);//13		//Codec PRIM [8:7] SDO source (SAIF), [5:0]PRIM SDO Audio format			
																//       [R13 setting is essential!!!]	
								   //typical : 0x102 - paif src is not adc 		
		}	
		
	}	
	WM8580_IICClose();
	WM8580_HWmute(MUTEOFF);
	
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//for WM9713
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WM9713_CodecInitPCMIn(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, AudioSource eSource,CodecPort eCodecPort)
{
	#ifdef __AC97_H__
	AC97_CodecCmd(WRITE,0x26, 0x4f00);		// Enable PR5(Internal Clock, AC-link I/F)
	AC97_CodecCmd(WRITE,0x26, 0x4700);		// Enable PR3(VREF, I/P PGA's, DAC's, ADC's, Mixer, O/P's) 	
	AC97_CodecCmd(WRITE,0x3c, 0xfbff);			// Enable MBIAS generator
	Delay(1000);	
	AC97_CodecCmd(WRITE,0x26, 0x4300);		// Enable PR2(I/P PGA's and mixers)
	
	if (eFormat == ACLinkSlot34)					// Enable ADC L/R
		AC97_CodecCmd(WRITE,0x3C, 0xfbc3);	
	else if (eFormat == ACLinkSlot6)
		AC97_CodecCmd(WRITE,0x3C, 0xfbcf);	
	
	AC97_CodecCmd(WRITE,0x26, 0x4200);		// Enable Stereo ADC 				//4100
	AC97_CodecCmd(WRITE,0x26, 0x0200);		// Enable PR6 (O/P PGA's)						
	AC97_CodecCmd(WRITE,0x3E, 0xff9f);			// Enable LINE L/R PGA			26 0100
				
	
	AC97_CodecCmd(WRITE,0x2A,0x1);			//Variable Rate Enable	
	UART_Printf("VRA Enable(1)/Disable(0): 0x%x\n",(0x1&AC97_CodecCmd(READ,0x2A,0x0000)));
	if(eSampleRate == 8000)						//ADC Sampling frequency 8kHz
		AC97_CodecCmd(WRITE,0x32,0x1f40);	
	else if(eSampleRate == 44100)					//ADC Sampling frequency 44.1kHz
		AC97_CodecCmd(WRITE,0x32,0xac44);
	else if(eSampleRate == 22050)					//ADC Sampling frequency 22.05kHz
		AC97_CodecCmd(WRITE,0x32,0x5622);	 	
	else if(eSampleRate == 48000)					//ADC Sampling frequency 48kHz
		AC97_CodecCmd(WRITE,0x32,0xbb80);
	else
		Assert(0);								//Sample Rate is not supported. 
	//UART_Printf("\nAC97 Codec 0x32 Reg.: 0x%x\n\n", AC97_CodecCmd(READ,0x32,0x0000));
	if ( eFormat == ACLinkSlot34)
	{
		//AC97_CodecCmd(WRITE,0x3C, 0xfbc3);	// Enable ADC L/R					//fbf3
		AC97_CodecCmd(WRITE,0x14, 0xfe12);	// Record Mux Source Selection: LINE L/R
		AC97_CodecCmd(WRITE,0x1c, 0x00a0);
		AC97_CodecCmd(WRITE,0x04, 0x0303);
		AC97_CodecCmd(WRITE,0x12, 0x1010);	// Unmute ADC and Set ADC Recoding Volume	
	}
	else if (eFormat == ACLinkSlot6)
	{
		AC97_CodecCmd(WRITE,0x5C, 0x2);		// ADC Slot Mapping: Left(Slot 6), Right(Slot 9)	
		AC97_CodecCmd(WRITE,0x14, 0xfe12);	// Record Mux Source Selection: LINE L/R
		AC97_CodecCmd(WRITE,0x1c, 0x00a0);
		AC97_CodecCmd(WRITE,0x12, 0x1010);	// Unmute ADC and Set ADC Recoding Volume		
	}
	////////////////////////////////////////////////////////
	// codec setting to hear sound while PCM encoding 
	//uAc97cmd = AC97_CodecCmd(READ,0x14, 0x0000);
	//uAc97cmd =  uAc97cmd &  ~(3 << 14) & (~ (5 << 11));
	//AC97_CodecCmd(WRITE,0x14, 0x1612);
	//AC97_CodecCmd(WRITE,0x1c, 0x00a0);
	//AC97_CodecCmd(WRITE,0x04,0x0707);
	//UART_Printf("%x\n",AC97_CodecCmd(READ,0x14, 0x0000));	
	//UART_Printf("%x\n",AC97_CodecCmd(READ,0x0a, 0x0000));
	////////////////////////////////////////////////////////
	#else
	UART_Printf("AC97 Controller code is not included\n");
	#endif	
}

void WM9713_InitPCMOut(SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, CodecPort eCodecPort)
{	
	#ifdef __AC97_H__
 	AC97_CodecCmd(WRITE,0x26, 0x4f00);	// Enable PR5(Internal Clock, AC-link I/F)
	AC97_CodecCmd(WRITE,0x26, 0x4700);	// Enable PR3(VREF, I/P PGA's, DAC's, ADC's, Mixer, O/P's)
 	
	AC97_CodecCmd(WRITE,0x3c, 0xfbff);		// Enable MBIAS generator
	Delay(1000);

	AC97_CodecCmd(WRITE,0x26, 0x4300);	// Enable PR2(I/P PGA's and mixers)
	AC97_CodecCmd(WRITE,0x3C, 0xfbf3);		// Enable HPL/R Mixer
	AC97_CodecCmd(WRITE,0x26, 0x4100);	// Enable PR1(Stereo DAC)
	AC97_CodecCmd(WRITE,0x3C, 0xfb33);	// Enable DAC L/R
	AC97_CodecCmd(WRITE,0x26, 0x0100);	// Enable PR6 (O/P PGA's)
	AC97_CodecCmd(WRITE,0x3E, 0xf9ff);		// Enable PR6 (O/P PGA's)

	AC97_CodecCmd(WRITE,0x2A,0x1);		//Variable Rate Enable	
	if(eSampleRate==8000)
		AC97_CodecCmd(WRITE,0x2C,0x1f40);		//DAC Sampling frequency 8kHz
	else if(eSampleRate==48000)
		AC97_CodecCmd(WRITE,0x2C,0xbb80);	//DAC Sampling frequency 48kHz
	else if(eSampleRate==44100)
		AC97_CodecCmd(WRITE,0x2C,0xac44);		//DAC Sampling frequency 44.1kHz
	else if(eSampleRate==22050)
		AC97_CodecCmd(WRITE,0x2C,0x5622);		//DAC Sampling frequency 22.05kHz
	else
		Assert(0);
	AC97_CodecCmd(WRITE,0x12,0x8000);		//Disable ADC because it makes noise when ADC is turn on
	AC97_CodecCmd(WRITE,0x1c, 0x00a0);	// HPL/R PGA input select HPMIXL/R
	AC97_CodecCmd(WRITE,0x04,0x0707);		// Set HPL/R Volume 
	AC97_CodecCmd(READ,0x04,0x00000);	//HP out volume 
	AC97_CodecCmd(WRITE,0x0c,0x6808);		// Unmute DAC to HP mixer path
	AC97_CodecCmd(WRITE,0x04,0x0A0A);	// Unmute HPL/R
	#endif	
}

//////////
// Function Name : WM9713_CodecInit
// Function Desctiption : Initialize WM9713(AC97/I2S/PCM) Codec.
// Input : 			eCh  - TX / RX
// 					eFormat  - Interface data format
// 					eSampleRate  - Sample Rate
// 					eOpmode  - Operating Mode of AP. 
// 					eWordLen  - PCM Data Length
// 					eSource  - Audio source of ADC
// 					CodecPort  - Codec interface port
// Output : None
// Version : 0.0
// Author : Sunghyun, Na
void WM9713_CodecInit(AUDIO_Interface eCh, SerialDataFormat eFormat, u32 eSampleRate, OPMode eOpmode, PCMWordLength eWordLen, AudioSource eSource, CodecPort eCodecPort)
{
	switch(eCh)
	{
		case AUDIO_Tx:
			AC97_CodecCmd(WRITE,0x26, 0x4f00);	//Enable PR5(Internal Clock, AC-link I/F)
			AC97_CodecCmd(WRITE,0x26, 0x4700);	//Enable PR3(VREF, I/P PGA's, DAC's, ADC's, Mixer, O/P's)
		 	AC97_CodecCmd(WRITE,0x3c, 0xfbff);		//Enable MBIAS generator
			Delay(1000);
			AC97_CodecCmd(WRITE,0x26, 0x4300);	//Enable PR2(I/P PGA's and mixers)
			AC97_CodecCmd(WRITE,0x3C, 0xfbf3);		//Enable HPL/R Mixer
			AC97_CodecCmd(WRITE,0x26, 0x4100);	//Enable PR1(Stereo DAC)
			AC97_CodecCmd(WRITE,0x3C, 0xfb33);	//Enable DAC L/R
			AC97_CodecCmd(WRITE,0x26, 0x0100);	//Enable PR6 (O/P PGA's)
			AC97_CodecCmd(WRITE,0x3E, 0xf9ff);		//Enable PR6 (O/P PGA's)
			if (eSampleRate >= 48000)
			{
				AC97_CodecCmd(WRITE,0x2A,0x0);		//Variable Rate Disable	
				AC97_CodecCmd(WRITE,0x2C,0xbb80);	//DAC Sampling frequency 48kHz
				UART_Printf("Fs=48Khz\n");
			}
			else
			{
				AC97_CodecCmd(WRITE,0x2A,0x1);			//Variable Rate Enable	
				AC97_CodecCmd(WRITE,0x2C,eSampleRate);	//DAC Sampling frequency
				UART_Printf("Fs=%d hz\n",eSampleRate);				
			}
			UART_Printf("VRA Enable(1)/Disable(0): 0x%x\n",(0x1&AC97_CodecCmd(READ,0x2A,0x0000)));
			AC97_CodecCmd(WRITE,0x12,0x8000);		//Disable ADC because it makes noise when ADC is turn on
			AC97_CodecCmd(WRITE,0x1c, 0x00a0);	// HPL/R PGA input select HPMIXL/R
			AC97_CodecCmd(WRITE,0x04,0x0707);		// Set HPL/R Volume 			
			AC97_CodecCmd(WRITE,0x0c,0x6808);		// Unmute DAC to HP mixer path
			AC97_CodecCmd(WRITE,0x04,0x0000);		// Unmute HPL/R
			// codec setting to hear sound while PCM encoding -> need to Modify
			//uAc97cmd = AC97_CodecCmd(READ,0x14, 0x0000);
			//uAc97cmd =  uAc97cmd &  ~(3 << 14) & (~ (5 << 11));
			//AC97_CodecCmd(WRITE,0x14, 0x1612);
			//AC97_CodecCmd(WRITE,0x1c, 0x00a0);
			//AC97_CodecCmd(WRITE,0x04,0x0707);
			//UART_Printf("%x\n",AC97_CodecCmd(READ,0x14, 0x0000));	
			//UART_Printf("%x\n",AC97_CodecCmd(READ,0x0a, 0x0000));			
			break;
			
		case AUDIO_Rx:
			AC97_CodecCmd(WRITE,0x26, 0x4f00);		//Enable PR5(Internal Clock, AC-link I/F)
			AC97_CodecCmd(WRITE,0x26, 0x4700);		//Enable PR3(VREF, I/P PGA's, DAC's, ADC's, Mixer, O/P's) 	
			AC97_CodecCmd(WRITE,0x3c, 0xfbff);			//Enable MBIAS generator
			Delay(1000);	
			AC97_CodecCmd(WRITE,0x26, 0x4300);		//Enable PR2(I/P PGA's and mixers)
			if (eFormat == ACLinkSlot34)					//Enable ADC L/R
				AC97_CodecCmd(WRITE,0x3C, 0xfbc3);	
			else if (eFormat == ACLinkSlot6)
				AC97_CodecCmd(WRITE,0x3C, 0xfbcf);				
			AC97_CodecCmd(WRITE,0x26, 0x4200);		//Enable Stereo ADC 				//4100
			AC97_CodecCmd(WRITE,0x26, 0x0200);		//Enable PR6 (O/P PGA's)						
			AC97_CodecCmd(WRITE,0x3E, 0xbf9f);			//Enable LINE L/R PGA			26 0100			
			if (eSampleRate >= 48000)
			{
				AC97_CodecCmd(WRITE,0x2A,0x0);		//Variable Rate Disable	
				AC97_CodecCmd(WRITE,0x32,0xbb80);	//ADC Sampling frequency 48kHz
			}
			else
			{
				AC97_CodecCmd(WRITE,0x2A,0x1);			//Variable Rate Enable	
				AC97_CodecCmd(WRITE,0x32,eSampleRate);	//ADC Sampling frequency
			}
			UART_Printf("VRA Enable(1)/Disable(0): 0x%x\n",(0x1&AC97_CodecCmd(READ,0x2A,0x0000)));		
			if ( eFormat == ACLinkSlot34)
			{
				//AC97_CodecCmd(WRITE,0x3C, 0xfbc3);	// Enable ADC L/R					//fbf3
				AC97_CodecCmd(WRITE,0x14, 0xfe12);	// Record Mux Source Selection: LINE L/R
				AC97_CodecCmd(WRITE,0x1c, 0x00a0);
				AC97_CodecCmd(WRITE,0x04, 0x0303);
				AC97_CodecCmd(WRITE,0x12, 0x1010);	// Unmute ADC and Set ADC Recoding Volume	
			}
			else if (eFormat == ACLinkSlot6)
			{
				AC97_CodecCmd(WRITE,0x5C, 0x2);		// ADC Slot Mapping: Left(Slot 6), Right(Slot 9)	
				AC97_CodecCmd(WRITE,0x14, 0xfe12);	// Record Mux Source Selection: LINE L/R
				AC97_CodecCmd(WRITE,0x1c, 0x00a0);
				AC97_CodecCmd(WRITE,0x12, 0x1010);	// Unmute ADC and Set ADC Recoding Volume		
			}				
			break;
		case AUDIO_TxRx:
		default:
			AC97_CodecCmd(WRITE,0x26, 0x4f00);	//Enable PR5(Internal Clock, AC-link I/F)
			AC97_CodecCmd(WRITE,0x26, 0x4700);	//Enable PR3(VREF, I/P PGA's, DAC's, ADC's, Mixer, O/P's)
			AC97_CodecCmd(WRITE,0x3c, 0xfbff);		//Enable MBIAS generator
			Delay(1000);
			AC97_CodecCmd(WRITE,0x26, 0x4300);	//Enable PR2(I/P PGA's and mixers)
			AC97_CodecCmd(WRITE,0x3C, 0xfb03);	//Enable ADC L/R
			if (eSource == LINEIN)					
				AC97_CodecCmd(WRITE,0x14, 0xfe12);	//Record Mux Source Selection: LINE L/R
			else if (eSource == MICIN)
				AC97_CodecCmd(WRITE,0x14, 0xfe40);	//Record Mux Source Selection: MICA Enable 20dB gain Booster
			AC97_CodecCmd(WRITE,0x26, 0x4000);	//Enable PR1/PR0 (Stereo DACs and ADCs)
			AC97_CodecCmd(WRITE,0x26, 0x0000);	//Enable PR6 (O/P PGA's)		
			AC97_CodecCmd(WRITE,0x3E, 0xb990);	//Enable PGAs of LINE In L/R HPL,HPR and microphone bias
			if (eSampleRate >= 48000)
			{
				AC97_CodecCmd(WRITE,0x2A,0x0);		//Variable Rate Disable	
				AC97_CodecCmd(WRITE,0x2C,0xbb80);	//DAC Sampling frequency 48kHz
				AC97_CodecCmd(WRITE,0x32,0xbb80);	//ADC Sampling frequency 48kHz
			}
			else
			{
				AC97_CodecCmd(WRITE,0x2A,0x1);			//Variable Rate Enable	
				AC97_CodecCmd(WRITE,0x2C,eSampleRate);	//DAC Sampling frequency
				AC97_CodecCmd(WRITE,0x32,eSampleRate);	//ADC Sampling frequency
			}
			UART_Printf("VRA Enable(1)/Disable(0): 0x%x\n",(0x1&AC97_CodecCmd(READ,0x2A,0x0000)));	
			AC97_CodecCmd(WRITE,0x04, 0x0a0a);	//HeadPhone output Volume
			AC97_CodecCmd(WRITE,0x0c, 0x6808);	//Unmute DAC to HP mixer path
			AC97_CodecCmd(WRITE,0x12, 0x0000);		//Unmute ADC and Set ADC Recoding Volume, Standard Record Gain : 22.5dB	
			AC97_CodecCmd(WRITE,0x1c, 0x00a0);	//Control input PGA 			
			if ( eFormat == ACLinkSlot34)
				AC97_CodecCmd(WRITE,0x5C, 0x0);		// ADC Slot Mapping: Left(Slot 3), Right(Slot 4)					
			else if (eFormat == ACLinkSlot6)
				AC97_CodecCmd(WRITE,0x5C, 0x2);		// ADC Slot Mapping: Left(Slot 6), Right(Slot 9)					
			break;	
	}
}

//////////
// Function Name : WM9713_GetVolume
// Function Desctiption : This function gets Audio Codec Volume.
// Input : 			eCh  - TX / RX
// Output : None
// Version : 0.0
// Author : Sunghyun, Na
u32 WM9713_GetVolume(AUDIO_Interface eCh)
{
	u32 uVolRegister;
	if (eCh == AUDIO_Rx)
	{
		uVolRegister = AC97_CodecCmd(READ,0x12,0x00000);	//HP out volume 
		uVolRegister &= (0x3f);
		return uVolRegister;
	}
	else 
	{
		uVolRegister = AC97_CodecCmd(READ,0x04,0x00000);	//HP out volume 
		uVolRegister &= (0x3f);
		return uVolRegister;
	}
}	

//////////
// Function Name : WM9713_SetVolume
// Function Desctiption : This function sets Audio Codec Gain.
// Input : 			eCh  - TX / RX
// Output : u8 - Limited Volume Range
// Version : 0.0
// Author : Sunghyun, Na
u8 WM9713_SetVolume(AUDIO_Interface eCh, s32 uVolume)
{
	u16 uVolRegister;
	if (eCh == AUDIO_Rx)
	{
		if ( uVolume >= 0xf || uVolume <= 0x0 )
		{
			return FALSE;	
		}
		else 
		{
			uVolRegister = AC97_CodecCmd(READ,0x12,0);			//Read ADC Gain
			uVolRegister &= ~(0xf << 8) & ~(0xf << 0);
			uVolRegister |= (uVolume << 8) | (uVolume << 0);
			AC97_CodecCmd(WRITE,0x12,(u16) uVolRegister);				//ADC Gain		
			return TRUE;
		}
	}
	else 
	{
		if ( uVolume < WM9713_MAXVOL || uVolume > WM9713_MINVOL )
		{
			return FALSE;	
		}
		else
		{
			uVolRegister = AC97_CodecCmd(READ, 0x04, 0);		//Read HP out volume Register
			uVolRegister &= ~(0x3f << 8) & ~(0x3f << 0);
			uVolRegister |= ((u16) uVolume << 8) | ((u16) uVolume << 0);
			AC97_CodecCmd(WRITE,0x04,(u16) uVolRegister);				//HP out volume 
			return TRUE;
		}
	}
}	


