/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : adcts_test.c
*  
*	File Description : This file implements adcts test functions.
*
*	Author : Sunil,Roe
*	Dept. : AP Development Team
*	Created Date : 2007/1/2
*	Version : 0.1 
* 
*	History
*	- Created(Sunil,Roe 2007/1/2)
*	- Edited by OnPil,Shin (SOP) on 2008/03/05 ~ 
*	- Edited by Chigwan,Oh (ocg) on 2009/07/03 ~ 
*   
**************************************************************************************/
#ifndef __ADCTS_H__
#define __ADCTS_H__
 
  
#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "def.h"

#define	RESSEL12BIT			1	// A/D conversion   0: 10-bit,   1: 12-bit

#define	ENABLE					1
#define	DISABLE					0
#define	SELECT					1
#define	DESELECT				0

#define	STYLUS_DOWN				0
#define	STYLUS_UP				1


#define	ADCTS_TOUCH_DOWN		0
#define	ADCTS_TOUCH_UP			1
#define	ADCTS_TOUCH_INIT		2

//ocg
//#define	ADCTS_PRSCVL			65	//PCLK(66MHz)/(65+1) = 1MHz = ADC Conversion freq.
//#define	ADCTS_PRSCVL				49	//PCLK(50MHz)/(49+1) = 1MHz = ADC Conversion freq.
//#define	ADCTS_PRSCVL			9	//PCLK(50MHz)/(9+1) = 5MHz = ADC Conversion freq Max Test.
//#define	ADCTS_PRSCVL				5	// PRSCVL MIN	
#define	ADCTS_PRSCVL				255	// PRSCVL MAX	

typedef enum ADCTS_Id
{
	// Touch Channel 0
	eADCTS_ADCCON = 0,				// Off_Set : 0x00
	eADCTS_ADCTSC = 1,				// Off_Set : 0x04 
	eADCTS_ADCDLY = 2,				// Off_Set : 0x08 
	eADCTS_ADCDAT0 = 3,				// Off_Set : 0x0c 
	eADCTS_ADCDAT1 = 4,				// Off_Set : 0x10 
	eADCTS_ADCUPDN = 5,				// Off_Set : 0x14 
	eADCTS_ADCCLRINT = 6,			// Off_Set : 0x18 
	eADCTS_ADCMUX = 7,				// Off_Set : 0x1c 
	eADCTS_ADCCLRINTPNDNUP = 8,		// Off_Set : 0x20 	
		
}
eADCTS_Id;

typedef enum ADCTS_Id_CH1
{
	// Touch Channel 1
	eADCTS_ADCCON_CH1 = 0,				// Off_Set : 0x00 
	eADCTS_ADCTSC_CH1 = 1,				// Off_Set : 0x04 
	eADCTS_ADCDLY_CH1 = 2,				// Off_Set : 0x08 
	eADCTS_ADCDAT0_CH1 = 3,				// Off_Set : 0x0c 
	eADCTS_ADCDAT1_CH1 = 4,				// Off_Set : 0x10 
	eADCTS_ADCUPDN_CH1 = 5,				// Off_Set : 0x14 
	eADCTS_ADCCLRINT_CH1 = 6,			// Off_Set : 0x18 

	eADCTS_ADCCLRINTPNDNUP_CH1 = 8,		// Off_Set : 0x20 			
}
eADCTS_Id_CH1;

typedef enum ADCTS_MeasureModeId
{
	eADCTS_MEASURE_NOP = 0,
	eADCTS_MEASURE_MANUAL_X = 1,
	eADCTS_MEASURE_MANUAL_Y = 2,
	eADCTS_MEASURE_AUTO_SEQ = 3,
	eADCTS_MEASURE_FOR_STYLUS = 4,
}
eADCTS_MeasureModeId;

typedef struct ADCTS_Inform
{	
	u32	uADCSampleData;	
	u8	ucADCflag;
	u8	ucTouchStatus_ch0;
	u8	ucTouchStatus_ch1;
	bool  uTouchChannels_ch0;
	bool  uTouchChannels_ch1;
}

ADCTS_oInform;


void __irq	ADC_NormalISR(void);
void __irq	ADCTS_StylusTrackingISR(void);
void __irq	ADCTS_StylusTrackingISR_CH1(void);
void __irq	ADCTS_StylusTrackingISR_Auto(void);

/*---------------------------------- APIs of rADCCON ---------------------------------*/
bool ADCTS_Init(void);
void ADCTS_SetStandbyMode(void);
void ADC_InitADCCON(void);	
bool ADC_IsEOCFlag(void);
void ADC_EnablePrescaler(u8);
void ADC_SetPrescaler(u8);
void ADC_SelectADCCh(u8);
void ADC_SelectStandbyMode(u8);
void ADC_EnableReadStart(u8);
void ADC_EnableStart(u8);
bool ADC_IsAfterStartup(void);
void ADCTS_SelTouchScreen(u8 );//ocg add

/*---------------------------------- APIs of rADCTSC ---------------------------------*/
void ADCTS_SetMeasureMode(u8 );
void ADCTS_SetMeasureMode_CH1(u8 );
void ADCTS_SetStylusDetectMode(u8 );
	
/*---------------------------------- APIs of rADCDLY ---------------------------------*/
void ADCTS_SetDelayClkSrc(u8 );
void ADCTS_SetDelay(u32 );

/*---------------------------------- APIs of rADCDATx ---------------------------------*/
bool ADCTS_GetXPStylusIntState(void);
bool ADCTS_GetYPStylusIntState(void);
u32 ADCTS_GetXPData(void);
u32 ADCTS_GetYPData(void);

/*---------------------------------- APIs of INT Clear Registers ---------------------------------*/
void ADCTS_SetADCClearInt(void);
void ADCTS_SetADCClearWKInt(void);

/*---------------------------------- APIs of general ADCTS ---------------------------------*/
u32 ADCTS_GetRegValue(u8);
void ADCTS_SetRegValue(u8, u32);

// Channel_1 functions
u32 ADCTS_GetRegValue_CH1(u8 );
void ADC_InitADCCON_CH1(void);
void ADCTS_SetRegValue_CH1(u8 , u32 );
void ADCTS_SetDelay_CH1(u32 );
void ADCTS_SetDelayClkSrc_CH1(u8 );
void ADCTS_SetMeasureMode_CH1(u8 );
bool ADCTS_GetXPStylusIntState_CH1(void);
void ADC_EnableStart_CH1(u8 );
bool ADC_IsAfterStartup_CH1(void);
bool ADC_IsEOCFlag_CH1(void);
u32 ADCTS_GetXPData_CH1(void);
void ADCTS_SetStylusDetectMode_CH1(u8 );
void ADCTS_SetADCClearInt_CH1(void);
void ADCTS_SetADCClearWKInt_CH1(void);

void ADCTS_TouchChannelSel(u8 );

bool ADCTS_AutoTest(void);

void ADCTS_WakeUpInit(u32 uCh); // default channel 0. by junon

#ifdef __cplusplus
}
#endif

#endif /*__ADCTS_H__*/
