/***************************************************************

  NAME: SfrReadWrite
  DESC: To check sfr read/write is possible
  HISTORY:  
  09.19.2007:grmoon
  	- S3C2443 GPIO configuration setup

 ****************************************************************/
#include "System.h"
#include "SfrReadWriten.h"



void RPRINTFn(REGINFOn sReg, unsigned int uPattern, unsigned char uRegStatus, int Nth,unsigned char uInDetail)
{	
#if 0 //jspark removed	
	if(uInDetail)
		UART_Printf("\n%s,0x%X,0x%X,0x%X", sReg.name, sReg.uAddr, uPattern, sReg.rValue);	
	else
	{	
		if(!Nth)	
		UART_Printf("\n%s,0x%X\t", sReg.name, sReg.uAddr);
	}
	if(uRegStatus)
	{
		if(uInDetail)
			UART_Printf("\t[%d] Error!!",Nth);
		else
			UART_Printf("%d)",Nth);			
	}
#else
	if(uInDetail)
		UART_Printf("\n%20s (0x%08X): Pattern 0x%08X, Read 0x%08X", sReg.name, sReg.uAddr, uPattern, sReg.rValue);	
	else
	{	
		if(!Nth)	
		UART_Printf("\n%20s, 0x%08X\t", sReg.name, sReg.uAddr);
	}
	if(uRegStatus)
	{
		if(uInDetail)
			UART_Printf(", Error Pattern Bit[%d]",Nth);
		else
			UART_Printf("%d)",Nth);			
	}
#endif
	return;
	
}

//count = sizeof(sRegInfo)/sizeof(REGINFO)
bool TestSFRn(const REGINFOn* psRegInfo, int count)
{
	volatile unsigned int *pAddr;	
	int i,j,nPattern, nBitMask;
	unsigned int uRegStatus, uWritePatternWithMask, uReadWithMask;	
	REGINFOn sRegInfo;
	unsigned int uRegResetvalue;
	int failnum=0;
	int tempfailnum=0;
	
	
	unsigned int uPatternShitfOneBit[] = 
	{
		0x00000001,		0x00000002,		0x00000004,		0x00000008,		0x00000010,		0x00000020,		0x00000040,		0x00000080,
		0x00000100,		0x00000200,		0x00000400,		0x00000800,		0x00001000,		0x00002000,		0x00004000,		0x00008000,
		0x00010000,		0x00020000,		0x00040000,		0x00080000,		0x00100000,		0x00200000,		0x00400000,		0x00800000,
		0x01000000,		0x02000000,		0x04000000,		0x08000000,		0x10000000,		0x20000000,		0x40000000,		0x80000000,
	};
	
	unsigned int uDefaultBitMask[] =
	{
		0x00000001,		0x00000003,		0x00000007,		0x0000000F,		0x0000001F,		0x0000003F,		0x0000007F,		0x000000FF,
		0x000001FF,		0x000003FF,		0x000007FF,		0x00000FFF,		0x00001FFF,		0x00003FFF,		0x00007FFF,		0x0000FFFF,
		0x0001FFFF,		0x0003FFFF,		0x0007FFFF,		0x000FFFFF,		0x001FFFFF,		0x003FFFFF,		0x007FFFFF,		0x00FFFFFF,
		0x01FFFFFF,		0x03FFFFFF,		0x07FFFFFF,		0x0FFFFFFF,		0x1FFFFFFF,		0x3FFFFFFF,		0x7FFFFFFF,		0xFFFFFFFF,
	};

	//added

	UART_Printf("\n\nSFR reset value test entered\n\n");
	for(i=0; i<count; i++)
	{		
		sRegInfo = psRegInfo[i];
	
		pAddr = (unsigned int*)sRegInfo.uAddr;		

		uRegResetvalue = *pAddr;
		UART_Printf("\n%20s reset value -should be: 0x%08x, now: 0x%08x",sRegInfo.name, sRegInfo.uResetValue, uRegResetvalue);		
		if( uRegResetvalue != sRegInfo.uResetValue)
		{
			UART_Printf(" --> Error !!");
			failnum++;			
		}
	}
	tempfailnum = failnum;
	if(!tempfailnum) UART_Printf("\nSFR reset test is Done...\n");

	//added
	
	UART_Printf("\n\nSFR read/write test entered\n\n");	
	for(i=0; i<count; i++)
	{		
		sRegInfo = psRegInfo[i];
	
		pAddr = (unsigned int*)sRegInfo.uAddr;		
		
	
		if(sRegInfo.uFlag == DPDB)
		{		
			if(sRegInfo.uRWType == RW)
			{
				for(j=0; j<= sRegInfo.uBitLen ; j++)
				{			
					uWritePatternWithMask = (uPatternShitfOneBit[j] &uDefaultBitMask[j]);					
					*pAddr = uWritePatternWithMask;					
					
					uReadWithMask = (*pAddr & uDefaultBitMask[j]);	
					sRegInfo.rValue = uReadWithMask;					
					
					uRegStatus = (	uWritePatternWithMask !=uReadWithMask );										
					RPRINTFn(sRegInfo, uPatternShitfOneBit[j], uRegStatus, j, 1/*SHOWALL*/);					
					
					if(uRegStatus) failnum++;
				}
			}
		}		
		else if(sRegInfo.uFlag == DPPB)
		{		
			nPattern = (sizeof(uPatternShitfOneBit)/sizeof(uPatternShitfOneBit[0]));			
			if(sRegInfo.uRWType == RW)
			{
				for(j=0; j<nPattern; j++)
				{
					if(uPatternShitfOneBit[j] & sRegInfo.uPrivateBitMask)
					{
						uWritePatternWithMask = (uPatternShitfOneBit[j] & sRegInfo.uPrivateBitMask);
						*pAddr = uWritePatternWithMask;
						
						uReadWithMask = (*pAddr & sRegInfo.uPrivateBitMask);
						sRegInfo.rValue = uReadWithMask;
						
						uRegStatus = (	uWritePatternWithMask != uReadWithMask );																
						RPRINTFn(sRegInfo, uPatternShitfOneBit[j], uRegStatus, j, 1/*SHOWALL*/);					
						if(uRegStatus) failnum++;
					}
				}
			}			
		}					
	}
	tempfailnum = failnum - tempfailnum;
	if(!tempfailnum) UART_Printf("\nSFR read/write test is ok\n");	
	
	UART_Printf("\n\nTest Complete! (failnum: %d)\n\n", failnum);
	UART_Printf("if it has too many failnum then check, whether register set by UMON, or the other code\n");
	//added
	UART_Printf("\n\nSFR reset restore...\n\n");
	for(i=0; i<count; i++)
	{		
		sRegInfo = psRegInfo[i];
	
		pAddr = (unsigned int*)sRegInfo.uAddr;		

		*pAddr = sRegInfo.uResetValue;
	}
	//added
	
	
	if(failnum>0) return 0;
	else return 1;
}
