/*******************************************************************************
* 
*	Filename:	autotest_ip_fn.h
*  
*	Descriptions
*	- Header file of extern ip function verifying code, function information for autotest.c
* 
*	History
*	- 28, July 2007 add
*
*	Version 0.1
*	Copyright (c) 2007 SAMSUNG Electronics.  
*  
********************************************************************************/

#ifndef __AUTOTEST_IP_FN_H__
#define __AUTOTEST_IP_FN_H__

//
// only included to autotest.c


/////////////////////////////////// add headers, externs for each IPs ////////////////////////////

//Auto Tests

extern u8 TIMER_Int_autotest(void);				//chapter 32

extern bool DMA_FullFunction_autotest(void);

extern bool OneNAND_FullFunction_autotest(void);

extern bool ADCTS_AutoTest(void);

extern bool SDHC_CH0_Test_autotest(void);
extern bool SDHC_CH2_Test_autotest(void);
extern bool SDHC_CH3_Test_autotest(void);

extern bool	SGX540_3D_Autotest(void);

extern u8 MFC_AutoTest(void);

extern bool KEYPAD_AutoTest(void);
extern u8 Uart_AutoTest(void);

extern	u8 IIC0_AutoTest(void);
extern u8  Sblock_AES_autotest(void);
//extern u8  Sblock_DES_autotest(void);
extern u8  Sblock_Hash_autotest(void);
extern u8  Sblock_PKA_autotest(void);
extern bool ROTATOR_AutoTest(void);
extern u8 WDT_IntReq_autotest(void);
extern u8 RTC_initialize_autotest(void);
extern u8 DMCT_DramInterfaceAutoTest(void);
extern u8 DMCT_OnedramAportCtypeSMDK_autotest(void);
extern u8 DMCT_OnedramAportAtypeSMDK_autotest(void);
extern u8 RTC_TimeTick_autotest(void);
extern u8 JPEG_AutoTest(void);
extern u8 TestDinDoutForSortingChip(void);
extern bool APP_PlayingWavFileUsingAudioSubSysemAuto();
//Manual Tests

extern u8 SPIAuto_MasterTxSlaveRxDMA(void);	// chapter 29
extern u8 SPIAuto_MasterRxSlaveTxDMA(void);	// chapter 29
extern u8 SPIAuto_SlaveTxMasterRxDMA(void);	// chapter 29
extern u8 SPIAuto_SlaveRxMasterTxDMA(void);	// chapter 29
extern u8 SPIAuto_MasterTxSlaveRxInt(void);		// chapter 29
extern u8 SPIAuto_MasterRxSlaveTxInt(void);		// chapter 29
extern u8 SPIAuto_SlaveTxMasterRxInt(void);		// chapter 29
extern u8 SPIAuto_SlaveRxMasterTxInt(void);		// chapter 29

extern bool TestI2Sv5_1_autotest();
extern bool TestI2Sv5_1_autotest2();
extern bool TestPCM_autotest();
extern u8 DSIMTest_AutoTest(void);

extern u8 DhryStone_autotest(void);

extern u8 ATA_PioCpu_autotest(void);
extern u8 ATA_PioDma_autotest(void);
extern u8 ATA_UDmaMode_autotest(void);

//Fill above manualtest externs...


////////////////////////////////////// Guide to how to add ip functions /////////////////
// 1.Guide to how to fill function structure.
// 1.0.function structure
//typedef struct 
//{
//	u8 	(*fn)(void); 			//user set
//	char 	name[LEN_TEST_NAME+1];	//user set
//	int		type;					//user set
//	char	Result;					//default
//	u8 	bIsSelected;			//default
//}test_fn;
//   - leave Result, isSelected fileds as default value
// 
// 1.1.IP test function code guide
//   - Every Unit  tests  should return  ok or fail.
//   - using tags(<  >  </  >) in printf is not recommended
//
// 1.2.IP test name guide 
//   - test name size is upto 449
//   - to support tree structure support
//	   add '+'s beginning of test name to assign tree depth
//  ex)
//	 IP test name 			tree depth					actual tree structure will be showing
//   ALL						0 (parent)				|---[ ] ALL 
//   +Auto tests			=>  1 (child) 		=>	  	  |---[ ] auto tests
//   ++19. PWM timer			2 (grandchild 0)			|---[ ] 19. PWM timer			//IP name
//	 +++1. Interrupt test		3 (grandgrandchild)			| |---[ ] 1. Interrupt test		  //IP sub test names
//   ++20. Watchdog Timer       2 (grandchild 1)			|---[ ] 20. Watchdog Timer
//
// 1.3.Sub test
//	- sub tests easily can be made as adding one more '+' than its parent test
//    19. PWM timer /  +1. Interrupt test
//  - but for readability it is recommended to limit number of sub tests less than 10
//
// 1.4 Group name
//  - In a treed view, it is needed grouping tests
//  - first, set function as dummygroupname, becuase it is not an IP test code
//  - second, set type as TYPE_GROUP_NAME to transfer type information to DNW
//
// 1.5 Prepare guide
//  - before starting tests(when get test lists from SMDK), 
//  - show to user  what  should be prepared before starting  test,
//  - use TYPE_PREPARE_GUIDE
//  - this description will be show at the first time of the displaying lists,
////////////////////////////////////// add ip functions & explanation //////

test_fn func_auto_test[]=
{
	//IP testfunction pointer   	  IP test name / Group name / Guide		type				Result 		isSelected  
	//(user set)					  (user set)							(user set)			(system)	 (system)
	//								  0123456789012345678901... up to 449   
	//dummy							  PWM timer					    		TYPE_GROUP_NAME		0				0
	//dummy							  ; set the jumper1 to [100]			TYPE_PREPARE_GUIDE	0				0
	//PWM_INT_autotest				  +Interrupt test						TYPE_IP_TEST		0				0

	//These parts are for the auto test which user don't need to  check result.
	dummyguide						,"S5PV210 Tests guide                    ", TYPE_GROUP_NAME,0,0,
	dummyguide						,"+; DEFAULT BOARD SETTING is needed (before starting whole test)", TYPE_PREPARE_GUIDE,0,0,	
	dummyguide						,"++;     IF this is the First time, Turn OFF BOARD, Setting as follows, Then Close This box, and RESTART TESTS", TYPE_PREPARE_GUIDE,0,0,	
	dummyguide						,"++;     Tests which has* right side of IP test names, for these IPs, user should prepare following", TYPE_PREPARE_GUIDE,0,0,
	dummyguide						,"++;     items before starting tests", TYPE_PREPARE_GUIDE,0,0,

	dummygroupname					,"S5PV210 Automatic tests                ", TYPE_GROUP_NAME,0,0,
	dummyguide						,"+; tests user doesn't need to input ", TYPE_PREPARE_GUIDE,0,0,

	dummygroupname					,"+09. CF CONTROLLER                    ", TYPE_GROUP_NAME,0,0,
	ATA_PioCpu_autotest					,"++ATA PIOCPU mode                    ", TYPE_IP_TEST,0,0,
	ATA_PioDma_autotest				,"++ATA PIODMA mode                    ", TYPE_IP_TEST,0,0,
	ATA_UDmaMode_autotest				,"++ATA UDMA mode 	                  ", TYPE_IP_TEST,0,0,


	dummygroupname					,"+32. PWM timer                      ", TYPE_GROUP_NAME,0,0,
	TIMER_Int_autotest				,"++Interrupt                         ", TYPE_IP_TEST,0,0,//(coverage 90%)

	dummygroupname					,"+32. DMA test                       ", TYPE_GROUP_NAME,0,0,
	DMA_FullFunction_autotest		,"++DMA_FullFunction_autotest         ", TYPE_IP_TEST,0,0,//(coverage 90%)

	dummygroupname					,"+32. OneNAND test                   ", TYPE_GROUP_NAME,0,0,
	OneNAND_FullFunction_autotest	,"++OneNAND_FullFunction_autotest     ", TYPE_IP_TEST,0,0,//(coverage 90%)

	dummygroupname                  ,"+39. ADC&TS                       ", TYPE_GROUP_NAME,0,0,
	ADCTS_AutoTest					,"++Touch and ADC conversion        ", TYPE_IP_TEST,0,0,//(coverage 80%)

	dummygroupname					,"+ SD Test                     ", TYPE_GROUP_NAME,0,0,
	SDHC_CH0_Test_autotest				,"++  CH0 Read and Write blocks                       ", TYPE_IP_TEST,0,0,//(coverage 90%)
	SDHC_CH2_Test_autotest				,"++  CH0 Read and Write blocks                       ", TYPE_IP_TEST,0,0,//(coverage 90%)
	SDHC_CH3_Test_autotest				,"++  CH0 Read and Write blocks                       ", TYPE_IP_TEST,0,0,//(coverage 90%)
	
	dummygroupname					,"+09.12 ROTATOR                        ", TYPE_GROUP_NAME,0,0,
	ROTATOR_AutoTest					,"++Rotator All Combination  [50 sec] ", TYPE_IP_TEST,0,0,


	dummygroupname					,"+11.03 Security Sub System            ", TYPE_GROUP_NAME,0,0,
	Sblock_AES_autotest					,"++AES FullFunction                  ", TYPE_IP_TEST,0,0,//(Coverage 100%)
	 //Sblock_DES_autotest 	    			,"++DES FullFunction                  ", TYPE_IP_TEST,0,0,//(Coverage 100%)
	Sblock_Hash_autotest    				,"++HASH FullFunction                 ", TYPE_IP_TEST,0,0,//(Coverage 100%)
	Sblock_PKA_autotest					,"++PKA FullFunction 			", TYPE_IP_TEST,0,0,//(Coverage 100%)
	
	dummygroupname					,"+ 3D Test                     ", TYPE_GROUP_NAME,0,0,
	SGX540_3D_Autotest				,"++  3D Block Test                     ", TYPE_IP_TEST,0,0,//(coverage 70%)

	dummygroupname					,"+ MFC Test                     ", TYPE_GROUP_NAME,0,0,
	MFC_AutoTest					,"++  DEC/ENC Conformance Test                     ", TYPE_IP_TEST,0,0,//(coverage 80%)

	dummygroupname					,"+ JPEG Codec *                  ", TYPE_GROUP_NAME,0,0,
	JPEG_AutoTest					,"++JPEG Test                     ", TYPE_IP_TEST,0,0,//(Coverage 25%)	

	dummygroupname					,"+ FIMC_0/1/2 test *                  ", TYPE_GROUP_NAME,0,0,
	TestDinDoutForSortingChip			,"++ FIMC_0/1/2 DinDout test      ", TYPE_IP_TEST,0,0,//(Coverage 25%)	
	
	dummygroupname                  ,"+40. KEYPAD                      ", TYPE_GROUP_NAME,0,0,
 	//dummyguide						,"++; Keypad :  base b'd bottom right (JF1001) <- INSERT KEYPAD B'D",TYPE_PREPARE_GUIDE,0,0,	
	//dummygroupname					,"++; (at run time) :  base b'd center bottom  CFG4 -> SW ALL OFF     ",TYPE_GROUP_NAME,0,0,
	KEYPAD_AutoTest                 ,"++Falling Interrupt mode          ", TYPE_IP_TEST,0,0,//(coverage 100%)

	dummygroupname                  ,"+31. UART                           ", TYPE_GROUP_NAME,0,0,
	Uart_AutoTest                   ,"++Loop back test                    ", TYPE_IP_TEST,0,0,

	dummygroupname                  ,"+31. IIC                           ", TYPE_GROUP_NAME,0,0,
	IIC0_AutoTest                   ,"++ IIC CH0 Test                    ", TYPE_IP_TEST,0,0,
	
	dummygroupname					,"+90. WDT test                       ", TYPE_GROUP_NAME,0,0,
	WDT_IntReq_autotest				,"++WDT_Interupt_Function_autotest    ", TYPE_IP_TEST,0,0,//(coverage 30%)

	dummygroupname					,"+91. RTC test 				      ", TYPE_GROUP_NAME,0,0,
	RTC_initialize_autotest     	,"++RTC_Initial_Function_autotest	  ", TYPE_IP_TEST,0,0,//(coverage 30%)
	RTC_TimeTick_autotest 		    ,"++RTC_TimeTick_autotest	          ", TYPE_IP_TEST,0,0,//(coverage 30%)

	dummygroupname					,"+92. DRAM test 				     ", TYPE_GROUP_NAME,0,0,
	DMCT_DramInterfaceAutoTest   	,"++DMC_DramInterface_autotest	      ", TYPE_IP_TEST,0,0,//(coverage 90%)
	DMCT_OnedramAportAtypeSMDK_autotest		,"++A-Port A-Type(SDRx32)			  ", TYPE_IP_TEST,0,0,//(coverage 30%)
	DMCT_OnedramAportCtypeSMDK_autotest		,"++A-Port C-Type(DDRx16)		   ", TYPE_IP_TEST,0,0,//(coverage 30%)

	dummygroupname					,"+. PCM test                      ", TYPE_GROUP_NAME,0,0,
// 	dummyguide						,"++; set CFGB10[1]on [2]off",TYPE_PREPARE_GUIDE,0,0,		
// 	dummyguide						,"++; set CFGB11[2][3] on",TYPE_PREPARE_GUIDE,0,0,		
	TestPCM_autotest					,"++hear tada sound(Polling/PDMA)           ", TYPE_IP_TEST,0,0,//(coverage 50%)

	dummygroupname					,"+. I2S v5.1                      ", TYPE_GROUP_NAME,0,0,
// 	dummyguide						,"++; set CFGB11[2][3] on",TYPE_PREPARE_GUIDE,0,0,		
//	TestI2Sv5_1_autotest				,"++hear tada sound(semi-auto)(polling master)           ", TYPE_IP_TEST,0,0,//(coverage 50%)
//	TestI2Sv5_1_autotest2				,"++hear tada sound(semi-auto)(dma master)           ", TYPE_IP_TEST,0,0,//(coverage 50%)
	APP_PlayingWavFileUsingAudioSubSysemAuto,"++hear tada sound(IDMA Audio SS)     ", TYPE_IP_TEST,0,0,//(coverage 70%)


	dummygroupname					,"+29. HS-SPI                       ", TYPE_GROUP_NAME,0,0,
	dummyguide						,"++; HS_SPI: Loopback Test between SPI0 and SPI1",	TYPE_PREPARE_GUIDE,0,0,
	//dummyguide						,"++; HS_SPI: cpu b'd top right CFG6 SW1,2 to ON, OFF",	TYPE_PREPARE_GUIDE,0,0,
	//dummyguide						,"++;     base b'd top right J7 -> Without CAMERA MODULE",	TYPE_PREPARE_GUIDE,0,0,	
	SPIAuto_MasterTxSlaveRxDMA		,"++SPI Master Tx/Slave Rx DMA        ", TYPE_IP_TEST,0,0,
	SPIAuto_MasterRxSlaveTxDMA		,"++SPI Master Rx/Slave Tx DMA        ", TYPE_IP_TEST,0,0,
	SPIAuto_SlaveRxMasterTxDMA		,"++SPI Slave Rx/Master Tx DMA        ", TYPE_IP_TEST,0,0,
	SPIAuto_SlaveTxMasterRxDMA		,"++SPI Slave Tx/Master Rx DMA        ", TYPE_IP_TEST,0,0,

	dummygroupname					,"+DSI Master*                       			", TYPE_GROUP_NAME,0,0,
	DSIMTest_AutoTest				,"++Display Color Bar on DSI Module        ", TYPE_IP_TEST,0,0,
	
	dummygroupname					,"+100. DhryStone test 				     ", TYPE_GROUP_NAME,0,0,
	DhryStone_autotest          	,"++DhryStone Arm performance test	     ", TYPE_IP_TEST,0,0,//(coverage 90%)

	//SPIAuto_MasterRxSlaveTxDMA		,"++SPI Master Rx/Slave Tx DMA        ", TYPE_IP_TEST,0,0,
	//SPIAuto_SlaveTxMasterRxDMA		,"++SPI Slave Tx/Master Rx DMA        ", TYPE_IP_TEST,0,0,
	//SPIAuto_SlaveRxMasterTxDMA		,"++SPI Slave Rx/Master Tx DMA        ", TYPE_IP_TEST,0,0,
	//SPIAuto_MasterTxSlaveRxInt			,"++SPI Master Tx/Slave Rx INT        ", TYPE_IP_TEST,0,0,
	//SPIAuto_MasterRxSlaveTxInt			,"++SPI Master Rx/Slave Tx INT        ", TYPE_IP_TEST,0,0,
	//SPIAuto_SlaveTxMasterRxInt			,"++SPI Slave Tx/Master Rx INT        ", TYPE_IP_TEST,0,0,
	//SPIAuto_SlaveRxMasterTxInt			,"++SPI Slave Rx/Master Tx INT        ", TYPE_IP_TEST,0,0,

 	0,0,0,0,0

};



#endif //end of __AUTOTEST_IP_FN_H__
