/*******************************************************************************
* 
*	Filename:	autotest_api.h
*  
*	Descriptions
*	- Header file of extern api for autotest.c
* 
*	History
*	- 23,July, 2007 Modified for 6400
*
*	Version 0.1
*	Copyright (c) 2007 SAMSUNG Electronics.  
*  
********************************************************************************/

#ifndef __AUTOTEST_API_H__
#define __AUTOTEST_API_H__

//#include "auto_protocol.h"
//when protocol is changed , below tag should be changed.

#ifdef __cplusplus
extern "C" {
#endif

///////////////////////////////////////////////////////////////////////////////////////////
///////////////// API funtion prototype for helping autotest ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////
// Find valid data out of 3 sampled data
//  
// return median of samples.
// if same data are exist, then return one of them
// 
// Background : because PC stopwatch based on OS tick,
//			   which has 30ms resolution, and every program
//			   operating task based, so some time,
//			   data which over the 30 ms resolution 
//			   in some cases over 1000 ms
//			   error ratio is 50 errors over 100,000 times stopwatch 
int AUTO_findvaliddata(int s1, int s2, int s3);

//Stopwatch

///////////////////////////
// PC Stopwtach start API
// ; start PC startwatch
extern void AUTO_stopwatchstart(void);

//////////////////////////////////
// PC Stopwtach finish & get ms API
//  ; finish PC stopwatch ,
//    return laptime(unit : milisecond) since PC stopwatch start
//
// output 
//		int : laptime (ms)
//			  resolution is 30ms (PC stopwatch 15~20ms + UART variation 10ms)
// example
//	    if got 100, it means  laptime is 70~130 ms
//
// Notice 
//		three sampling is needed for secure, 
//      at 100,000 of aging , 50 error(out of resolution) samples
//      were occured
//
// recommanded
//	    s1 = sampling 1,
//		s2 = sampling 2,
//		s3 = sampling 3,
//		i = secure data
//		i = AUTO_sampling( s1, s3, s3);
//
// for verification purpose, use oscilloscope which has less 10us resolution.
extern int  AUTO_stopwatchfinish_ms(void);


//USB upload/download

//////////////////////////////////
// Usb upload file from smdk memory to PC
//   ;upload contents in the firmware memory to the usb otg connected PC as a file.
// 	  , file location is where test binary file is located  
//	  if usb open is fail in the pc side, then retry.
//	 wait until upload is finished
//
// input : filename in the PC which want,   firmware memory address, size to want to upload
//
// output : true : upload ok,  false : fail.
//
// example :
//   AUTO_usb_upload_memtofile("UsbGetFile.bin",  0x18000000, 256);//pc dest filename,  firmware_source_mem_addr, source mem size to upload
extern u8 AUTO_usb_upload_memtofile(char* pc_dest_filename, int firmware_source_addr, int firmware_source_size );


//////////////////////////////////
// Usb file download from PC to smdk memory
//  ;download a certain file in the usb otg connected PC to firmware memory
// 	 , file location is where test binary file is located  
//	 wait until download is finished
//
// input : firmware DownloadAddress, filename in the PC
//
// output : >0 download ok, FileSize, size of downloaded image
//			-1 : download fail
// example : 
//	size = AUTO_usb_download_filetomem(0x20000000, "UsbGetFile.bin");//firmware_dest_mem_addr,  source pc file name
extern u32 AUTO_usb_download_filetomem(int firmware_dest_addr, char* pc_source_filename);




//reset

///////////////////////////
// reset API
// ; notice to DNW autotest, this SMDK IP test will be restarted
//
// DNW Autotest Action after reset
//   when download test image, SMDK will enter to Autotest mode,
//   then send testlists to continue tests 
//
// Guide code for IP test code
// 
// u8 IP_wdt_reset_test()
// {   
//		u32 uRstID = SYSC_RdRSTSTAT(0);//read reset status 0:hw 1:warm, 2:wdt, 3:sleep, 4:esleep, 5:sw
//		u32 uInform0 = Inp32Inform(0);
//		
//		if( uInform0 != 0xA070 ) 
//		{
//			AUTO_noticeWillReset();//notice before entering reset
//
//			uOutp32Inform(0, 0xA070 );
//			WDT_reset();
//			//will reset
//		}
//		else
//		if(uRstID == 2) 
//		{
//			//if rebooted, then entered again
//			//it's pass
//			printf("Reset ID : %d\n", uRstID);
//			
//			uOutp32Inform(0, 0x0 );//clear

//			return true;//ok
//		}
//		else
//			return false;//fail
// }
extern void AUTO_noticeWillReset(void);

///////////////////////////////////////////////////////////////////////////////////////////
///////////////// API funtion prototype for manual test ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////
// manual result check API
// ; show statement to user as message box (or with image),
//   allow user to input result manually
//   wait until user input the result.
//
// input
//		imagefileindex : related imagefile index(if it exist)
//					     else -1
//		char* format   : <statement with format %s, %f,> equivalent to printf
//		,...  		   : values equivalent to printf
//      * string size max is 1931 byte
//
// output
//      u8: true/false (when user pressed yes/no button)
//            this represent the result of a manual test
//
// example 
//		ret = AUTO_msg_askresult( -1, "<statement %f  %d>", 0.08, 12 );
//
//      /////////////manual result check//////////////////////////////////////////////////
//		//																			    //
//		//		Check following statement, if your observation is correct press [yes],  //
//		//													     if wrong press [no]    //
//		//																			    //
//		//        <statement  0.08, 12>												    //
//		//																			    //
//		//       					 [ yes ]             [no]						    //
//      //																			    //
//      //////////////////////////////////////////////////////////////////////////////////
//                                  
//      ret = true;//if yes is pressed after observation
//	 or ret = false;//if no is pressed after observation
//
// in short : string size max 2028-94-3 = 1931, printf format is possible, return user input
extern u8 AUTO_askresult(int imgfileindex, char *format,...);


///////////////////////////
// manual prepare guide API
// ; show statement to user as message box (or with image),
//   allow user to prepare for test manually ( prepare setting, prepare to observe results)
//   wait until user notice the finishing of preparing by pressing ok button
//
// input
//		imagefileindex : related imagefile index(if it exist)
//					     else -1
//		char* format   : <statement with format %s, %f,> equivalent to printf
//		,...  		   : values equivalent to printf
//      * string size max is 1966 byte
//
// example 
//		AUTO_preparing( -1, "<statement %f>", 0.1 );
//
//      /////////////Preparing guide before test///////////////////////////////////
//		//																	//
//		//		Prepare as following statement, after finished press [ok]   //
//		//																	//
//		//      <statement  0.1>											//
//		//																	//
//		//       					 [ ok  ]					  	    	//
//      //																	//
//      //////////////////////////////////////////////////////////////////////
//                                  
//      //go to next source line  if ok is pressed after presetting
//
// in short : string size max 2028-59 -3= 1966, printf format is possible, wait user preparing
extern void AUTO_preparing(int imgfileindex, const char *format,...);






///////////////////////////////////////////////////////////////////////////////////////////
///////////////// API function prototype for supporting verification ///////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


//Debug message (File, label2)

//////////////////////////////////////////
// Message with additional information API
// ; Show message to User(Label2)
//   save message to File(Error.log)
//   with additional information(Aging number, current total aging time)
//
// input 
//		const char *format,... : equivalent with printf(const char *format,...);
//      * string size max is 2028 byte
// example 
//      AUTO_msginfo_printf("current time : 0x%x:0x%x:0x%x", hour,min,sec);
extern void AUTO_msginfo_printf(const char *format,...);


////////////////////////////////////////////////
// Error Message with additional information API
// ; Show message to User(Label2)
//   save message to File(Error.log)
//   and increase Error count
//   with additional information(Aging number, current total aging time, error count)
//
// input 
//		const char *format,... : equivalent with printf(const char *format,...);
//      * string size max is 2028 byte
// example 
//      AUTO_errinfo_printf("%d : sec:0x%x", i, oldsec);
extern void AUTO_errinfo_printf(const char *format,...);








///////////////////////////////////////////////////////////////////////////////////////////
//////////////// function for autotest ////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

extern void AUTO_alltest(void);//add in main.c
extern void AUTO_menunumber(int n);



#ifdef __cplusplus
}
#endif


#endif //end of __AUTOTEST_API_H__
