/*******************************************************************************
* 
*	Filename:	autotest.h
*  
*	Descriptions
*	- Header file of autotest.c
* 
*	History
*	- 21,FEB,2007	Programming start	Dongjin Kim
*	- 23,July, 2007 Modified for 6400
*
*	Version 0.1
*	Copyright (c) 2007 SAMSUNG Electronics.  
*  
********************************************************************************/

#ifndef __AUTOTEST_H__
#define __AUTOTEST_H__


//when defined then, can verify Autotest function in testcase.c
#define VERIFYCODE

//function
static u8 AUTO_parser(char* pBuff,    char** pPTag, char** pPContent);
static u8 AUTO_gluer(char*,char*,char*,int);


// type def -be careful :
// it woulb pre-defined or type defined in Def.h
// in 6400 : don't need this 
// in 2443 : need define, type def ,
//
// add auto_typedefine.h  at IP test code.c, autotest.c"


//data structure & defines
#define TYPE_GROUP_NAME		1	//test type is for the title,
#define TYPE_IP_TEST		0	//test type if for the experiment
#define TYPE_PREPARE_GUIDE 	2	//guide to prepare before starting tests

#define RESULT_NOTYET	-1	//test is not yet tested

#define SIZE_test_fn	464
#define LEN_TEST_NAME	449
typedef struct 
{
									//size		type		value
	u8 	(*fn)(void); 			//4			user set
	char 	name[LEN_TEST_NAME+1];	//1*100		user set
	int		type;					//4			user set	TYPE_GROUP_NAME or
									//						TYPE_IP_TEST
	signed char	Result;					//1			system		RESULT_NOTYET
									//						 : not yet tested,
									//						0:fail, 1:ok
	u8 	bIsSelected;			//1			system
									//tot 460+4
}test_fn;//44
// system means user don't need to set this value, leave as default value
//  this space will be use for storing result after each tests
//  and for stroing test lists when dnw sent test lists



#endif //end of __AUTOTEST_H__
