/*******************************************************************************
* 
*	Project Name:	AP IP functional automatic test program(in SMDK test code part)
*  
*	Descriptions
*	- To implement Automatic test enviorment to QA, application part engineer,
*	  added protocol, and parser in SMDK test code part.
*	- also to support one click test enviorment, each IP test codes
*	  have to be modified.
*	  so in SMDK test code part, modifying IP test code is also included.
* 
*	Copyright (c) 2007 SAMSUNG Electronics.  
*	All rights reserved.
*
********************************************************************************/
/*******************************************************************************
* 
*	Filename:	autotest.c
*  
*	Descriptions
*	- S3C6410 Auto test code 
* 
*	History
*	- 21,FEB,2007	Programming start	Dongjin Kim
*	- 32,JULY,2007	modify for 6400	
*	- 01,APRIL,2008	modify for 6400	
*
*	Version 0.0
*	Copyright (c) 2007 SAMSUNG Electronics.  
*  
********************************************************************************/

#include <stdlib.h>//for atoi
#include <string.h>//for strrok
#include <stdio.h>//va_list
#include <stdarg.h>//va_list

#include "system.h"
#include "autotest.h"
#include "auto_protocol.h"

////////////////////////////////////// headers, externs for each IPs //////////////////


#define AUTO_GETS getsAutotest
#define AUTO_PUTS puts

 
		 



////////////////////////////////////// add ip functions & explanation ////////////////////
u8 dummygroupname(void) {	return true; }//dummy function for group name
u8 dummyguide(void) {	return true;}
u8 dummytest(void) {	return true;}

#include "autotest_ip_fn.h"//just moved to header file for convinence.

////////////////////////////////////// Start of Autotest main code //////////////////////////////

//input : num - number  to find  in   test list array
//		  bSelected - selected value  which want to set
//output : func_auto_test[i].bIsSelected  is  set  as
void AUTO_ARRAY_saveSelect(int num, u8 bSelect)
{
	int _s;
	
	_s= ( sizeof(func_auto_test)/SIZE_test_fn ) - 1;//1 for 0,0,0,0,0 end of structure
	if(num<0 || num>=_s) return;//assert;
	
	func_auto_test[num].bIsSelected = bSelect;	
}


//input : num - number  to find  in   test list array
//		  Result - result of test
//output : func_auto_test[i].Result  is  set  as
void AUTO_ARRAY_saveResult(int num, signed char Result)
{
	int _s;
	
	_s= ( sizeof(func_auto_test)/SIZE_test_fn ) - 1;//1 for 0,0,0,0,0 end of structure
	if(num<0 || num>=_s) return;//assert;
	
	func_auto_test[num].Result = Result;	
}



void AUTO_ARRAY_display()
{
	int i, _s;
	
	_s= ( sizeof(func_auto_test)/SIZE_test_fn ) - 1;//1 for 0,0,0,0,0 end of structure
	
	UART_Printf("______________________________________________________________________________\n");
	UART_Printf("Test information\n[num] - test name\n");
	UART_Printf("------------------------------------------------------------------------------\n");		
	for(i=0;i<_s;i++) 
	{
		UART_Printf("[%d] %s \t type [%s], result [%s], IsSelected [%s]\n",	 i,
											 	func_auto_test[i].name,
											 	(func_auto_test[i].type==TYPE_GROUP_NAME)?"group name":"ip test",
											 	(func_auto_test[i].Result==true)?"true":
											 	(func_auto_test[i].Result==false)?"false":
											 	"n/a  ",
											 	(func_auto_test[i].bIsSelected==true)?"true":"false"
			  );
	}
	UART_Printf("______________________________________________________________________________\n");
	
}



//saving selected testlists
//<go>0,1,2</go>  after inspecting  content
// save selected result to func_auto_test[i].bIsSelected
// input : "0,1,2" pContent
// act : save to func_auto_test[i].bIsSelected = true
void AUTO_RECI_getLists(char* pBuff)
{
	char* pch;
	int num;


	//found tag & content, pBuff will be changed.
    pch = strtok(pBuff,LIST_SEPERATOR);//		 ","
	while(pch!=NULL)
	{
		//update func_auto_test
		num=atoi(pch);
		AUTO_ARRAY_saveSelect(num, true);	
		//update end
		
		pch = strtok(NULL,LIST_SEPERATOR);//		 ","
		
	}	
}

//print usage
//when entered auto mode
//and help
void AUTO_DISP_help()
{
	UART_Printf("______________________________________________________________________________\n");
	UART_Printf("AP IP functional automatic test program(in SMDK test code part)\n");
	UART_Printf("general guide\n");			
	UART_Printf("  1. first be ready in SMDK test code(type autotest number or press CTRL+Q\n");
	UART_Printf("  2. then open Autotest window in DNW(press CTRL+A or choose in menu)\n");			
	UART_Printf("  3. select tests by pressing check box\n");			
	UART_Printf("  4. start test in DNW by pressing Go button\n");			
	UART_Printf("command summary\n");
	UART_Printf("  help : this screen, show general guide\n");
	UART_Printf("  display : show all IP test lists available in autotest mode\n");
	UART_Printf("  clear : clear result / IsSelected field of all IP test\n");
	UART_Printf("  go : start selected tests\n");
	UART_Printf("  exit : quit autotest mode\n");	
	UART_Printf("protocal commands test code will get\n");	
	UART_Printf("  <dgo>test number0,testnumber1,...</dgo> start selected tests\n");	
	UART_Printf("  <dlistreq>request</dlistreq> request test lists\n");		
	UART_Printf("______________________________________________________________________________\n");
}



//when result of AUTO_parser is NULL,
//then strcmp(NULL, "something") is not possible
void AUTO_alltest(void)
{
	char string[MAX_GLUER_DEST_BUFF_SIZE];
	char bResult=false;
	int i, _s, j;
		
	
	u8  bParser;
	char* pTag=NULL;
	char* pContent=NULL;
	
	UART_Printf("Autotest entered\n");
	
	//making testlists
	j = sizeof(func_auto_test);
	_s=j/SIZE_test_fn-1;
	UART_Printf("making auto test lists : total lists size:%d, each list est size:%d, list num:%d\n",
			j, SIZE_test_fn,_s );;
	
	//init
	for(i=0;i<_s;i++) 
	{
		AUTO_ARRAY_saveSelect(i,false);	
		AUTO_ARRAY_saveResult(i,-1);//not yet tested		
	}
	//AUTO_ARRAY_display();

	AUTO_DISP_help();

	//pseudo code for future extension with coworking with hardware board setting checking
	//board problem checking
	//board configuration test for certain (default) IPs tests
	
	while( 1 )
	{
		//waiting for command : SMDK ready
		UART_Printf("<%s>%s</%s>",TAG_TESTCODE_SMDKREADY,CONTENT_TESTCODE_READY,TAG_TESTCODE_SMDKREADY);
		AUTO_GETS(string);

		
		//exit
		if( strcmp(string, "exit") ==0) break;
		else if ( strcmp(string, "display") ==0) 
		{
			AUTO_ARRAY_display();
			continue;
		}//clear
		else if ( strcmp(string, "clear") ==0)
		{
			for(i=0;i<_s;i++) 
			{
				AUTO_ARRAY_saveSelect(i,false);	
				AUTO_ARRAY_saveResult(i,-1);		
			}
			AUTO_ARRAY_display();
			continue;
		}//help
		else if ( strcmp(string, "help") ==0)
		{
			AUTO_DISP_help();
			continue;
		}//command go without clearing selection
		else if ( strcmp(string, "go") ==0)
		{
			//clear result only
			for(i=0;i<_s;i++) 
			{
				AUTO_ARRAY_saveResult(i,-1);		
			}		
		
			//displaying selected test information
			AUTO_ARRAY_display();
			
			//starting test			
			for(i=0;i<_s;i++)
			{
				if(func_auto_test[i].bIsSelected == true) {
					char DestBuff[20];		
					bResult = func_auto_test[i].fn();
				
					//if test is finished, then send result & save information
					if(bResult == true) 
					{
						UART_Printf ("%s test result is OK\n", func_auto_test[i].name);
						sprintf(DestBuff,"%d-%s", i, CONTENT_TESTCODE_RESULT_OK);
					}
					else
					{
						UART_Printf ("%s test result is fail\n", func_auto_test[i].name);
						sprintf(DestBuff,"%d-%s", i, CONTENT_TESTCODE_RESULT_FAIL);
					}
					AUTO_ARRAY_saveResult(i,(char)bResult);//saveResult
					
				}

			}
			//repeating until finishing all tests
			
			//show summary of result
			AUTO_ARRAY_display();
			continue;
		}
		
		
		//if got command looking in the command table
		bParser=AUTO_parser(string, &pTag, &pContent);
		if( bParser == true)
		{
			//if it is list request command then send test all lists.
			if( strcmp( pTag, TAG_DNW_LIST_REQUEST ) == 0)
			{	
				char DestBuff[MAX_GLUER_DEST_BUFF_SIZE];

			//tests information
				//protocol version
				DestBuff[0]='\0';
				sprintf(DestBuff,"%d",PROTOCOL_VERSION);
				AUTO_gluer(TAG_TESTCODE_PROTOCOL_VER,DestBuff,string,MAX_GLUER_DEST_BUFF_SIZE);
				AUTO_PUTS (string);
				
				
				//lists infomation
				for(i=0;i<_s;i++) {
					DestBuff[0]='\0';
					//12-E+Interrupt test
					sprintf(DestBuff,"%d-%c%s",
												 i,
												 (func_auto_test[i].type==TYPE_GROUP_NAME)? CONTENT_TESTCODE_TYPE_GROUP_NAME :
												 (func_auto_test[i].type==TYPE_IP_TEST)?	CONTENT_TESTCODE_TYPE_IP_TEST:
												 											CONTENT_TESTCODE_TYPE_PREPARE_GUIDE,
												 func_auto_test[i].name);
					AUTO_gluer(TAG_TESTCODE_LIST_INFO,DestBuff,string,MAX_GLUER_DEST_BUFF_SIZE);
					AUTO_PUTS (string);
			    }
			    AUTO_gluer(TAG_TESTCODE_LIST_END,CONTENT_TESTCODE_LIST_END,string,MAX_GLUER_DEST_BUFF_SIZE);
				AUTO_PUTS (string);
			}//if is command is starting command, then execute auto test
			else if( strcmp( pTag, TAG_DNW_GO ) == 0)
			{
				//init
				for(i=0;i<_s;i++) 
				{
					AUTO_ARRAY_saveSelect(i,false);	
					AUTO_ARRAY_saveResult(i,-1);		
				}			
			
				//saving selected testlists
				//<go>0,1,2</go>  after inspecting  content
				// save selected result to func_auto_test[i].bIsSelected
				AUTO_RECI_getLists(pContent);
							
				
				//displaying selected test information
//				AUTO_ARRAY_display();
				

				//starting test			
				for(i=0;i<_s;i++)
				{
					if(func_auto_test[i].bIsSelected == true)
					{
						char DestBuff[MAX_GLUER_DEST_BUFF_SIZE];
					
						//delay for dnw store, display	esp in case of short test in SMDK
						for(j=0;j<2000000;j++);

						//test is started
						//printf ("single IP test start\n");
						UART_Printf("\n");
						sprintf(DestBuff,"%d-%s", i, CONTENT_TESTCODE_TEST_STARTED);
						AUTO_gluer(TAG_TESTCODE_TEST_START,DestBuff,string,MAX_GLUER_DEST_BUFF_SIZE);
						AUTO_PUTS (string);	
						
						//test
						bResult = func_auto_test[i].fn();
					
						//if test is finished, then send result & save information
						if(bResult == true) 
						{
							UART_Printf ("%s test result is OK\n", func_auto_test[i].name);
							sprintf(DestBuff,"%d-%s", i, CONTENT_TESTCODE_RESULT_OK);
							AUTO_gluer(TAG_TESTCODE_RESULT,DestBuff,string,MAX_GLUER_DEST_BUFF_SIZE);
							AUTO_PUTS (string);
							
							
						}
						else
						{
							UART_Printf ("%s test result is fail\n", func_auto_test[i].name);
							sprintf(DestBuff,"%d-%s", i, CONTENT_TESTCODE_RESULT_FAIL);
							AUTO_gluer(TAG_TESTCODE_RESULT,DestBuff,string,MAX_GLUER_DEST_BUFF_SIZE);
							AUTO_PUTS (string);// string + \n
						}
						AUTO_ARRAY_saveResult(i,bResult);//saveResult
						
					}

				}
				//repeating until finishing all tests
				
				//show summary of result
//				AUTO_ARRAY_display();
				
			}
			
		}//end of parser	
		
		//return;
	
	}//end of while loop
	

			
}


//////////////////////////////////////////////// autotest parser & gluer ////////////////////////////


////////////////////////////////////////////////////
// Function Name : Parser function
// Function Description : 
//
// Input		: char *pbuff - address allocated string
//  format	: "<cmd>go</cmd>0" or "<cmd>go</cmd>'\n'"
//			"<cmd>go</cmd>xxxxxxxx"
//			cmd is tag, go is content , < >  </ >wrapper
//	warning : buff will be changed to "<cmd0go0/cmd0xxx"
// Output	
//			: u8 - true mean  condition  is met
//			: char *pPTag - starting address of tag(opener)
//			:			return address buff+1		
//			: char *pPContent - starting address of content
//			:			return address buff+5
//			
// condition(assert point)
//			: buff has not to be NULL
//			: tag must be wrapped with < > and </ >
//			: tag must be found both of <> and </ >
// history: change format
u8 AUTO_parser(char* pBuff,    char** pPTag, char** pPContent)
{
	int i;
	u8 bIsWrapperfound;
	u8 bIsTagfound;
	char* pch;
	char* pcha[NUM_PARSER_ARRAY];//3

	if (pBuff == NULL ||
		pPTag == NULL || pPContent == NULL) return false;//assert
	
	//init
	i=0;
	bIsWrapperfound=false;
	bIsTagfound=false;	

	//found proper warpper								<  >    </  >
    pcha[0] = strchr(pBuff, WRAPPER_OPENER_END);	//	  '>'
	pcha[1] = strstr(pBuff, WRAPPER_CLOSER_BEGIN);	//		   "</"
	pcha[2] = strrchr(pBuff,WRAPPER_CLOSER_END);	//			   '>'
	//pcha are used to inspect Wrapper loc.
	if( pBuff[0] == WRAPPER_OPENER_BEGIN &&			// '<'
	    pcha[0] > pBuff &&
	    pcha[1] > pcha[0] &&
	    pcha[2] > pcha[1] )
	{
		bIsWrapperfound = true;
	}	
	if(bIsWrapperfound==false) return false;//assert

	//found tag & content, pBuff will be changed.
    pch = strtok(pBuff,WRAPPER_KINDS);//		 "<>/"
	while(pch!=NULL && i<NUM_PARSER_ARRAY)
	{
		pcha[i] = pch;
		pch = strtok(NULL,WRAPPER_KINDS);//		 "<>/"
		i++;
	}
	//pcha[0] = tagOpener
	//pcha[1] = content	
	//pcha[2] = tagCloser
	if( strcmp(pcha[0], pcha[2]) == 0)
		bIsTagfound = true;
	if(bIsTagfound == false) return false;//assert
	
	//found contents location	
	*pPTag = pcha[0];
	*pPContent = pcha[1];
	return true;
}

////////////////////////////////////////////////////
// Function Name : Gluer function
// Function Description : 
// Input  : pTag - staring address of tag
//		   pContent - starting addess of content
//		   sBuffsize - size of Destination Buff, including null
// Output : pDestBuff - allocated starting address Buff
//		   <Tag>Content</Content>0
// warning : pDestBuff is initialized in this function.
// condition : pDestBuff size has to be same or larger than
//			  strlen(tag)*2+5 + strlen(content) +1
u8 AUTO_gluer(char*	pTag,
				char*	pContent,
				char*	pDestBuff,				
				int		sBuffsize)
{
	int i;
	char ch[1];
	
	if( pTag == NULL || pContent == NULL || pDestBuff == NULL)
		return false;//assert
	
	//estimate needed pDestBuff size	
	i=strlen(pTag)*2+strlen(pContent)+strlen(WRAPPER_ALL)+1;
	if(sBuffsize<i) return false;//assert
	
	
	pDestBuff[0]='\0';
	ch[0] =			 WRAPPER_OPENER_BEGIN;	strcat(pDestBuff,ch);
	strcat(pDestBuff,pTag);
	ch[0] =			 WRAPPER_OPENER_END;	strcat(pDestBuff,ch);
	strcat(pDestBuff,pContent);
	strcat(pDestBuff,WRAPPER_CLOSER_BEGIN);
	strcat(pDestBuff,pTag);
	ch[0] =			 WRAPPER_CLOSER_END;	strcat(pDestBuff,ch);	
	
	return true;	
}




///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
//                                       API
///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////
///////////////// API funtion prototype for manual test ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////



///////////////////////////
// manual result check API
// ; show statement to user as message box (or with image),
//   allow user to input result manually
//   wait until user input the result.
//
// input
//		imagefileindex : related imagefile index(if it exist)
//					     else -1
//		char* format   : <statement with format %s, %f,> equivalent to printf
//		,...  		   : values equivalent to printf
//      * string size max is 1931 byte
//
// output
//      u8: true/false (when user pressed yes/no button)
//            this represent the result of a manual test
//
// example 
//		ret = AUTO_msg_askresult( -1, "<statement %f  %d>", 0.08, 12 );
//
//      /////////////manual result check//////////////////////////////////////////////////
//		//																			    //
//		//		Check following statement, if your observation is correct press [yes],  //
//		//													     if wrong press [no]    //
//		//																			    //
//		//        <statement  0.08, 12>												    //
//		//																			    //
//		//       					 [ yes ]             [no]						    //
//      //																			    //
//      //////////////////////////////////////////////////////////////////////////////////
//                                  
//      ret = true;//if yes is pressed after observation
//	 or ret = false;//if no is pressed after observation
//
// in short : string size max 2028-94-3 = 1931, printf format is possible, return user input
u8 AUTO_askresult(int imgfileindex, const char *format,...)
{
	char string[50];
	va_list ap;
	
	
	UART_Printf("\n<%s>", TAG_TESTCODE_ASKRESULT);
	UART_Printf("%d-Check following statement, if your observation is correct press [yes], if wrong press [no]\n\n",imgfileindex);
	
	
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);
	
	UART_Printf("</%s>\n",TAG_TESTCODE_ASKRESULT);

	AUTO_GETS(string);//y or n \n  //worst based	
	if( string[0] == 'y') return true;
	else return false;	
}



///////////////////////////
// manual prepare guide API
// ; show statement to user as message box (or with image),
//   allow user to prepare for test manually ( prepare setting, prepare to observe results)
//   wait until user notice the finishing of preparing by pressing ok button
//
// input
//		imagefileindex : related imagefile index(if it exist)
//					     else -1
//		char* format   : <statement with format %s, %f,> equivalent to printf
//		,...  		   : values equivalent to printf
//      * string size max is 1966 byte
//
// example 
//		AUTO_preparing( -1, "<statement %f>", 0.1 );
//
//      /////////////Preparing guide before test///////////////////////////////////
//		//																	//
//		//		Prepare as following statement, after finished press [ok]   //
//		//																	//
//		//      <statement  0.1>											//
//		//																	//
//		//       					 [ ok  ]					  	    	//
//      //																	//
//      //////////////////////////////////////////////////////////////////////
//                                  
//      //go to next source line  if ok is pressed after presetting
//
// in short : string size max 2028-59 -3= 1966, printf format is possible, wait user preparing
void AUTO_preparing(int imgfileindex, const char *format,...)
{
	char string[50];
	va_list ap;
	
	
	UART_Printf("\n<%s>", TAG_TESTCODE_PREPARING);
	UART_Printf("%d-Prepare as following statement, after finished press [ok]\n\n",imgfileindex);
	
	
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);
	
	UART_Printf("</%s>\n",TAG_TESTCODE_PREPARING);

	AUTO_GETS(string);//c \n  //keep continue test else ?...
	//if( string[0] == 'c') ; //check routine skip
}




///////////////////////////////////////////////////////////////////////////////////////////
///////////////// API function prototype for supporting verification ///////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////
// Find valid data out of 3 sampled data
//  
// return median of samples.
// if same data are exist, then return one of them
// 
// Background : because PC stopwatch based on OS tick,
//			   which has 30ms resolution, and every program
//			   operating task based, so some time,
//			   data which over the 30 ms resolution 
//			   in some cases over 1000 ms
//			   error ratio is 50 errors over 100,000 times stopwatch 
int AUTO_findvaliddata(int s1, int s2, int s3)
{
	if(s1 == s2) return s2;
	else if(s1 == s3) return s1;
	else if(s2 == s3) return s2;

	if( s2< s1 && s1 < s3) return s1;//assume s1 is median (s2<s1<s3)
	else if( s3< s1 && s1 < s2) return s1;//assume s1 is median (s3<s1<s2)
	else if( s1 < s2 && s2 < s3) return s2;//assume s2 is median (s1<s2<s3)
	else if( s3 < s2 && s2 < s1) return s2;//assume s2 is median (s3<s2<s1)
	else return s3;//else s3 is median for both case
}


///////////////////////////
// PC Stopwtach start API
// ; start PC startwatch
void AUTO_stopwatchstart()
{
	UART_Printf("\n<%s>%s</%s>\n",
			TAG_TESTCODE_STOPWATCH_START,
			CONTENT_TESTCODE_STOPWATCH_START,
			TAG_TESTCODE_STOPWATCH_START);
}

//////////////////////////////////
// PC Stopwtach finish & get ms API
//  ; finish PC stopwatch ,
//    return laptime(unit : milisecond) since PC stopwatch start
//
// output 
//		int : laptime (ms)
//			  resolution is 30ms (PC stopwatch 15~20ms + UART variation 10ms)
// example
//	    if got 100, it means  laptime is 70~130 ms
//
// Notice 
//		three sampling is needed for secure, 
//      at 100,000 of aging , 50 error(out of resolution) samples
//      were occured
//
// recommanded
//	    s1 = sampling 1,
//		s2 = sampling 2,
//		s3 = sampling 3,
//		i = secure data
//		i = AUTO_sampling( s1, s3, s3);
//
// for verification purpose, use oscilloscope which has less 10us resolution.
int AUTO_stopwatchfinish_ms()
{
	char string[50];
	int num;
	
	UART_Printf("\n<%s>%s</%s>\n",
			TAG_TESTCODE_STOPWATCH_FINISH,
			CONTENT_TESTCODE_STOPWATCH_FINISH,
			TAG_TESTCODE_STOPWATCH_FINISH);
	AUTO_GETS(string);//number\n
	num=atoi(string);
	return num;
}


///////////////////////////
// reset API
// ; notice to DNW autotest, this SMDK IP test will be restarted
//
// DNW Autotest Action after reset
//   when download test image, SMDK will enter to Autotest mode,
//   then send testlists to continue tests 
//
// Guide code for IP test code
// 
// u8 IP_wdt_reset_test()
// {   
//		u32 uRstID = SYSC_RdRSTSTAT(0);//read reset status 0:hw 1:warm, 2:wdt, 3:sleep, 4:esleep, 5:sw
//		u32 uInform7 = Inp32Inform(7);
//		
//		if( uInform7 != 0xA070 ) 
//		{
//			AUTO_noticeWillReset();
//
//			uOutp32Inform(7, 0xA070 );
//			WDT_reset();
//			//will reset
//		}
//		else
//		if(uRstID == 2) 
//		{
//			//if rebooted, then entered again
//			//it's pass
//			uOutp32Inform(7, 0x0 );//clear

//			return true;//ok
//		}
//		else
//			return false;//fail
// }
void AUTO_noticeWillReset()
{
	UART_Printf("\n<%s>%s</%s>\n",
			TAG_TESTCODE_WILLRESET,
			CONTENT_TESTCODE_WILLRESET,
			TAG_TESTCODE_WILLRESET);	
}




//////////////////////////////////////////
// Message with additional information API
// ; Show message to User(Label2)
//   save message to File(Error.log)
//   with additional information(Aging number, current total aging time)
//
// input 
//		const char *format,... : equivalent with printf(const char *format,...);
//      * string size max is 380 byte
// example 
//      AUTO_msginfo_printf("current time : 0x%x:0x%x:0x%x", hour,min,sec);
void AUTO_msginfo_printf(const char *format,...)
{
	va_list ap;
	
	UART_Printf("\n<%s>", TAG_TESTCODE_MESSAGEINFO);
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);	
	UART_Printf("</%s>\n",TAG_TESTCODE_MESSAGEINFO);
}


////////////////////////////////////////////////
// Error Message with additional information API
// ; Show message to User(Label2)
//   save message to File(Error.log)
//   and increase Error count
//   with additional information(Aging number, current total aging time, error count)
//
// input 
//		const char *format,... : equivalent with printf(const char *format,...);
//      * string size max is 380 byte
// example 
//      AUTO_errinfo_printf("%d : sec:0x%x", i, oldsec);
void AUTO_errinfo_printf(const char *format,...)
{
	va_list ap;
	
	UART_Printf("\n<%s>", TAG_TESTCODE_ERRORLOGINFO);
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);	
	UART_Printf("</%s>\n",TAG_TESTCODE_ERRORLOGINFO);
}



///////////////////////////////////////////////////////////////////////////////////////////
//////////////// function for autotest /////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

//send autotest menu number (n) 
//and notice reset status (uRstID)
//  read reset status 0:hw 1:warm, 2:wdt, 3:sleep, 4:esleep, 5:sw
// ex) for reset test, uRstID will be >0 
// to dnw
void AUTO_menunumber(int n)
{
	u32 uRstID = SYSC_RdRSTSTAT(0);
	
	UART_Printf("\n<%s>%d-%d</%s>",
			TAG_TESTCODE_REBOOT_MAIN,
			n,uRstID,
			TAG_TESTCODE_REBOOT_MAIN);
}


//End of File
