/*******************************************************************************
* 
*	Filename:	auto_protocol.h
*  
*	Descriptions
*	- Header file of Protocol of Autotest 
*     (share DNW, SMDK this header file) 
*	History
*	- 2,MAR,2007	Programming start	Dongjin Kim
*	- 26, May, 2007, merge parser, test mode all in to this file
*   - 10 Aug, 2007, add more tags
*   - 22 Aug, 2007, add willreset
*   - 23 Aug, 2007, increase buff size to 2048
*
*	Version 0.0
*	Copyright (c) 2007 SAMSUNG Electronics.  
*  
********************************************************************************/
#ifndef __AUTO_PROTOCOL_H__
#define __AUTO_PROTOCOL_H__

//////////////////////////////////////////////////////////////////////////////
//constant & defines
//////////////////////////////////////////////////////////////////////////////

//protocol version
#define PROTOCOL_VERSION	12013//009-010
						  		 //000-000 : 
							//increase version number
							// first three digit -  critical added or changed
							// second three digit - minor added or changed.
//10- : AUTO_presetting is changed to AUTO_preparing ; prepare setting, prepare to observe results.
//  -011 : AUTO_AUTO_findvaliddata is added, and for using AUTO_stopwatchfinish_ms, Three sampling is recommanded.
//  -012 : AUTO_menunumber() is also return reset status(//0:hw 1:warm, 2:wdt, 3:sleep, 4:esleep, 5:sw)
//         if willreset is requested, but it stop, then reboot board will return hw reset.
//  -013 : AUTO_findvaliddata() is debugged in case of s3<s1<s2 & s3<s2<s1
//11- : umon reboot image auto download is supported.
//12- : umon usb api added smdk timeout, dnw considered smdk timeout

//dnw
#define DNW_MAX_BLOCK_SIZE 			(4096)
#define DNW_COLLECTOR_LENGTH_BUFF	2048//string size without null

//smdk
#define MAX_MSGSTRING_BUFF_SIZE		2029// 2049 - null 1 - wrapper 5 - tag max 7*2 
#define MAX_GLUER_DEST_BUFF_SIZE	2049

//parser , gluer
#define NUM_PARSER_ARRAY	3

//wrapper
#define WRAPPER_OPENER_BEGIN	'<'
#define WRAPPER_OPENER_END		'>'
#define WRAPPER_CLOSER_BEGIN	"</"
#define WRAPPER_CLOSER_END		'>'
#define WRAPPER_KINDS			"<>/"
#define WRAPPER_ALL				"<></>"

#define WRAPPER_TAG_SMDK_BEGIN	"<s"

//////////////////////////////////////////////////////////////////////////////
//tags
//////////////////////////////////////////////////////////////////////////////

#define MAX_TAGSIZE		8//7+1

////////////////////
//tags from DNW
//
#define TAG_DNW_PREFIX			'd'
#define TAG_DNW_LIST_REQUEST	"dlistreq"
#define TAG_DNW_GO				"dgo"

////////////////////
//tags from testcode
//
#define TAG_TESTCODE_PREFIX		's'
//before, after test
#define TAG_TESTCODE_PROTOCOL_VER	"spver" //protocol version
#define TAG_TESTCODE_LIST_INFO	"slist"		//list information
#define TAG_TESTCODE_LIST_END	"slend"		//list information ended
#define TAG_TESTCODE_TEST_START	"sts"		//test is started
#define TAG_TESTCODE_RESULT		"sresult"	//test result
#define TAG_TESTCODE_REBOOT_MAIN	"sr"		//smdk main entered after starting test image
#define TAG_TESTCODE_SMDKREADY	"sd"		//SMDK is ready for autotest mode
#define TAG_TESTCODE_UMON_DN_READY	"su"    //SMDK umon is usb download ready after rebooted.


//during test
//for manual test
#define TAG_TESTCODE_ASKRESULT   			"saskrlt"
#define TAG_TESTCODE_PREPARING   			"sprep"//presetting, prepare to observe


//for helping autotest
#define TAG_TESTCODE_STOPWATCH_START		"stimes"
#define TAG_TESTCODE_STOPWATCH_FINISH		"stimef"
#define TAG_TESTCODE_WILLRESET				"swt"
#define TAG_TESTCODE_USB_UPLOAD_SMDK2PC		"susbup"
#define TAG_TESTCODE_USB_DOWNLOAD_PC2SMDK	"susbdn"



//for debug
#define TAG_TESTCODE_MESSAGEINFO			"smsgt"		//
#define TAG_TESTCODE_ERRORLOGINFO			"selogt"


//////////////////////////////////////////////////////////////////////////////
//content
//////////////////////////////////////////////////////////////////////////////

/////////////////////
//content from DNW
//
//before, after test
#define LIST_SEPERATOR						","//list seperator

/////////////////////
//content from testcode
//
//before, after test
#define CONTENT_TESTCODE_READY				"SMDK ready"//dummy - SMDK is ready for autotest mode

#define LIST_DEPTH_LEVEL					'+'//list information
#define CONTENT_TESTCODE_TYPE_GROUP_NAME	'N'
#define CONTENT_TESTCODE_TYPE_IP_TEST		'T'
#define CONTENT_TESTCODE_TYPE_PREPARE_GUIDE	'P'

#define RESULT_SEPEARTOR	'-'
#define CONTENT_TESTCODE_LIST_END			"end"		//dummy - list information ended
#define CONTENT_TESTCODE_TEST_STARTED		"started"	//dummy - test is started
#define CONTENT_TESTCODE_RESULT_OK			"ok"		//ok,pass - test result
#define CONTENT_TESTCODE_RESULT_FAIL		"fail"		//fail 	  - test result

#define CONTENT_TESTCODE_UMON_DN_READY		"umon usbdownload ready" //dummly

//0:hw 1:warm, 2:wdt, 3:sleep, 4:esleep, 5:sw
#define CONTENT_TESTCODE_REBOOT_MAINMENU_HW_RESET	0
//

//during test
//for helping autotest
#define CONTENT_TESTCODE_STOPWATCH_START 	"stopwatch start"				//dummy - pc stopwatch start
#define CONTENT_TESTCODE_STOPWATCH_FINISH 	"stopwatch finish, get lap(ms)"	//dummy - pc stopwatch finish, get lap
#define CONTENT_TESTCODE_WILLRESET			"will reset"	//dummy - 

#endif //end of __AUTO_PROTOCOL_H__
