
/**************************************************************************************
* 
*	Project Name : S5PV210 validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File name : MM_Manual_test.c
*
*	File Description : This file implements test codes of mDNIe
*
*	Author : Woojin,Kim
*	Dept : AP application
*	Created Date : 2009/07/16
*	Version	: v0.1
*
*	History 
*		- Created(Woojin.Kim 2009/07/16)
*
******************************************************************************/

#include "system.h"
#include "sysc.h"
#include "util.h"
#include "lcd.h"
#include "lcd_module.h"

#include "Mixer.h"
#include "hdmi.h"
#include "sdout.h"
#include "fimc.h"
#include "ipc.h"
#include "intc.h"
#include "glib.h"
#include "option.h"
#include "library.h"
#include "def.h"
#include "gpio.h"
#include "i2c.h"

extern u32 HDMIT_InitIP(void);
extern u32 HDMIT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan);
extern u32 HDMIT_SimplePlayOn(void);
extern u32 HDMIT_SimplePlayOff(void);
extern void SDVPT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan,TV_STANDARDS eTvStand,
						SDOUT_VIDEO_SIGNAL eVideoSignal);


const static u32 uLcdFbAddr = CODEC_MEM_ST;
//static u32 eFimc;
void __irq Isr_LcdUnderRun (void)
{
	u32 uIntFlag;

	LCDC_GetIntFlag(&uIntFlag);
	
	Disp("[FIFO UnderRun]\n");

	LCDC_ClearPending(uIntFlag);
	
	INTC_ClearVectAddr();	

}

#if 0
static u8 volatile bFimcDoneA;
static void __irq Isr_FimcA(void)
{
	FIMC_INTR_SRC eSrc;
	FIMC_GetIntrSrc(FIMC_A, &eSrc);
//	Disp("[i]");
	switch(eSrc)
	{
		case FIMC_SUCCESS:
			bFimcDone = true;
			break;
		case FIFO_Y_OVF:
			bFimcDone = false;
			Disp("\n FIFO Y overflow \n");
			break;
		case FIFO_CB_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cb overflow \n");
			break;
		case FIFO_CR_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cr overflow \n");
			break;
		case ROT_LINE_BUF_OVF:
			bFimcDone = false;
			Disp("\n Rotation line buffer overflow \n");
			break;
		default:
			bFimcDone = false;
			Assert(0);
			break;		
	}

	FIMC_ClearInterrupt(FIMC_A);
	INTC_ClearVectAddr();
}

static u8 volatile bFimcDoneB;
static void __irq Isr_FimcB(void)
{
	FIMC_INTR_SRC eSrc;
	FIMC_GetIntrSrc(FIMC_B, &eSrc);
//	Disp("[i]");
	switch(eSrc)
	{
		case FIMC_SUCCESS:
			bFimcDone = true;
			break;
		case FIFO_Y_OVF:
			bFimcDone = false;
			Disp("\n FIFO Y overflow \n");
			break;
		case FIFO_CB_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cb overflow \n");
			break;
		case FIFO_CR_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cr overflow \n");
			break;
		case ROT_LINE_BUF_OVF:
			bFimcDone = false;
			Disp("\n Rotation line buffer overflow \n");
			break;
		default:
			bFimcDone = false;
			Assert(0);
			break;		
	}

	FIMC_ClearInterrupt(FIMC_B);
	INTC_ClearVectAddr();
}

static u8 volatile bFimcDoneC;
static void __irq Isr_FimcC(void)
{
	FIMC_INTR_SRC eSrc;
	FIMC_GetIntrSrc(FIMC_C, &eSrc);
//	Disp("[i]");
	switch(eSrc)
	{
		case FIMC_SUCCESS:
			bFimcDone = true;
			break;
		case FIFO_Y_OVF:
			bFimcDone = false;
			Disp("\n FIFO Y overflow \n");
			break;
		case FIFO_CB_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cb overflow \n");
			break;
		case FIFO_CR_OVF:
			bFimcDone = false;
			Disp("\n FIFO Cr overflow \n");
			break;
		case ROT_LINE_BUF_OVF:
			bFimcDone = false;
			Disp("\n Rotation line buffer overflow \n");
			break;
		default:
			bFimcDone = false;
			Assert(0);
			break;		
	}

	FIMC_ClearInterrupt(FIMC_C);
	INTC_ClearVectAddr();
}
#endif
//////////////////////////////////FIMC///////////////////////////////////////

#if 0
// [Select FIMC A]
static void SelFimcA(void)
{
	eFimc = FIMC_A;
	FIMC_SetChA();
	Disp("\n FIMC_A selected! \n");
}

// [Select FIMC B]
static void SelFimcB(void)
{
	eFimc = FIMC_B;
	FIMC_SetChB();	
	Disp("\n FIMC_B selected! \n");
}

// [Select FIMC C]
static void SelFimcC(void)
{
	eFimc = FIMC_C;
	FIMC_SetChC();	
	Disp("\n FIMC_C selected! \n");
}
#endif

////////////////////////////////////////////////////////////////////////////////////



/*
//////////////////////////////////VP - HDMI path////////////////////////////////////
u32 HDMIT_InitIP(void)
{
	u32 hpd;
	
	SYSC_SetDivHDMI(0x96);
	SYSC_EnHDMIPHY();
	
	HDMI_Init();

	if (HPD_Init() != OK)
	{
		UART_Printf("fail to init HPD\n");
		return;
	}

	I2CHDMI_Init();
    
	if (EDDC_Init() != OK)
	{
		UART_Printf("fail to init EDDC\n");
		return;
	}

	if (HDCP_Init() != OK)
	{
		UART_Printf("fail to init HDMI\n");
		return;
	}
	    
	UART_Printf("waiting for HPD...\n");
	while(!UART_GetKey())
	{
		hpd = HPD_Detect();
		if(hpd == HDMI_HPD_CABLE_IN)
		{
			UART_Printf("HDMI_HPD_CABLE_IN\n");
			break;
		}
	}

	return TRUE;
}


// for Manual Test
u32 HDMIT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan)
{
	u32 uResolution, uScanMode, uHdmiMode, uColorFormat, uBitPerColor, uWideColor;
	u32 uWin0StAddr, uWin1StAddr;
	HDMIMode eHDMI_DVI;
	VideoFormat eVideoFmt;
	ColorDepth eColorDepth;
	PixelAspectRatio ePixelRatio;
	ColorSpace eColorSpace;
	PixelLimit ePixelLimit;
	MX_RGB_FORMAT eMxOutRgb;
	
	eHDMI_DVI =HDMI;	
	eImgSz = eOutImgRes;
	eScanMode = eOutScan;
	
	eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? v1920x1080p_60Hz : v1920x1080i_60Hz) :
				(eImgSz == HD720)? 	v1280x720p_60Hz:
				(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
									((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
									
	ePixelRatio = 	(eImgSz == HD1080)? HDMI_PIXEL_RATIO_16_9:
				(eImgSz == HD720)? 	HDMI_PIXEL_RATIO_16_9:
				(eImgSz == SD480)?	HDMI_PIXEL_RATIO_4_3: HDMI_PIXEL_RATIO_4_3;

	eColorSpace =  HDMI_CS_YCBCR444;
	eColorDepth = HDMI_CD_24;
	eMxOutRgb = 	RGB709_16_235;	
	ePixelLimit = HDMI_RGB_LIMIT_RANGE;
					
	uWin0StAddr = CODEC_MEM_ST + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	// for Graphic Layer Image
	HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);

	HDMIT_InitIP();
		
	// VP setting
	HDVPT_InitParaForTV(NV12);
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uSrcHSize;
	oVP_SrcInf.uImgVsz = uSrcVSize;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	HDMIT_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eColorSpace, eMxOutRgb);
	
	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(eColorSpace);
	HDMI_SetPixelLimit(ePixelLimit); 	
	HDMI_SetVideoMode(eVideoFmt, eColorDepth, ePixelRatio);
	
	return TRUE;
}


// for Manual Test
u32 HDMIT_SimplePlayOn(void)
{
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
}

u32 HDMIT_SimplePlayOff(void)
{
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
}

////////////////////////////////////////////////////////////////////////////////


*/


void LCD_Blending_ManualTest(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 j;


	Disp("Enter Any Key To Test Per Plane Blending\n");
	UART_Getc();

	INTC_Init();
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdUnderRun);
	INTC_Enable(NUM_LCD0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);	
	LCDC_GetFrmSz(&uHSz,&uVSz, WIN0);

	LCDC_EnableAllWinFifoLvlInt(EMPTY);

	LCDC_Start();

	
	// Draw Pattern by using Glib for window 0
	Disp("Window %d(Background) is Displayed\n", (int)WIN0);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Trigger();

	Disp("Enter Any Key To Display Window %d\n", (int)WIN1);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN0);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN1, false); 	
	LCDC_SetWinOnOff(1, WIN1);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN1);

	// Draw Rectangles by using Glib for window 1
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN1);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN1);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN2, false); 	
	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN2);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(1, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN3);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(1, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 60, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);


}


// [Test FIFO-in DMA-out for basic function]
static void TestFinDoutForBasicFunc(void)
{
	u32 uFinImgHsz, uFinImgVsz;
	u32 uFrmCnt;

	//SelFimcA();

	//Assert(eFimc == FIMC_A);	

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24, 480, 480, 0, 0, 480, 480,	0, 0, uLcdFbAddr, WIN0, false);
	LCDC_Start();


	memset((void *)uLcdFbAddr, 0, 480*480*4);

	FIMC_InitCamera(S5K3BAF, YCRYCB, UXGA); // UXGA:1600x1200
	FIMC_GetFinImgSize(&uFinImgHsz, &uFinImgVsz);
	
	FIMC_InitIpForFinDout(FIMC_A, ITU_CAMERA_A,
		0, 0, uFinImgHsz, uFinImgVsz,
		480, 480,
		0, 0, 480, 480, 0,
		uLcdFbAddr, uLcdFbAddr, RGB24,
		ROT_90_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
}


// [Test DMA-in FIFO-out for interlace out with IPC]
static void TestDinFoutForInterlaceOutWithIpc(void)
{
	u32 i;
	u32 uGlibAddr;

	//SelFimcB();

	//Assert(eFimc == FIMC_B);

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();


#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 320, 0);
#elif (LCD_MODEL == LCD_TL2796)	
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 0, 320);
#endif
	LCDC_SetWinOnOff(1, WIN1);			
	
	LCDC_EnableAllWinFifoLvlInt(EMPTY);
	LCDC_Start();

	// Initialize IPC v1.0
	IPC_InitIp(480, 480/2, IPC_2D);
	IPC_On();

	uGlibAddr = uLcdFbAddr + (480 * 480 * 4);
	// Generate DMA input image
	GLIB_InitInstance(uGlibAddr, 480, 480, RGB24);
	GLIB_DrawPattern(480, 480);

	FIMC_InitIpForDinFout(FIMC_B,
		480, 480, 0,
		0, 0, 480, 480,
		uGlibAddr, RGB24, false,		
		480, 480, // Fifo out display size
		LOCAL_IF_YCBCR444, INTERLACED,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);
}



// [Test DIRECT-FIFO-in DMA-out for basic function]
static void TestDFinDoutForBasicFunc(void)
{
	IMG_FMT eImgFmt[2] = {NV12, TILE_NV12};

	u32 i;
	u32 uDispHSz, uDispVSz;
	u32 uLcdHsz,uLcdVsz;
	u32 uFrmCnt;
	u32 uDispOutFrAddr;

	//SelFimcC();

	//Assert(eFimc == FIMC_C);

	// Initialize LCDC v6.0
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);	
	LCDC_GetLcdSz(&uLcdHsz, &uLcdVsz);
	LCDC_SetOutputPath(LCD_TVRGB);

	Disp("\n Drawing sample image! wait for a moment! \n");
	// Generate DMA input image
	GLIB_InitInstance(uLcdFbAddr, uLcdHsz, uLcdVsz, RGB24);
	GLIB_DrawPattern(uLcdHsz, uLcdVsz);


	LCDC_Start();

	uDispOutFrAddr = uLcdFbAddr + (800*480*4*2);

	memset((void *)uDispOutFrAddr, 0, 800*480*4);

	FIMC_InitIpForDFinDout(FIMC_C, 
		480, 800,
		//0, 0, uLcdHsz, uLcdVsz,
		800, 480,
		0, 0, 480, 800, 0,
		uDispOutFrAddr, uDispOutFrAddr, NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
		ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW);

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);	
}



void Test_FIMC_FIMD_Blending(void)

{
	u32 uFinImgHsz, uFinImgVsz;
	u32 uFrmCnt;
	u32 i;
	u32 uGlibAddr;
	u32 uWin2FbAddr,uWin3FbAddr,uWin4FbAddr;
	u32 uHSz,uVSz;
	u32 uDispOutFrAddr;
	
//	Assert(eFimc == FIMC_A);	
//////////////////  FIMC 0 with Camera path ////////////////////
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24, 480, 480, 0, 0, 480, 480,	0, 0, uLcdFbAddr, WIN0, false);


#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 320, 0);
#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 0, 320);
#endif
	LCDC_SetWinOnOff(1, WIN1);			

	LCDC_Start();


	memset((void *)uLcdFbAddr, 0, 480*480*4);

	//SelFimcA();


	FIMC_InitCamera(S5K3BAF, YCRYCB, UXGA); // UXGA:1600x1200
	FIMC_GetFinImgSize(&uFinImgHsz, &uFinImgVsz);
	
	FIMC_InitIpForFinDout(FIMC_A, ITU_CAMERA_A,
		0, 0, uFinImgHsz, uFinImgVsz,
		480, 480,
		0, 0, 480, 480, 0,
		uLcdFbAddr, uLcdFbAddr, RGB24,
		ROT_90_FLIP_NO, CSC_ITU601, YCBCR_WIDE);


//////////////////  FIMC 1 with IPC path //////////////////////
	// Initialize IPC v1.0

	//SelFimcB();

	IPC_InitIp(480, 480/2, IPC_2D);
	IPC_On();

	uGlibAddr = uLcdFbAddr + (480 * 480 * 4);
	// Generate DMA input image
	GLIB_InitInstance(uGlibAddr, 480, 480, RGB24);
	GLIB_DrawPattern(480, 480);



	FIMC_InitIpForDinFout(FIMC_B,
		480, 480, 0,
		0, 0, 480, 480,
		uGlibAddr, RGB24, false,		
		480, 480, // Fifo out display size
		LOCAL_IF_YCBCR444, INTERLACED,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);



/////////////////  WIN0~4 Blending ///////////////////////////

	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

	uWin2FbAddr = uGlibAddr + (480 * 480 * 4);

#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 240, 240, 0, 0, 240, 240,	440, 120, uWin2FbAddr, WIN2, false); 	
#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWin(RGB24, 240, 240, 0, 0, 240, 240,	120, 440, uWin2FbAddr, WIN2, false); 	
#endif

	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uWin2FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();

	LCDC_GetFbEndAddr(&uWin3FbAddr, WIN2);

#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 120, 120, 0, 0, 120, 120,	500, 180, uWin3FbAddr, WIN3, false); 	
#elif (LCD_MODEL == LCD_TL2796)	
	LCDC_InitWin(RGB24, 120, 120, 0, 0, 120, 120,	180, 500, uWin3FbAddr, WIN3, false); 	
#endif

	LCDC_SetWinOnOff(1, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uWin3FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();

	LCDC_GetFbEndAddr(&uWin4FbAddr, WIN3);
#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 60, 60, 0, 0, 60, 60,	530, 210, uWin4FbAddr, WIN4, false); 	
#elif (LCD_MODEL == LCD_TL2796)		
	LCDC_InitWin(RGB24, 60, 60, 0, 0, 60, 60,	210, 530, uWin4FbAddr, WIN4, false); 	
#endif

	LCDC_SetWinOnOff(1, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uWin4FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 60, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);


///////////////// WriteBack path ///////////////////////////
	//SelFimcC();

	LCDC_GetFbEndAddr(&uDispOutFrAddr, WIN4);

	memset((void *)uDispOutFrAddr, 0, 800*480*4);

#if (LCD_MODEL == LCD_LTE480WV_RGB)
	FIMC_InitIpForDFinDout(FIMC_C,
		800, 480,
		//0, 0, uLcdHsz, uLcdVsz,
		800, 480,
		0, 0, 800, 480, 0,
		uDispOutFrAddr, uDispOutFrAddr, NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
		ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW);

#elif (LCD_MODEL == LCD_TL2796)		
	FIMC_InitIpForDFinDout(FIMC_C,
		480, 800,
		//0, 0, uLcdHsz, uLcdVsz,
		800, 480,
		0, 0, 480, 800, 0,
		uDispOutFrAddr, uDispOutFrAddr, NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
		ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW);
#endif

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);

}



void LCD_HDMI_PerformanceTest(void)
{
	u32 uFgAddr;
	u32 uHSz, uVSz;
	u32 j;
	u32 uDispOutFrAddr;
	u32 uDispOutFrAddrTmp;


	Disp("Enter Any Key To Test Per Plane Blending\n");
	UART_Getc();

	INTC_Init();
	INTC_SetVectAddr(NUM_LCD0, Isr_LcdUnderRun);
	INTC_Enable(NUM_LCD0);

	LCDC_InitLdi(MAIN);
	LCDC_InitIp(RGB24, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);	
	LCDC_GetFrmSz(&uHSz,&uVSz, WIN0);

	LCDC_EnableAllWinFifoLvlInt(EMPTY);

	LCDC_SetOutputPath(LCD_TVRGB);

	LCDC_Start();

	
	// Draw Pattern by using Glib for window 0
	Disp("Window %d(Background) is Displayed\n", (int)WIN0);
	Disp("\n");
	GLIB_InitInstance(uLcdFbAddr, uHSz, uVSz, RGB24);
	GLIB_DrawPattern(uHSz, uVSz);
	LCDC_Trigger();

	Disp("Enter Any Key To Display Window %d\n", (int)WIN1);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN0);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN1, false); 	
	LCDC_SetWinOnOff(1, WIN1);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN1);

	// Draw Rectangles by using Glib for window 1
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_MAGENTA);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN1);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN1);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN2, false); 	
	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN2);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN3, false); 	
	LCDC_SetWinOnOff(1, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();

	LCDC_GetFbEndAddr(&uFgAddr, WIN3);
	LCDC_InitWin(RGB24, uHSz, uVSz, 0, 0, uHSz, uVSz,	0, 0, uFgAddr, WIN4, false); 	
	LCDC_SetWinOnOff(1, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uFgAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);
	LCDC_Trigger();

	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 60, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);


		LCDC_GetFbEndAddr(&uDispOutFrAddr, WIN4);



///////////////// WriteBack path ///////////////////////////
		//SelFimcC();

//		LCDC_GetFbEndAddr(&uDispOutFrAddr, WIN4);

//		memset((void *)uDispOutFrAddr, 0, 800*480*4);



#if 1
		FIMC_InitIpForDFinDout(FIMC_C,
			480, 800,
			//0, 0, uLcdHsz, uLcdVsz,
			800, 480,
			0, 0, 480, 800, 0,
			uLcdFbAddr,uLcdFbAddr,NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
			ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW);

#else

	 	FIMC_InitIpForDinDout(
		480, 800, 0,
		0,0,480,800,		
		uLcdFbAddr, RGB24,
		800, 480,
		0, 0, 480, 800,0,
		uDispOutFrAddr, NV12,
		ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW,0);

#endif


/////////////////// VP MIXER HDTV SDTV //////////////////////

	HDMIT_InitSimplePlay(uDispOutFrAddr, 800, 480,  
						HD1080, PROGRESSIVE);

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);

	HDMIT_SimplePlayOn();


	UART_Getc();


#if 0	
	while(!UART_GetKey())
		{

	 	FIMC_InitIpForDinDout(
		480, 800, 0,
		0,0,480,800,		
		uLcdFbAddr, RGB24,
		800, 480,
		0, 0, 480, 800,0,
		uDispOutFrAddr, NV12,
		ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW,0);

		}
	
#endif



	UART_Getc();

	//Set VPLL to 54MHz
//	SYSC_StartPLLbyFout(eVPLL, 54000000);
	Outp32(0xE0100120, 0x806c0603);
	
	// DAC_SEL : SCLKVPLL
	SYSC_InitClkForMM();
	// MIXER_SEL : 
	SYSC_SetClkMuxState(eCLKMUX_MIXER_SDAC);
	SYSC_EnDAC();

	HDMIT_SimplePlayOff();


	SDVPT_InitSimplePlay(uDispOutFrAddr, 800, 480,  
						SD480, INTERLACED,NTSC_M,
						SDOUT_COMPOSITE_SIG);






}



void Test_Sorting_Manual_MM(void)

{
	u32 uFinImgHsz, uFinImgVsz;
	u32 uFrmCnt;
	u32 i;
	u32 uGlibAddr;
	u32 uWin2FbAddr,uWin3FbAddr,uWin4FbAddr;
	u32 uHSz,uVSz;
	u32 uDispOutFrAddr;
	
//	Assert(eFimc == FIMC_A);	
//////////////////  FIMC 0 with Camera path ////////////////////
	LCDC_InitLdi(MAIN);
	LCDC_InitBase();
	LCDC_InitWin(RGB24, 480, 480, 0, 0, 480, 480,	0, 0, uLcdFbAddr, WIN0, false);

#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 320, 0);
#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 0, 320);
#endif
	LCDC_SetWinOnOff(1, WIN1);			

	LCDC_EnableAllWinFifoLvlInt(EMPTY);

//	LCDC_Start();


	memset((void *)uLcdFbAddr, 0, 480*480*4);

	//SelFimcA();


	FIMC_InitCamera(S5K3BAF, YCRYCB, UXGA); // UXGA:1600x1200
	FIMC_GetFinImgSize(&uFinImgHsz, &uFinImgVsz);

	FIMC_InitIpForFinDout(FIMC_A, ITU_CAMERA_A,
		0, 0, uFinImgHsz, uFinImgVsz,
		480, 480,
		0, 0, 480, 480, 0,
		uLcdFbAddr, uLcdFbAddr, RGB24,
		ROT_90_FLIP_NO, CSC_ITU601, YCBCR_WIDE);


	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);

//////////////////  FIMC 1 with IPC path //////////////////////
	// Initialize IPC v1.0

	//SelFimcB();

	IPC_InitIp(480, 480/2, IPC_2D);
	IPC_On();

	uGlibAddr = uLcdFbAddr + (480 * 480 * 4);
	// Generate DMA input image
	GLIB_InitInstance(uGlibAddr, 480, 480, RGB24);
	GLIB_DrawPattern(480, 480);



	FIMC_InitIpForDinFout(FIMC_B,
		480, 480, 0,
		0, 0, 480, 480,
		uGlibAddr, RGB24, false,		
		480, 480, // Fifo out display size
		LOCAL_IF_YCBCR444, INTERLACED,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);

	LCDC_SetOutputPath(LCD_TVRGB);
	LCDC_Start();


/////////////////  WIN0~4 Blending ///////////////////////////

#ifdef DBG_MM_Path

	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

#endif
	uWin2FbAddr = uGlibAddr + (480 * 480 * 4);



#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 240, 240, 0, 0, 240, 240,	440, 120, uWin2FbAddr, WIN2, false); 	

#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWin(RGB24, 240, 240, 0, 0, 240, 240,	120, 440, uWin2FbAddr, WIN2, false); 	

#endif

	LCDC_SetWinOnOff(1, WIN2);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN2);

	// Draw Rectangles by using Glib for window 2
	GLIB_InitInstance(uWin2FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_CYAN);
	LCDC_Trigger();


#ifdef DBG_MM_Path
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN2);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN3);
	UART_Getc();
#endif

	LCDC_GetFbEndAddr(&uWin3FbAddr, WIN2);

#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 120, 120, 0, 0, 120, 120,	500, 180, uWin3FbAddr, WIN3, false); 	
#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWin(RGB24, 120, 120, 0, 0, 120, 120,	180, 500, uWin3FbAddr, WIN3, false); 	
#endif
	LCDC_SetWinOnOff(1, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uWin3FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);

#ifdef DBG_MM_Path
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();
#endif

	LCDC_GetFbEndAddr(&uWin4FbAddr, WIN3);
#if (LCD_MODEL == LCD_LTE480WV_RGB)
	LCDC_InitWin(RGB24, 60, 60, 0, 0, 60, 60,	530, 210, uWin4FbAddr, WIN4, false); 	
#elif (LCD_MODEL == LCD_TL2796)
	LCDC_InitWin(RGB24, 60, 60, 0, 0, 60, 60,	210, 530, uWin4FbAddr, WIN4, false); 	
#endif
	LCDC_SetWinOnOff(1, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uWin4FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);


#ifdef DBG_MM_Path
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();
#endif

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 60, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);


///////////////// WriteBack path ///////////////////////////
		//SelFimcC();

		LCDC_GetFbEndAddr(&uDispOutFrAddr, WIN4);

		memset((void *)uDispOutFrAddr, 0, 800*480*4);


#if (LCD_MODEL == LCD_LTE480WV_RGB)
		FIMC_InitIpForDFinDout(FIMC_C,
			800, 480,
			//0, 0, uLcdHsz, uLcdVsz,
			800, 480,
			0, 0, 800, 480, 0,
			uDispOutFrAddr, uDispOutFrAddr, NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
			ROT_NO_FLIP_NO, CSC_ITU709, YCBCR_NARROW);


#elif (LCD_MODEL == LCD_TL2796)
		FIMC_InitIpForDFinDout(FIMC_C,
			480, 800,
			//0, 0, uLcdHsz, uLcdVsz,
			800, 480,
			0, 0, 480, 800, 0,
			uDispOutFrAddr, uDispOutFrAddr, NV12,
//			uInFbAddr, uInFbAddr, TILE_NV12,
			ROT_90_FLIP_XY, CSC_ITU709, YCBCR_NARROW);
#endif


/////////////////// VP MIXER HDTV SDTV //////////////////////

	HDMIT_InitSimplePlay(uDispOutFrAddr, 800, 480,  
						HD1080, PROGRESSIVE);

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);

	HDMIT_SimplePlayOn();

	UART_Getc();

	//Set VPLL to 54MHz
//	SYSC_StartPLLbyFout(eVPLL, 54000000);
	Outp32(0xE0100120, 0x806c0603);
	
	// DAC_SEL : SCLKVPLL
	SYSC_InitClkForMM();
	// MIXER_SEL : 
	SYSC_SetClkMuxState(eCLKMUX_MIXER_SDAC);
	SYSC_EnDAC();

	HDMIT_SimplePlayOff();

	SDVPT_InitSimplePlay(uDispOutFrAddr, 800, 480,  
						SD480, INTERLACED,NTSC_M,
						SDOUT_COMPOSITE_SIG);


}


void Test_Sorting_Manual_Lite_MM(void)

{
	u32 uFinImgHsz, uFinImgVsz;
	u32 uFrmCnt;
	u32 i;
	u32 uGlibAddr,uGlibAddr2;
	u32 uWin2FbAddr,uWin3FbAddr,uWin4FbAddr;
	u32 uHSz,uVSz;
	u32 uDispOutFrAddr;
	

	LCDC_InitLdi(MAIN);
	LCDC_InitBase();

	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN0, 480, 480, 0, 0);
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN1, 480, 480, 0, 320);
	LCDC_InitWinForFifoIn4(LOCAL_IF_YCBCR444, WIN2, 400, 400, 40, 200);	
	

	LCDC_EnableAllWinFifoLvlInt(EMPTY);

//	LCDC_Start();

//////////////////  FIMC 0 with D in F out ////////////////////
	memset((void *)uLcdFbAddr, 0, 480*480*4);

	// Generate DMA input image
	GLIB_InitInstance(uLcdFbAddr, 480, 480, RGB24);
	GLIB_DrawPattern(480, 480);

	//SelFimcA();

	FIMC_InitIpForDinFout(FIMC_A,
		480, 480, 0,
		0, 0, 480, 480,
		uLcdFbAddr, RGB24, false,		
		480, 480, // Fifo out display size
		LOCAL_IF_YCBCR444, PROGRESSIVE,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);



//////////////////  FIMC 1 with IPC path //////////////////////
	// Initialize IPC v1.0

	//SelFimcB();

	IPC_InitIp(480, 480/2, IPC_2D);
	IPC_On();

	uGlibAddr = uLcdFbAddr + (480 * 480 * 4);
	// Generate DMA input image
	GLIB_InitInstance(uGlibAddr, 480, 480, RGB24);
	GLIB_DrawPattern2(480, 480);



	FIMC_InitIpForDinFout(FIMC_B, 
		480, 480, 0,
		0, 0, 480, 480,
		uGlibAddr, RGB24, false,		
		480, 480, // Fifo out display size
		LOCAL_IF_YCBCR444, INTERLACED,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_B, false, 0, 0, false, 0);

//////////////////  FIMC 2 with D in F out ////////////////////


	//SelFimcC();

	uGlibAddr2 = uGlibAddr + (480 * 480 * 4);
	// Generate DMA input image
	GLIB_InitInstance(uGlibAddr2, 400, 400, RGB24);
	GLIB_ClearFrame(C_BLUE);

	FIMC_InitIpForDinFout(FIMC_C,
		400, 400, 0,
		0, 0, 400, 400,
		uGlibAddr2, RGB24, false,		
		400, 400, // Fifo out display size
		LOCAL_IF_YCBCR444, PROGRESSIVE,
		ROT_NO_FLIP_NO, CSC_ITU601, YCBCR_WIDE);

	FIMC_StartProcessing(FIMC_C, false, 0, 0, false, 0);

	LCDC_Start();


#ifdef DBG_MM_Path

	Disp("Enter Any Key To Display Window %d\n", (int)WIN2);
	UART_Getc();

#endif
	uWin3FbAddr = uGlibAddr2 + (400 * 400 * 4);

	LCDC_InitWin(RGB24, 200, 200, 0, 0, 200, 200,	140, 300, uWin3FbAddr, WIN3, false); 	
	LCDC_SetWinOnOff(1, WIN3);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN3);

	// Draw Rectangles by using Glib for window 3
	GLIB_InitInstance(uWin3FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_YELLOW);

#ifdef DBG_MM_Path
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN3);
	Disp("\n");


	Disp("Enter Any Key To Display Window %d\n", (int)WIN4);
	UART_Getc();
#endif

	LCDC_GetFbEndAddr(&uWin4FbAddr, WIN3);
	LCDC_InitWin(RGB24, 100, 100, 0, 0, 100, 100,	190, 350, uWin4FbAddr, WIN4, false); 	
	LCDC_SetWinOnOff(1, WIN4);	
	LCDC_GetFrmSz(&uHSz, &uVSz, WIN4);

	// Draw Rectangles by using Glib for window 4
	GLIB_InitInstance(uWin4FbAddr, uHSz, uVSz, RGB24);
	GLIB_ClearFrame(C_RED);


#ifdef DBG_MM_Path
	Disp("Window %d(ForeGround) is Displayed\n", (int)WIN4);
	Disp("\n");




	Disp("Enter Any Key To Test Per Plane Blending(Using ALPHA 0 VALUE)\n");
	Disp("\n");
	UART_Getc();
#endif
/////////////////  WIN0~4 Blending ///////////////////////////

	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN1);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN2);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN3);
	LCDC_SetBlendingType(PER_PLANE, ALPHA0_PLANE, WIN4);	
	LCDC_SetAlphaClear(ALLWIN);
	LCDC_SetAlpha(	60, 60, 60, 0x0, 0x0, 0x0, WIN1);
	LCDC_SetAlpha(	80, 80, 80, 0x0, 0x0, 0x0, WIN2);
	LCDC_SetAlpha(	120, 120, 120, 0x0, 0x0, 0x0, WIN3);
	LCDC_SetAlpha(	160, 160, 160, 0x0, 0x0, 0x0, WIN4);



}


void MM_path_ManualTest(void)
{
	int i, nSel;

	const testFuncMenu menu[]=
	{
		0,                             			    "Exit\n",
		LCD_Blending_ManualTest,				 "LCD Blending test",
		TestFinDoutForBasicFunc,				 "Camera in",
		TestDinFoutForInterlaceOutWithIpc,	 "IPC",
		TestDFinDoutForBasicFunc,			"Write Back",	
		LCD_HDMI_PerformanceTest,			"LCD 5 WVGA blending with HDMI",
		Test_Sorting_Manual_MM,				"MM Sorting Manual path test (full)",
		Test_Sorting_Manual_Lite_MM,			"MM Sorting Manual path test (Lite)",
		0,							       0
	};

	SYSC_InitClkForMM();

#ifdef LDI_INIT_GPIO
	GPIO_Init();
#endif

	InitBaseHwForI2C();
	InitBaseHwForFIMC();
	//InitBaseHwForCSIS();
/*
#ifndef FIMC_POLLING	
	INTC_Init(); // Initialize interrupt controller
	INTC_SetVectAddr(NUM_FIMC_A, Isr_Fimc);
	INTC_SetVectAddr(NUM_FIMC_B, Isr_Fimc);
	INTC_SetVectAddr(NUM_FIMC_C, Isr_Fimc);
	INTC_Enable(NUM_FIMC_A);
	INTC_Enable(NUM_FIMC_B);
	INTC_Enable(NUM_FIMC_C);
	
	//INTC_SetVectAddr(NUM_LCD0, Isr_Fimd);
	//INTC_Enable(NUM_LCD0);
#endif
*/
	
	SYSC_SetDispPath(eDISP_BYPASS);
	
	while (1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
		{
			Disp("%2d: %s\n", i, menu[i].desc);
		}

		Disp("================================================================\n");

	

		Disp("\nSelect the function to test : ");
		nSel = UART_GetIntNum();
		Disp("\n");

//		nSel = 5;

		if (nSel == 0)
		{
			break;
		}
		if (nSel>0 && nSel<(sizeof(menu)/8-1))
		{
			 (menu[nSel].func)();
		}

	}
}

