/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : v210_main.c
*  
*	File Description : This file implements the test main functon.
*
*	Author : Gom
*	Dept. : AP Development Team
*	Created Date : 2009/02/03
*	Version : 0.0 
* 
*	History
*	- Created(Gom 2009/02/03)
*  
**************************************************************************************/

#include <stdio.h>

#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "gpio.h"
#include "intc.h"

#include "autotest_api.h"

extern void TIMER_Test(void);
extern void RTC_Test(void);
extern void SYSCT_Test(void);
extern void SYSCT_CheckAgingWakeupReset(void);

extern void Test_OND(void);
extern void INTC_Test(void);
extern void Test_FIMC(void);
extern void LCD_Test(void);
extern void JPEG_Test(void);
extern void Test_MFC(void);
extern void Test_ROTATOR(void);
extern void SBLOCK_Test(void);
extern void HDMI_Test(void);
extern void VPMixer_Test(void);
extern void DMC_Test(void);
extern void Test_DMAC(void);
extern void TestNFC(void);
extern void SMC_Test(void);

//Connectivity Test
extern void ADCTS_Test(void);
extern void AC97_Test(void);
extern void ATA_Test(void);
extern void Test_MIPICSI(void);
extern void Test_MIPIDSI(void);
extern void Test_HDMI_AUDIO(void);
extern void IIC_Test(void);
extern void KEYPAD_Test(void);
extern void MODEM_Test(void);
extern void Test_PCM(void);
extern void I2S0v5_1_Test(void);
extern void RPDecode_Test(void);
extern void AudioSS_Test();
extern void I2S1_Test(void);
extern void I2S2_Test(void);
extern void SDHC_Test(void);
extern void Test_SPDIF(void);
extern void SPI_Test(void);
extern void Test_TSI(void);
extern void Test_UART(void);
extern int Test3D(void);
extern void Test_PMIC(void);
extern void Test_OTGDEV(void);
extern void Test_USBHOST(void);
extern void Test_SDOUT(void);

//Performance for Arm
extern void Dhry_1(void);
//PMIC[max8698c] Initial Power Setting
extern void Test_PMIC(void);
extern void PMIC_InitSetting(void);
extern void BOOTCODEWRITE(void);
extern void MM_path_ManualTest(void);


const testFuncMenu menu[] =
{
//  1234567890123456789012345
#if 0
	Test_PCM,				"PCM Test                 ",
	I2S_Test,				"I2S test                 ",
#endif
	TIMER_Test,				"PWM Timer                ",
	RTC_Test,				"RTC Test                 ",
	SYSCT_Test,				"System Controller        ",
	TestNFC,				"Nand                     ",
	SYSCT_Test,				"System Controller        ",
	SMC_Test,				"SROMC Test",
	Test_OND,				"Audi OneNand             ",	
	DMC_Test,				"DRAM Controller Test     ",
	Test_DMAC,				"DMA Test                 ",
	Test_FIMC,				"FIMC Test                ",
	LCD_Test,				"FIMD Test                ",
	JPEG_Test,				"JPEG Test                ",
	Test_MFC,				"MFC(DEC) Test            ",
	SBLOCK_Test,			"Crypto Engine Test       ",
	VPMixer_Test,			"VP/Mixer Test(for HDTV)  ",
	Test3D,					"3D Test                  ",
	
//Connectivity test
	AC97_Test,				"AC97_Test                ",	
	ADCTS_Test,				"ADCTS Test               ",
	ATA_Test,				"CFCON-ATA Test           ",	
	Test_MIPICSI,			"MIPI CSI Test            ",	
	Test_MIPIDSI,			"MIPI DSI Test            ",	
	Test_HDMI_AUDIO,		"HDMI Audio Test          ",
	IIC_Test,				"IIC_Test                 ",		
	KEYPAD_Test,			"KEYPAD Test              ",
	MODEM_Test,				"Modem Test               ",
	Test_PCM,				"PCM_Test                 ",
	I2S0v5_1_Test,			"I2S0 v5_1 Test           ",
	AudioSS_Test,			"Audio Sub system Test    ",
	RPDecode_Test, 			"RP Decode Test           ",
	I2S1_Test,				"I2S1 Test                ",	
	I2S2_Test,				"I2S2 Test                ",		
	SDHC_Test,				"SDHC Test                ",	
	Test_SPDIF,				"SPDIF Test               ",
	SPI_Test,				"HS SPI test              ",
	Test_TSI,				"TSI Test                 ",		
	Test_UART,				"UART Test                ",
	Test_OTGDEV,			"USB OTG Test             ",
	Test_USBHOST,			"USB HOST Test         ",

	Test_PMIC,				"PMIC Power Control       ",	
	Dhry_1,					"DhryStone Test           ",

	BOOTCODEWRITE,			"Boot Memory Write        ",
	Test_SDOUT, 			"Test Analog_TV",

	
	MM_path_ManualTest,		"MM manual test           ",	// Multimedia Sorting code add.
	AUTO_alltest, 			"Auto_Test                ", // auto tet add.
	0,0
};


//////////
// Function Name : main
// Function Desctiption : main function of the validation
// Input : NONE
// Output : NONE
// Version :
int main(void)
{	
	u32 i, uSel; 
	u8 bClockChange=false;

#ifndef FPGA
	SYSC_SetPSHold(TRUE);
#endif

	SYSTEM_InitException();
	CoStartMmuAndCache();
	SYSC_ReadSystemID();

	GPIO_Init();
	TZPC_Init();
	SYSC_ReleaseRetentionIO(eRET_BLOCK_ALL); // release retention all for UART debug, GPIOs, ...
 
#ifndef FPGA // Comment all on DDR2. Enable to select one on mDDR
//	SYSC_InitSysClk(eINIT_SYSCLK_NB_NORM);
//	SYSC_InitSysClk(eINIT_SYSCLK_NB_HIGH);
#else
	SYSC_InitSysClk(eINIT_SYSCLK_NORMAL);
	//SYSC_InitSysClk(eINIT_SYSCLK_LOW);
	//SYSC_InitSysClk(eINIT_SYSCLK_VERYLOW);
#endif 

	SYSC_UpdateClkInform();
	OpenConsole(DBG_UART_CH);
	CalibrateDelay();

	DisplayLED(0x9);

	SYSCT_CheckAgingWakeupReset(); // include releasing retention..

	DisplayLED(0x6);
	
#ifndef FPGA
	PMIC_InitSetting();	
#endif
 
	DisplayLED(0x1);


	while(1)
	{ 
		UART_Printf("\n\n");
		UART_Printf("***************************************************\n");
		UART_Printf("*          S5PV210 - Test firmware v0.0           *\n");
		UART_Printf("***************************************************\n");
		UART_Printf(" System Info : Product ID [%x], Pkg Type [%x]\n", g_uProductID, g_uPkgMode);
		UART_Printf("               Main Revision [%d], Sub Revision [%d]\n", g_uMainRev, g_uSubRev);
		UART_Printf(" ARMCLK: %.2fMHz\n HCLK_Msys: %.2fMHz  PCLK_Msys: %.2fMHz\n HCLK_Dsys: %.2fMHz  PCLK_Dsys: %.2fMHz\n HCLK_Psys: %.2fMHz  PCLK_Psys: %.2fMHz\n\n",
				(float)g_uARMCLK/1.0e6, (float)g_uHclkMsys/1.0e6, (float)g_uPclkMsys/1.0e6, (float)g_uHclkDsys/1.0e6, (float)g_uPclkDsys/1.0e6, (float)g_uHclkPsys/1.0e6, (float)g_uPclkPsys/1.0e6);
		UART_Printf(" APLL: %.2fMHz	MPLL: %.2fMHz\n EPLL: %.2fMHz 	VPLL: %.2fMHz\n\n",
				(float)g_uAPLL/1.0e6, (float)g_uMPLL/1.0e6, (float)g_uEPLL/1.0e6, (float)g_uVPLL/1.0e6);
	
		for (i=0; (u32)(menu[i].desc)!=0; i++)
		{
			UART_Printf("%2d: %s  ", i, menu[i].desc);
			if(((i+1)%4)==0)
				Putc('\n');
		}
		
		UART_Printf("\n\n Select the function to test : ");
		AUTO_menunumber(i-1);//returning auto test number
		uSel =UART_GetIntNumAutotest();
		UART_Printf("\n");

		if (uSel<(sizeof(menu)/8-1))
			(menu[uSel].func) ();
	}
	
}
