/*-------------------------------------------------------------
 *  etc.h
 *
 *  Siyoung Kim @ Mobile Design P/J, Samsung Electronics
 *
 *-------------------------------------------------------------
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <stdlib.h>
#include "library.h"

//#define Assert(a) {if (!(a)) {Disp("\n %s(line %d)\n", __FILE__, __LINE__); exit(0);}}

void Assert2(bool bCondition, const char *fmt,...);
void Delay(u32 uVal);
void Copy(u32 sa, u32 da, u32 words);
void Dump(u32 addr, u32 words);
bool Compare(u32 a1, u32 a2, u32 words);
void SaveToFile(const char* fileName, u32 fileSize, u32 uSrcAddr);
void MemcInit(void);
void InitMemc(void);
void InitMemc16(void);
/*
#define Outp32(addr, data) (*(volatile u32 *)(addr) = (data))
#define Outp16(addr, data) (*(volatile u16 *)(addr) = (data))
#define Outp8(addr, data)  (*(volatile u8 *)(addr) = (data))
#define Inp32(addr, data) (data = (*(volatile u32 *)(addr)))
#define INP32(addr) (*(volatile u32 *)(addr))
#define Inp16(addr, data) (data = (*(volatile u16 *)(addr)))
#define Inp8(addr, data)  (data = (*(volatile u8 *)(addr)))
*/

#define Inp32_0(addr)		(*(volatile u32 *)(addr)) //in order to match applicaton team code
#define Inp16_0(addr)		(*(volatile u16 *)(addr))
#define Inp8_0(addr)			(*(volatile u8 *)(addr))

void Delay(u32 time);
void TuneDelay(void);
void WaitForButton(void);

void Copy32(u32 sa, u32 da, u32 words);
void Copy16(u32 sa, u32 da, u32 hwords);
void Copy8(u32 sa, u32 da, u32 bytes);
void Pcopy8(u8* sa, u8* da, u32 bytes);

bool Compare128(u32 a1, u32 a2, u32 words);
bool Compare32(u32 a1, u32 a2, u32 words);
bool Compare24(u32 a1, u32 a2, u32 words);
bool Compare16(u32 a1, u32 a2, u32 hwords);
bool Compare8(u32 a1, u32 a2, u32 bytes);

u32  LoadFromFile(const char* fileName, u32 uDstAddr);
void LoadFromFile1(const char* fileName, u32 uDstAddr, u32* uFileSize);
void SaveToFile(const char* fileName, u32 fileSize, u32 uSrcAddr);
void ConvertBmpToRgb16bpp(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize);
void ConvertBmpToRgb24bpp(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize);
void ConvertBmpToPackedRgb24bpp(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize);
void ConvertBmpToRgb(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize, u32 bpp);
void Dump32(u32 addr, u32 words);
void Dump32Cfcon(u32 addr, u32 words);
void Dump16(u32 addr, u32 hwords);
void Dump8(u32 addr, u32 bytes);

void ConvertCSpaceToString(IMG_FMT eBpp, char* pcBpp);
void ConvertImgSzToNumber(IMG_RESOLUTION eSize, u32* uHsz, u32* uVsz);

bool FindFrameBufferDiff(u32 a0, u32 a1, u32 bytes, u32 uWidth, u32 uHeight,
	u32* uPeakDiff, u32* uAvgDiff);
bool CompareFrameBuffers(
	u32 a0, u32 width, u32 height, 
	u32 a1, u32 dispWidth, u32 dispHeight,
	u32* uMaxAbsDiff, u32* uAvgDiff);

#include <stdlib.h>
u32  Stop(void);
#define Assert(b) (!(b) ? Disp("\n %s(line %d)\n", __FILE__, __LINE__), Stop() : 0)
	
void MemcInit(void); // obsolete
void InitMemc(void);
void InitMemc16(void);
void InitMemc32(void);

u32 ToBigEndian(u32 data);
void AlignPackedRGB24(u32 fromAddr, u32 xSize, u32 ySize);
u32 Inp32Not4ByteAlign(u32 addr);
#endif

