#include <stdio.h> 
#include <string.h> 
#include <stdlib.h>
#include <stdarg.h>

#include "util.h"
#include "system.h"
#include "library.h"

u32 Stop(void) 
{ 
	while(1); 
	return 0; 
}

/*
void Assert2(bool bCondition, const char *fmt,...)
{
	if (!bCondition) 
		return;

    va_list ap;
    char string[256];

    va_start(ap, fmt);
    vsprintf(string, fmt, ap);
    va_end(ap);
	urtPutString(string);

	exit(0);
}
*/

void Copy32(u32 sa, u32 da, u32 words)
{
	u32 i;

	for (i=0; i<words; i++)
		*(u32 *)(da+i*4) = *(u32 *)(sa+i*4);
}

/*
void Copy8(u32 sa, u32 da, u32 bytes)
{
	u32 i;

	for (i=0; i<bytes; i++)
		*(u8 *)(da+i) = *(u8 *)(sa+i);
}
*/

void Pcopy8(u8* sa, u8* da, u32 bytes)
{
	u32 i;

	for (i=0; i<bytes; i++)
		*(da+i) = *(sa+i);
}

bool Compare128(u32 a0, u32 a1, u32 qwords)
{
__asm
	{
loop1:
	ldmia   r0, {r3-r6}
	ldmia   r1, {r7-r10}

	cmp     r3, r7
	bne     err
	cmp     r4, r8
	bne     err
	cmp     r5, r9
	bne     err
	cmp     r6, r10
	bne     err

	add     r0, r0, #0x10
	add     r1, r1, #0x10
	subs    r2, r2, #1
	bne     loop1
	b       ok
	}
err:
	return 0;
ok:
	return 1;
}

bool Compare32(u32 a0, u32 a1, u32 words)
{
	u32* pD0 = (u32 *)a0;
	u32* pD1 = (u32 *)a1;
	bool ret = true;
	u32  ecnt = 0;
	u32 i;

	for (i=0; i<words; i++)
	{
		if (*pD0 != *pD1) 
		{
			ret = false;
			Disp(" %08x=%08x <-> %08x=%08x\n", pD0, *pD0, pD1, *pD1);
			ecnt++;
		}
		pD0++;
		pD1++;
	}

	if (ret == false)
		Disp("\n");

	return ret;
}

bool Compare24(u32 a0, u32 a1, u32 words)
{
	u32* pD0 = (u32 *)a0;
	u32* pD1 = (u32 *)a1;
	bool ret = true;
	u32  ecnt = 0;
	u32 i;
	
	for (i=0; i<words; i++)
	{
		if (((*pD0)<<8) != ((*pD1)<<8)) 
		{
			ret = false;
			Disp(" %08x=%08x <-> %08x=%08x\n", pD0, *pD0, pD1, *pD1);
			ecnt++;
		}
		pD0++;
		pD1++;
	}

	if (ret == false)
		Disp("\n");

	return ret;
}

bool Compare8(u32 a0, u32 a1, u32 bytes)
{
	u8*  pD0 = (u8 *)a0;
	u8*  pD1 = (u8 *)a1;
	bool ret = true;
	u32  uErrCnt = 0;
	u32 i;

	for (i=0; i<bytes; i++)
	{
		if (*pD0 != *pD1) 
		{
			ret = false;
			Disp(" %08x=%02x <-> %08x=%02x\n", pD0, *pD0, pD1, *pD1);
			uErrCnt++;
		}
		pD0++;
		pD1++;
	}

	if (ret == false)
		Disp("\n");
	
	return ret;

}

/*
u32 LoadFromFile(const char* fileName, u32 uDstAddr)
{
	u32 uFileSize;
	u32 read;
	
#ifdef SEMI_HOSTING

#if 1 // realview
	FILE* fp = fopen(fileName, "rb");
	Assert(fp);
	fseek(fp, 0, SEEK_END);
	uFileSize = ftell(fp);
    rewind(fp);

	read = fread((void *)uDstAddr, sizeof(unsigned char), uFileSize, fp);
	Assert(read==uFileSize);
	
	fclose(fp);
#else // t32
	u32 i, uQuotient, uRemainder, uWriteAddr;

	FILE* fp = fopen(fileName, "rb");
	Assert(fp);
	fseek(fp, 0, SEEK_END);
	uFileSize = ftell(fp);
	fseek(fp, 0, SEEK_SET);
    //rewind(fp);
	uWriteAddr = uDstAddr;
    	uQuotient = uFileSize/10000;
	uRemainder = uFileSize%10000;

	for(i=0; i<uQuotient ; i++)
	{
		read = fread((void *)uWriteAddr, sizeof(unsigned char), 10000, fp);
		Assert(read==10000);
		uWriteAddr += 10000;
	}
	read = fread((void *)uWriteAddr, sizeof(unsigned char), uRemainder, fp);
	Assert(read==uRemainder);	
	
	fclose(fp);
#endif
	
#else

	Disp(" Sorry! It is not ready.\n");

#endif

	return uFileSize;
}

void LoadFromFile1(const char* fileName, u32 uDstAddr, u32* uFileSize)
{
#ifdef SEMI_HOSTING
	u32 read;

	FILE* fp = fopen(fileName, "rb");
	Assert(fp);
	fseek(fp, 0, SEEK_END);
	*uFileSize = ftell(fp);
    rewind(fp);

	read = fread((void *)uDstAddr, sizeof(unsigned char), *uFileSize, fp);
	Assert(read==*uFileSize);
	
	fclose(fp);
	
#else

	Disp(" Sorry! It is not ready.\n");

#endif
}
*/

/*
void SaveToFile(const char* fileName, u32 fileSize, u32 uSrcAddr)
{
#ifdef SEMI_HOSTING
	u32 written;

	FILE* fp = fopen(fileName, "wb");
	Assert(fp);
	
	written = fwrite((void *)uSrcAddr, sizeof(unsigned char), fileSize, fp);
	Assert(written == fileSize);

	fclose(fp);

#else

	Disp(" Sorry! It is not ready.\n");

#endif
}
*/

#define IMAGE_MAXSIZE 1600
/*
// 24bpp BMP -> 16bpp RGB
void ConvertBmpToRgb16bpp(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize)
{
	u32 i,x,y;
	u16 *lcdFramePtr;
	u16 *tempPtr;
	u16 temp[IMAGE_MAXSIZE];
	u32 tempBuffer = fromAddr + 0x400000; // up to 1600x1200
	u8 b,g,r;
	
	u8 *srcPtr=(u8 *)(fromAddr+54);
	lcdFramePtr=(u16 *)(toAddr);

	for(y=0;y<ySize;y++) {
		for(x=0;x<xSize*3;x++) {
			b=*srcPtr++;
			g=*srcPtr++;
			r=*srcPtr++;

			*lcdFramePtr++=(r>>3)<<11|(g>>2)<<5|(b>>3)<<0;
		}
	}

	lcdFramePtr=(u16 *)(toAddr+xSize*ySize*2-2);
	tempPtr=(u16 *)(tempBuffer);
	for(y=0;y<xSize*ySize;y++) {
		*tempPtr++=*lcdFramePtr--;
	}

	lcdFramePtr=(u16 *)(toAddr);
	tempPtr=(u16 *)(tempBuffer);
	for(y=0;y<ySize;y++) {
		for(x=0;x<xSize;x++) {
			temp[(xSize-1)-x]=*tempPtr++;
		}
		if(x==xSize) {
			for(i=0;i<xSize;i++)
				*lcdFramePtr++=temp[i];
		}
	}
}
*/

/*
// 24bpp BMP -> 24bpp RGB
void ConvertBmpToRgb24bpp(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize)
{
	u32 i,x,y;
	u32 *lcdFramePtr,*tempPtr;
	u32 temp[IMAGE_MAXSIZE];
	u32 tempBuffer = fromAddr + 0x760000; // up to 1600x1200
    u8 b,g,r;
	
	u8 *srcPtr=(u8 *)(fromAddr+54);
	lcdFramePtr=(u32 *)(toAddr);
   	for(y=0;y<xSize*ySize;y++) {
    	b=*srcPtr++;
    	g=*srcPtr++;
	    r=*srcPtr++;

	    *lcdFramePtr++=(r<<16)|(g<<8)|(b<<0);
	}

	lcdFramePtr=(u32 *)(toAddr+xSize*ySize*4-4);
	tempPtr=(u32 *)(tempBuffer);
    for(y=0;y<xSize*ySize;y++) {
	    *tempPtr++=*lcdFramePtr--;
    }

	lcdFramePtr=(u32 *)(toAddr);
	tempPtr=(u32 *)(tempBuffer);
    for(y=0;y<ySize;y++) {
	    for(x=0;x<xSize;x++) {
			temp[(xSize-1)-x]=*tempPtr++;
	    }
	    if(x==xSize) {	    	
		   	for(i=0;i<xSize;i++)
		    	*lcdFramePtr++=temp[i];
		}
	}	

}
*/
// Bmp 24bpp -> Rgb 16 or 24bpp
void ConvertBmpToRgb(u32 fromAddr, u32 toAddr, u32 xSize, u32 ySize, u32 bpp)
{
	if (bpp == 16) 
	{		
		ConvertBmpToRgb16bpp(fromAddr, toAddr, xSize, ySize);
	} 
	else if (bpp == 24) 
	{
		ConvertBmpToRgb24bpp(fromAddr, toAddr, xSize, ySize);
	} 
	else 
	{
		Disp("bpp should be 16 or 24 at ConvertBmpToRgb()\n");
	}
}

/*
void ConvertImgSzToNumber(IMG_RESOLUTION eSize, u32* uHsz, u32* uVsz)
{
	if (eSize == UXGA)
		*uHsz = 1600, *uVsz = 1200; 
	else if (eSize == SXGA)
		*uHsz = 1280, *uVsz = 1024; 
	else if (eSize == SVGA)
		*uHsz = 800, *uVsz = 600;		
	else if (eSize == VGA)
		*uHsz = 640, *uVsz = 480; 
	else if (eSize == QVGA)
		*uHsz = 320, *uVsz = 240; 
	else if (eSize == QQVGA)
		*uHsz = 160, *uVsz = 120; 
	else if (eSize == CIF)
		*uHsz = 352, *uVsz = 288; 
	else if (eSize == QCIF)
		*uHsz = 172, *uVsz = 144; 
	else
		Assert(0);
}
*/

/*
void Dump32(u32 addr, u32 words)
{
	int i, j;
	u32 *pMem;

	pMem = (u32 *)(addr/4*4);

	Disp("\n");
	for(i=0; i<words; )
	{
		Disp(" %04x: ", i);

		for(j=0; j<8; j++)
			Disp("%08x ", *pMem++),
			i++;
		Disp("\n");
	}
}
*/

void Dump32Cfcon(u32 addr, u32 words)
{
	int i, j;
	u32 *pMem;

	pMem = (u32 *)(addr/4*4);

	Disp("\n");
	for(i=0; i<words; )
	{
		Disp(" 0X%04x: ", i*4);

		for(j=0; j<8; j++)
		{
			Disp("%08x ", *pMem++);
			i++;
		}
		Disp("\n");
	}
}
/*
void Dump16(u32 addr, u32 hwords)
{
	int i, j;
	u16 *pMem;

	pMem = (u16 *)(addr/2*2);

	Disp("\n");
	for(i=0; i<hwords; )
	{
		Disp(" %04x: ", i);

		for(j=0; j<16; j++)
			Disp("%04x ", *pMem++),
			i++;
		Disp("\n");
	}
}
*/

/*
void Dump8(u32 addr, u32 bytes)
{
	int i, j;
	u8 *pMem;

	pMem = (u8 *)addr;

	Disp("\n");
	for(i=0; i<bytes; )
	{
		Disp(" %04x: ", i);

		for(j=0; j<16; j++)
			Disp("%02x ", *pMem++),
			i++;
		Disp("\n");
	}
}
*/

//void ConvertCSpaceToString(IMG_FMT eBpp, const char* pcBpp)
void ConvertCSpaceToString(IMG_FMT eBpp, char* pcBpp)
{
#if 0
	switch (eBpp)
	{
		case PAL1:
			pcBpp = "1Bpp (Palette)";
			break;
		case PAL2:
			pcBpp =	"2Bpp (Palette)";
			break;
		case PAL4:
			pcBpp =	"4Bpp (Palette)";
			break;
		case PAL8:
			pcBpp =	"8Bpp (Palette)";
			break;
		case RGB8:
			pcBpp = "RGB 8Bpp (R:3 G:3 B:2)";
			break;
		case RGB16:
			pcBpp = "RGB 16Bpp (R:5 G:6 B:5)";
			break;
		case RGB24:
			pcBpp = "RGB 24Bpp (R:8 G:8 B:8)";
			break;
		case ARGB8:
			pcBpp = "ARGB 8Bpp (A:1 R:2 G:3 B:2)";
			break;
		case ARGB16:
			pcBpp = "ARGB 16Bpp (A:1 R:5 G:5 B:5)";
			break;
		case ARGB24:
			pcBpp = "ARGB 24Bpp (A:1 R:8 G:8 B:7)";
			break;
		default:
			Assert(0);
	}
#else
	switch (eBpp)
	{
		case PAL1:
			strcpy(pcBpp, "1Bpp (Palette)");
			break;
		case PAL2:
			strcpy(pcBpp, "2Bpp (Palette)");
			break;
		case PAL4:
			strcpy(pcBpp, "4Bpp (Palette)");
			break;
		case PAL8:
			strcpy(pcBpp, "8Bpp (Palette)");
			break;
		case RGB8:
			strcpy(pcBpp, "RGB 8Bpp (R:3 G:3 B:2)");
			break;
		case RGB16:
			strcpy(pcBpp, "RGB 16Bpp (R:5 G:6 B:5)");
			break;
		case RGB24:
			strcpy(pcBpp, "RGB 24Bpp (R:8 G:8 B:8)");
			break;
		case ARGB8:
			strcpy(pcBpp, "ARGB 8Bpp (A:1 R:2 G:3 B:2)");
			break;
		case ARGB16:
			strcpy(pcBpp, "ARGB 16Bpp (A:1 R:5 G:5 B:5)");
			break;
		case ARGB24:
			strcpy(pcBpp, "ARGB 24Bpp (A:1 R:8 G:8 B:7)");
			break;
		default:
			Assert(0);
	}
#endif
}


/*-----------------------------------------------------------
 * Delay
 *  - Delay for 100us step.
 *
 */
#if 0
#define CNT_FOR_TENTH_MSEC 820 /* FCLK = 100MHz */
#else
#define CNT_FOR_TENTH_MSEC 413 /* HCLKin:HCLKout = 1:1, HCLK = 25MHz */
#endif

/*
void Delay(u32 steps)
{
	int i;

	for(; steps>0; steps--)
		for(i=0; i<CNT_FOR_TENTH_MSEC; i++);
}
*/

static void delay2(u32 steps, u32 cntFor100us)
{
	int i;

	for(; steps>0; steps--)
		for(i=0; i<cntFor100us; i++);
}

void TuneDelay(void)
{
	u32 i, r, j, sel, cntFor100us;
	int val;

	cntFor100us = CNT_FOR_TENTH_MSEC;

	while(1)
	{

		Disp(" 0. Exit\n");
		Disp(" 1. Enter the count value.\n");
		Disp(" 2. Count in every one sec.\n");
		Disp(" 3. Count in every one sec display the value of the timer.\n");
		Disp(" Which one ? ");

		sel = UART_GetIntNum();

		if (sel == 0)
			break;
		else if (sel == 1)
		{
			Disp("  Current count value for 100us is %d. Enter the new value: ", cntFor100us);
			val = UART_GetIntNum();
			if (val != -1)
				cntFor100us = val;
		}
		else if (sel == 2)
		{
			for (i=0; i<60; i++)
			{
				Disp("%d ", i);

				for (j=0; j<100; j++)
					delay2(100, cntFor100us);

				if (GetKey() != 0)
					break;
			}
		}
#if 0		
		else if (sel == 3)
		{
			for (i=0; i<60; i++)
			{
				Disp("%d ", i);

				TimerStart();

				for (j=0; j<100; j++)
					delay2(100, cntFor100us);

				Disp("(%d) ",TimerRead());

				if (UartGetKey() != 0)
					break;
			}
		}
#endif		
	}
}





void Assert2(bool bCondition, const char *fmt,...)
{
    va_list ap;
    char string[256];

	if (!bCondition) 
		return;

    va_start(ap, fmt);
    vsprintf(string, fmt, ap);
    va_end(ap);
	UART_PutString(string);

	exit(0);
}


// void Delay(u32 uVal)
//{
//	u32 i;
//
//	for(i=0; i<uVal; i++)
//		;
//}

/*
void Copy(u32 sa, u32 da, u32 words)
{
	u32 i;	
	for (i=0; i<words; i++)
		*(u32 *)(da+i*4) = *(u32 *)(sa+i*4);
}
*/

void Dump(u32 addr, u32 words)
{
	u32 i, j;
	u32 *pMem;

	pMem = (u32 *)(addr/4*4);

	Disp("\n");
	for(i=0; i<words; )
	{
		Disp(" %04x: ", i);

		for(j=0; j<8; j++)
			Disp("%08x ", *pMem++),
			i++;
		Disp("\n");
	}
}
/*
bool Compare( u32 a0,  u32 a1,  u32 words)
{
	volatile u32 d0,d1;
	volatile u32 *pD0, *pD1;
	bool ret = true;
	u32  ecnt = 0;
	u32 i;
	
	pD0 = (volatile u32 *)(a0);
	pD1 = (volatile u32 *)(a1);
	
	Disp("\n");	

	for (i=0; i<words; i++)
	{
		
		d0=*pD0;
		d1=*pD1;

		if (d0!= d1) 
		{
			ret = false;
			Disp(" %08x=%08x <-> %08x=%08x\n", pD0, d0, pD1, d1);
			ecnt++;
		}
		pD0++;
		pD1++;
	}

//	if (ret == false)
//	{
//		Assert(0);		
//		Disp("\n");
//	}

	return ret;
}
*/
bool FindFrameBufferDiff(u32 a0, u32 a1, u32 bytes, u32 uWidth, u32 uHeight, u32* uPeakDiff, u32* uAvgDiff)
{
	u8* pD0 = (u8 *)a0;
	u8* pD1 = (u8 *)a1;
	bool ret = true;
	u32 uErrCnt = 0;
	u32 uMaxDiff = 0;
	u32 uSumDiff = 0;
	u32 temp2, i;
	u32 uYEndAddr = uWidth*uHeight;
	u32 uCbEndAddr = uWidth*uHeight*5/4;
	u32 uCrEndAddr = uWidth*uHeight*3/2;
	u32 uStride = (uWidth%16 ==0) ? uWidth : (uWidth+15)/16*16;
	u32 uNewHeight = (uHeight%16 ==0) ? uHeight : (uHeight+15)/16*16;
	
	for (i=0; i<bytes; i++)
	{
		if (*pD0 != *pD1) 
		{
			ret = false;			
			temp2 = (*pD0 > *pD1) ? *pD0-*pD1 : *pD1-*pD0;

			if (uMaxDiff < temp2)
				uMaxDiff = temp2;
			uErrCnt++;
			//Disp("%d:0x%x~0x%x: %d-%d ",i,(u32)pD0, (u32)pD1, *pD0,*pD1);
			//Disp("%d: %d-%d ",i, *pD0, *pD1);
		}			

		pD0++;
		if ((i%uWidth == uWidth-1) && i<uYEndAddr)
		{
			pD1 = pD1 + (uStride-uWidth) + 1;
			if (i==uYEndAddr-1)
			{
				pD1 = pD1 + uStride*(uNewHeight-uHeight);
			}
		}
		else if (i>=uYEndAddr && i<uCrEndAddr && ((i-uYEndAddr)%(uWidth/2) == (uWidth/2-1)))
		{
			pD1 = pD1 + (uStride-uWidth)/2 + 1;
			if (i==uCbEndAddr-1)
			{
				pD1 = pD1 + uStride*(uNewHeight-uHeight)/4;
			}
		}
		else
		{
			pD1++;
		}
	}

	if (ret == false)
	{
		Assert(uErrCnt>0);
		//Disp("\nError Count=%d, Max diff=%d, Avg diff=%d\n", uErrCnt, uMaxDiff, uSumDiff/uErrCnt);
		*uPeakDiff = uMaxDiff;
		*uAvgDiff = uSumDiff/uErrCnt;
	}
	else
	{
		*uPeakDiff = 0;
		*uAvgDiff = 0;
	}
	return ret;
}



bool CompareFrameBuffers(
	u32 a0, u32 width, u32 height, 
	u32 a1, u32 dispWidth, u32 dispHeight,
	u32* uMaxAbsDiff, u32* uAvgDiff)
{
	u32 uAbsDiff;
	bool resultComp=true;
	bool resultCompY;
	u32 j;
	bool resultCompCb;
	u32 uCompStAddr;
	u32 uFrameStAddr;
	bool resultCompCr;

	for (j=0; j<height; j++)
	{
		resultCompY = Compare128(a0+j*width, a1+j*dispWidth, width/16);
		if (!resultCompY)
		{
			FindFrameBufferDiff(a0+j*width, a1+j*dispWidth, width, width,   height, &uAbsDiff, uAvgDiff);			
			if (*uMaxAbsDiff < uAbsDiff)
			{				
				*uMaxAbsDiff = uAbsDiff;								
			}
			resultComp = false;
		}
	}

	uCompStAddr = a0+width*height;
	uFrameStAddr = a1+dispWidth*dispHeight;
	for (j=0; j<height/2; j++)
	{
		resultCompCb = Compare128(uCompStAddr+j*width/2, uFrameStAddr+j*dispWidth/2, width/2/16);
		if (!resultCompCb)
		{
			FindFrameBufferDiff(uCompStAddr+j*width/2, uFrameStAddr+j*dispWidth/2, width/2, width,   height, &uAbsDiff, uAvgDiff);			
			if (*uMaxAbsDiff < uAbsDiff)
			{				
				*uMaxAbsDiff = uAbsDiff;								
			}
			resultComp = false;
		}
	}		

	uCompStAddr = a0+width*height*5/4;
	uFrameStAddr = a1+dispWidth*dispHeight*5/4;
	for (j=0; j<height/2; j++)
	{
		resultCompCr = Compare128(uCompStAddr+j*width/2, uFrameStAddr+j*dispWidth/2, width/2/16);
		if (!resultCompCr)
		{
			FindFrameBufferDiff(uCompStAddr+j*width/2, uFrameStAddr+j*dispWidth/2, width/2, width,   height, &uAbsDiff, uAvgDiff);			
			if (*uMaxAbsDiff < uAbsDiff)
			{				
				*uMaxAbsDiff = uAbsDiff;								
			}
			resultComp = false;
		}
	}
	return resultComp;
}

u32 ToBigEndian(u32 data)
{
	u32 Temp;
	Temp =	((data &0xff) <<24)
			|( ((data >>8) &0xff) <<16)
			| (((data >>16) &0xff) <<8)
			| ((data >>24) &0xff);
	return Temp;
}

void AlignPackedRGB24(u32 fromAddr, u32 xSize, u32 ySize)
{
	u8 *pTmpPtr = (u8 *)fromAddr;
	u32 uSize = xSize*ySize*4;
	u8* pOriginalTempBuffer = (u8 *)malloc(xSize*ySize*3);
	u8* pInc = pOriginalTempBuffer;
	
	u32 uCnt0;	

	for (uCnt0 = 0;uCnt0 < uSize;uCnt0++)
	{
		if(uCnt0 % 4 == 0 )
		{
			*(u8 *)((u32)pInc+2) = *pTmpPtr++;
		}
		else if(uCnt0 % 4 == 1 )
		{
			*(u8 *)((u32)pInc+1) = *pTmpPtr++;
		}
		else if(uCnt0 % 4 == 2 )
		{
			*(u8 *)((u32)pInc+0) = *pTmpPtr++;
		}		
		else
		{
			pTmpPtr++;
			pInc = pInc + 3;
		}
	}
	memcpy((void *)fromAddr, (void *)pOriginalTempBuffer, xSize*ySize*3);
	free(pOriginalTempBuffer);
}

/*
u32 Inp32Not4ByteAlign(u32 addr)
{
	u32 Temp1;
	u32 Temp2;
	u32 Temp3;
	u32 Temp4;
	Temp1 = Inp8(addr);
	addr++;
	Temp2 = Inp8(addr);
	Temp2 = Temp2<<8;
	addr++;
	Temp3 = Inp8(addr);
	Temp3 = Temp3<<16;
	addr++;
	Temp4 = Inp8(addr);
	Temp4 = Temp4<<24;
	return (Temp1 | Temp2 |Temp3 |Temp4 );
}
*/
