;/*************************************************************************************
; 
;	Project Name : S5PC100 Validation
;
;	Copyright 2006 by Samsung Electronics, Inc.
;	All rights reserved.
;
;	Project Description :
;		This software is only for validating functions of the S5PC100.
;		Anybody can use this software without our permission.
;  
;--------------------------------------------------------------------------------------
; 
;	File Name : system_.s
;  
;	File Description : This file implements CP15 control.
;
;	Author	: Haksoo,Kim
;	Dept. : AP Development Team
;	Created Date : 2006/11/08
;	Version : 0.1 
; 
;	History
;	- Created(Haksoo,Kim 2006/11/08)
;  
;*************************************************************************************/


				AREA	|C$$code|, CODE, READONLY

                EXPORT  CoEnableIrq
CoEnableIrq
                MRS     r0,cpsr
                BIC     r0,r0,#0x80
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

                EXPORT  CoDisableIrq
CoDisableIrq
                MRS     r0,cpsr
                ORR     r0,r0,#0x80
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

                EXPORT  CoEnableFiq
CoEnableFiq
                MRS     r0,cpsr
                BIC     r0,r0,#0x40
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

                EXPORT  CoDisableFiq
CoDisableFiq
                MRS     r0,cpsr
                ORR     r0,r0,#0x40
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

NOINT           EQU     0xc0
                EXPORT  CoSetIF
                ;/* The return value is current CPSR. */
CoSetIF
                MRS     r0,cpsr
                MOV     r1,r0
                ORR     r1,r1,#NOINT
                MSR     cpsr_cxsf,r1
                MOV     pc,lr

                EXPORT  CoWrIF
                ;/* r0 = uCpsrValue */
CoWrIF
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

                EXPORT  CoClrIF
CoClrIF
                MRS     r0,cpsr
                BIC     r0,r0,#NOINT
                MSR     cpsr_cxsf,r0
                MOV     pc,lr

                EXPORT  CoEnableVectoredInt
CoEnableVectoredInt
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<24)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoDisableVectoredInt
CoDisableVectoredInt
                MRC     p15,0,r0,c1,c0,0
                BIC     r0,r0,#(1<<24)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableICache
CoEnableICache
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<12)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoDisableICache
CoDisableICache
                MRC     p15,0,r0,c1,c0,0
                BIC     r0,r0,#(1<<12)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableDCache
CoEnableDCache
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<2)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoDisableDCache
CoDisableDCache
                MRC     p15,0,r0,c1,c0,0
                BIC     r0,r0,#(1<<2)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableAlignFault
CoEnableAlignFault
                MRC     p15,0,r0,c1,c0,0
                ORR	r0,r0,#(1<<1)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoDisableAlignFault
CoDisableAlignFault
                MRC     p15,0,r0,c1,c0,0
                BIC      r0,r0,#(1<<1)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableMmu
CoEnableMmu
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<0)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoDisableMmu
CoDisableMmu
                MRC     p15,0,r0,c1,c0,0
                BIC     r0,r0,#(1<<0)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoSetFastBusMode
CoSetFastBusMode
                MRC     p15,0,r0,c1,c0,0
                BIC     r0,r0,#(1<<30):OR:(1<<31)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoSetAsyncBusMode
CoSetAsyncBusMode
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<30):OR:(1<<31)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableBranchPrediction
CoEnableBranchPrediction
                MRC     p15,0,r0,c1,c0,0
                ORR     r0,r0,#(1<<11)
                MCR     p15,0,r0,c1,c0,0
                MOV     pc,lr

                EXPORT  CoEnableL1ParityDetection
CoEnableL1ParityDetection
                MRC     p15,0,r0,c1,c0,1
                ORR     r0,r0,#(1<<3)
                MCR     p15,0,r0,c1,c0,1
                MOV     pc,lr

                EXPORT  CoDisableL1ParityDetection
CoDisableL1ParityDetection
                MRC     p15,0,r0,c1,c0,1
                BIC     r0,r0,#(1<<3)
                MCR     p15,0,r0,c1,c0,1
                MOV     pc,lr

                EXPORT  CoEnableL2Cache
CoEnableL2Cache
                MRC     p15,0,r0,c1,c0,1
                ORR     r0,r0,#(1<<1)
                MCR     p15,0,r0,c1,c0,1
                MOV     pc,lr

                EXPORT  CoDisableL2Cache
CoDisableL2Cache
                MRC     p15,0,r0,c1,c0,1
                BIC     r0,r0,#(1<<1)
                MCR     p15,0,r0,c1,c0,1
                MOV     pc,lr

                EXPORT  CoEnableVfp
CoEnableVfp
                MRC     p15,0,r0,c1,c0,2
                ORR     r0,r0,#(3<<20)
                MCR     p15,0,r0,c1,c0,2
                MOV     pc,lr

                EXPORT  CoEnableNeon
CoEnableNeon
                MRC     p15,0,r0,c1,c0,2
                ORR     r0,r0,#(3<<22)
                MCR     p15,0,r0,c1,c0,2
                MOV     pc,lr

                EXPORT  CoSetTTBase
CoSetTTBase
                ;/* r0 = base */
                MCR     p15,0,r0,c2,c0,0
                MOV     pc,lr

                EXPORT  CoSelTTBReg0
CoSelTTBReg0
                ;/* r0 = base */
                MOV     r0,#0
                MCR     p15,0,r0,c2,c0,2
                MOV     pc,lr

                EXPORT  CoSetDomain
CoSetDomain
                ;/* r0 = domain */
                MCR     p15,0,r0,c3,c0,0
                MOV     pc,lr

                EXPORT  CoWaitForInterrupt
CoWaitForInterrupt
                MOV     r0,#0
                MCR     p15,0,r0,c7,c0,4
                MOV     pc,lr

                EXPORT  CoInvalidateICache
CoInvalidateICache
                MOV     r0,#0
                MCR     p15,0,r0,c7,c5,0
                MOV     pc,lr

                EXPORT  CoInvalidateICacheVA
CoInvalidateICacheVA
                ;/* r0 = va */
                MCR     p15,0,r0,c7,c5,1
                MOV     pc,lr

                EXPORT  CoInvalidateDCache
CoInvalidateDCache
                MOV     r0,#0
                MCR     p15,0,r0,c7,c6,0
                MOV     pc,lr

                EXPORT  CoInvalidateDCacheVA
CoInvalidateDCacheVA
                ;/* r0 = va */
                MCR     p15,0,r0,c7,c6,1
                MOV     pc,lr

                EXPORT  CoInvalidateDCacheIndex
CoInvalidateDCacheIndex
                ;/* r0 = index */
                MCR     p15,0,r0,c7,c6,2
                MOV     pc,lr

                EXPORT  CoInvalidateBothCaches
CoInvalidateBothCaches
                MOV     r0,#0
                MCR     p15,0,r0,c7,c7,0
                MOV     pc,lr

                EXPORT  CoCleanDCacheVA
CoCleanDCacheVA
                ;/* r0 = va */
                MCR     p15,0,r0,c7,c10,1
                MOV     pc,lr

                EXPORT  CoCleanDCacheIndex
CoCleanDCacheIndex
                ;/* r0 = index */
                MCR     p15,0,r0,c7,c10,2
                MOV     pc,lr

                EXPORT  CoPrefetchICacheLineVA
CoPrefetchICacheLineVA
                ;/* r0 = va */
                MCR     p15,0,r0,c7,c13,1
                MOV     pc,lr

                EXPORT  CoCleanAndInvalidateDCacheVA
CoCleanAndInvalidateDCacheVA
                ;/* r0 = va */
                MCR     p15,0,r0,c7,c14,1
                MOV     pc,lr

                EXPORT  CoCleanAndInvalidateDCacheIndex
                ;/* r0 = index */
CoCleanAndInvalidateDCacheIndex
                MCR     p15,0,r0,c7,c14,2
                MOV     pc,lr

                EXPORT  CoInvalidateITlb
CoInvalidateITlb
                MOV     r0,#0
                MCR     p15,0,r0,c8,c5,0
                MOV     pc,lr

                EXPORT  CoInvalidateITlbVA
CoInvalidateITlbVA
                ;/* r0 = va */
                MCR     p15,0,r0,c8,c5,1
                MOV     pc,lr

                EXPORT  CoInvalidateDTlb
CoInvalidateDTlb
                MOV     r0,#0
                MCR     p15,0,r0,c8,c6,0
                MOV     pc,lr

                EXPORT  CoInvalidateDTlbVA
CoInvalidateDTlbVA
                ;/* r0 = va */
                MCR     p15,0,r0,c8,c6,1
                MOV     pc,lr

                EXPORT  CoInvalidateBothTlbs
CoInvalidateBothTlbs
                MOV     r0,#0
                MCR     p15,0,r0,c8,c7,0
                MOV     pc,lr

                EXPORT  CoSetDCacheLockdownBase
CoSetDCacheLockdownBase
                ;/* r0 = base */
                MCR     p15,0,r0,c9,c0,0
                MOV     pc,lr

                EXPORT  CoSetICacheLockdownBase
CoSetICacheLockdownBase
                ;/* r0 = base */
                MCR     p15,0,r0,c9,c0,1
                MOV     pc,lr

                EXPORT  CoLockL2Cache
CoLockL2Cache
                ;/* r0=uWayNum */
                MRC     p15,1,r1,c9,c0,0
                BIC     r1,r1,r0
                MCR     p15,1,r1,c9,c0,0
                MOV     pc,lr

                EXPORT  CoUnLockL2Cache
CoUnLockL2Cache
                ;/* r0=uWayNum */
                MRC     p15,1,r1,c9,c0,0
                BIC     r1,r1,r0
                MCR     p15,1,r1,c9,c0,0
                MOV     pc,lr

                EXPORT  CoSetL2CacheAuxCrtlReg
CoSetL2CacheAuxCrtlReg
                ;/* r0 = uRegValue */
                MCR     p15,1,r0,c9,c0,2
                MOV     pc,lr

                EXPORT  CoSetDTlbLockdown
CoSetDTlbLockdown
                ;/* r0 = uBaseVictim */
                MCR     p15,0,r0,c10,c0,0
                MOV     pc,lr

                EXPORT  CoSetITlbLockdown
CoSetITlbLockdown
                ;/* r0 = uBaseVictim */
                MCR     p15,0,r0,c10,c0,1
                MOV     pc,lr

                EXPORT  CoSetL2CacheLines
CoSetL2CacheLines
                ;/* r0=uNumOfLines */
                ; 1 line = 64 bytes
                LSL     r0,r0,#6
                MCR     p15,0,r0,c11,c7,0
                MOV     pc,lr
                LTORG
                

;; To load into L2 cache, memory region type should be cacheable. To determine the type, 
;; the PLE performs a hardware translation table walk at the start of the sequence and for any 4KB page boundary.
;; Cacheable regions are the following three types.
;; 1. Write-through, nonshared, 2. Write-back, no write-allocate, nonshared, 3. Write-back, write-allocate, nonshared
;;  When the preload engine encounters a noncached memory region, including at the start of the transfer, 
;;   the preload engine stops the transfer and marks the transfer as complete.
;; The PLE channel does not save any state for the table walk. 
;; The translation procedure is for exception checking purposes and for determination of the memory attributes of the page.

;; You must enable the MMU for the PLE to operate. 
;; If you disabled the MMU during preloading engine configurations, the PLE treats all memory as noncacheable
;;regardless of the state of the Memory Region Remap Registers

                EXPORT  CoCopyToL2Cache
CoCopyToL2Cache
                ;/* r0=uStAddr, r1=uWayNum, r2=uNumOfLines */
                MOV     r3,#0
                MCR     p15,0,r3,c11,c2,0   ;/* Set Channel 0 or 1 */ ; Write PLE Channel Number Register
                ORR     r1,r1,#(0<<30|1<<29|1<<28) ; bit[30] - 0: to L2, 1: from L2 (0<<29)
                MCR     p15,0,r1,c11,c4,0   ;/* Set PLE ConReg */ ; Write PLE Control Register
                BIC     r0,r0,#0x1f			; why not 5bit(64bit aligned) clear? (BIC - Bitwise bit Clear)
                MCR     p15,0,r0,c11,c5,0   ;/* Set PLE Start Addr */ ; Write PLE Internal Start Address Register
                LSL     r2,r2,#6			; /* bit[N-1:6], N: log2(cache size in KB unit)+7 */
                MCR     p15,0,r2,c11,c7,0   ;/* Set NumOfLines (1line = 64bytes) */ ; Write PLE Internal End Address Register
                MOV     r0,#0				; /* Context ID is 0 */
                MCR     p15,0,r0,c11,c15,0  ;/* Set Context ID */ ; Write PLE Context ID Register
                MOV     r0,#0				; set the PLE Channel Number Register to the appropriate PLE channel
                MCR     p15,0,r0,c11,c3,1   ;/* Start PLE */ ; start command triggers data to be transferred to or from the L2 cache RAM as defined by DT bit [30] of the L2 PLE Control Reg
1               MRC     p15,0,r0,c11,c8,0   ;/* Get status */ ; Read PLE Channel Status Register
                CMP     r0,#0x3				; 0x3 means complete or error state.
                BNE     %B1

				MOV     r0,#0				; set the PLE Channel Number Register to the appropriate PLE channel
                MCR     p15,0,r0,c11,c3,2   ;/* Clear PLE */ ; Channel status transitions from error or complete to idle and the interrupt or error flag is cleared to 0
2               MRC     p15,0,r0,c11,c8,0   ;/* Get status */
                CMP     r0,#0x0				; 0x0 means idle or reset state
                BNE     %B2

                MOV     pc,lr
                LTORG

                EXPORT  CoCopyFromL2Cache
CoCopyFromL2Cache
                ;/* r0=uStAddr, r1=uWayNum, r2=uNumOfLines */
                MOV     r3,#0
                MCR     p15,0,r3,c11,c2,0   ;/* Set Channel 0 or 1 */ ; Write PLE Channel Number Register
                ORR     r1,r1,#(1<<30|1<<29|1<<28)	; bit[30] - 0: to L2, 1: from L2 (0<<29)
                MCR     p15,0,r1,c11,c4,0   ;/* Set PLE ConReg */
                BIC     r0,r0,#0x1f
                MCR     p15,0,r0,c11,c5,0   ;/* Set PLE START Addr */
                LSL     r2,r2,#6
                MCR     p15,0,r2,c11,c7,0   ;/* Set NumOfLines (1line = 64bytes) */
                MOV     r0,#0				; set the PLE Channel Number Register to the appropriate PLE channel
                MCR     p15,0,r0,c11,c3,1   ;/* Start PLE */ ; start command triggers data to be transferred to or from the L2 cache RAM as defined by DT bit [30] of the L2 PLE Control Reg        
1               MRC     p15,0,r0,c11,c8,0   ;/* Get status */
                CMP     r0,#0x3				; 0x3 means complete or error state.
                BNE     %B1

                MOV     r0,#0				; set the PLE Channel Number Register to the appropriate PLE channel
                MCR     p15,0,r0,c11,c3,2   ;/* Clear PLE */ ; Channel status transitions from error or complete to idle and the interrupt or error flag is cleared to 0
2               MRC     p15,0,r0,c11,c8,0   ;/* Get status */
                CMP     r0,#0x0				; 0x0 means idle or reset state
                BNE     %B2

                MOV     pc,lr               ;/* Return */
                LTORG

                EXPORT  CoStopPLE
CoStopPLE
                ;/* PLE Channel Number is always 0 */
                MOV     r0,#0				; set the PLE Channel Number Register to the appropriate PLE channel
                MCR     p15,0,r0,c11,c3,0   ;/* Stop PLE */ ; Stop command triggers data to be transferred to or from the L2 cache RAM as defined by DT bit [30] of the L2 PLE Control Reg

                MOV     pc,lr               ;/* Return */
                LTORG

                EXPORT  CoNonSecureAccCtrl
CoNonSecureAccCtrl
                ;/*  */
                MOV     r0,#(0x73<<12)		; set PLE, TL, CL, CP[n] to secure and non-secure accessible
                ORR		r0,r0,#(0xf<<8)
                ORR		r0,r0,#(0xff)
                MCR     p15,0,r0,c1,c1,2    ; Write Nonsecure Access Control Register data

                MOV     pc,lr               ;/* Return */
                LTORG

                EXPORT  CoGetCacheSizeID
CoGetCacheSizeID
                ;/* r0=current cache size ID */
                MOV     r0,#0
                MRC     p14,0,r0,c0,c0,0    ;/* Reads current Cache Size ID register */

                MOV     pc,lr               ;/* Return */
                LTORG

                EXPORT  CoGetPAreg
CoGetPAreg
                ;/* r0=PA reg value */
                MOV     r0,#0
                MRC     p15,0,r0,c7,c4,0    ;/* Read PA Register */

                MOV     pc,lr               ;/* Return */
                LTORG

                EXPORT  CoGetNormalMemRemapReg
CoGetNormalMemRemapReg
                ;/* r0=Normal Memory Remap reg value */
                MOV     r0,#0
                MRC     p15,0,r0,c10,c2,1   ;/* Read Normal Memory Remap Register */

                MOV     pc,lr               ;/* Return */
                LTORG
                
;                EXPORT  CoInvalidateDCacheForV7
;CoInvalidateDCacheForV7
;                PUSH    {r4-r10,lr}
;                MRC     p15,1,r0,c0,c0,1    ;/* Read CLIDR */
;                ANDS    r3,r0,#&7000000
;                MOV     r3,r3,LSR #23       ;/* Total cache levels << 1 */
;                BEQ     Finished
;
;                MOV     r10,#0              ;/* R10 holds current cache level << 1 */
;Loop1           ADD     r2,r10,r10,LSR #1   ;/* R2 holds cache "Set" position */
;                MOV     r1,r0,LSR r2        ;/* Bottom 3 bits are the Cache-type for this level */
;                AND     r1,R1,#7            ;/* Get those 3 bits alone */
;                CMP     r1,#2
;                BLT     Skip                ;/* No cache or only instruction cache at this level */
;
;                MCR     p15,2,r10,c0,c0,0   ;/* Write the Cache Size selection register */
;                MOV     r1,#0
;                MCR     p15,0,r1,c7,c5,4    ;/* PrefetchFlush to sync the change to the CacheSizeID reg */
;                MRC     p15,1,r1,c0,c0,0    ;/* Reads current Cache Size ID register */
;                AND     r2,r1,#&7           ;/* Extract the line length field */
;                ADD     r2,r2,#4            ;/* Add 4 for the line length offset (log2 16 bytes) */
;                LDR     r4,=0x3FF
;                ANDS    r4,r4,r1,LSR #3     ;/* R4 is the max number on the way size (right aligned) */
;                CLZ     r5,r4               ;/* R5 is the bit position of the way size increment */
;                LDR     r7,=0x00007FFF
;                ANDS    r7,r7,r1,LSR #13    ;/* R7 is the max number of the index size (right aligned) */
;
;Loop2           MOV     r9,r4               ;/* R9 working copy of the max way size (right aligned) */
;Loop3           ORR     r11,r10,r9,LSL r5   ;/* Factor in the Way number and cache number into R11 */
;                ORR     r11,r11,r7,LSL r2   ;/* Factor in the Set number */
;                MCR     p15,0,r11,c7,c14,2  ;/* Clean and Invalidate by set/way */
;                SUBS    r9,r9,#1            ;/* Decrement the Way number */
;                BGE     Loop3
;                SUBS    r7,r7,#1            ;/* Decrement the Set number */
;                BGE     Loop2
;Skip            ADD     r10,r10,#2          ;/* increment the cache number */
;                CMP     r3,r10
;                BGT     Loop1
;Finished
;                POP     {r4-r10,pc}
;                LTORG

                EXPORT  CoSetExceptonVectoerBase
CoSetExceptonVectoerBase
                ;/* r0=uBaseAddr */
                MCR     p15,0,r0,c12,c0,0
                MOV     pc,lr

                EXPORT  CoSetProcessId
CoSetProcessId
                ;/* r0 =u32 pid */
                MCR     p15,0,r0,c13,c0,0
                MOV     pc,lr

                EXPORT  CoSetMpll
CoSetMpll
                ;/* r0 = param */
                MOV     r2,r0
                LDR     r0,=0x0000C000
                ORR     r0,r0,r2
                MCR     p15,0,r0,c15,c12,0
0
                MRC     p15,0,r1,c15,c12,0
                TST     r1,#0x00800000
                BEQ     %B0
                MOV     pc,lr




					EXPORT	CoReadDFSR
CoReadDFSR			PROC
					mrc		p15,0,r0,c5,c0,0
					mov		pc,lr
					ENDP
				

					EXPORT	CoReadIFSR
CoReadIFSR			PROC
					mrc		p15,0,r0,c5,c0,1
					mov		pc,lr
					ENDP

					EXPORT	CoReadFAR
CoReadFAR			PROC
					mrc		p15,0,r0,c6,c0,0
					mov		pc,lr
					ENDP   

;-------------------------------------------------------


				EXPORT IsrIRQ
IsrIRQ
				sub		sp,sp,#4			; reserved for PC
				stmfd	sp!,{r8}
				ldr		r8,=0xF2000F00		; rVIC0ADDR  edited by junon
				ldr		r8,[r8]
				str		r8,[sp,#4]
				ldmfd	sp!,{r8,pc}


				EXPORT burst8_memcpy
burst8_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r3,r5-r12,lr}
				mov		r2, r2, LSR #5
loop8				
				ldmia	r1!,{r5-r12}					; 
				stmia	r0!,{r5-r12}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop8	 
 
				ldmia	r13!,{r0-r3,r5-r12,pc}

				EXPORT burst2_memcpy_writeonly
burst2_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r5,r9-r12,lr}
				mov		r1, r1, LSR #3
				mov		r2,#0
				mov		r3,#0xFFFFFFFF
				;ldr		r2,=0x0
				;ldr		r3,=0x000fffff
loop2_w				
				stmia	r0!,{r2-r3}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop2_w		 
 
				ldmia	r13!,{r0-r5,r9-r12,pc}
				
				EXPORT burst4_memcpy_writeonly
burst4_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r5,r9-r12,lr}
				mov		r1, r1, LSR #4
				;mov		r2,#0x0
				;mov		r3,#0xffffffff
				;mov		r4,#0x0
				;mov		r5,#0xffffffff
				ldr		r2,=0xffffffff
				ldr		r3,=0x0
				ldr		r4,=0xffffffff
				ldr		r5,=0x0

loop4_w				
				stmia	r0!,{r2-r5}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop4_w	 
 
				ldmia	r13!,{r0-r5,r9-r12,pc}


				EXPORT burst8_memcpy_writeonly
burst8_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r12,lr}
				mov		r1, r1, LSR #5
				mov		r2,#0
				mov		r3,#0xFFFFFFFF
				mov		r4,#0
				mov		r5,#0xFFFFFFFF
				mov		r6,#0
				mov		r7,#0xFFFFFFFF
				mov		r8,#0
				mov		r9,#0xFFFFFFFF
loop8_w				
				stmia	r0!,{r2-r9}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop8_w	 
 
				ldmia	r13!,{r0-r12,pc}
				
				EXPORT burst4_memcpy_readonly
burst4_memcpy_readonly
				; r0 : Source Address
				; r1 : Size
				stmdb	r13!,{r0-r5,r9-r12,lr}
				mov		r1, r1, LSR #4
loop4_r				
				ldmia	r0!,{r2-r5}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop4_r	 
 
				ldmia	r13!,{r0-r5,r9-r12,pc}

				
				EXPORT	burst2_memcpy
burst2_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r2,r11-r12,lr}
				mov		r2, r2, LSR #3
loop2				
				ldmia	r1!,{r11-r12}					; 
				stmia	r0!,{r11-r12}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop2	 
 
				ldmia	r13!,{r0-r2,r11-r12,pc}

				
						
                END

