/**************************************************************************************
* 
*	Project Name : S5PC100 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PC100.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : system.h
*  
*	File Description : This file declares prototypes of system funcions.
*
*	Author : Haksoo,Kim
*	Dept. : AP Development Team
*	Created Date : 2006/11/08
*	Version : 0.1 
* 
*	History
*	- Created(Haksoo,Kim 2006/11/08)
*  
**************************************************************************************/

#ifndef __SYSTEM_H__
#define __SYSTEM_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"

extern volatile u32 g_uProductID, g_uPkgMode, g_uMainRev, g_uSubRev; // Chip & Revision inform
extern volatile u32 g_uAPLL, g_uMPLL, g_uEPLL, g_uVPLL; // SCLKapll,mpll,epll,vpll
extern volatile u32 g_uARMCLK, g_uHclkMsys, g_uHclkDsys, g_uHclkPsys, g_uPclkMsys, g_uPclkDsys, g_uPclkPsys, g_uOneDRAM; // Core & Bus clocks

extern volatile u32 g_uSclkA2M, g_uSclkG3D, g_uSclkMFC;
extern volatile u32 g_uSclkFIMD, g_uSclkMDNIE, g_uSclkMDNIEPWM;
extern volatile u32 g_uSclkFIMC, g_uSclkFIMC0LCLK, g_uSclkFIMC1LCLK, g_uSclkFIMC2LCLK, g_uSclkCAM0, g_uSclkCAM1;
extern volatile u32 g_uSclkPIXEL, g_uSclkHDMIPHY, g_uSclkHDMI, g_uSclkMIXER, g_uSclkTVENC;

void CoEnableIrq(void);
void CoEnableFiq(void);
void CoDisableIrq(void);
void CoDisableFiq(void);
u32  CoSetIF(void); // The return value is the current CPSR
void CoWrIF(u32 cpsr);
void CoClrIF(void);

void CoSetProcessId(u32 uId);
void CoStartMmuAndCache(void);
void CoStopMmuAndCache(void);
void CoStartICacheOnly(void);
void CoStartICache(void);
void CoStartL2Cache(void);

void CoEnableVectoredInt(void);
void CoDisableVectoredInt(void);

void CoEnableAlignFault(void);
void CoDisableAlignFault(void);

void CoSetFastBusMode(void); // ARM920 Only, FCLK=BCLK
void CoSetAsyncBusMode(void); // ARM920 Only, FCLK!=BCLK

void CoEnableICache(void);
void CoEnableDCache(void);
void CoDisableDCache(void);
void CoDisableICache(void);

void CoEnableVfp(void);
void CoEnableNeon(void);

void CoEnableBranchPrediction(void);
void CoInvalidateICache(void);
void CoInvalidateICacheVA(u32 va);
void CoPrefetchICacheLineVA(u32 va);
void CoInvalidateDCache(void);
void CoInvalidateDCacheVA(u32 va);
void CoInvalidateDCacheIndex(u32 index);
void CoCleanDCacheVA(u32 va);
void CoCleanDCacheIndex(u32 index);
void CoCleanAndInvalidateDCacheVA(u32 va);
void CoCleanAndInvalidateDCacheIndex(u32 index);
void CoWaitForInterrupt(void); // Valid for ARMv5
void CoSetDCacheLockdownBase(u32 base);
void CoSetICacheLockdownBase(u32 base);
void CoSetDTlbLockdown(u32 baseVictim);
void CoSetITlbLockdown(u32 baseVictim);

void CoEnableMmu(void);
void CoDisableMmu(void);
void CoSetTTBase(u32 base);
void CoSelTTBReg0(void);
void CoSetDomain(u32 domain);
void CoInvalidateITlb(void);
void CoInvalidateITlbVA(u32 va);
void CoInvalidateDTlb(void);
void CoInvalidateDTlbVA(u32 va);
void CoInvalidateBothTlbs(void);

void CoStartMmu(void); ///

void CoEnableL1ParityDetection(void);
void CoDisableL1ParityDetection(void);
void CoEnableL2Cache(void);
void CoDisableL2Cache(void);
void CoSetL2CacheAuxCrtlReg(u32 uRegValue);
void CoSetL2CacheLines(u32 uNumOfLinesTransferred); // 1 line = 64 bytes
void CoCopyToL2Cache(u32 uAddr, u32 uWayNum, u32 uNumOfLines);
void CoCopyFromL2Cache(u32 uAddr, u32 uWayNum, u32 uNumOfLines);
void CoStopPLE(void);
void CoNonSecureAccCtrl(void);
//void CoGetCacheSizeID(u32& uSizeId);
//void CoGetPAreg(u32& uReg);
//void CoGetNormalMemRemapReg(u32& uReg);
void CoLockL2Cache(u32 uWayNum);
void CoUnLockL2Cache(u32 uWayNum);
void CoSetExceptonVectoerBase(u32 uBaseAddr);

u32 CoReadIFSR(void);
u32 CoReadDFSR(void);
u32 CoReadFAR(void);

////////////////// Security //////////////////
void TZPC_Init(void);



#ifdef __cplusplus
}
#endif

#endif /*__SYSTEM_H__*/
