;/*************************************************************************************
; 
;	Project Name : S5PC110 Validation
;
;	Copyright 2006 by Samsung Electronics, Inc.
;	All rights reserved.
;
;	Project Description :
;		This software is only for validating functions of the S5PC100.
;		Anybody can use this software without our permission.
;  
;--------------------------------------------------------------------------------------
; 
;	File Name : startup.s
;  
;	File Description : This file implements the startup procedure.
;
;	Author	: Heemyung.Noh
;	Dept. : AP Development Team
;	Created Date : 2008/02/20
;	Version : 0.1 
; 
;	History
;	- Created for Scatterloading option(Heemyung.Noh 2008/02/20)
;  
;*************************************************************************************/

				GET		option.inc

				MACRO
$HandlerLabel 	HANDLER		$HandleLabel

$HandlerLabel
				sub		sp,sp,#4        		;decrement sp(to store jump address)
				stmfd	sp!,{r0}        		;PUSH the work register to stack(lr doesnt push because it return to original address)
				ldr     	r0,=$HandleLabel	;load the address of HandleXXX to r0
				ldr     	r0,[r0]         		;load the contents(service routine start address) of HandleXXX
				str     	r0,[sp,#4]      		;store the contents(ISR) of HandleXXX to stack
				ldmfd   	sp!,{r0,pc}     	;POP the work register and pc(jump to ISR)

				MEND

;=======================================================
;						ENTRY  
;=======================================================

				AREA    Init,CODE,READONLY

				
		              EXPORT  ResetHandler

				ENTRY 

				IMPORT IsrIRQ
				IMPORT CoSetExceptonVectoerBase
				;IMPORT ScatterLoad
				IMPORT |Image$$RO$$Base|
				IMPORT  __main   			; The main entry of mon program 
				
				b		ResetHandler
				b		HandlerUndef
				b		HandlerSWI
				b		HandlerPabort
				b		HandlerDabort
				b		.
				b		HandlerIRQ
				b		HandlerFIQ

HandlerUndef		HANDLER HandleUndef
HandlerSWI		HANDLER HandleSWI
HandlerPabort		HANDLER HandlePabort
HandlerDabort		HANDLER HandleDabort
HandlerIRQ		HANDLER	HandleIRQ
HandlerFIQ		HANDLER	HandleFIQ

ResetHandler

				; WatchDog timer disable
				ldr		r0,=0xE2700000
				mov		r1,#0
				str		r1,[r0]
 
 	IF :DEF: Cortex
				LDR		r0,=|Image$$RO$$Base|
				BL		CoSetExceptonVectoerBase

				LDR     r0,=0xffffffff
	        		MCR     p15,0,r0,c1,c0,2 ;/* Enable coprocessors */
	        		MOV     R0,#0x40000000
	        		VMSR    FPEXC,r0 ;/* Globally enable NEON & VFP */
	ENDIF
	
			   	bl		__main
			   	b		.

			   	
;=======================================================		

				LTORG
				

			   	ALIGN

			   	AREA IntVector, DATA, READWRITE

				^   Exception_Vector

HandleReset 	#   4
HandleUndef 	#   4
HandleSWI   	#   4
HandlePabort    #   4
HandleDabort    #   4
HandleReserved  #   4
HandleIRQ   	#   4
HandleFIQ   	#   4

		        END

