;/*************************************************************************************
; 
;	Project Name : S5PC110 Validation
;
;	Copyright 2006 by Samsung Electronics, Inc.
;	All rights reserved.
;
;	Project Description :
;		This software is only for validating functions of the S5PC100.
;		Anybody can use this software without our permission.
;  
;--------------------------------------------------------------------------------------
; 
;	File Name : retarget_.s
;  
;	File Description : This file implements the stack & heap initilaization
;
;	Author	: GOM
;	Dept. : AP Development Team
;	Created Date : 2009/02/06
;	Version : 0.1 
; 
;	History
;	- Created(GOM 2009/02/06)
;  
;*************************************************************************************/

				GET		option.inc
				

				AREA	|C$$code|, CODE, READONLY


Mode_USR		EQU		0x10
Mode_FIQ		EQU		0x11
Mode_IRQ		EQU		0x12
Mode_SVC		EQU		0x13
Mode_ABT		EQU		0x17
Mode_UND		EQU		0x1b
Mode_SYS		EQU		0x1f

I_Bit				EQU		0x80
F_Bit			EQU		0x40

Size_FIQ_Stack	EQU		256
Size_IRQ_Stack	EQU		1024
Size_ABT_Stack	EQU		256
Size_UND_Stack	EQU		256
Size_SVC_Stack	EQU		1024


Offset_FIQ_Stack	EQU     0
Offset_IRQ_Stack	EQU     Offset_FIQ_Stack + Size_FIQ_Stack
Offset_ABT_Stack	EQU     Offset_IRQ_Stack + Size_IRQ_Stack
Offset_UND_Stack	EQU     Offset_ABT_Stack + Size_ABT_Stack
Offset_SVC_Stack	EQU     Offset_UND_Stack + Size_UND_Stack

				
				EXPORT	__user_initial_stackheap

__user_initial_stackheap

				ldr		r0,=top_of_stacks

				msr		CPSR_c,#Mode_FIQ:OR:I_Bit:OR:F_Bit
				mov		sp, r0
				sub		r0, r0, #Offset_FIQ_Stack

				msr		CPSR_c,#Mode_IRQ:OR:I_Bit:OR:F_Bit
				mov		sp, r0
				sub     	r0, r0, #Offset_IRQ_Stack

				msr		CPSR_c,#Mode_ABT:OR:I_Bit:OR:F_Bit
				mov		sp, r0
				sub		r0, r0, #Offset_ABT_Stack

				msr		CPSR_c,#Mode_UND:OR:I_Bit:OR:F_Bit
				mov		sp, r0
				sub		r0, r0, #Offset_UND_Stack

				msr		CPSR_c,#Mode_SVC:OR:I_Bit:OR:F_Bit
				sub		r1, r0, #Offset_SVC_Stack
				
				ldr		r0, =base_of_heap
				
				mov		pc,lr

				LTORG
   
				END
