/**************************************************************************************
* 
*	Project Name : S5PC100 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PC100.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : option.h
*  
*	File Description : This file defines basic setting and configuration.
*
*	Author : Haksoo,Kim
*	Dept. : AP Development Team
*	Created Date : 2006/11/08
*	Version : 0.1 
* 
*	History
*	- Created(Haksoo,Kim 2006/11/08)
*  
**************************************************************************************/

#ifndef __OPTION_H__
#define __OPTION_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"

///////////////////////// user setting //////////////////////

// semi-hosting
#define	SEMIHOSTING			(false)
#define Cortex

//#define FPGA
//#define EVT1
#define	POP						(false)

//#define SRAM_BOOT			

//////////////////////////////////////////////////////////


#ifdef FPGA

#define	FIN						12000000

#define	_SMC_BaseAddress		0x80000000

// OneDram 96MB address
#define	_DRAM01_BaseAddress		0x30000000
#define	_DRAM01_LimitAddress	0x36000000	// 96MB

#define	_DRAM0_BaseAddress		0x20000000
#define	_DRAM0_LimitAddress		0x28000000	// 96MB : 0x06000000, 128MB : 0x08000000
#define	_DRAM1_BaseAddress		0x40000000
#define	_DRAM1_LimitAddress		0x48000000		

#define _DRAM_BaseAddress		_DRAM0_BaseAddress
#define _DRAM_LimitAddress		_DRAM0_LimitAddress

#define	DefaultDownloadAddress	(_DRAM_BaseAddress+0x00000000)

#define DMAC_CODE_BASE 			(_DRAM_BaseAddress+0x04000000)
#define CODEC_MEM_ST			(_DRAM_BaseAddress+0x01000000)
#define CODEC_MEM_LMT  			(_DRAM_BaseAddress+0x04000000)

#define MFC_BUFFER_BASE 		(_DRAM0_LimitAddress+0x02000000)

#define DBG_UART_CH	1

#else // Silicon

#define	FIN						24000000

#define	_SMC_BaseAddress		0x80000000

// OneDram 96MB address
#define	_DRAM01_BaseAddress		0x30000000
#define	_DRAM01_LimitAddress	0x36000000	// 96MB

#define	_DRAM0_BaseAddress		0x20000000
#define	_DRAM0_LimitAddress		0x26000000	// 96MB : 0x06000000, 128MB : 0x08000000
#define	_DRAM1_BaseAddress		0x40000000
#define	_DRAM1_LimitAddress		0x48000000		

#define	_DRAM_BaseAddress		_DRAM1_BaseAddress	// Code base address
#define	_DRAM_LimitAddress		_DRAM1_LimitAddress

#define	DefaultDownloadAddress	(_DRAM_BaseAddress+0x00100000)

#define	DMAC_CODE_BASE 			(_DRAM_BaseAddress+0x04000000)
#define	CODEC_MEM_ST			(_DRAM_BaseAddress+0x01000000)
#define	CODEC_MEM_LMT  			(_DRAM_BaseAddress+0x04000000)	

#define MFC_BUFFER_BASE 		(_DRAM0_LimitAddress+0x02000000)

#ifdef EVT1
#define DBG_UART_CH	2
#else // EVT0
#define DBG_UART_CH 3
#endif

#endif // ifndef FPGA


#ifdef SRAM_BOOT
#define	_MMUTT_BaseAddress		(_SMC_BaseAddress+0x001F0000)	// edited by junon
#define	_Exception_Vector		(_SMC_BaseAddress+0x001FFF00)
#else
#define	_MMUTT_BaseAddress		(_DRAM_BaseAddress+0x07ff8000) //128MB:0x07ff8000, 96MB(OneDram):0x05ff8000
#define	_Exception_Vector		(_DRAM_BaseAddress+0x07FFFF00) //128MB:0x07FFFF00, 96MB(OneDram):0x05FFFF00
#endif // SRAM_BOOT


#define MMU_CB			(0)
#define	MMU_CNB		(1)
#define	MMU_NCB		(2)
#define MMU_NCNB		(3)


#ifdef __cplusplus
}
#endif

#endif /*__OPTION_H__*/


