/**************************************************************************************
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : AsyncBridge_test.c
*  
*	File Description : 
*
*	Author : 
*	Dept. : AP Development Team
*	Created Date :
*	Version : 0.0
* 
*	History
*	- 
*   
**************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "AsyncBridge.h"


void AsyncBridge_test(void);
void AsyncBridge_Set_normal(void);


void AsyncBridge_Init_Test()
{
u32 uIndex;
u32 uTempHalf, uTempIndex;



	for(uIndex=0;uIndex<6;uIndex++)
		{


	Async_Init(ASYNC9_BASE , false, uIndex,FALSE);
	uTempHalf= Inp32(ASYNC9_BASE);
	uTempIndex=Inp32(ASYNC9_BASE+0x4);
	Disp("Half Enable : %d \n", uTempHalf);
	Disp("Index : %d \n", uTempIndex);

	while(!UART_GetKey()){};
	Async_Init(ASYNC9_BASE , TRUE, uIndex,FALSE);
	uTempHalf= Inp32(ASYNC9_BASE);
	uTempIndex=Inp32(ASYNC9_BASE+0x4);
	Disp("Half Enable : %d \n", uTempHalf);
	Disp("Index : %d \n", uTempIndex);
	while(!UART_GetKey()){};
		}


}

void AsyncBridge_Set_normal()
{
	Async_Init(ASYNC0_BASE , TRUE, 0,FALSE); 	//BETWEEN MFC AND VSYS0, 200Mhz<->200Mhz
	Async_Init(ASYNC1_BASE , TRUE, 0,FALSE); 	//BETWEEN MFC AND VSYS1, 200Mhz<->200Mhz
	Async_Init(ASYNC2_BASE , TRUE, 0,FALSE); 	//BETWEEN DSYS AND MSYS0, 200Mhz(but DMC0 166Mhz)<->166Mhz
	Async_Init(ASYNC3_BASE , TRUE, 1,FALSE);	//BETWEEN DSYS AND MSYS1, 200Mhz(but DMC1 200Mhz)<->166Mhz
	Async_Init(ASYNC4_BASE , TRUE, 0,FALSE);	//BETWEEN MSFR AND DSFR 
	Async_Init(ASYNC5_BASE , TRUE, 0,FALSE);	//BETWEEN MSFR AND PSFR  
	Async_Init(ASYNC6_BASE , TRUE, 0,FALSE);	//BETWEEN MSYS AND DMC0 
	Async_Init(ASYNC7_BASE , TRUE, 0,FALSE);	//BETWEEN MSFR AND MPERI 
	Async_Init(ASYNC8_BASE , TRUE, 2,FALSE);	//BETWEEN PSYS AND DSYS, 166Mhz(Dsys)<->133Mhz(Psys)
	Async_Init(ASYNC9_BASE , TRUE, 0,FALSE);	//BETWEEN AUDIO AND PSYS (???)
	Async_Init(ASYNC10_BASE , TRUE, 0,FALSE);	//BETWEEN PSFR AND AUDIO 
}



void AsyncBridge_test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;
	u32 addr;


	const testFuncMenu g_aAsyncBridgeTestFunc[]=
	{

        AsyncBridge_Init_Test,                              "Async Bridge Init test",

		0, 0
	};
	
	while(1)
	{
		UART_Printf("\n\n============= AsyncBridge Function Test =================\n\n");

		for (uCountFunc=0; (u32)(g_aAsyncBridgeTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aAsyncBridgeTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel = UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(sizeof(g_aAsyncBridgeTestFunc)/8-1))
			(g_aAsyncBridgeTestFunc[iSel].func) ();
	}


}


