/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : ddi_mipi_dummy.c
*  
*	File Description : This file describe Specification of MIPI DDI Pannel. 
*
*	Author : Sung-Hyun, Na
*	Dept. : AP Development Team
*	Created Date : 2009/04/05
*	Version : 0.1 
* 
*	History
*	- Created(Sung-Hyun, Na 2009/04/05)
*  
**************************************************************************************/
#include <stdlib.h>
#include "ddi_mipi_dummy.h" 

static DDI_Handler* g_pHandlerMIPIDummy;
static DDI_Spec* g_oSpecMIPIDummy = NULL;

//////////
// Function Name : MIPIDummy_Init
// Function Description : This function initilize DSI DDI
// Input : 	None
// Output :	None
// Version : v0.0
u32 MIPIDummy_Init(u32 uVar0, u32 uVar1)
{	
	DCS_Infor* pDCS = (DCS_Infor*) (g_pHandlerMIPIDummy->m_uGlobalParameter[0]);
	
	DCS_SoftReset(pDCS);			//S/W Reset
	DCS_ExitSleepMode(pDCS);	
	#if 1
	if ( g_oSpecMIPIDummy->m_02eBgBpp == RGB565 )
		DCS_SetPixelFormat(pDCS, 0x40);			// Set Pixel Format	
	else if ( g_oSpecMIPIDummy->m_02eBgBpp == RGB888 )
		DCS_SetPixelFormat(pDCS, 0x77);			// Set Pixel Format	
	else if ( g_oSpecMIPIDummy->m_02eBgBpp == RGB666)
	{
		DCS_SetPixelFormat(pDCS, 0x60);			// Set Pixel Format	
	}
	#endif
	DCS_SetDisplayOn(pDCS);
	DCS_EnterNormalMode(pDCS);	
	//DCS_SetAddressMode(pDCS, 0x50);
	//DDI_CMD(TurnOn, 0 ,0);
	return true;
}

//////////
// Function Name : MIPIDummy_Down
// Function Description : This function initilize DSI DDI
// Input : 	None
// Output :	None
// Version : v0.0
u32 MIPIDummy_Down(u32 uVar0, u32 uVar1)
{	
	return true;
}
//////////
// Function Name : MIPIDummy_CreateSpec
// Function Description : This function initilize DSI DDI
// Input : 	None
// Output :	None
// Version : v0.0
DDI_Spec* MIPIDummy_GetSpec(void)
{
	if ( !g_oSpecMIPIDummy )
	{
		g_oSpecMIPIDummy = (DDI_Spec*) malloc(sizeof(DDI_Spec));
		if ( g_oSpecMIPIDummy )
		{
			//for LCDC Configuration
			g_oSpecMIPIDummy->m_00uHoriSize = 320;
			g_oSpecMIPIDummy->m_01uVertiSize = 480;
			g_oSpecMIPIDummy->m_02eBgBpp = RGB888;
			g_oSpecMIPIDummy->m_03Interface = MIPI_Video;
			g_oSpecMIPIDummy->m_04FrameRate = 60;
				
			// Parameters
			g_oSpecMIPIDummy->m_uParaMeter[VBackPorch] 	= 0x7;
			g_oSpecMIPIDummy->m_uParaMeter[VFrontPorch]	= 0x3;
			g_oSpecMIPIDummy->m_uParaMeter[HBackPorch] 	= 0x19;
			g_oSpecMIPIDummy->m_uParaMeter[HFrontPorch]	= 0x19;
			g_oSpecMIPIDummy->m_uParaMeter[VSyncArea] 	= 0x6;
			g_oSpecMIPIDummy->m_uParaMeter[HSyncArea] 	= 0x3;
			g_oSpecMIPIDummy->m_uParaMeter[VCLKPol] 	= true;
			g_oSpecMIPIDummy->m_uParaMeter[HsyncPol] 	= false;
			g_oSpecMIPIDummy->m_uParaMeter[VSyncPol] 	= false;
			g_oSpecMIPIDummy->m_uParaMeter[VDENPol] 	= false;
			g_oSpecMIPIDummy->m_uParaMeter[DSI_VideoModeSel] = (u32)DSIM_Burst;
			g_oSpecMIPIDummy->m_uParaMeter[DSI_VirtualChID] = (u32)VirtualCh_0;
			g_oSpecMIPIDummy->m_uParaMeter[DSI_CmdAllowLen] = 0xf;
			g_oSpecMIPIDummy->m_uParaMeter[DSI_Format] =(u32)DSIM_24BPP_888;
			
			return g_oSpecMIPIDummy;
		}
		else
			return FALSE;
	}
	else
		return g_oSpecMIPIDummy;
}

//////////
// Function Name : MIPIDummy_CreateSpec
// Function Description : This function initilize DSI DDI
// Input : 	None
// Output :	None
// Version : v0.0
u32 MIPIDummy_DeleteSpec(void)
{
	free(g_oSpecMIPIDummy);
	g_oSpecMIPIDummy = 0;
	return false;
}

//////////
// Function Name : MIPIDummy_SetLink
// Function Description : This function initilize DSI DDI
// Input : 	None
// Output :	None
// Version : v0.0
u8 MIPIDummy_SetLink(DDI_Handler* pDDIHandler)
{
	g_pHandlerMIPIDummy = pDDIHandler;	
	pDDIHandler->m_fnInit = MIPIDummy_Init;
	pDDIHandler->m_fnDown = MIPIDummy_Down;
	
}

