/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : ddi.h
*  
*	File Description : This file handles DDI Pannel.
*
*	Author : Sunghyun,Na
*	Dept. : AP Development Team
*	Created Date : 2009/07/24
*	Version : 0.0 
* 
*	History
*	- 0. Created(Sunghyun,Na 2009/07/24)		
*   
**************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __DDI_H_
#define __DDI_H_
#include "def.h"

typedef enum
{
	RGB_IF = 0x4000,
	I80_IF = 0x8000,
	YUV_601 = 0x10000,
	YUV_656 = 0x20000,
	MIPI_Video = 0x1000,
	MIPI_Command = 0x2000,	
}DDI_Interface;

typedef enum 
{
	//MIPI Model
	//Video Mode
	MIPI_Dummy = MIPI_Video,
	
	
	
	
	
	
	
	// Command Mode
	
} DDI_MODEL;

typedef enum
{
	//RGB Interface Parameter
	VBackPorch = 0,
	VFrontPorch = 1,
	HBackPorch = 2,
	HFrontPorch = 3,
	VSyncArea =  4,
	HSyncArea = 5,
	VCLKPol = 6,
	HsyncPol = 7,
	VSyncPol = 8,
	VDENPol = 9,

	//I80 Interface parameter
	CSSetupTime = VBackPorch,
	WrSetUpTime = VFrontPorch, 
	WrActTime = HBackPorch,
	WrHoldTime = HFrontPorch,
	RSPol = VSyncArea,

	//DSIM Video inteface Parameter
	DSI_VideoModeSel = 10,
	DSI_VirtualChID = 11,
	DSI_CmdAllowLen = 12,	
	DSI_Format = 13,
		
}DDI_Parameter;

typedef struct 
{
	//for LCDC Configuration
	u32 			m_00uHoriSize;
	u32 			m_01uVertiSize;
	IMG_FMT		m_02eBgBpp;
	DDI_Interface		m_03Interface;
	u32				m_04FrameRate;
		
	// Parameters
	u32 m_uParaMeter[32];
}DDI_Spec;

typedef struct 
{
	DDI_MODEL m_eModel;
	Connectivity_Link m_eLink;
	u32 m_uLinkHandler;
	u32 m_uGlobalParameter[2];

	u32 m_uPrivateParamter[2];

	//DDI Specification
	DDI_Spec* m_pDDISpec;	
	
	//API of DDI Init
	u32 (*m_fnInit)(u32, u32);
	//API of DDI Down
	u32 (*m_fnDown)(u32, u32);
	
	// API of DDI
	void (*m_fnAPI[16])(u32);	// Additional APIs
}DDI_Handler;

typedef struct
{
	u8*	m_pReadBuffer;
	u32	m_uSize;
	u32 m_ReturnSize;
}ReadStruct;

DDI_Spec* DDI_GetSpec(DDI_MODEL eDDI);
DDI_Handler* DDI_Create(DDI_MODEL eDDI, Connectivity_Link eLink, u32 uLinkHandler, u32 uVar0, u32 uVar1);
u8 DDI_Destory(DDI_Handler* pDDIHandler, u32 uVar0, u32 uVar1, u32 uVar2);

#endif

#ifdef __cplusplus
}
#endif