/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : ddi.c
*  
*	File Description : This file handles DDI Pannel.
*
*	Author : Sung-Hyun, Na
*	Dept. : AP Development Team
*	Created Date : 2009/07/24/
*	Version : 0.0 
* 
*	History
*	- Created(Sung-Hyun, Na 2009/07/24)
*  
**************************************************************************************/
#include <stdlib.h>
#include <string.h>

#include "def.h"
#include "ddi.h"
#include "library.h"
#include "uart.h"

//MIPI DSIM Video Module
#include "ddi_mipi_dummy.h" 
//MIPI DSIM Command Module


//////////
// Function Name : DDI_Create
// Function Description : 
//   This function create DDI Handler
// Input : 	DDI_MODEL - DDI Model
//			Connectivity_Link - Link Selection to Control DDI 
//			u32 - uLinkHandler : Link Handler
//			u32 - uVar0 : Variable 0 
//			u32 - uVar1 : Variable 1
// Output : Address of DDI_Handler or False
// Version : v0.0
DDI_Spec* DDI_GetSpec(DDI_MODEL eDDI)
{
	switch(eDDI)
	{
		case MIPI_Dummy:
			return (DDI_Spec*) (MIPIDummy_GetSpec());		
		default:
			Disp("This DDI Model is not embodied for S5PV210 Verification Project\n");
			return false;
	}
}

//////////
// Function Name : DDI_Create
// Function Description : 
//   This function create DDI Handler
// Input : 	DDI_MODEL - DDI Model
//			Connectivity_Link - Link Selection to Control DDI 
//			u32 - uLinkHandler : Link Handler
//			u32 - uVar0 : Variable 0 
//			u32 - uVar1 : Variable 1
// Output : Address of DDI_Handler or False
// Version : v0.0
DDI_Handler* DDI_Create(DDI_MODEL eDDI, Connectivity_Link eLink, u32 uLinkHandler, u32 uVar0, u32 uVar1)
{
	DDI_Handler* pHandler = (DDI_Handler*) malloc(sizeof(DDI_Handler));
	
	if (pHandler)
	{
		pHandler->m_eLink = eLink;
		pHandler->m_uLinkHandler = uLinkHandler;
		pHandler->m_uGlobalParameter[0] = uVar0;
		pHandler->m_uGlobalParameter[1] = uVar1;
		switch(eDDI)
		{
			case MIPI_Dummy:
				pHandler->m_pDDISpec = (DDI_Spec*) (MIPIDummy_GetSpec());
				MIPIDummy_SetLink(pHandler);
				break;			
			default:
				Disp("This DDI Model is not embodied for S5PV210 Verification Project\n");
				return false;
		}
		return pHandler;		
	}
	else 
	{	
		Disp("DDI Interface is not created!!\n");
		return false;
	}
}

//////////
// Function Name : DDI_Destory
// Function Description : 
//   This function destroy ddi handler 
// Input : 	DDI_Handler* - DDI Handler
//			uVar0 - Variable 0
//			uVar1 - Variable 1
//			uVar2 - Variable 2
//			uVar3 - Variable 3
// Output : True/False
// Version : v0.0
u8 DDI_Destory(DDI_Handler* pDDIHandler, u32 uVar0, u32 uVar1, u32 uVar2)
{
	if ( pDDIHandler != NULL)
	{
		#if 0
		switch(pDDIHandler->m_eModel)
		{
			case MIPI_Dummy:
				MIPIDummy_DeleteSpec();				
				break;			
			default:
				Disp("This DDI Model is not embodied for S5PV210 Verification Project");
				return false;
		}
		#endif		
		// if there is sequence before closing lcd pannel, write here
		memset(pDDIHandler, 0, sizeof(DDI_Handler));
		free(pDDIHandler);
		return true;
	}
	else
		return false;
}
