/*
 * (C) Copyright 2008
 * Jongpill Lee, Samsung Erectronics, boyko.lee@samsung.com.
 *      - only support for S5P6442
 *  $Id: s5pc100.h,v 1.4 2008/11/25 06:15:10 boyko Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/************************************************
 * NAME	    : s5p6442.h
 *
 ************************************************/

#ifndef __S5P6442_H__
#define __S5P6442_H__

#ifndef CONFIG_S5P6442
#define CONFIG_S5P6442			1
#endif

#define S5P644X_UART_CHANNELS		3
#define S5P644X_SPI_CHANNELS		2

#include <asm/hardware.h>

#ifndef __ASSEMBLY__
typedef enum {
	S5P644X_UART0,
	S5P644X_UART1,
	S5P644X_UART2,
	S5P644X_UART3,
} S5P644X_UARTS_NR;

#include <s5p644x.h>
#endif

#define BIT0 				0x00000001
#define BIT1 				0x00000002
#define BIT2 				0x00000004
#define BIT3 				0x00000008
#define BIT4 				0x00000010
#define BIT5 				0x00000020
#define BIT6				0x00000040
#define BIT7				0x00000080
#define BIT8				0x00000100
#define BIT9				0x00000200
#define BIT10				0x00000400
#define BIT11				0x00000800
#define BIT12				0x00001000
#define BIT13				0x00002000
#define BIT14				0x00004000
#define BIT15				0x00008000
#define BIT16				0x00010000
#define BIT17				0x00020000
#define BIT18				0x00040000
#define BIT19				0x00080000
#define BIT20				0x00100000
#define BIT21				0x00200000
#define BIT22				0x00400000
#define BIT23				0x00800000
#define BIT24				0x01000000
#define BIT25				0x02000000
#define BIT26				0x04000000
#define BIT27				0x08000000
#define BIT28				0x10000000
#define BIT29				0x20000000
#define BIT30				0x40000000
#define BIT31				0x80000000


/* S5P6442 device base addresses */
#define ELFIN_DMA_BASE			0xE9000000
#define ELFIN_LCD_BASE			0xEE000000
#define ELFIN_USB_HOST_BASE		0xED400000
#define ELFIN_I2C_BASE			0xEC100000
#define ELFIN_I2S_BASE			0xF2200000
#define ELFIN_ADC_BASE			0xF3000000
#define ELFIN_SPI_BASE			0xEC300000


#define ELFIN_HSMMC_0_BASE		0xED800000
#define ELFIN_HSMMC_1_BASE		0xED900000
#define ELFIN_HSMMC_2_BASE		0xEDA00000

#define ELFIN_CLOCK_POWER_BASE		0xE0100000

#define IO_RET_REL			(1 << 31)

/* Clock & Power Controller for s5p6442*/
#define APLL_LOCK_OFFSET		0x00
#define MPLL_LOCK_OFFSET		0x08
#define EPLL_LOCK_OFFSET		0x10
#define VPLL_LOCK_OFFSET		0x20
#define APLL_CON_OFFSET			0x100
#define MPLL_CON_OFFSET			0x108
#define EPLL_CON_OFFSET			0x110
#define VPLL_CON_OFFSET			0x120

#define CLK_SRC0_OFFSET			0x200
#define CLK_SRC1_OFFSET			0x204
#define CLK_SRC2_OFFSET			0x208
#define CLK_SRC3_OFFSET			0x20c
#define CLK_SRC4_OFFSET			0x210
#define CLK_SRC5_OFFSET			0x214
#define CLK_SRC6_OFFSET			0x218
#define CLK_SRC_MASK0_OFFSET		0x280
#define CLK_SRC_MASK1_OFFSET		0x284

#define CLK_DIV0_OFFSET			0x300
#define CLK_DIV1_OFFSET			0x304
#define CLK_DIV2_OFFSET			0x308
#define CLK_DIV3_OFFSET			0x30c
#define CLK_DIV4_OFFSET			0x310
#define CLK_DIV5_OFFSET			0x314
#define CLK_DIV6_OFFSET			0x318

#define CLK_GATE_IP0_OFFSET		0x460
#define CLK_GATE_IP1_OFFSET		0x464
#define CLK_GATE_IP2_OFFSET		0x468
#define CLK_GATE_IP3_OFFSET		0x46c
#define CLK_GATE_IP4_OFFSET		0x470
#define CLK_GATE_BLOCK_OFFSET		0x480

#define CLK_OUT_OFFSET			0x500
#define CLK_DIV_STAT0_OFFSET		0x1000
#define CLK_DIV_STAT1_OFFSET		0x1004
#define CLK_MUX_STAT0_OFFSET		0x1100
#define CLK_MUX_STAT1_OFFSET		0x1104
#define SW_RST_OFFSET			0x2000

//#define ONEDRAM_CFG_OFFSET		0x6208

#define OSC_CON_OFFSET			0x8000
#define RST_STAT_OFFSET			0xa000
#define PWR_CFG_OFFSET			0xc000
#define	EINT_WAKEUP_MASK_OFFSET		0xc004
#define WAKEUP_MASK_OFFSET		0xc008
#define NORMAL_CFG_OFFSET		0xc010
#define IDLE_CFG_OFFSET			0xc020
#define STOP_CFG_OFFSET			0xc030
#define STOP_MEM_CFG_OFFSET		0xc034
#define SLEEP_CFG_OFFSET		0xc040
#define OSC_FREQ_OFFSET			0xc100
#define OSC_STABLE_OFFSET		0xc104
#define PWR_STABLE_OFFSET		0xc108
#define MTC_STABLE_OFFSET		0xc110
#define CLAMP_STABLE_OFFSET		0xc114
#define WAKEUP_STAT_OFFSET		0xc200
#define BLK_PWR_STAT_OFFSET		0xc204
#define BODY_BIAS_CON_OFFSET		0xc300
#define ION_SKEW_CON_OFFSET		0xc310
#define ION_SKEW_MON_OFFSET		0xc314
#define IOFF_SKEW_CON_OFFSET		0xc320
#define IOFF_SKEW_MON_OFFSET		0xc324
#define OTHERS_OFFSET			0xe000
#define OM_STAT_OFFSET			0xe100

//#define MIE_CONTROL_OFFSET		0xe800		//reserved
//#define HDMI_CONTROL_OFFSET		0xe804		//reserved

#define USB_PHY_CONTROL_OFFSET		0xe80c
#define DAC_CONTROL_OFFSET		0xe810

//#define MIPI_DPHY_CONTROL_OFFSET	0xe814		//reserved
#define ADC_CONTROL_OFFSET		0xe818
#define PS_HOLD_CONTROL_OFFSET		0xe81c

#define INFORM0_OFFSET			0xf000
#define INFORM1_OFFSET			0xf004
#define INFORM2_OFFSET			0xf008
#define INFORM3_OFFSET			0xf00c
#define INFORM4_OFFSET			0xf010
#define INFORM5_OFFSET			0xf014
#define INFORM6_OFFSET			0xf018
#define INFORM7_OFFSET			0xf01c


#define APLL_LOCK_REG			__REG(ELFIN_CLOCK_POWER_BASE+APLL_LOCK_OFFSET)
#define MPLL_LOCK_REG			__REG(ELFIN_CLOCK_POWER_BASE+MPLL_LOCK_OFFSET
#define EPLL_LOCK_REG			__REG(ELFIN_CLOCK_POWER_BASE+EPLL_LOCK_OFFSET)
#define HPLL_LOCK_REG			__REG(ELFIN_CLOCK_POWER_BASE+HPLL_LOCK_OFFSET)
#define APLL_CON_REG			__REG(ELFIN_CLOCK_POWER_BASE+APLL_CON_OFFSET)
#define MPLL_CON_REG			__REG(ELFIN_CLOCK_POWER_BASE+MPLL_CON_OFFSET)
#define EPLL_CON_REG			__REG(ELFIN_CLOCK_POWER_BASE+EPLL_CON_OFFSET)
#define HPLL_CON_REG			__REG(ELFIN_CLOCK_POWER_BASE+HPLL_CON_OFFSET)
#define CLK_SRC0_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC0_OFFSET)
#define CLK_SRC1_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC1_OFFSET)
#define CLK_SRC2_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC2_OFFSET)
#define CLK_SRC3_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC3_OFFSET)
#define CLK_SRC4_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC4_OFFSET)
#define CLK_DIV0_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV0_OFFSET)
#define CLK_DIV1_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV1_OFFSET)
#define CLK_DIV2_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV2_OFFSET)
#define CLK_DIV3_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV3_OFFSET)
#define CLK_DIV4_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV4_OFFSET)
#define CLK_DIV5_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV5_OFFSET)
#define CLK_DIV6_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV6_OFFSET)
#define CLK_DIV7_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV7_OFFSET)

#define CLK_OUT_REG			__REG(ELFIN_CLOCK_POWER_BASE+CLK_OUT_OFFSET)

#define CLK_GATE_IP0_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_IP0_OFFSET)
#define CLK_GATE_IP1_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_IP1_OFFSET)
#define CLK_GATE_IP2_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_IP2_OFFSET)
#define CLK_GATE_IP3_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_IP3_OFFSET)
#define CLK_GATE_IP4_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_IP4_OFFSET)
#define CLK_GATE_BLOCK_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_GATE_BLOCK_OFFSET)

#define CLK_DIV_STAT0_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV_STAT0_OFFSET)
#define CLK_DIV_STAT1_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV_STAT1_OFFSET)
#define CLK_MUX_STAT0_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_MUX_STAT0_OFFSET)
#define CLK_MUX_STAT1_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_MUX_STAT1_OFFSET)


#define AHB_CON0_REG			__REG(ELFIN_CLOCK_POWER_BASE+AHB_CON0_OFFSET)
#define AHB_CON1_REG			__REG(ELFIN_CLOCK_POWER_BASE+AHB_CON1_OFFSET)
#define AHB_CON2_REG			__REG(ELFIN_CLOCK_POWER_BASE+AHB_CON2_OFFSET)
#define SELECT_DMA_REG			__REG(ELFIN_CLOCK_POWER_BASE+SELECT_DMA_OFFSET)
#define SW_RST_REG			__REG(ELFIN_CLOCK_POWER_BASE+SW_RST_OFFSET)
#define SYS_ID_REG			__REG(ELFIN_CLOCK_POWER_BASE+SYS_ID_OFFSET)
#define MEM_SYS_CFG_REG			__REG(ELFIN_CLOCK_POWER_BASE+MEM_SYS_CFG_OFFSET)
#define QOS_OVERRIDE0_REG		__REG(ELFIN_CLOCK_POWER_BASE+QOS_OVERRIDE0_OFFSET)
#define QOS_OVERRIDE1_REG		__REG(ELFIN_CLOCK_POWER_BASE+QOS_OVERRIDE1_OFFSET)
#define MEM_CFG_STAT_REG		__REG(ELFIN_CLOCK_POWER_BASE+MEM_CFG_STAT_OFFSET)
#define PWR_CFG_REG			__REG(ELFIN_CLOCK_POWER_BASE+PWR_CFG_OFFSET)
#define EINT_MASK_REG			__REG(ELFIN_CLOCK_POWER_BASE+EINT_MASK_OFFSET)
#define NOR_CFG_REG			__REG(ELFIN_CLOCK_POWER_BASE+NOR_CFG_OFFSET)
#define STOP_CFG_REG			__REG(ELFIN_CLOCK_POWER_BASE+STOP_CFG_OFFSET)
#define SLEEP_CFG_REG			__REG(ELFIN_CLOCK_POWER_BASE+SLEEP_CFG_OFFSET)
#define OSC_FREQ_REG			__REG(ELFIN_CLOCK_POWER_BASE+OSC_FREQ_OFFSET)
#define OSC_CNT_VAL_REG			__REG(ELFIN_CLOCK_POWER_BASE+OSC_CNT_VAL_OFFSET)
#define PWR_CNT_VAL_REG			__REG(ELFIN_CLOCK_POWER_BASE+PWR_CNT_VAL_OFFSET)
#define FPC_CNT_VAL_REG			__REG(ELFIN_CLOCK_POWER_BASE+FPC_CNT_VAL_OFFSET)
#define MTC_CNT_VAL_REG			__REG(ELFIN_CLOCK_POWER_BASE+MTC_CNT_VAL_OFFSET)
#define OTHERS_REG			__REG(ELFIN_CLOCK_POWER_BASE+OTHERS_OFFSET)
#define RST_STAT_REG			__REG(ELFIN_CLOCK_POWER_BASE+RST_STAT_OFFSET)
#define WAKEUP_STAT_REG			__REG(ELFIN_CLOCK_POWER_BASE+WAKEUP_STAT_OFFSET)
#define BLK_PWR_STAT_REG		__REG(ELFIN_CLOCK_POWER_BASE+BLK_PWR_STAT_OFFSET)

#define PRO_ID_BASE			0xE0000000
#define PRO_ID_OFFSET			0x00
#define OMR_OFFSET			0x04

#define INF_REG_BASE			0xE010F000

#define INF_REG0_OFFSET			0x00
#define INF_REG1_OFFSET			0x04
#define INF_REG2_OFFSET			0x08
#define INF_REG3_OFFSET			0x0c
#define INF_REG4_OFFSET			0x10
#define INF_REG5_OFFSET			0x14
#define INF_REG6_OFFSET			0x18
#define INF_REG7_OFFSET			0x1c

#define INF_REG0_REG			__REG(INF_REG_BASE+INF_REG0_OFFSET)
#define INF_REG1_REG			__REG(INF_REG_BASE+INF_REG1_OFFSET)
#define INF_REG2_REG			__REG(INF_REG_BASE+INF_REG2_OFFSET)
#define INF_REG3_REG			__REG(INF_REG_BASE+INF_REG3_OFFSET)
#define INF_REG4_REG			__REG(INF_REG_BASE+INF_REG4_OFFSET)
#define INF_REG5_REG			__REG(INF_REG_BASE+INF_REG5_OFFSET)
#define INF_REG6_REG			__REG(INF_REG_BASE+INF_REG6_OFFSET)
#define INF_REG7_REG			__REG(INF_REG_BASE+INF_REG7_OFFSET)

#define APLL_LOCK			(ELFIN_CLOCK_POWER_BASE+APLL_LOCK_OFFSET)
#define MPLL_LOCK			(ELFIN_CLOCK_POWER_BASE+MPLL_LOCK_OFFSET)
#define EPLL_LOCK			(ELFIN_CLOCK_POWER_BASE+EPLL_LOCK_OFFSET)
#define APLL_CON			(ELFIN_CLOCK_POWER_BASE+APLL_CON_OFFSET)
#define MPLL_CON			(ELFIN_CLOCK_POWER_BASE+MPLL_CON_OFFSET)
#define EPLL_CON			(ELFIN_CLOCK_POWER_BASE+EPLL_CON_OFFSET)
#define CLK_SRC				(ELFIN_CLOCK_POWER_BASE+CLK_SRC_OFFSET)
#define CLK_DIV0			(ELFIN_CLOCK_POWER_BASE+CLK_DIV0_OFFSET)
#define CLK_DIV1			(ELFIN_CLOCK_POWER_BASE+CLK_DIV1_OFFSET)
#define CLK_DIV2			(ELFIN_CLOCK_POWER_BASE+CLK_DIV2_OFFSET)
#define CLK_OUT				(ELFIN_CLOCK_POWER_BASE+CLK_OUT_OFFSET)
#define HCLK_GATE			(ELFIN_CLOCK_POWER_BASE+HCLK_GATE_OFFSET)
#define PCLK_GATE			(ELFIN_CLOCK_POWER_BASE+PCLK_GATE_OFFSET)
#define SCLK_GATE			(ELFIN_CLOCK_POWER_BASE+SCLK_GATE_OFFSET)
#define AHB_CON0			(ELFIN_CLOCK_POWER_BASE+AHB_CON0_OFFSET)
#define AHB_CON1			(ELFIN_CLOCK_POWER_BASE+AHB_CON1_OFFSET)
#define AHB_CON2			(ELFIN_CLOCK_POWER_BASE+AHB_CON2_OFFSET)
#define SELECT_DMA			(ELFIN_CLOCK_POWER_BASE+SELECT_DMA_OFFSET)
#define SW_RST				(ELFIN_CLOCK_POWER_BASE+SW_RST_OFFSET)
#define SYS_ID				(ELFIN_CLOCK_POWER_BASE+SYS_ID_OFFSET)
#define MEM_SYS_CFG			(ELFIN_CLOCK_POWER_BASE+MEM_SYS_CFG_OFFSET)
#define QOS_OVERRIDE0			(ELFIN_CLOCK_POWER_BASE+QOS_OVERRIDE0_OFFSET)
#define QOS_OVERRIDE1			(ELFIN_CLOCK_POWER_BASE+QOS_OVERRIDE1_OFFSET)
#define MEM_CFG_STAT			(ELFIN_CLOCK_POWER_BASE+MEM_CFG_STAT_OFFSET)
#define PWR_CFG				(ELFIN_CLOCK_POWER_BASE+PWR_CFG_OFFSET)
#define EINT_MASK			(ELFIN_CLOCK_POWER_BASE+EINT_MASK_OFFSET)
#define NOR_CFG				(ELFIN_CLOCK_POWER_BASE+NOR_CFG_OFFSET)
#define STOP_CFG			(ELFIN_CLOCK_POWER_BASE+STOP_CFG_OFFSET)
#define SLEEP_CFG			(ELFIN_CLOCK_POWER_BASE+SLEEP_CFG_OFFSET)
#define OSC_FREQ			(ELFIN_CLOCK_POWER_BASE+OSC_FREQ_OFFSET)
#define OSC_CNT_VAL			(ELFIN_CLOCK_POWER_BASE+OSC_CNT_VAL_OFFSET)
#define PWR_CNT_VAL			(ELFIN_CLOCK_POWER_BASE+PWR_CNT_VAL_OFFSET)
#define FPC_CNT_VAL			(ELFIN_CLOCK_POWER_BASE+FPC_CNT_VAL_OFFSET)
#define MTC_CNT_VAL			(ELFIN_CLOCK_POWER_BASE+MTC_CNT_VAL_OFFSET)
#define OTHERS				(ELFIN_CLOCK_POWER_BASE+OTHERS_OFFSET)
#define RST_STAT			(ELFIN_CLOCK_POWER_BASE+RST_STAT_OFFSET)
#define WAKEUP_STAT			(ELFIN_CLOCK_POWER_BASE+WAKEUP_STAT_OFFSET)
#define BLK_PWR_STAT			(ELFIN_CLOCK_POWER_BASE+BLK_PWR_STAT_OFFSET)
#define USB_PHY_CONTROL			(ELFIN_CLOCK_POWER_BASE+USB_PHY_CONTROL_OFFSET)
#define INF_REG0			(ELFIN_CLOCK_POWER_BASE+INF_REG0_OFFSET)
#define INF_REG1			(ELFIN_CLOCK_POWER_BASE+INF_REG1_OFFSET)
#define INF_REG2			(ELFIN_CLOCK_POWER_BASE+INF_REG2_OFFSET)
#define INF_REG3			(ELFIN_CLOCK_POWER_BASE+INF_REG3_OFFSET)
#define INF_REG4			(ELFIN_CLOCK_POWER_BASE+INF_REG4_OFFSET)
#define INF_REG5			(ELFIN_CLOCK_POWER_BASE+INF_REG5_OFFSET)
#define INF_REG6			(ELFIN_CLOCK_POWER_BASE+INF_REG6_OFFSET)
#define INF_REG7			(ELFIN_CLOCK_POWER_BASE+INF_REG7_OFFSET)

/*
 * GPIO
 */
#define ELFIN_GPIO_BASE			0xE0200000


#define GPA0CON_OFFSET 			0x000 
#define GPA0DAT_OFFSET	 		0x004 
#define GPA0PUD_OFFSET 			0x008 
#define GPA0DRV_SR_OFFSET	 	0x00C 
#define GPA0CONPDN_OFFSET 		0x010 
#define GPA0PUDPDN_OFFSET 		0x014

#define GPA1CON_OFFSET 			0x020
#define GPA1DAT_OFFSET 			0x024 
#define GPA1PUD_OFFSET 			0x028 
#define GPA1DRV_SR_OFFSET 		0x02C 
#define GPA1CONPDN_OFFSET 		0x030 
#define GPA1PUDPDN_OFFSET 		0x034 

#define GPBCON_OFFSET 			0x040 
#define GPBDAT_OFFSET 			0x044 
#define GPBPUD_OFFSET 			0x048 
#define GPBDRV_SR_OFFSET 		0x04C 
#define GPBCONPDN_OFFSET 		0x050 
#define GPBPUDPDN_OFFSET 		0x054 

#define GPC0CON_OFFSET 			0x060 
// #define GPC0DAT_OFFSET 		0x064 //GPC0 only used for I2S0 and PCM0
#define GPC0PUD_OFFSET 			0x068 
#define GPC0DRV_SR_OFFSET 		0x06C 
// #define GPC0CONPDN_OFFSET 		0x070 
#define GPC0PUDPDN_OFFSET 		0x074 

#define GPC1CON_OFFSET 			0x080 
#define GPC1DAT_OFFSET 			0x084 
#define GPC1PUD_OFFSET 			0x088 
#define GPC1DRV_SR_OFFSET 		0x08C 
#define GPC1CONPDN_OFFSET 		0x090 
#define GPC1PUDPDN_OFFSET 		0x094 

#define GPD0CON_OFFSET 			0x0A0 
#define GPD0DAT_OFFSET 			0x0A4 
#define GPD0PUD_OFFSET 			0x0A8 
#define GPD0DRV_SR_OFFSET 		0x0AC 
#define GPD0CONPDN_OFFSET 		0x0B0 
#define GPD0PUDPDN_OFFSET 		0x0B4 

#define GPD1CON_OFFSET 			0x0C0 
#define GPD1DAT_OFFSET 			0x0C4 
#define GPD1PUD_OFFSET 			0x0C8 
#define GPD1DRV_SR_OFFSET 		0x0CC 
#define GPD1CONPDN_OFFSET 		0x0D0 
#define GPD1PUDPDN_OFFSET 		0x0D4 

#define GPE0CON_OFFSET 			0x0E0 
#define GPE0DAT_OFFSET 			0x0E4 
#define GPE0PUD_OFFSET 			0x0E8 
#define GPE0DRV_SR_OFFSET 		0x0EC 
#define GPE0CONPDN_OFFSET 		0x0F0 
#define GPE0PUDPDN_OFFSET 		0x0F4

#define GPE1CON_OFFSET 			0x100 
#define GPE1DAT_OFFSET 			0x104 
#define GPE1PUD_OFFSET 			0x108 
#define GPE1DRV_SR_OFFSET 		0x10C 
#define GPE1CONPDN_OFFSET 		0x110 
#define GPE1PUDPDN_OFFSET 		0x114 

#define GPF0CON_OFFSET 			0x120 
#define GPF0DAT_OFFSET 			0x124 
#define GPF0PUD_OFFSET 			0x128 
#define GPF0DRV_SR_OFFSET 		0x12C 
#define GPF0CONPDN_OFFSET 		0x130 
#define GPF0PUDPDN_OFFSET 		0x134 

#define GPF1CON_OFFSET 			0x140 
#define GPF1DAT_OFFSET 			0x144 
#define GPF1PUD_OFFSET 			0x148 
#define GPF1DRV_SR_OFFSET 		0x14C 
#define GPF1CONPDN_OFFSET 		0x150 
#define GPF1PUDPDN_OFFSET 		0x154 

#define GPF2CON_OFFSET 			0x160 
#define GPF2DAT_OFFSET 			0x164 
#define GPF2PUD_OFFSET 			0x168 
#define GPF2DRV_SR_OFFSET 		0x16C 
#define GPF2CONPDN_OFFSET 		0x170 
#define GPF2PUDPDN_OFFSET 		0x174 

#define GPF3CON_OFFSET 			0x180 
#define GPF3DAT_OFFSET 			0x184 
#define GPF3PUD_OFFSET 			0x188 
#define GPF3DRV_SR_OFFSET 		0x18C 
#define GPF3CONPDN_OFFSET 		0x190 
#define GPF3PUDPDN_OFFSET 		0x194 

#define GPG0CON_OFFSET 			0x1A0 
#define GPG0DAT_OFFSET 			0x1A4 
#define GPG0PUD_OFFSET 			0x1A8 
#define GPG0DRV_SR_OFFSET 		0x1AC 
#define GPG0CONPDN_OFFSET 		0x1B0 
#define GPG0PUDPDN_OFFSET 		0x1B4 

#define GPG1CON_OFFSET 			0x1C0 
#define GPG1DAT_OFFSET 			0x1C4 
#define GPG1PUD_OFFSET 			0x1C8 
#define GPG1DRV_SR_OFFSET 		0x1CC 
#define GPG1CONPDN_OFFSET 		0x1D0 
#define GPG1PUDPDN_OFFSET 		0x1D4 

#define GPG2CON_OFFSET 			0x1E0 
#define GPG2DAT_OFFSET 			0x1E4 
#define GPG2PUD_OFFSET 			0x1E8 
#define GPG2DRV_SR_OFFSET 		0x1EC 
#define GPG2CONPDN_OFFSET 		0x1F0 
#define GPG2PUDPDN_OFFSET 		0x1F4 

#if 0
#define GPG3CON_OFFSET 			0x200 
#define GPG3DAT_OFFSET 			0x204 
#define GPG3PUD_OFFSET 			0x208 
#define GPG3DRV_SR_OFFSET 		0x20C 
#define GPG3CONPDN_OFFSET 		0x210 
#define GPG3PUDPDN_OFFSET 		0x214 
#endif

/* GPH0 */
#define GPH0CON_OFFSET			0xc00
#define GPH0DAT_OFFSET			0xc04
#define GPH0PUD_OFFSET			0xc08
#define GPH0DRV_OFFSET			0xc0c

/* GPH1 */
#define GPH1CON_OFFSET			0xc20
#define GPH1DAT_OFFSET			0xc24
#define GPH1PUD_OFFSET			0xc28
#define GPH1DRV_OFFSET			0xc2c

/* GPH2 */
#define GPH2CON_OFFSET			0xc40
#define GPH2DAT_OFFSET			0xc44
#define GPH2PUD_OFFSET			0xc48
#define GPH2DRV_OFFSET			0xc4c

/* GPH3 */
#define GPH3CON_OFFSET			0xc60
#define GPH3DAT_OFFSET			0xc64
#define GPH3PUD_OFFSET			0xc68
#define GPH3DRV_OFFSET			0xc6c

#if 0
#define GPICON_OFFSET 			0x220 
#define GPIPUD_OFFSET 			0x228 
#define GPIDRV_OFFSET_SR 		0x22C 
#define GPIPUDPDN_OFFSET 		0x234 
#endif

#define GPJ0CON_OFFSET 			0x200 
#define GPJ0DAT_OFFSET 			0x204 
#define GPJ0PUD_OFFSET 			0x208 
#define GPJ0DRV_SR_OFFSET 		0x20C 
#define GPJ0CONPDN_OFFSET 		0x210
#define GPJ0PUDPDN_OFFSET 		0x214

#define GPJ1CON_OFFSET 			0x220 
#define GPJ1DAT_OFFSET 			0x224 
#define GPJ1PUD_OFFSET 			0x228 
#define GPJ1DRV_SR_OFFSET 		0x22C 
#define GPJ1CONPDN_OFFSET 		0x230 
#define GPJ1PUDPDN_OFFSET 		0x234 

#define GPJ2CON_OFFSET 			0x240 
#define GPJ2DAT_OFFSET 			0x244 
#define GPJ2PUD_OFFSET 			0x248 
#define GPJ2DRV_SR_OFFSET 		0x24C 
#define GPJ2CONPDN_OFFSET 		0x250 
#define GPJ2PUDPDN_OFFSET 		0x254 

#define GPJ3CON_OFFSET 			0x260 
#define GPJ3DAT_OFFSET 			0x264 
#define GPJ3PUD_OFFSET 			0x268 
#define GPJ3DRV_SR_OFFSET 		0x26C 
#define GPJ3CONPDN_OFFSET 		0x270 
#define GPJ3PUDPDN_OFFSET 		0x274 

#define GPJ4CON_OFFSET 			0x280
#define GPJ4DAT_OFFSET 			0x284 
#define GPJ4PUD_OFFSET 			0x288 
#define GPJ4DRV_SR_OFFSET 		0x28C 
#define GPJ4CONPDN_OFFSET 		0x290 
#define GPJ4PUDPDN_OFFSET 		0x294 

#define MP01CON_OFFSET 			0x2A0 
#define MP01DAT_OFFSET 			0x2A4 
#define MP01PUD_OFFSET 			0x2A8 
#define MP01DRV_SR_OFFSET 		0x2AC 
#define MP01CONPDN_OFFSET 		0x280 
#define MP01PUDPDN_OFFSET 		0x284 

#define GPA0CON				(ELFIN_GPIO_BASE + GPA0CON_OFFSET)	 
#define GPA0DAT				(ELFIN_GPIO_BASE + GPA0DAT_OFFSET)		 
#define GPA0PUD				(ELFIN_GPIO_BASE + GPA0PUD_OFFSET)		 
#define GPA0DRV				(ELFIN_GPIO_BASE + GPA0DRV_SR_OFFSET)
#define GPA0CONPDN			(ELFIN_GPIO_BASE + GPA0CONPDN_OFFSET)	 
#define GPA0PUDPDN			(ELFIN_GPIO_BASE + GPA0PUDPDN_OFFSET)	 
#define GPA1CON				(ELFIN_GPIO_BASE + GPA1CON_OFFSET) 
#define GPA1DAT				(ELFIN_GPIO_BASE + GPA1DAT_OFFSET) 		 
#define GPA1PUD				(ELFIN_GPIO_BASE + GPA1PUD_OFFSET) 		 
#define GPA1DRV				(ELFIN_GPIO_BASE + GPA1DRV_SR_OFFSET) 	 
#define GPA1CONPDN			(ELFIN_GPIO_BASE + GPA1CONPDN_OFFSET) 	 
#define GPA1PUDPDN			(ELFIN_GPIO_BASE + GPA1PUDPDN_OFFSET) 	 
#define GPBCON				(ELFIN_GPIO_BASE + GPBCON_OFFSET) 
#define GPBDAT				(ELFIN_GPIO_BASE + GPBDAT_OFFSET)			 
#define GPBPUD				(ELFIN_GPIO_BASE + GPBPUD_OFFSET)			 
#define GPBDRV_SR			(ELFIN_GPIO_BASE + GPBDRV_SR_OFFSET)
#define GPBCONPDN			(ELFIN_GPIO_BASE + GPBCONPDN_OFFSET)	 
#define GPBPUDPDN			(ELFIN_GPIO_BASE + GPBPUDPDN_OFFSET)	 
#define GPC0CON				(ELFIN_GPIO_BASE + GPC0CON_OFFSET)	 
#define GPC0DAT				(ELFIN_GPIO_BASE + GPC0DAT_OFFSET)		 
#define GPC0PUD				(ELFIN_GPIO_BASE + GPC0PUD_OFFSET)		 
#define GPC0DRV				(ELFIN_GPIO_BASE + GPC0DRV_SR_OFFSET)
#define GPC0CONPDN			(ELFIN_GPIO_BASE + GPC0CONPDN_OFFSET)	 
#define GPC0PUDPDN			(ELFIN_GPIO_BASE + GPC0PUDPDN_OFFSET)	 
#define GPC1CON				(ELFIN_GPIO_BASE + GPC1CON_OFFSET) 
#define GPC1DAT				(ELFIN_GPIO_BASE + GPC1DAT_OFFSET)		 
#define GPC1PUD				(ELFIN_GPIO_BASE + GPC1PUD_OFFSET)		 
#define GPC1DRV				(ELFIN_GPIO_BASE + GPC1DRV_SR_OFFSET)
#define GPC1CONPDN			(ELFIN_GPIO_BASE + GPC1CONPDN_OFFSET)	 
#define GPC1PUDPDN			(ELFIN_GPIO_BASE + GPC1PUDPDN_OFFSET)	 
#define GPD0CON				(ELFIN_GPIO_BASE + GPD0CON_OFFSET) 
#define GPD0DAT				(ELFIN_GPIO_BASE + GPD0DAT_OFFSET)		 
#define GPD0PUD				(ELFIN_GPIO_BASE + GPD0PUD_OFFSET)		 
#define GPD0DRV				(ELFIN_GPIO_BASE + GPD0DRV_SR_OFFSET)
#define GPD0CONPDN			(ELFIN_GPIO_BASE + GPD0CONPDN_OFFSET)	 
#define GPD0PUDPDN			(ELFIN_GPIO_BASE + GPD0PUDPDN_OFFSET)	 
#define GPD1CON				(ELFIN_GPIO_BASE + GPD1CON_OFFSET) 
#define GPD1DAT				(ELFIN_GPIO_BASE + GPD1DAT_OFFSET)		 
#define GPD1PUD				(ELFIN_GPIO_BASE + GPD1PUD_OFFSET)		 
#define GPD1DRV				(ELFIN_GPIO_BASE + GPD1DRV_SR_OFFSET)
#define GPD1CONPDN			(ELFIN_GPIO_BASE + GPD1CONPDN_OFFSET)	 
#define GPD1PUDPDN			(ELFIN_GPIO_BASE + GPD1PUDPDN_OFFSET)	 
#define GPE0CON				(ELFIN_GPIO_BASE + GPE0CON_OFFSET) 
#define GPE0DAT				(ELFIN_GPIO_BASE + GPE0DAT_OFFSET)		 
#define GPE0PUD				(ELFIN_GPIO_BASE + GPE0PUD_OFFSET)		 
#define GPE0DRV				(ELFIN_GPIO_BASE + GPE0DRV_SR_OFFSET)
#define GPE0CONPDN			(ELFIN_GPIO_BASE + GPE0CONPDN_OFFSET)
#define GPE0PUDPDN			(ELFIN_GPIO_BASE + GPE0PUDPDN_OFFSET)	 
#define GPE1CON				(ELFIN_GPIO_BASE + GPE1CON_OFFSET) 
#define GPE1DAT				(ELFIN_GPIO_BASE + GPE1DAT_OFFSET)		 
#define GPE1PUD				(ELFIN_GPIO_BASE + GPE1PUD_OFFSET)		 
#define GPE1DRV				(ELFIN_GPIO_BASE + GPE1DRV_SR_OFFSET)
#define GPE1CONPDN			(ELFIN_GPIO_BASE + GPE1CONPDN_OFFSET)	 
#define GPE1PUDPDN			(ELFIN_GPIO_BASE + GPE1PUDPDN_OFFSET)	 
#define GPF0CON				(ELFIN_GPIO_BASE + GPF0CON_OFFSET) 
#define GPF0DAT				(ELFIN_GPIO_BASE + GPF0DAT_OFFSET)		 
#define GPF0PUD				(ELFIN_GPIO_BASE + GPF0PUD_OFFSET)		 
#define GPF0DRV				(ELFIN_GPIO_BASE + GPF0DRV_SR_OFFSET)
#define GPF0CONPDN			(ELFIN_GPIO_BASE + GPF0CONPDN_OFFSET)	 
#define GPF0PUDPDN			(ELFIN_GPIO_BASE + GPF0PUDPDN_OFFSET)	 
#define GPF1CON				(ELFIN_GPIO_BASE + GPF1CON_OFFSET) 
#define GPF1DAT				(ELFIN_GPIO_BASE + GPF1DAT_OFFSET)		 
#define GPF1PUD				(ELFIN_GPIO_BASE + GPF1PUD_OFFSET)		 
#define GPF1DRV				(ELFIN_GPIO_BASE + GPF1DRV_SR_OFFSET)
#define GPF1CONPDN			(ELFIN_GPIO_BASE + GPF1CONPDN_OFFSET)	 
#define GPF1PUDPDN			(ELFIN_GPIO_BASE + GPF1PUDPDN_OFFSET)	 
#define GPF2CON				(ELFIN_GPIO_BASE + GPF2CON_OFFSET) 
#define GPF2DAT				(ELFIN_GPIO_BASE + GPF2DAT_OFFSET)		 
#define GPF2PUD				(ELFIN_GPIO_BASE + GPF2PUD_OFFSET)		 
#define GPF2DRV				(ELFIN_GPIO_BASE + GPF2DRV_SR_OFFSET)	 
#define GPF2CONPDN			(ELFIN_GPIO_BASE + GPF2CONPDN_OFFSET)	 
#define GPF2PUDPDN			(ELFIN_GPIO_BASE + GPF2PUDPDN_OFFSET)	 
#define GPF3CON				(ELFIN_GPIO_BASE + GPF3CON_OFFSET) 
#define GPF3DAT				(ELFIN_GPIO_BASE + GPF3DAT_OFFSET)		 
#define GPF3PUD				(ELFIN_GPIO_BASE + GPF3PUD_OFFSET)		 
#define GPF3DRV				(ELFIN_GPIO_BASE + GPF3DRV_SR_OFFSET)
#define GPF3CONPDN			(ELFIN_GPIO_BASE + GPF3CONPDN_OFFSET)	 
#define GPF3PUDPDN			(ELFIN_GPIO_BASE + GPF3PUDPDN_OFFSET)	 
#define GPG0CON				(ELFIN_GPIO_BASE + GPG0CON_OFFSET) 
#define GPG0DAT				(ELFIN_GPIO_BASE + GPG0DAT_OFFSET)		 
#define GPG0PUD				(ELFIN_GPIO_BASE + GPG0PUD_OFFSET)		 
#define GPG0DRV				(ELFIN_GPIO_BASE + GPG0DRV_SR_OFFSET)
#define GPG0CONPDN			(ELFIN_GPIO_BASE + GPG0CONPDN_OFFSET)	 
#define GPG0PUDPDN			(ELFIN_GPIO_BASE + GPG0PUDPDN_OFFSET)	 
#define GPG1CON				(ELFIN_GPIO_BASE + GPG1CON_OFFSET) 
#define GPG1DAT				(ELFIN_GPIO_BASE + GPG1DAT_OFFSET)		 
#define GPG1PUD				(ELFIN_GPIO_BASE + GPG1PUD_OFFSET)		 
#define GPG1DRV				(ELFIN_GPIO_BASE + GPG1DRV_SR_OFFSET)
#define GPG1CONPDN			(ELFIN_GPIO_BASE + GPG1CONPDN_OFFSET)	 
#define GPG1PUDPDN			(ELFIN_GPIO_BASE + GPG1PUDPDN_OFFSET)	 
#define GPG2CON				(ELFIN_GPIO_BASE + GPG2CON_OFFSET) 
#define GPG2DAT				(ELFIN_GPIO_BASE + GPG2DAT_OFFSET)		 
#define GPG2PUD				(ELFIN_GPIO_BASE + GPG2PUD_OFFSET)		 
#define GPG2DRV				(ELFIN_GPIO_BASE + GPG2DRV_SR_OFFSET)
#define GPG2CONPDN			(ELFIN_GPIO_BASE + GPG2CONPDN_OFFSET)	 
#define GPG2PUDPDN			(ELFIN_GPIO_BASE + GPG2PUDPDN_OFFSET)	

#if 0
#define GPG3CON				(ELFIN_GPIO_BASE + GPG3CON_OFFSET) 
#define GPG3DAT				(ELFIN_GPIO_BASE + GPG3DAT_OFFSET)		 
#define GPG3PUD				(ELFIN_GPIO_BASE + GPG3PUD_OFFSET)		 
#define GPG3DRV				(ELFIN_GPIO_BASE + GPG3DRV_SR_OFFSET)
#define GPG3CONPDN			(ELFIN_GPIO_BASE + GPG3CONPDN_OFFSET)	 
#define GPG3PUDPDN			(ELFIN_GPIO_BASE + GPG3PUDPDN_OFFSET)	 
#define GPICON				(ELFIN_GPIO_BASE + GPICON_OFFSET) 
#define GPIPUD				(ELFIN_GPIO_BASE + GPIPUD_OFFSET)			 
#define GPIDRV				(ELFIN_GPIO_BASE + GPIDRV_OFFSET_SR)
#define GPIPUDPDN			(ELFIN_GPIO_BASE + GPIPUDPDN_OFFSET)
#endif

#define GPJ0CON				(ELFIN_GPIO_BASE + GPJ0CON_OFFSET)	 
#define GPJ0DAT				(ELFIN_GPIO_BASE + GPJ0DAT_OFFSET)		 
#define GPJ0PUD				(ELFIN_GPIO_BASE + GPJ0PUD_OFFSET)		 
#define GPJ0DRV				(ELFIN_GPIO_BASE + GPJ0DRV_SR_OFFSET)
#define GPJ0CONPDN			(ELFIN_GPIO_BASE + GPJ0CONPDN_OFFSET)	 
#define GPJ0PUDPDN			(ELFIN_GPIO_BASE + GPJ0PUDPDN_OFFSET)	 
#define GPJ1CON				(ELFIN_GPIO_BASE + GPJ1CON_OFFSET) 
#define GPJ1DAT				(ELFIN_GPIO_BASE + GPJ1DAT_OFFSET)		 
#define GPJ1PUD				(ELFIN_GPIO_BASE + GPJ1PUD_OFFSET)		 
#define GPJ1DRV				(ELFIN_GPIO_BASE + GPJ1DRV_SR_OFFSET)
#define GPJ1CONPDN			(ELFIN_GPIO_BASE + GPJ1CONPDN_OFFSET)	 
#define GPJ1PUDPDN			(ELFIN_GPIO_BASE + GPJ1PUDPDN_OFFSET)	 
#define GPJ2CON				(ELFIN_GPIO_BASE + GPJ2CON_OFFSET) 
#define GPJ2DAT				(ELFIN_GPIO_BASE + GPJ2DAT_OFFSET)		 
#define GPJ2PUD				(ELFIN_GPIO_BASE + GPJ2PUD_OFFSET)		 
#define GPJ2DRV				(ELFIN_GPIO_BASE + GPJ2DRV_SR_OFFSET)
#define GPJ2CONPDN			(ELFIN_GPIO_BASE + GPJ2CONPDN_OFFSET)	 
#define GPJ2PUDPDN			(ELFIN_GPIO_BASE + GPJ2PUDPDN_OFFSET)	 
#define GPJ3CON				(ELFIN_GPIO_BASE + GPJ3CON_OFFSET) 
#define GPJ3DAT				(ELFIN_GPIO_BASE + GPJ3DAT_OFFSET)		 
#define GPJ3PUD				(ELFIN_GPIO_BASE + GPJ3PUD_OFFSET)		 
#define GPJ3DRV_SR			(ELFIN_GPIO_BASE + GPJ3DRV_SR_OFFSET)
#define GPJ3CONPDN			(ELFIN_GPIO_BASE + GPJ3CONPDN_OFFSET)	 
#define GPJ3PUDPDN			(ELFIN_GPIO_BASE + GPJ3PUDPDN_OFFSET)	 
#define GPJ4CON				(ELFIN_GPIO_BASE + GPJ4CON_OFFSET)
#define GPJ4DAT				(ELFIN_GPIO_BASE + GPJ4DAT_OFFSET)		 
#define GPJ4PUD				(ELFIN_GPIO_BASE + GPJ4PUD_OFFSET)		 
#define GPJ4DRV				(ELFIN_GPIO_BASE + GPJ4DRV_SR_OFFSET)
#define GPJ4CONPDN			(ELFIN_GPIO_BASE + GPJ4CONPDN_OFFSET)	 
#define GPJ4PUDPDN			(ELFIN_GPIO_BASE + GPJ4PUDPDN_OFFSET)

#define MP01CON_REG			__REG(ELFIN_GPIO_BASE + MP01CON_OFFSET)
#define MP01DAT_REG			__REG(ELFIN_GPIO_BASE + MP01DAT_OFFSET)		 
#define MP01PUD_REG			__REG(ELFIN_GPIO_BASE + MP01PUD_OFFSET)		 
#define MP01DRV_REG			__REG(ELFIN_GPIO_BASE + MP01DRV_SR_OFFSET)
#define MP01CONPDN_REG			__REG(ELFIN_GPIO_BASE + MP01CONPDN_OFFSET)	 
#define MP01PUDPDN_REG			__REG(ELFIN_GPIO_BASE + MP01PUDPDN_OFFSET)	 


/*
 * Bus Matrix
 */
#define ELFIN_MEM_SYS_CFG		0xE0106200

/*
 * Memory controller
 */
#define ELFIN_SROM_BASE			0xE7000000

#define SROM_BW_OFFSET			0x0
#define SROM_BC0_OFFSET			0x4
#define SROM_BC1_OFFSET			0x8
#define SROM_BC2_OFFSET			0xC
#define SROM_BC3_OFFSET			0x10
#define SROM_BC4_OFFSET			0x14
#define SROM_BC5_OFFSET			0x18

#define SROM_BW_REG			__REG(ELFIN_SROM_BASE+SROM_BW_OFFSET)
#define SROM_BC0_REG			__REG(ELFIN_SROM_BASE+SROM_BC0_OFFSET)
#define SROM_BC1_REG			__REG(ELFIN_SROM_BASE+SROM_BC1_OFFSET)
#define SROM_BC2_REG			__REG(ELFIN_SROM_BASE+SROM_BC2_OFFSET)
#define SROM_BC3_REG			__REG(ELFIN_SROM_BASE+SROM_BC3_OFFSET)
#define SROM_BC4_REG			__REG(ELFIN_SROM_BASE+SROM_BC4_OFFSET)
#define SROM_BC5_REG			__REG(ELFIN_SROM_BASE+SROM_BC5_OFFSET)

/*
 * SDRAM Controller
 */
#define APB_DMC_0_BASE			0xE6000000

#define	DMC_CONCONTROL			0x00
#define	DMC_MEMCONTROL			0x04
#define	DMC_MEMCONFIG0			0x08
#define	DMC_MEMCONFIG1			0x0C
#define	DMC_DIRECTCMD			0x10
#define	DMC_PRECHCONFIG			0x14
#define	DMC_PHYCONTROL0			0x18
#define	DMC_PHYCONTROL1			0x1C
#define	DMC_PHYCONTROL2			0x20
#define	DMC_PWRDNCONFIG 		0x28
#define	DMC_TIMINGAREF  		0x30
#define	DMC_TIMINGROW   		0x34
#define	DMC_TIMINGDATA  		0x38
#define	DMC_TIMINGPOWER 		0x3C
#define	DMC_PHYSTATUS0  		0x40
#define	DMC_PHYSTATUS1  		0x44
#define	DMC_CHIP0STATUS 		0x48
#define	DMC_CHIP1STATUS 		0x4C
#define	DMC_AREFSTATUS  		0x50
#define	DMC_MRSTATUS    		0x54
#define	DMC_PHYTEST0    		0x58
#define	DMC_PHYTEST1    		0x5C
#define	DMC_QOSCONTROL0 		0x60
#define	DMC_QOSCONFIG0  		0x64
#define	DMC_QOSCONTROL1 		0x68
#define	DMC_QOSCONFIG1  		0x6C
#define	DMC_QOSCONTROL2 		0x70
#define	DMC_QOSCONFIG2  		0x74
#define	DMC_DMC_QOSCONTROL3 		0x78
#define	DMC_QOSCONFIG3  		0x7C
#define	DMC_QOSCONTROL4 		0x80
#define	DMC_QOSCONFIG4  		0x84
#define	DMC_QOSCONTROL5 		0x88
#define	DMC_QOSCONFIG5  		0x8C
#define	DMC_QOSCONTROL6 		0x90
#define	DMC_QOSCONFIG6  		0x94
#define	DMC_QOSCONTROL7 		0x98
#define	DMC_QOSCONFIG7  		0x9C
#define	DMC_QOSCONTROL8 		0xA0
#define	DMC_QOSCONFIG8 			0xA4
#define	DMC_QOSCONTROL9 		0xA8
#define	DMC_QOSCONFIG9 			0xAC
#define	DMC_QOSCONTROL10 		0xB0
#define	DMC_QOSCONFIG10 		0xB4
#define	DMC_QOSCONTROL11 		0xB8
#define	DMC_QOSCONFIG11 		0xBC
#define	DMC_QOSCONTROL12 		0xC0
#define	DMC_QOSCONFIG12 		0xC4
#define	DMC_QOSCONTROL13 		0xC8
#define	DMC_QOSCONFIG13 		0xCC
#define	DMC_QOSCONTROL14 		0xD0
#define	DMC_QOSCONFIG14 		0xD4
#define	DMC_QOSCONTROL15 		0xD8
#define	DMC_QOSCONFIG15 		0xDC


/*
* Memory Chip direct command
*/



/****************************************************************
 Definitions for memory configuration
 Set memory configuration
	active_chips	 = 1'b0 (1 chip)
	qos_master_chip  = 3'b000(ARID[3:0])
	memory burst	 = 3'b010(burst 4)
	stop_mem_clock	 = 1'b0(disable dynamical stop)
	auto_power_down  = 1'b0(disable auto power-down mode)
	power_down_prd	 = 6'b00_0000(0 cycle for auto power-down)
	ap_bit		 = 1'b0 (bit position of auto-precharge is 10)
	row_bits	 = 3'b010(# row address 13)
	column_bits	 = 3'b010(# column address 10 )

 Set user configuration
	2'b10=SDRAM/mSDRAM, 2'b11=DDR, 2'b01=mDDR

 Set chip select for chip [n]
	 row bank control, bank address 0x3000_0000 ~ 0x37ff_ffff
	 CHIP_[n]_CFG=0x30F8,  30: ADDR[31:24], F8: Mask[31:24]
******************************************************************/

/*
 * HS MMC Interface
 */
#define ELFIN_HSMMC_BASE		0xEB000000

#define HM_SYSAD			(0x00)
#define HM_BLKSIZE			(0x04)
#define HM_BLKCNT			(0x06)
#define HM_ARGUMENT			(0x08)
#define HM_TRNMOD			(0x0c)
#define HM_CMDREG			(0x0e)
#define HM_RSPREG0			(0x10)
#define HM_RSPREG1			(0x14)
#define HM_RSPREG2			(0x18)
#define HM_RSPREG3			(0x1c)
#define HM_BDATA			(0x20)
#define HM_PRNSTS			(0x24)
#define HM_HOSTCTL			(0x28)
#define HM_PWRCON			(0x29)
#define HM_BLKGAP			(0x2a)
#define HM_WAKCON			(0x2b)
#define HM_CLKCON			(0x2c)
#define HM_TIMEOUTCON			(0x2e)
#define HM_SWRST			(0x2f)
#define HM_NORINTSTS			(0x30)
#define HM_ERRINTSTS			(0x32)
#define HM_NORINTSTSEN			(0x34)
#define HM_ERRINTSTSEN			(0x36)
#define HM_NORINTSIGEN			(0x38)
#define HM_ERRINTSIGEN			(0x3a)
#define HM_ACMD12ERRSTS			(0x3c)
#define HM_CAPAREG			(0x40)
#define HM_MAXCURR			(0x48)
#define HM_CONTROL2			(0x80)
#define HM_CONTROL3			(0x84)
#define HM_CONTROL4			(0x8c)
#define HM_HCVER			(0xfe)

#if 1
/*
 * Nand flash controller
 */
#define ELFIN_NAND_BASE			0xB0E00000

#define NFCONF_OFFSET           	0x00
#define NFCONT_OFFSET           	0x04
#define NFCMMD_OFFSET           	0x08
#define NFADDR_OFFSET           	0x0c
#define NFDATA_OFFSET			0x10
#define NFMECCDATA0_OFFSET      	0x14
#define NFMECCDATA1_OFFSET      	0x18
#define NFSECCDATA0_OFFSET      	0x1c
#define NFSBLK_OFFSET           	0x20
#define NFEBLK_OFFSET           	0x24
#define NFSTAT_OFFSET           	0x28
#define NFESTAT0_OFFSET         	0x2c
#define NFESTAT1_OFFSET         	0x30
#define NFMECC0_OFFSET          	0x34
#define NFMECC1_OFFSET          	0x38
#define NFSECC_OFFSET           	0x3c
#define NFMLCBITPT_OFFSET       	0x40
#define NF8ECCERR0_OFFSET		0x44
#define NF8ECCERR1_OFFSET		0x48
#define NF8ECCERR2_OFFSET		0x4c
#define NFM8ECC0_OFFSET			0x50
#define NFM8ECC1_OFFSET			0x54
#define NFM8ECC2_OFFSET			0x58
#define NFM8ECC3_OFFSET			0x5c
#define NFMLC8BITPT0_OFFSET		0x60
#define NFMLC8BITPT1_OFFSET		0x64
#define NFACTADJ_OFFSET			0x68

#define NFCONF				(ELFIN_NAND_BASE+NFCONF_OFFSET)
#define NFCONT				(ELFIN_NAND_BASE+NFCONT_OFFSET)
#define NFCMMD				(ELFIN_NAND_BASE+NFCMMD_OFFSET)
#define NFADDR           		(ELFIN_NAND_BASE+NFADDR_OFFSET)
#define NFDATA          		(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFMECCDATA0     		(ELFIN_NAND_BASE+NFMECCDATA0_OFFSET)
#define NFMECCDATA1     		(ELFIN_NAND_BASE+NFMECCDATA1_OFFSET)
#define NFSECCDATA0      		(ELFIN_NAND_BASE+NFSECCDATA0_OFFSET)
#define NFSBLK          		(ELFIN_NAND_BASE+NFSBLK_OFFSET)
#define NFEBLK           		(ELFIN_NAND_BASE+NFEBLK_OFFSET)
#define NFSTAT           		(ELFIN_NAND_BASE+NFSTAT_OFFSET)
#define NFESTAT0         		(ELFIN_NAND_BASE+NFESTAT0_OFFSET)
#define NFESTAT1         		(ELFIN_NAND_BASE+NFESTAT1_OFFSET)
#define NFMECC0          		(ELFIN_NAND_BASE+NFMECC0_OFFSET)
#define NFMECC1          		(ELFIN_NAND_BASE+NFMECC1_OFFSET)
#define NFSECC           		(ELFIN_NAND_BASE+NFSECC_OFFSET)
#define NFMLCBITPT           		(ELFIN_NAND_BASE+NFMLCBITPT_OFFSET)
#define NF8ECCERR0			(ELFIN_NAND_BASE+NF8ECCERR0_OFFSET)
#define NF8ECCERR1			(ELFIN_NAND_BASE+NF8ECCERR1_OFFSET)
#define NF8ECCERR2			(ELFIN_NAND_BASE+NF8ECCERR2_OFFSET)
#define NFM8ECC0			(ELFIN_NAND_BASE+NFM8ECC0_OFFSET)
#define NFM8ECC1			(ELFIN_NAND_BASE+NFM8ECC1_OFFSET)
#define NFM8ECC2			(ELFIN_NAND_BASE+NFM8ECC2_OFFSET)
#define NFM8ECC3			(ELFIN_NAND_BASE+NFM8ECC3_OFFSET)
#define NFMLC8BITPT0			(ELFIN_NAND_BASE+NFMLC8BITPT0_OFFSET)
#define NFMLC8BITPT1			(ELFIN_NAND_BASE+NFMLC8BITPT1_OFFSET)
#define NFACTADJ			(ELFIN_NAND_BASE+NFACTADJ_OFFSET)

#define NFCONF_REG			__REG(ELFIN_NAND_BASE+NFCONF_OFFSET)
#define NFCONT_REG			__REG(ELFIN_NAND_BASE+NFCONT_OFFSET)
#define NFCMD_REG			__REG(ELFIN_NAND_BASE+NFCMMD_OFFSET)
#define NFADDR_REG           		__REG(ELFIN_NAND_BASE+NFADDR_OFFSET)
#define NFDATA_REG          		__REG(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFDATA8_REG          		__REGb(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFMECCDATA0_REG     		__REG(ELFIN_NAND_BASE+NFMECCDATA0_OFFSET)
#define NFMECCDATA1_REG     		__REG(ELFIN_NAND_BASE+NFMECCDATA1_OFFSET)
#define NFSECCDATA0_REG      		__REG(ELFIN_NAND_BASE+NFSECCDATA0_OFFSET)
#define NFSBLK_REG          		__REG(ELFIN_NAND_BASE+NFSBLK_OFFSET)
#define NFEBLK_REG           		__REG(ELFIN_NAND_BASE+NFEBLK_OFFSET)
#define NFSTAT_REG           		__REG(ELFIN_NAND_BASE+NFSTAT_OFFSET)
#define NFESTAT0_REG         		__REG(ELFIN_NAND_BASE+NFESTAT0_OFFSET)
#define NFESTAT1_REG         		__REG(ELFIN_NAND_BASE+NFESTAT1_OFFSET)
#define NFMECC0_REG          		__REG(ELFIN_NAND_BASE+NFMECC0_OFFSET)
#define NFMECC1_REG          		__REG(ELFIN_NAND_BASE+NFMECC1_OFFSET)
#define NFSECC_REG           		__REG(ELFIN_NAND_BASE+NFSECC_OFFSET)
#define NFMLCBITPT_REG         		__REG(ELFIN_NAND_BASE+NFMLCBITPT_OFFSET)

#define NFCONF_ECC_MLC			(1<<24)

#define NFCONF_ECC_1BIT			(0<<23)
#define NFCONF_ECC_4BIT			(2<<23)
#define NFCONF_ECC_8BIT			(1<<23)

#define NFCONT_ECC_ENC			(1<<18)
#define NFCONT_WP			(1<<16)
#define NFCONT_MECCLOCK			(1<<7)
#define NFCONT_SECCLOCK			(1<<6)
#define NFCONT_INITMECC			(1<<5)
#define NFCONT_INITSECC			(1<<4)
#define NFCONT_INITECC			(NFCONT_INITMECC | NFCONT_INITSECC)
#define NFCONT_CS			(1<<1)
#define NFSTAT_ECCENCDONE		(1<<7)
#define NFSTAT_ECCDECDONE		(1<<6)
#define NFSTAT_RnB			(1<<0)
#define NFESTAT0_ECCBUSY		(1<<31)
#endif

#if 1
/*************************************************************
 * OneNAND Controller
 *************************************************************/
#define ELFIN_ONENAND_BASE		0xB0000000

#define ONENAND_REG_MEM_CFG 		(0x000)
#define ONENAND_REG_BURST_LEN 		(0x010)
#define ONENAND_REG_MEM_RESET 		(0x020)
#define ONENAND_REG_INT_ERR_STAT 	(0x030)
#define ONENAND_REG_INT_ERR_MASK 	(0x040)
#define ONENAND_REG_INT_ERR_ACK 	(0x050)
#define ONENAND_REG_ECC_ERR_STAT_1 	(0x060)
#define ONENAND_REG_MANUFACT_ID 	(0x070)
#define ONENAND_REG_DEVICE_ID 		(0x080)
#define ONENAND_REG_DATA_BUF_SIZE	(0x090)
#define ONENAND_REG_BOOT_BUF_SIZE 	(0x0A0)
#define ONENAND_REG_BUF_AMOUNT 		(0x0B0)
#define ONENAND_REG_TECH 		(0x0C0)
#define ONENAND_REG_FBA_WIDTH 		(0x0D0)
#define ONENAND_REG_FPA_WIDTH 		(0x0E0)
#define ONENAND_REG_FSA_WIDTH 		(0x0F0)
#define ONENAND_REG_REVISION 		(0x100)
#define ONENAND_REG_SYNC_MODE 		(0x130)
#define ONENAND_REG_TRANS_SPARE 	(0x140)
#define ONENAND_REG_PAGE_CNT 		(0x170)
#define ONENAND_REG_ERR_PAGE_ADDR 	(0x180)
#define ONENAND_REG_BURST_RD_LAT 	(0x190)
#define ONENAND_REG_INT_PIN_ENABLE 	(0x1A0)
#define ONENAND_REG_INT_MON_CYC 	(0x1B0)
#define ONENAND_REG_ACC_CLOCK 		(0x1C0)
#define ONENAND_REG_ERR_BLK_ADDR 	(0x1E0)
#define ONENAND_REG_FLASH_VER_ID 	(0x1F0)
#define ONENAND_REG_BANK_EN 		(0x220)
#define ONENAND_REG_WTCHDG_RST_L 	(0x260)
#define ONENAND_REG_WTCHDG_RST_H 	(0x270)
#define ONENAND_REG_SYNC_WRITE 		(0x280)
#define ONENAND_REG_CACHE_READ 		(0x290)
#define ONENAND_REG_COLD_RST_DLY 	(0x2A0)
#define ONENAND_REG_DDP_DEVICE 		(0x2B0)
#define ONENAND_REG_MULTI_PLANE 	(0x2C0)
#define ONENAND_REG_MEM_CNT 		(0x2D0)
#define ONENAND_REG_TRANS_MODE 		(0x2E0)
#define ONENAND_REG_DEV_STAT 		(0x2F0)
#define ONENAND_REG_ECC_ERR_STAT_2 	(0x300)
#define ONENAND_REG_ECC_ERR_STAT_3 	(0x310)
#define ONENAND_REG_ECC_ERR_STAT_4 	(0x320)
#define ONENAND_REG_EFCT_BUF_CNT 	(0x330)
#define ONENAND_REG_DEV_PAGE_SIZE 	(0x340)
#define ONENAND_REG_SUPERLOAD_EN 	(0x350)
#define ONENAND_REG_CACHE_PRG_EN 	(0x360)
#define ONENAND_REG_SINGLE_PAGE_BUF 	(0x370)
#define ONENAND_REG_OFFSET_ADDR 	(0x380)
#define ONENAND_REG_INT_MON_STATUS 	(0x390)


#define ONENAND_MEM_CFG_SYNC_READ	(1 << 15)
#define ONENAND_MEM_CFG_BRL_7		(7 << 12)
#define ONENAND_MEM_CFG_BRL_6		(6 << 12)
#define ONENAND_MEM_CFG_BRL_5		(5 << 12)
#define ONENAND_MEM_CFG_BRL_4		(4 << 12)
#define ONENAND_MEM_CFG_BRL_3		(3 << 12)
#define ONENAND_MEM_CFG_BRL_10		(2 << 12)
#define ONENAND_MEM_CFG_BRL_9		(1 << 12)
#define ONENAND_MEM_CFG_BRL_8		(0 << 12)
#define ONENAND_MEM_CFG_BRL_SHIFT	(12)
#define ONENAND_MEM_CFG_BL_1K		(5 << 9)
#define ONENAND_MEM_CFG_BL_32		(4 << 9)
#define ONENAND_MEM_CFG_BL_16		(3 << 9)
#define ONENAND_MEM_CFG_BL_8		(2 << 9)
#define ONENAND_MEM_CFG_BL_4		(1 << 9)
#define ONENAND_MEM_CFG_BL_CONT		(0 << 9)
#define ONENAND_MEM_CFG_BL_SHIFT	(9)
#define ONENAND_MEM_CFG_NO_ECC		(1 << 8)
#define ONENAND_MEM_CFG_RDY_HIGH	(1 << 7)
#define ONENAND_MEM_CFG_INT_HIGH	(1 << 6)
#define ONENAND_MEM_CFG_IOBE		(1 << 5)
#define ONENAND_MEM_CFG_RDY_CONF	(1 << 4)
#define ONENAND_MEM_CFG_HF		(1 << 2)
#define ONENAND_MEM_CFG_WM_SYNC		(1 << 1)
#define ONENAND_MEM_CFG_BWPS_UNLOCK	(1 << 0)

#define ONENAND_BURST_LEN_CONT		(0)
#define ONENAND_BURST_LEN_4		(4)
#define ONENAND_BURST_LEN_8		(8)
#define ONENAND_BURST_LEN_16		(16)

#define ONENAND_MEM_RESET_WARM		(0x1)
#define ONENAND_MEM_RESET_COLD		(0x2)
#define ONENAND_MEM_RESET_HOT		(0x3)

#define ONENAND_INT_ERR_CACHE_OP_ERR	(1 << 13)
#define ONENAND_INT_ERR_RST_CMP		(1 << 12)
#define ONENAND_INT_ERR_RDY_ACT		(1 << 11)
#define ONENAND_INT_ERR_INT_ACT		(1 << 10)
#define ONENAND_INT_ERR_UNSUP_CMD	(1 << 9)
#define ONENAND_INT_ERR_LOCKED_BLK	(1 << 8)
#define ONENAND_INT_ERR_BLK_RW_CMP	(1 << 7)
#define ONENAND_INT_ERR_ERS_CMP		(1 << 6)
#define ONENAND_INT_ERR_PGM_CMP		(1 << 5)
#define ONENAND_INT_ERR_LOAD_CMP	(1 << 4)
#define ONENAND_INT_ERR_ERS_FAIL	(1 << 3)
#define ONENAND_INT_ERR_PGM_FAIL	(1 << 2)
#define ONENAND_INT_ERR_INT_TO		(1 << 1)
#define ONENAND_INT_ERR_LD_FAIL_ECC_ERR	(1 << 0)

#define ONENAND_DEVICE_DENSITY_SHIFT	(4)
#define ONENAND_DEVICE_IS_DDP		(1 << 3)
#define ONENAND_DEVICE_IS_DEMUX		(1 << 2)
#define ONENAND_DEVICE_VCC_MASK		(0x3)
#define ONENAND_DEVICE_DENSITY_128Mb	(0x000)
#define ONENAND_DEVICE_DENSITY_256Mb	(0x001)
#define ONENAND_DEVICE_DENSITY_512Mb	(0x002)
#define ONENAND_DEVICE_DENSITY_1Gb	(0x003)
#define ONENAND_DEVICE_DENSITY_2Gb	(0x004)
#define ONENAND_DEVICE_DENSITY_4Gb	(0x005)

#define ONENAND_SYNC_MODE_RM_SYNC	(1 << 1)
#define ONENAND_SYNC_MODE_WM_SYNC	(1 << 0)

#define ONENAND_TRANS_SPARE_TSRF_INC	(1 << 0)

#define ONENAND_INT_PIN_ENABLE		(1 << 0)

#define ONENAND_ACC_CLOCK_266_133	(0x5)
#define ONENAND_ACC_CLOCK_166_83	(0x3)
#define ONENAND_ACC_CLOCK_134_67	(0x3)
#define ONENAND_ACC_CLOCK_100_50	(0x2)
#define ONENAND_ACC_CLOCK_60_30		(0x2)

#define ONENAND_FLASH_AUX_WD_DISABLE	(1 << 0)

/*
 * Datain values for mapped commands
 */
#define ONENAND_DATAIN_ERASE_STATUS	(0x00)
#define ONENAND_DATAIN_ERASE_MULTI	(0x01)
#define ONENAND_DATAIN_ERASE_SINGLE	(0x03)
#define ONENAND_DATAIN_ERASE_VERIFY	(0x15)
#define ONENAND_DATAIN_UNLOCK_START	(0x08)
#define ONENAND_DATAIN_UNLOCK_END	(0x09)
#define ONENAND_DATAIN_LOCK_START	(0x0A)
#define ONENAND_DATAIN_LOCK_END		(0x0B)
#define ONENAND_DATAIN_LOCKTIGHT_START	(0x0C)
#define ONENAND_DATAIN_LOCKTIGHT_END	(0x0D)
#define ONENAND_DATAIN_UNLOCK_ALL	(0x0E)
#define ONENAND_DATAIN_COPYBACK_SRC	(0x1000)
#define ONENAND_DATAIN_COPYBACK_DST	(0x2000)
#define ONENAND_DATAIN_ACCESS_OTP	(0x12)
#define ONENAND_DATAIN_ACCESS_MAIN	(0x14)
#define ONENAND_DATAIN_ACCESS_SPARE	(0x13)
#define ONENAND_DATAIN_ACCESS_MAIN_AND_SPARE	(0x16)
#define ONENAND_DATAIN_PIPELINE_READ	(0x4000)
#define ONENAND_DATAIN_PIPELINE_WRITE	(0x4100)
#define ONENAND_DATAIN_RMW_LOAD		(0x10)
#define ONENAND_DATAIN_RMW_MODIFY	(0x11)

/*
 * Device ID Register F001h (R)
 */
#define ONENAND_DEVICE_DENSITY_SHIFT	(4)
#define ONENAND_DEVICE_IS_DDP		(1 << 3)
#define ONENAND_DEVICE_IS_DEMUX		(1 << 2)
#define ONENAND_DEVICE_VCC_MASK		(0x3)

/*
 * Version ID Register F002h (R)
 */
#define ONENAND_VERSION_PROCESS_SHIFT	(8)

/*
 * Start Address 1 F100h (R/W)
 */
#define ONENAND_DDP_SHIFT		(15)
#define ONENAND_DDP_CHIP0		(0)
#define ONENAND_DDP_CHIP1		(1 << ONENAND_DDP_SHIFT)

/*
 * Start Buffer Register F200h (R/W)
 */
#define ONENAND_BSA_MASK		(0x03)
#define ONENAND_BSA_SHIFT		(8)
#define ONENAND_BSA_BOOTRAM		(0 << 2)
#define ONENAND_BSA_DATARAM0		(2 << 2)
#define ONENAND_BSA_DATARAM1		(3 << 2)
#define ONENAND_BSC_MASK		(0x03)

/*
 * Command Register F220h (R/W)
 */
#define ONENAND_CMD_READ		(0x00)
#define ONENAND_CMD_READOOB		(0x13)
#define ONENAND_CMD_PROG		(0x80)
#define ONENAND_CMD_PROGOOB		(0x1A)
#define ONENAND_CMD_UNLOCK		(0x23)
#define ONENAND_CMD_LOCK		(0x2A)
#define ONENAND_CMD_LOCK_TIGHT		(0x2C)
#define ONENAND_CMD_UNLOCK_ALL		(0x27)
#define ONENAND_CMD_ERASE		(0x94)
#define ONENAND_CMD_RESET		(0xF0)
#define ONENAND_CMD_OTP_ACCESS		(0x65)
#define ONENAND_CMD_READID		(0x90)
#define ONENAND_CMD_STARTADDR1		(0xE0)
#define ONENAND_CMD_WP_STATUS		(0xE1)
#define ONENAND_CMD_PIPELINE_READ	(0x01)
#define ONENAND_CMD_PIPELINE_WRITE	(0x81)

/*
 * Command Mapping for S5P6442 OneNAND Controller
 */
#define ONENAND_AHB_ADDR		(0xB0000000)
#define ONENAND_DUMMY_ADDR		(0xB0400000)
#define ONENAND_CMD_SHIFT		(26)
#define ONENAND_CMD_MAP_00		(0x0)
#define ONENAND_CMD_MAP_01		(0x1)
#define ONENAND_CMD_MAP_10		(0x2)
#define ONENAND_CMD_MAP_11		(0x3)
#define ONENAND_CMD_MAP_FF		(0xF)

/*
 * Mask for Mapping table
 */
#define ONENAND_MEM_ADDR_MASK		(0xffffff)
#define ONENAND_DDP_SHIFT_1Gb		(22)
#define ONENAND_DDP_SHIFT_2Gb		(23)
#define ONENAND_DDP_SHIFT_4Gb		(24)
#define ONENAND_FBA_SHIFT		(13)
#define ONENAND_FPA_SHIFT		(7)
#define ONENAND_FSA_SHIFT		(5)
#define ONENAND_FBA_MASK_128Mb		(0xff)
#define ONENAND_FBA_MASK_256Mb		(0x1ff)
#define ONENAND_FBA_MASK_512Mb		(0x1ff)
#define ONENAND_FBA_MASK_1Gb_DDP	(0x1ff)
#define ONENAND_FBA_MASK_1Gb		(0x3ff)
#define ONENAND_FBA_MASK_2Gb_DDP	(0x3ff)
#define ONENAND_FBA_MASK_2Gb		(0x7ff)
#define ONENAND_FBA_MASK_4Gb_DDP	(0x7ff)
#define ONENAND_FBA_MASK_4Gb		(0xfff)
#define ONENAND_FPA_MASK		(0x3f)
#define ONENAND_FSA_MASK		(0x3)

/*
 * System Configuration 1 Register F221h (R, R/W)
 */
#define ONENAND_SYS_CFG1_SYNC_READ	(1 << 15)
#define ONENAND_SYS_CFG1_BRL_7		(7 << 12)
#define ONENAND_SYS_CFG1_BRL_6		(6 << 12)
#define ONENAND_SYS_CFG1_BRL_5		(5 << 12)
#define ONENAND_SYS_CFG1_BRL_4		(4 << 12)
#define ONENAND_SYS_CFG1_BRL_3		(3 << 12)
#define ONENAND_SYS_CFG1_BRL_10		(2 << 12)
#define ONENAND_SYS_CFG1_BRL_9		(1 << 12)
#define ONENAND_SYS_CFG1_BRL_8		(0 << 12)
#define ONENAND_SYS_CFG1_BRL_SHIFT	(12)
#define ONENAND_SYS_CFG1_BL_32		(4 << 9)
#define ONENAND_SYS_CFG1_BL_16		(3 << 9)
#define ONENAND_SYS_CFG1_BL_8		(2 << 9)
#define ONENAND_SYS_CFG1_BL_4		(1 << 9)
#define ONENAND_SYS_CFG1_BL_CONT	(0 << 9)
#define ONENAND_SYS_CFG1_BL_SHIFT	(9)
#define ONENAND_SYS_CFG1_NO_ECC		(1 << 8)
#define ONENAND_SYS_CFG1_RDY		(1 << 7)
#define ONENAND_SYS_CFG1_INT		(1 << 6)
#define ONENAND_SYS_CFG1_IOBE		(1 << 5)
#define ONENAND_SYS_CFG1_RDY_CONF	(1 << 4)

/*
 * Controller Status Register F240h (R)
 */
#define ONENAND_CTRL_ONGO		(1 << 15)
#define ONENAND_CTRL_LOCK		(1 << 14)
#define ONENAND_CTRL_LOAD		(1 << 13)
#define ONENAND_CTRL_PROGRAM		(1 << 12)
#define ONENAND_CTRL_ERASE		(1 << 11)
#define ONENAND_CTRL_ERROR		(1 << 10)
#define ONENAND_CTRL_RSTB		(1 << 7)
#define ONENAND_CTRL_OTP_L		(1 << 6)
#define ONENAND_CTRL_OTP_BL		(1 << 5)

/*
 * Interrupt Status Register F241h (R)
 */
#define ONENAND_INT_MASTER		(1 << 15)
#define ONENAND_INT_READ		(1 << 7)
#define ONENAND_INT_WRITE		(1 << 6)
#define ONENAND_INT_ERASE		(1 << 5)
#define ONENAND_INT_RESET		(1 << 4)
#define ONENAND_INT_CLEAR		(0 << 0)

/*
 * NAND Flash Write Protection Status Register F24Eh (R)
 */
#define ONENAND_WP_US			(1 << 2)
#define ONENAND_WP_LS			(1 << 1)
#define ONENAND_WP_LTS			(1 << 0)

/*
 * ECC Status Register FF00h (R)
 */
#define ONENAND_ECC_1BIT		(1 << 0)
#define ONENAND_ECC_1BIT_ALL		(0x5555)
#define ONENAND_ECC_2BIT		(1 << 1)
#define ONENAND_ECC_2BIT_ALL		(0xAAAA)

/*
 * One-Time Programmable (OTP)
 */
#define ONENAND_OTP_LOCK_OFFSET		(14)

#endif
/*************************************************************
 * End of OneNAND Controller
 *************************************************************/
/*
 * Interrupt
 */
#define ELFIN_VIC0_BASE_ADDR		(0xE4000000)
#define ELFIN_VIC1_BASE_ADDR		(0xE4100000)
#define ELFIN_VIC2_BASE_ADDR		(0xE4200000)

#if 0
#define ELFIN_TZIC0_BASE_ADDR		(0xF2800000)
#define ELFIN_TZIC1_BASE_ADDR		(0xF2900000)
#define ELFIN_TZIC2_BASE_ADDR		(0xF2A00000)
#endif

#define oINTMOD				(0x0C)		// VIC INT SELECT (IRQ or FIQ)
#define oINTUNMSK			(0x10)		// VIC INT EN (Unmask by writing 1)
#define oINTMSK				(0x14)		// VIC INT EN CLEAR (Mask by writing 1)
#define oINTSUBMSK			(0x1C)		// VIC SOFT INT CLEAR
#define oVECTADDR			(0xF00)		// VIC ADDRESS

/*
 * Watchdog timer
 */
#define ELFIN_WATCHDOG_BASE		0xEA200000

#define WTCON_OFFSET			0x00
#define WTDAT_OFFSET			0x04
#define WTCNT_OFFSET			0x08

#define WTCON_REG			__REG(ELFIN_WATCHDOG_BASE+WTCON_OFFSET)
#define WTDAT_REG			__REG(ELFIN_WATCHDOG_BASE+WTDAT_OFFSET)
#define WTCNT_REG			__REG(ELFIN_WATCHDOG_BASE+WTCNT_OFFSET)

/*
 * UART
 */
#define ELFIN_UART_BASE			0xEC000000

#define ELFIN_UART0_OFFSET		0x0000
#define ELFIN_UART1_OFFSET		0x0400
#define ELFIN_UART2_OFFSET		0x0800
#define ELFIN_UART3_OFFSET		0x0c00

#if defined(CONFIG_SERIAL1)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART0_OFFSET)
#elif defined(CONFIG_SERIAL2)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART1_OFFSET)
#elif defined(CONFIG_SERIAL3)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART2_OFFSET)
#elif defined(CONFIG_SERIAL4)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART3_OFFSET)
#else
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART0_OFFSET)
#endif

#define ULCON_OFFSET			0x00
#define UCON_OFFSET			0x04
#define UFCON_OFFSET			0x08
#define UMCON_OFFSET			0x0C
#define UTRSTAT_OFFSET			0x10
#define UERSTAT_OFFSET			0x14
#define UFSTAT_OFFSET			0x18
#define UMSTAT_OFFSET			0x1C
#define UTXH_OFFSET			0x20
#define URXH_OFFSET			0x24
#define UBRDIV_OFFSET			0x28
#define UDIVSLOT_OFFSET			0x2C
#define UINTP_OFFSET			0x30
#define UINTSP_OFFSET			0x34
#define UINTM_OFFSET			0x38

#define UTRSTAT_TX_EMPTY		BIT2
#define UTRSTAT_RX_READY		BIT0
#define UART_ERR_MASK			0xF

/*
 * PWM timer
 */
#define ELFIN_TIMER_BASE		0xEA000000

#define TCFG0_REG			__REG(0xEA000000)
#define TCFG1_REG			__REG(0xEA000004)
#define TCON_REG			__REG(0xEA000008)
#define TCNTB0_REG			__REG(0xEA00000C)
#define TCMPB0_REG			__REG(0xEA000010)
#define TCNTO0_REG			__REG(0xEA000014)
#define TCNTB1_REG			__REG(0xEA000018)
#define TCMPB1_REG			__REG(0xEA00001C)
#define TCNTO1_REG			__REG(0xEA000020)
#define TCNTB2_REG			__REG(0xEA000024)
#define TCMPB2_REG			__REG(0xEA000028)
#define TCNTO2_REG			__REG(0xEA00002C)
#define TCNTB3_REG			__REG(0xEA000030)
#define TCMPB3_REG			__REG(0xEA000034)
#define TCNTO3_REG			__REG(0xEA000038)
#define TCNTB4_REG			__REG(0xEA00003C)
#define TCNTO4_REG			__REG(0xEA000040)
#define TINT_CSTAT_REG			__REG(0xEA000044)

/* Fields */
#define fTCFG0_DZONE			Fld(8,16)       /* the dead zone length (= timer 0) */
#define fTCFG0_PRE1			Fld(8,8)        /* prescaler value for time 2,3,4 */
#define fTCFG0_PRE0			Fld(8,0)        /* prescaler value for time 0,1 */
#define fTCFG1_MUX4			Fld(4,16)

/* bits */
#define TCFG0_DZONE(x)			FInsrt((x), fTCFG0_DZONE)
#define TCFG0_PRE1(x)			FInsrt((x), fTCFG0_PRE1)
#define TCFG0_PRE0(x)			FInsrt((x), fTCFG0_PRE0)
#define TCON_4_AUTO			(1 << 22)       /* auto reload on/off for Timer 4 */
#define TCON_4_UPDATE			(1 << 21)       /* manual Update TCNTB4 */
#define TCON_4_ONOFF			(1 << 20)       /* 0: Stop, 1: start Timer 4 */
#define COUNT_4_ON			(TCON_4_ONOFF*1)
#define COUNT_4_OFF			(TCON_4_ONOFF*0)
#define TCON_3_AUTO			(1 << 19)       /* auto reload on/off for Timer 3 */
#define TIMER3_ATLOAD_ON		(TCON_3_AUTO*1)
#define TIMER3_ATLAOD_OFF		FClrBit(TCON, TCON_3_AUTO)
#define TCON_3_INVERT			(1 << 18)       /* 1: Inverter on for TOUT3 */
#define TIMER3_IVT_ON			(TCON_3_INVERT*1)
#define TIMER3_IVT_OFF			(FClrBit(TCON, TCON_3_INVERT))
#define TCON_3_MAN			(1 << 17)       /* manual Update TCNTB3,TCMPB3 */
#define TIMER3_MANUP			(TCON_3_MAN*1)
#define TIMER3_NOP			(FClrBit(TCON, TCON_3_MAN))
#define TCON_3_ONOFF			(1 << 16)       /* 0: Stop, 1: start Timer 3 */
#define TIMER3_ON			(TCON_3_ONOFF*1)
#define TIMER3_OFF			(FClrBit(TCON, TCON_3_ONOFF))
/* macros */
#define GET_PRESCALE_TIMER4(x)		FExtr((x), fTCFG0_PRE1)
#define GET_DIVIDER_TIMER4(x)		FExtr((x), fTCFG1_MUX4)

/*
 * USB2.0 HS OTG (Chapter 26)
 */
#define USBOTG_PHY_BASE			(0xED300000)
#define USBOTG_LINK_BASE		(0xED200000)


#define S5P_OTG_PHYPWR	 		(USBOTG_PHY_BASE + 0x000) /* R/W OTG PHY Power Control Register */
#define S5P_OTG_PHYCLK 			(USBOTG_PHY_BASE + 0x004) /* R/W OTG PHY Clock Control Register */
#define S5P_OTG_RSTCON 			(USBOTG_PHY_BASE + 0x008) /* R/W OTG Reset Control Register */
#define S5P_OTG_PHYTUNE0 		(USBOTG_PHY_BASE + 0x024) /* R/W OTG PHY0 Tuning Register */

/* Core Global Register */
#define S5P_OTG_GOTGCTL 		(USBOTG_LINK_BASE + 0x000) /* R/W OTG Control and Status Register */
#define S5P_OTG_GOTGINT 		(USBOTG_LINK_BASE + 0x004) /* R/W OTG Interrupt Register */
#define S5P_OTG_GAHBCFG 		(USBOTG_LINK_BASE + 0x008) /* R/W Core AHB Configuration Register */
#define S5P_OTG_GUSBCFG 		(USBOTG_LINK_BASE + 0x00C) /* R/W Core USB Configuration Register */
#define S5P_OTG_GRSTCTL 		(USBOTG_LINK_BASE + 0x010) /* R/W Core Reset Register */
#define S5P_OTG_GINTSTS 		(USBOTG_LINK_BASE + 0x014) /* R/W Core Interrupt Register */
#define S5P_OTG_GINTMSK 		(USBOTG_LINK_BASE + 0x018) /* R/W Core Interrupt Mask Register */
#define S5P_OTG_GRXSTSR 		(USBOTG_LINK_BASE + 0x01C) /* R Receive Status Debug Read Register */
#define S5P_OTG_GRXSTSP 		(USBOTG_LINK_BASE + 0x020) /* R Receive Status Read/Pop Register */
#define S5P_OTG_GRXFSIZ 		(USBOTG_LINK_BASE + 0x024) /* R/W Receive FIFO Size Register */
#define S5P_OTG_GNPTXFSIZ 		(USBOTG_LINK_BASE + 0x028) /* R/W Non-Periodic Transmit FIFO Size Register */
#define S5P_OTG_GNPTXSTS 		(USBOTG_LINK_BASE + 0x02C) /* R Non-Periodic Transmit FIFO/Queue Status Register */
#define S5P_OTG_HPTXFSIZ 		(USBOTG_LINK_BASE + 0x100) /* R/W Host Periodic Transmit FIFO Size Register */
#define S5P_OTG_DPTXFSIZ1 		(USBOTG_LINK_BASE + 0x104) /* R/W Device Periodic Transmit FIFO-1 Size Register */
#define S5P_OTG_DPTXFSIZ2 		(USBOTG_LINK_BASE + 0x108) /* R/W Device Periodic Transmit FIFO-2 Size Register */
#define S5P_OTG_DPTXFSIZ3 		(USBOTG_LINK_BASE + 0x10C) /* R/W Device Periodic Transmit FIFO-3 Size Register */
#define S5P_OTG_DPTXFSIZ4 		(USBOTG_LINK_BASE + 0x110) /* R/W Device Periodic Transmit FIFO-4 Size Register */
#define S5P_OTG_DPTXFSIZ5 		(USBOTG_LINK_BASE + 0x114) /* R/W Device Periodic Transmit FIFO-5 Size Register */
#define S5P_OTG_DPTXFSIZ6 		(USBOTG_LINK_BASE + 0x118) /* R/W Device Periodic Transmit FIFO-6 Size Register */
#define S5P_OTG_DPTXFSIZ7 		(USBOTG_LINK_BASE + 0x11C) /* R/W Device Periodic Transmit FIFO-7 Size Register */
#define S5P_OTG_DPTXFSIZ8 		(USBOTG_LINK_BASE + 0x120) /* R/W Device Periodic Transmit FIFO-8 Size Register */
#define S5P_OTG_DPTXFSIZ9 		(USBOTG_LINK_BASE + 0x124) /* R/W Device Periodic Transmit FIFO-9 Size Register */
#define S5P_OTG_DPTXFSIZ10 		(USBOTG_LINK_BASE + 0x128) /* R/W Device Periodic Transmit FIFO-10 Size Register */
#define S5P_OTG_DPTXFSIZ11 		(USBOTG_LINK_BASE + 0x12C) /* R/W Device Periodic Transmit FIFO-11 Size Register */
#define S5P_OTG_DPTXFSIZ12 		(USBOTG_LINK_BASE + 0x130) /* R/W Device Periodic Transmit FIFO-12 Size Register */
#define S5P_OTG_DPTXFSIZ13 		(USBOTG_LINK_BASE + 0x134) /* R/W Device Periodic Transmit FIFO-13 Size Register */
#define S5P_OTG_DPTXFSIZ14 		(USBOTG_LINK_BASE + 0x138) /* R/W Device Periodic Transmit FIFO-14 Size Register */
#define S5P_OTG_DPTXFSIZ15 		(USBOTG_LINK_BASE + 0x13C) /* R/W Device Periodic Transmit FIFO-15 Size Register */

/* Host Mode Register */
/* Host Global Register */
#define S5P_OTG_HCFG 			(USBOTG_LINK_BASE + 0x400) /* R/W Host Configuration Register */
#define S5P_OTG_HFIR 			(USBOTG_LINK_BASE + 0x404) /* R/W Host Frame Interval Register */
#define S5P_OTG_HFNUM 			(USBOTG_LINK_BASE + 0x408) /* R Host Frame Number/Frame Time Remaining Register */

#define S5P_OTG_HPTXSTS 		(USBOTG_LINK_BASE + 0x410) /* R Host Periodic Transmit FIFO/Queue Status Register */
#define S5P_OTG_HAINT 			(USBOTG_LINK_BASE + 0x414) /* R Host All Channels Interrupt Register */
#define S5P_OTG_HAINTMSK 		(USBOTG_LINK_BASE + 0x418) /* R/W Host All Channels Interrupt Mask Register */

/*Host Port Control and Status Register */
#define S5P_OTG_HPRT 			(USBOTG_LINK_BASE + 0x440) /* R/W Host Port Control and Status Register */

/*Host Channel-Specific Register */
#define S5P_OTG_HCCHAR0 		(USBOTG_LINK_BASE + 0x500) /* R/W Host Channel 0 Characteristics Register */
#define S5P_OTG_HCSPLT0 		(USBOTG_LINK_BASE + 0x504) /* R/W Host Channel 0 Spilt Control Register */
#define S5P_OTG_HCINT0 			(USBOTG_LINK_BASE + 0x508) /* R/W Host Channel 0 Interrupt Register */
#define S5P_OTG_HCINTMSK0 		(USBOTG_LINK_BASE + 0x50C) /* R/W Host Channel 0 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ0 		(USBOTG_LINK_BASE + 0x510) /* R/W Host Channel 0 Transfer Size Register */
#define S5P_OTG_HCDMA0 			(USBOTG_LINK_BASE + 0x514) /* R/W Host Channel 0 DMA Address Register */
#define S5P_OTG_HCCHAR1 		(USBOTG_LINK_BASE + 0x520) /* R/W Host Channel 1 Characteristics Register */
#define S5P_OTG_HCSPLT1 		(USBOTG_LINK_BASE + 0x524) /* R/W Host Channel 1 Spilt Control Register */
#define S5P_OTG_HCINT1 			(USBOTG_LINK_BASE + 0x528) /* R/W Host Channel 1 Interrupt Register */
#define S5P_OTG_HCINTMSK1 		(USBOTG_LINK_BASE + 0x52C) /* R/W Host Channel 1 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ1 		(USBOTG_LINK_BASE + 0x530) /* R/W Host Channel 1 Transfer Size Register */
#define S5P_OTG_HCDMA1 			(USBOTG_LINK_BASE + 0x534) /* R/W Host Channel 1 DMA Address Register */
#define S5P_OTG_HCCHAR2 		(USBOTG_LINK_BASE + 0x540) /* R/W Host Channel 2 Characteristics Register */
#define S5P_OTG_HCSPLT2 		(USBOTG_LINK_BASE + 0x544) /* R/W Host Channel 2 Spilt Control Register */
#define S5P_OTG_HCINT2 			(USBOTG_LINK_BASE + 0x548) /* R/W Host Channel 2 Interrupt Register */
#define S5P_OTG_HCINTMSK2 		(USBOTG_LINK_BASE + 0x54C) /* R/W Host Channel 2 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ2 		(USBOTG_LINK_BASE + 0x550) /* R/W Host Channel 2 Transfer Size Register */
#define S5P_OTG_HCDMA2 			(USBOTG_LINK_BASE + 0x554) /* R/W Host Channel 2 DMA Address Register */
#define S5P_OTG_HCCHAR3 		(USBOTG_LINK_BASE + 0x560) /* R/W Host Channel 3 Characteristics Register */
#define S5P_OTG_HCSPLT3 		(USBOTG_LINK_BASE + 0x564) /* R/W Host Channel 3 Spilt Control Register */
#define S5P_OTG_HCINT3 			(USBOTG_LINK_BASE + 0x568) /* R/W Host Channel 3 Interrupt Register */
#define S5P_OTG_HCINTMSK3 		(USBOTG_LINK_BASE + 0x56C) /* R/W Host Channel 3 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ3 		(USBOTG_LINK_BASE + 0x570) /* R/W Host Channel 3 Transfer Size Register */
#define S5P_OTG_HCDMA3 			(USBOTG_LINK_BASE + 0x574) /* R/W Host Channel 3 DMA Address Register */
#define S5P_OTG_HCCHAR4 		(USBOTG_LINK_BASE + 0x580) /* R/W Host Channel 4 Characteristics Register */
#define S5P_OTG_HCSPLT4 		(USBOTG_LINK_BASE + 0x584) /* R/W Host Channel 4 Spilt Control Register */
#define S5P_OTG_HCINT4 			(USBOTG_LINK_BASE + 0x588) /* R/W Host Channel 4 Interrupt Register */
#define S5P_OTG_HCINTMSK4 		(USBOTG_LINK_BASE + 0x58C) /* R/W Host Channel 4 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ4 		(USBOTG_LINK_BASE + 0x580) /* R/W Host Channel 4 Transfer Size Register */
#define S5P_OTG_HCDMA4 			(USBOTG_LINK_BASE + 0x584) /* R/W Host Channel 4 DMA Address Register */
#define S5P_OTG_HCCHAR5 		(USBOTG_LINK_BASE + 0x5A0) /* R/W Host Channel 5 Characteristics Register */
#define S5P_OTG_HCSPLT5 		(USBOTG_LINK_BASE + 0x5A4) /* R/W Host Channel 5 Spilt Control Register */
#define S5P_OTG_HCINT5 			(USBOTG_LINK_BASE + 0x5A8) /* R/W Host Channel 5 Interrupt Register */
#define S5P_OTG_HCINTMSK5 		(USBOTG_LINK_BASE + 0x5AC) /* R/W Host Channel 5 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ5 		(USBOTG_LINK_BASE + 0x5B0) /* R/W Host Channel 5 Transfer Size Register */
#define S5P_OTG_HCDMA5 			(USBOTG_LINK_BASE + 0x5B4) /* R/W Host Channel 5 DMA Address Register */
#define S5P_OTG_HCCHAR6 		(USBOTG_LINK_BASE + 0x5C0) /* R/W Host Channel 6 Characteristics Register */
#define S5P_OTG_HCSPLT6 		(USBOTG_LINK_BASE + 0x5C4) /* R/W Host Channel 6 Spilt Control Register */
#define S5P_OTG_HCINT6 			(USBOTG_LINK_BASE + 0x5C8) /* R/W Host Channel 6 Interrupt Register */
#define S5P_OTG_HCINTMSK6 		(USBOTG_LINK_BASE + 0x5CC) /* R/W Host Channel 6 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ6 		(USBOTG_LINK_BASE + 0x5D0) /* R/W Host Channel 6 Transfer Size Register */
#define S5P_OTG_HCDMA6 			(USBOTG_LINK_BASE + 0x5D4) /* R/W Host Channel 6 DMA Address Register */
#define S5P_OTG_HCCHAR7 		(USBOTG_LINK_BASE + 0x5E0) /* R/W Host Channel 7 Characteristics Register */
#define S5P_OTG_HCSPLT7 		(USBOTG_LINK_BASE + 0x5E4) /* R/W Host Channel 7 Spilt Control Register */
#define S5P_OTG_HCINT7 			(USBOTG_LINK_BASE + 0x5E8) /* R/W Host Channel 7 Interrupt Register */
#define S5P_OTG_HCINTMSK7 		(USBOTG_LINK_BASE + 0x5EC) /* R/W Host Channel 7 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ7 		(USBOTG_LINK_BASE + 0x5F0) /* R/W Host Channel 7 Transfer Size Register */
#define S5P_OTG_HCDMA7 			(USBOTG_LINK_BASE + 0x5F4) /* R/W Host Channel 7 DMA Address Register */
#define S5P_OTG_HCCHAR8 		(USBOTG_LINK_BASE + 0x600) /* R/W Host Channel 8 Characteristics Register */
#define S5P_OTG_HCSPLT8 		(USBOTG_LINK_BASE + 0x604) /* R/W Host Channel 8 Spilt Control Register */
#define S5P_OTG_HCINT8 			(USBOTG_LINK_BASE + 0x608) /* R/W Host Channel 8 Interrupt Register */
#define S5P_OTG_HCINTMSK8 		(USBOTG_LINK_BASE + 0x60C) /* R/W Host Channel 8 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ8 		(USBOTG_LINK_BASE + 0x610) /* R/W Host Channel 8 Transfer Size Register */
#define S5P_OTG_HCDMA8 			(USBOTG_LINK_BASE + 0x614) /* R/W Host Channel 8 DMA Address Register */
#define S5P_OTG_HCCHAR9 		(USBOTG_LINK_BASE + 0x620) /* R/W Host Channel 9 Characteristics Register */
#define S5P_OTG_HCSPLT9 		(USBOTG_LINK_BASE + 0x624) /* R/W Host Channel 9 Spilt Control Register */
#define S5P_OTG_HCINT9 			(USBOTG_LINK_BASE + 0x628) /* R/W Host Channel 9 Interrupt Register */
#define S5P_OTG_HCINTMSK9 		(USBOTG_LINK_BASE + 0x62C) /* R/W Host Channel 9 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ9 		(USBOTG_LINK_BASE + 0x630) /* R/W Host Channel 9 Transfer Size Register */
#define S5P_OTG_HCDMA9 			(USBOTG_LINK_BASE + 0x634) /* R/W Host Channel 9 DMA Address Register */
#define S5P_OTG_HCCHAR10 		(USBOTG_LINK_BASE + 0x640) /* R/W Host Channel 10 Characteristics Register */
#define S5P_OTG_HCSPLT10 		(USBOTG_LINK_BASE + 0x644) /* R/W Host Channel 10 Spilt Control Register */
#define S5P_OTG_HCINT10 		(USBOTG_LINK_BASE + 0x648) /* R/W Host Channel 10 Interrupt Register */
#define S5P_OTG_HCINTMSK10 		(USBOTG_LINK_BASE + 0x64C) /* R/W Host Channel 10 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ10 		(USBOTG_LINK_BASE + 0x650) /* R/W Host Channel 10 Transfer Size Register */
#define S5P_OTG_HCDMA10 		(USBOTG_LINK_BASE + 0x654) /* R/W Host Channel 10 DMA Address Register */
#define S5P_OTG_HCCHAR11 		(USBOTG_LINK_BASE + 0x660) /* R/W Host Channel 11 Characteristics Register */
#define S5P_OTG_HCSPLT11 		(USBOTG_LINK_BASE + 0x664) /* R/W Host Channel 11 Spilt Control Register */
#define S5P_OTG_HCINT11 		(USBOTG_LINK_BASE + 0x668) /* R/W Host Channel 11 Interrupt Register */
#define S5P_OTG_HCINTMSK11 		(USBOTG_LINK_BASE + 0x66C) /* R/W Host Channel 11 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ11 		(USBOTG_LINK_BASE + 0x670) /* R/W Host Channel 11 Transfer Size Register */
#define S5P_OTG_HCDMA11 		(USBOTG_LINK_BASE + 0x674) /* R/W Host Channel 11 DMA Address Register */
#define S5P_OTG_HCCHAR12 		(USBOTG_LINK_BASE + 0x680) /* R/W Host Channel 12 Characteristics Register */
#define S5P_OTG_HCSPLT12 		(USBOTG_LINK_BASE + 0x684) /* R/W Host Channel 12 Spilt Control Register */
#define S5P_OTG_HCINT12 		(USBOTG_LINK_BASE + 0x688) /* R/W Host Channel 12 Interrupt Register */
#define S5P_OTG_HCINTMSK12 		(USBOTG_LINK_BASE + 0x68C) /* R/W Host Channel 12 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ12 		(USBOTG_LINK_BASE + 0x690) /* R/W Host Channel 12 Transfer Size Register */
#define S5P_OTG_HCDMA12 		(USBOTG_LINK_BASE + 0x694) /* R/W Host Channel 12 DMA Address Register */
#define S5P_OTG_HCCHAR13 		(USBOTG_LINK_BASE + 0x6A0) /* R/W Host Channel 13 Characteristics Register */
#define S5P_OTG_HCSPLT13 		(USBOTG_LINK_BASE + 0x6A4) /* R/W Host Channel 13 Spilt Control Register */
#define S5P_OTG_HCINT13 		(USBOTG_LINK_BASE + 0x6A8) /* R/W Host Channel 13 Interrupt Register */
#define S5P_OTG_HCINTMSK13 		(USBOTG_LINK_BASE + 0x6AC) /* R/W Host Channel 13 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ13 		(USBOTG_LINK_BASE + 0x6B0) /* R/W Host Channel 13 Transfer Size Register */
#define S5P_OTG_HCDMA13 		(USBOTG_LINK_BASE + 0x6B4) /* R/W Host Channel 13 DMA Address Register */
#define S5P_OTG_HCCHAR14 		(USBOTG_LINK_BASE + 0x6C0) /* R/W Host Channel 14 Characteristics Register */
#define S5P_OTG_HCSPLT14 		(USBOTG_LINK_BASE + 0x6C4) /* R/W Host Channel 14 Spilt Control Register */
#define S5P_OTG_HCINT14 		(USBOTG_LINK_BASE + 0x6C8) /* R/W Host Channel 14 Interrupt Register */
#define S5P_OTG_HCINTMSK14 		(USBOTG_LINK_BASE + 0x6CC) /* R/W Host Channel 14 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ14	 	(USBOTG_LINK_BASE + 0x6D0) /* R/W Host Channel 14 Transfer Size Register */
#define S5P_OTG_HCDMA14 		(USBOTG_LINK_BASE + 0x6D4) /* R/W Host Channel 14 DMA Address Register */
#define S5P_OTG_HCCHAR15 		(USBOTG_LINK_BASE + 0x6E0) /* R/W Host Channel 15 Characteristics Register */
#define S5P_OTG_HCSPLT15 		(USBOTG_LINK_BASE + 0x6E4) /* R/W Host Channel 15 Spilt Control Register */
#define S5P_OTG_HCINT15 		(USBOTG_LINK_BASE + 0x6E8) /* R/W Host Channel 15 Interrupt Register */
#define S5P_OTG_HCINTMSK15 		(USBOTG_LINK_BASE + 0x6EC) /* R/W Host Channel 15 Interrupt Mask Register */
#define S5P_OTG_HCTSIZ15 		(USBOTG_LINK_BASE + 0x6F0) /* R/W Host Channel 15 Transfer Size Register */
#define S5P_OTG_HCDMA15 		(USBOTG_LINK_BASE + 0x6F4) /* R/W Host Channel 15 DMA Address Register */

/* Device Global Register */
#define S5P_OTG_DCFG 			(USBOTG_LINK_BASE + 0x800) /* R/W Device Configuration Register */
#define S5P_OTG_DCTL 			(USBOTG_LINK_BASE + 0x804) /* R/W Device Control Register */
#define S5P_OTG_DSTS 			(USBOTG_LINK_BASE + 0x808) /* R Device Status Register */
#define S5P_OTG_DIEPMSK 		(USBOTG_LINK_BASE + 0x810) /* R/W Device IN Endpoint Common Interrupt Mask Register */
#define S5P_OTG_DOEPMSK 		(USBOTG_LINK_BASE + 0x814) /* R/W Device OUT Endpoint Common Interrupt Mask Register */
#define S5P_OTG_DAINT 			(USBOTG_LINK_BASE + 0x818) /* R Device ALL Endpoints Interrupt Register */
#define S5P_OTG_DAINTMSK 		(USBOTG_LINK_BASE + 0x81C) /* R/W Device ALL Endpoints Interrupt Mask Register */
#define S5P_OTG_DTKNQR1 		(USBOTG_LINK_BASE + 0x820) /* R Device IN Token Sequence Learning Queue Read Register */
#define S5P_OTG_DTKNQR2 		(USBOTG_LINK_BASE + 0x824) /* R Device IN Token Sequence Learning Queue Read Register */
#define S5P_OTG_DVBUSDIS 		(USBOTG_LINK_BASE + 0x828) /* R/W Device VBUS Discharge Time Register */
#define S5P_OTG_DVBUSPULSE 		(USBOTG_LINK_BASE + 0x82C) /* R/W Device VBUS Pulsing Time Register */
#define S5P_OTG_DTKNQR3 		(USBOTG_LINK_BASE + 0x830) /* R Device IN Token Sequence Learning Queue Read Register */
#define S5P_OTG_DTKNQR4 		(USBOTG_LINK_BASE + 0x834) /* R Device IN Token Sequence Learning Queue Read Register */

/* Device Logical IN Endpo int-Specific Registers */
#define S5P_OTG_DIEPCTL0 		(USBOTG_LINK_BASE + 0x900) /* R/W Device Control IN Endpoint 0 Control Register */
#define S5P_OTG_DIEPINT0 		(USBOTG_LINK_BASE + 0x908) /* R/W Device IN Endpoint 0 Interrupt Register */
#define S5P_OTG_DIEPTSIZ0 		(USBOTG_LINK_BASE + 0x910) /* R/W Device IN Endpoint 0 Transfer Size Register */
#define S5P_OTG_DIEPDMA0 		(USBOTG_LINK_BASE + 0x914) /* R/W Device IN Endpoint 0 DMA Address Register */
#define S5P_OTG_DIEPCTL1 		(USBOTG_LINK_BASE + 0x920) /* R/W Device Control IN Endpoint 1 Control Register */
#define S5P_OTG_DIEPINT1 		(USBOTG_LINK_BASE + 0x928) /* R/W Device IN Endpoint 1 Interrupt Register */
#define S5P_OTG_DIEPTSIZ1 		(USBOTG_LINK_BASE + 0x930) /* R/W Device IN Endpoint 1 Transfer Size Register */
#define S5P_OTG_DIEPDMA1 		(USBOTG_LINK_BASE + 0x934) /* R/W Device IN Endpoint 1 DMA Address Register */
#define S5P_OTG_DIEPCTL2 		(USBOTG_LINK_BASE + 0x940) /* R/W Device Control IN Endpoint 2 Control Register */
#define S5P_OTG_DIEPINT2 		(USBOTG_LINK_BASE + 0x948) /* R/W Device IN Endpoint 2 Interrupt Register */
#define S5P_OTG_DIEPTSIZ2 		(USBOTG_LINK_BASE + 0x950) /* R/W Device IN Endpoint 2 Transfer Size Register */
#define S5P_OTG_DIEPDMA2 		(USBOTG_LINK_BASE + 0x954) /* R/W Device IN Endpoint 2 DMA Address Register */
#define S5P_OTG_DIEPCTL3 		(USBOTG_LINK_BASE + 0x960) /* R/W Device Control IN Endpoint 3 Control Register */
#define S5P_OTG_DIEPINT3 		(USBOTG_LINK_BASE + 0x968) /* R/W Device IN Endpoint 3 Interrupt Register */
#define S5P_OTG_DIEPTSIZ3 		(USBOTG_LINK_BASE + 0x970) /* R/W Device IN Endpoint 3 Transfer Size Register */
#define S5P_OTG_DIEPDMA3 		(USBOTG_LINK_BASE + 0x974) /* R/W Device IN Endpoint 3 DMA Address Register */
#define S5P_OTG_DIEPCTL4 		(USBOTG_LINK_BASE + 0x980) /* R/W Device Control IN Endpoint 0 Control Register */
#define S5P_OTG_DIEPINT4 		(USBOTG_LINK_BASE + 0x988) /* R/W Device IN Endpoint 4 Interrupt Register */
#define S5P_OTG_DIEPTSIZ4 		(USBOTG_LINK_BASE + 0x990) /* R/W Device IN Endpoint 4 Transfer Size Register */
#define S5P_OTG_DIEPDMA4 		(USBOTG_LINK_BASE + 0x994) /* R/W Device IN Endpoint 4 DMA Address Register */
#define S5P_OTG_DIEPCTL5 		(USBOTG_LINK_BASE + 0x9A0) /* R/W Device Control IN Endpoint 5 Control Register */
#define S5P_OTG_DIEPINT5 		(USBOTG_LINK_BASE + 0x9A8) /* R/W Device IN Endpoint 5 Interrupt Register */
#define S5P_OTG_DIEPTSIZ5 		(USBOTG_LINK_BASE + 0x9B0) /* R/W Device IN Endpoint 5 Transfer Size Register */
#define S5P_OTG_DIEPDMA5 		(USBOTG_LINK_BASE + 0x9B4) /* R/W Device IN Endpoint 5 DMA Address Register */
#define S5P_OTG_DIEPCTL6 		(USBOTG_LINK_BASE + 0x9C0) /* R/W Device Control IN Endpoint 6 Control Register */
#define S5P_OTG_DIEPINT6		(USBOTG_LINK_BASE + 0x9C8) /* R/W Device IN Endpoint 6 Interrupt Register */
#define S5P_OTG_DIEPTSIZ6		(USBOTG_LINK_BASE + 0x9D0) /* R/W Device IN Endpoint 6 Transfer Size Register */
#define S5P_OTG_DIEPDMA6		(USBOTG_LINK_BASE + 0x9D4) /* R/W Device IN Endpoint 6 DMA Address Register */
#define S5P_OTG_DIEPCTL7		(USBOTG_LINK_BASE + 0x9E0) /* R/W Device Control IN Endpoint 7 Control Register */
#define S5P_OTG_DIEPINT7		(USBOTG_LINK_BASE + 0x9E8) /* R/W Device IN Endpoint 7 Interrupt Register */
#define S5P_OTG_DIEPTSIZ7		(USBOTG_LINK_BASE + 0x9F0) /* R/W Device IN Endpoint 7 Transfer Size Register */
#define S5P_OTG_DIEPDMA7		(USBOTG_LINK_BASE + 0x9F4) /* R/W Device IN Endpoint 7 DMA Address Register */
#define S5P_OTG_DIEPCTL8		(USBOTG_LINK_BASE + 0xA00) /* R/W Device Control IN Endpoint 8 Control Register */
#define S5P_OTG_DIEPINT8		(USBOTG_LINK_BASE + 0xA08) /* R/W Device IN Endpoint 8 Interrupt Register */
#define S5P_OTG_DIEPTSIZ8		(USBOTG_LINK_BASE + 0xA10) /* R/W Device IN Endpoint 8 Transfer Size Register */
#define S5P_OTG_DIEPDMA8		(USBOTG_LINK_BASE + 0xA14) /* R/W Device IN Endpoint 8 DMA Address Register */
#define S5P_OTG_DIEPCTL9		(USBOTG_LINK_BASE + 0xA20) /* R/W Device Control IN Endpoint 9 Control Register */
#define S5P_OTG_DIEPINT9		(USBOTG_LINK_BASE + 0xA28) /* R/W Device IN Endpoint 9 Interrupt Register */
#define S5P_OTG_DIEPTSIZ9		(USBOTG_LINK_BASE + 0xA30) /* R/W Device IN Endpoint 9 Transfer Size Register */
#define S5P_OTG_DIEPDMA9		(USBOTG_LINK_BASE + 0xA34) /* R/W Device IN Endpoint 9 DMA Address Register */
#define S5P_OTG_DIEPCTL10		(USBOTG_LINK_BASE + 0xA40) /* R/W Device Control IN Endpoint 10 Control Register */
#define S5P_OTG_DIEPINT10		(USBOTG_LINK_BASE + 0xA48) /* R/W Device IN Endpoint 10 Interrupt Register */
#define S5P_OTG_DIEPTSIZ10		(USBOTG_LINK_BASE + 0xA50) /* R/W Device IN Endpoint 10 Transfer Size Register */
#define S5P_OTG_DIEPDMA10		(USBOTG_LINK_BASE + 0xA54) /* R/W Device IN Endpoint 10 DMA Address Register */
#define S5P_OTG_DIEPCTL11		(USBOTG_LINK_BASE + 0xA60) /* R/W Device Control IN Endpoint 11 Control Register */
#define S5P_OTG_DIEPINT11		(USBOTG_LINK_BASE + 0xA68) /* R/W Device IN Endpoint 11 Interrupt Register */
#define S5P_OTG_DIEPTSIZ11		(USBOTG_LINK_BASE + 0xA70) /* R/W Device IN Endpoint 11 Transfer Size Register */
#define S5P_OTG_DIEPDMA11		(USBOTG_LINK_BASE + 0xA74) /* R/W Device IN Endpoint 11 DMA Address Register */
#define S5P_OTG_DIEPCTL12		(USBOTG_LINK_BASE + 0xA80) /* R/W Device Control IN Endpoint 12 Control Register */
#define S5P_OTG_DIEPINT12		(USBOTG_LINK_BASE + 0xA88) /* R/W Device IN Endpoint 12 Interrupt Register */
#define S5P_OTG_DIEPTSIZ12		(USBOTG_LINK_BASE + 0xA90) /* R/W Device IN Endpoint 12 Transfer Size Register */
#define S5P_OTG_DIEPDMA12		(USBOTG_LINK_BASE + 0xA94) /* R/W Device IN Endpoint 12 DMA Address Register */
#define S5P_OTG_DIEPCTL13		(USBOTG_LINK_BASE + 0xAA0) /* R/W Device Control IN Endpoint 13 Control Register */
#define S5P_OTG_DIEPINT13		(USBOTG_LINK_BASE + 0xAA8) /* R/W Device IN Endpoint 13 Interrupt Register */
#define S5P_OTG_DIEPTSIZ13		(USBOTG_LINK_BASE + 0xAB0) /* R/W Device IN Endpoint 13 Transfer Size Register */
#define S5P_OTG_DIEPDMA13		(USBOTG_LINK_BASE + 0xAB4) /* R/W Device IN Endpoint 13 DMA Address Register */
#define S5P_OTG_DIEPCTL14		(USBOTG_LINK_BASE + 0xAC0) /* R/W Device Control IN Endpoint 14 Control Register */
#define S5P_OTG_DIEPINT14		(USBOTG_LINK_BASE + 0xAC8) /* R/W Device IN Endpoint 14 Interrupt Register */
#define S5P_OTG_DIEPTSIZ14		(USBOTG_LINK_BASE + 0xAD0) /* R/W Device IN Endpoint 14 Transfer Size Register */
#define S5P_OTG_DIEPDMA14		(USBOTG_LINK_BASE + 0xAD4) /* R/W Device IN Endpoint 14 DMA Address Register */
#define S5P_OTG_DIEPCTL15		(USBOTG_LINK_BASE + 0xAE0) /* R/W Device Control IN Endpoint 15 Control Register */
#define S5P_OTG_DIEPINT15		(USBOTG_LINK_BASE + 0xAE8) /* R/W Device IN Endpoint 15 Interrupt Register */
#define S5P_OTG_DIEPTSIZ15		(USBOTG_LINK_BASE + 0xAF0) /* R/W Device IN Endpoint 15 Transfer Size Register */
#define S5P_OTG_DIEPDMA15		(USBOTG_LINK_BASE + 0xAF4) /* R/W Device IN Endpoint 15 DMA Address Register */

/* Device Logical OUT Endpoint-Specific Register */
#define S5P_OTG_DOEPCTL0		(USBOTG_LINK_BASE + 0xB00) /* R/W Device Control OUT Endpoint 0 Control Register */
#define S5P_OTG_DOEPINT0		(USBOTG_LINK_BASE + 0xB08) /* R/W Device OUT Endpoint 0 Interrupt Register */
#define S5P_OTG_DOEPTSIZ0		(USBOTG_LINK_BASE + 0xB10) /* R/W Device OUT Endpoint 0 Transfer Size Register */
#define S5P_OTG_DOEPDMA0		(USBOTG_LINK_BASE + 0xB14) /* R/W Device OUT Endpoint 0 DMA Address Register */
#define S5P_OTG_DOEPCTL1		(USBOTG_LINK_BASE + 0xB20) /* R/W Device Control OUT Endpoint 1 Control Register */
#define S5P_OTG_DOEPINT1		(USBOTG_LINK_BASE + 0xB28) /* R/W Device OUT Endpoint 1 Interrupt Register */
#define S5P_OTG_DOEPTSIZ1		(USBOTG_LINK_BASE + 0xB30) /* R/W Device OUT Endpoint 1 Transfer Size Register */
#define S5P_OTG_DOEPDMA1		(USBOTG_LINK_BASE + 0xB34) /* R/W Device OUT Endpoint 1 DMA Address Register */
#define S5P_OTG_DOEPCTL2		(USBOTG_LINK_BASE + 0xB40) /* R/W Device Control OUT Endpoint 2 Control Register */
#define S5P_OTG_DOEPINT2		(USBOTG_LINK_BASE + 0xB48) /* R/W Device OUT Endpoint 2 Interrupt Register */
#define S5P_OTG_DOEPTSIZ2		(USBOTG_LINK_BASE + 0xB50) /* R/W Device OUT Endpoint 2 Transfer Size Register */
#define S5P_OTG_DOEPDMA2		(USBOTG_LINK_BASE + 0xB54) /* R/W Device OUT Endpoint 2 DMA Address Register */
#define S5P_OTG_DOEPCTL3		(USBOTG_LINK_BASE + 0xB60) /* R/W Device Control OUT Endpoint 3 Control Register */
#define S5P_OTG_DOEPINT3		(USBOTG_LINK_BASE + 0xB68) /* R/W Device OUT Endpoint 3 Interrupt Register */
#define S5P_OTG_DOEPTSIZ3		(USBOTG_LINK_BASE + 0xB70) /* R/W Device OUT Endpoint 3 Transfer Size Register */
#define S5P_OTG_DOEPDMA3		(USBOTG_LINK_BASE + 0xB74) /* R/W Device OUT Endpoint 3 DMA Address Register */
#define S5P_OTG_DOEPCTL4		(USBOTG_LINK_BASE + 0xB80) /* R/W Device Control OUT Endpoint 4 Control Register */
#define S5P_OTG_DOEPINT4		(USBOTG_LINK_BASE + 0xB88) /* R/W Device OUT Endpoint 4 Interrupt Register */
#define S5P_OTG_DOEPTSIZ4		(USBOTG_LINK_BASE + 0xB90) /* R/W Device OUT Endpoint 4 Transfer Size Register */
#define S5P_OTG_DOEPDMA4		(USBOTG_LINK_BASE + 0xB94) /* R/W Device OUT Endpoint 4 DMA Address Register */
#define S5P_OTG_DOEPCTL5		(USBOTG_LINK_BASE + 0xBA0) /* R/W Device Control OUT Endpoint 5 Control Register */
#define S5P_OTG_DOEPINT5		(USBOTG_LINK_BASE + 0xBA8) /* R/W Device OUT Endpoint 5 Interrupt Register */
#define S5P_OTG_DOEPTSIZ5		(USBOTG_LINK_BASE + 0xBB0) /* R/W Device OUT Endpoint 5 Transfer Size Register */
#define S5P_OTG_DOEPDMA5		(USBOTG_LINK_BASE + 0xBB4) /* R/W Device OUT Endpoint 5 DMA Address Register */
#define S5P_OTG_DOEPCTL6		(USBOTG_LINK_BASE + 0xBC0) /* R/W Device Control OUT Endpoint 6 Control Register */
#define S5P_OTG_DOEPINT6		(USBOTG_LINK_BASE + 0xBC8) /* R/W Device OUT Endpoint 6 Interrupt Register */
#define S5P_OTG_DOEPTSIZ6		(USBOTG_LINK_BASE + 0xBD0) /* R/W Device OUT Endpoint 6 Transfer Size Register */
#define S5P_OTG_DOEPDMA6		(USBOTG_LINK_BASE + 0xBD4) /* R/W Device OUT Endpoint 6 DMA Address Register */
#define S5P_OTG_DOEPCTL7		(USBOTG_LINK_BASE + 0xBE0) /* R/W Device Control OUT Endpoint 7 Control Register */
#define S5P_OTG_DOEPINT7		(USBOTG_LINK_BASE + 0xBE8) /* R/W Device OUT Endpoint 7 Interrupt Register */
#define S5P_OTG_DOEPTSIZ7		(USBOTG_LINK_BASE + 0xBF0) /* R/W Device OUT Endpoint 7 Transfer Size Register */
#define S5P_OTG_DOEPDMA7		(USBOTG_LINK_BASE + 0xBF4) /* R/W Device OUT Endpoint 7 DMA Address Register */
#define S5P_OTG_DOEPCTL8		(USBOTG_LINK_BASE + 0xC00) /* R/W Device Control OUT Endpoint 8 Control Register */
#define S5P_OTG_DOEPINT8		(USBOTG_LINK_BASE + 0xC08) /* R/W Device OUT Endpoint 8 Interrupt Register */
#define S5P_OTG_DOEPTSIZ8		(USBOTG_LINK_BASE + 0xC10) /* R/W Device OUT Endpoint 8 Transfer Size Register */
#define S5P_OTG_DOEPDMA8		(USBOTG_LINK_BASE + 0xC14) /* R/W Device OUT Endpoint 8 DMA Address Register */
#define S5P_OTG_DOEPCTL9		(USBOTG_LINK_BASE + 0xC20) /* R/W Device Control OUT Endpoint 9 Control Register */
#define S5P_OTG_DOEPINT9		(USBOTG_LINK_BASE + 0xC28) /* R/W Device OUT Endpoint 9 Interrupt Register */
#define S5P_OTG_DOEPTSIZ9		(USBOTG_LINK_BASE + 0xC30) /* R/W Device OUT Endpoint 9 Transfer Size Register */
#define S5P_OTG_DOEPDMA9		(USBOTG_LINK_BASE + 0xC34) /* R/W Device OUT Endpoint 9 DMA Address Register */
#define S5P_OTG_DOEPCTL10		(USBOTG_LINK_BASE + 0xC40) /* R/W Device Control OUT Endpoint 10 Control Register */
#define S5P_OTG_DOEPINT10		(USBOTG_LINK_BASE + 0xC48) /* R/W Device OUT Endpoint 10 Interrupt Register */
#define S5P_OTG_DOEPTSIZ10		(USBOTG_LINK_BASE + 0xC50) /* R/W Device OUT Endpoint 10 Transfer Size Register */
#define S5P_OTG_DOEPDMA10		(USBOTG_LINK_BASE + 0xC54) /* R/W Device OUT Endpoint 10 DMA Address Register */
#define S5P_OTG_DOEPCTL11		(USBOTG_LINK_BASE + 0xC60) /* R/W Device Control OUT Endpoint 11 Control Register */
#define S5P_OTG_DOEPINT11		(USBOTG_LINK_BASE + 0xC68) /* R/W Device OUT Endpoint 11 Interrupt Register */
#define S5P_OTG_DOEPTSIZ11		(USBOTG_LINK_BASE + 0xC70) /* R/W Device OUT Endpoint 11 Transfer Size Register */
#define S5P_OTG_DOEPDMA11		(USBOTG_LINK_BASE + 0xC74) /* R/W Device OUT Endpoint 11 DMA Address Register */
#define S5P_OTG_DOEPCTL12		(USBOTG_LINK_BASE + 0xC80) /* R/W Device Control OUT Endpoint 12 Control Register */
#define S5P_OTG_DOEPINT12		(USBOTG_LINK_BASE + 0xC88) /* R/W Device OUT Endpoint 12 Interrupt Register */
#define S5P_OTG_DOEPTSIZ12		(USBOTG_LINK_BASE + 0xC90) /* R/W Device OUT Endpoint 12 Transfer Size Register */
#define S5P_OTG_DOEPDMA12		(USBOTG_LINK_BASE + 0xC94) /* R/W Device OUT Endpoint 12 DMA Address Register */
#define S5P_OTG_DOEPCTL13		(USBOTG_LINK_BASE + 0xCA0) /* R/W Device Control OUT Endpoint 13 Control Register */
#define S5P_OTG_DOEPINT13		(USBOTG_LINK_BASE + 0xCA8) /* R/W Device OUT Endpoint 13 Interrupt Register */
#define S5P_OTG_DOEPTSIZ13		(USBOTG_LINK_BASE + 0xCB0) /* R/W Device OUT Endpoint 13 Transfer Size Register */
#define S5P_OTG_DOEPDMA13		(USBOTG_LINK_BASE + 0xCB4) /* R/W Device OUT Endpoint 13 DMA Address Register */
#define S5P_OTG_DOEPCTL14		(USBOTG_LINK_BASE + 0xCC0) /* R/W Device Control OUT Endpoint 14 Control Register */
#define S5P_OTG_DOEPINT14		(USBOTG_LINK_BASE + 0xCC8) /* R/W Device OUT Endpoint 14 Interrupt Register */
#define S5P_OTG_DOEPTSIZ14		(USBOTG_LINK_BASE + 0xCD0) /* R/W Device OUT Endpoint 14 Transfer Size Register */
#define S5P_OTG_DOEPDMA14		(USBOTG_LINK_BASE + 0xCD4) /* R/W Device OUT Endpoint 14 DMA Address Register */
#define S5P_OTG_DOEPCTL15		(USBOTG_LINK_BASE + 0xCE0) /* R/W Device Control OUT Endpoint 15 Control Register */
#define S5P_OTG_OTG_DOEPINT15		(USBOTG_LINK_BASE + 0xCE8) /* R/W Device OUT Endpoint 15 Interrupt Register */
#define S5P_OTG_DOEPTSIZ15		(USBOTG_LINK_BASE + 0xCF0) /* R/W Device OUT Endpoint 15 Transfer Size Register */
#define S5P_OTG_DOEPDMA15		(USBOTG_LINK_BASE + 0xCF4) /* R/W Device OUT Endpoint 15 DMA Address Register */

/* Power and Clock Gating Register */
#define S5P_OTG_PCGCCTL 		(USBOTG_LINK_BASE + 0xE00) /* R/W Power and Clock Gating Control Register */

/* Endpoint FIFO address */
#define S5P_OTG_EP0_FIFO		(USBOTG_LINK_BASE + 0x1000)

/* USB Global Interrupt Status register(GINTSTS) setting value */
#define GINTSTS_WkUpInt		(1<<31)
#define GINTSTS_OEPInt		(1<<19)
#define GINTSTS_IEPInt		(1<<18)
#define GINTSTS_EnumDone	(1<<13)
#define GINTSTS_USBRst		(1<<12)
#define GINTSTS_USBSusp		(1<<11)
#define GINTSTS_RXFLvl		(1<<4)

/* include common stuff */
#ifndef __ASSEMBLY__
static inline S5P644X_MEMCTL * S5P644X_GetBase_MEMCTL(void)
{
	return (S5P644X_MEMCTL *)(APB_DMC_0_BASE);
}
static inline S5P644X_USB_HOST * S5P644X_GetBase_USB_HOST(void)
{
	return (S5P644X_USB_HOST *)ELFIN_USB_HOST_BASE;
}
static inline S5P644X_INTERRUPT * S5P644X_GetBase_INTERRUPT(void)
{
	return (S5P644X_INTERRUPT *)ELFIN_VIC0_BASE_ADDR;
}
static inline S5P644X_DMAS * S5P644X_GetBase_DMAS(void)
{
	return (S5P644X_DMAS *)ELFIN_DMA_BASE;
}
static inline S5P644X_CLOCK_POWER * S5P644X_GetBase_CLOCK_POWER(void)
{
	return (S5P644X_CLOCK_POWER *)ELFIN_CLOCK_POWER_BASE;
}
static inline S5P644X_LCD * S5P644X_GetBase_LCD(void)
{
	return (S5P644X_LCD *)ELFIN_LCD_BASE;
}
static inline S5P644X_UART * S5P644X_GetBase_UART(S5P644X_UARTS_NR nr)
{
	return (S5P644X_UART *)(ELFIN_UART_BASE + (nr*0x400));
}
static inline S5P644X_TIMERS * S5P644X_GetBase_TIMERS(void)
{
	return (S5P644X_TIMERS *)ELFIN_TIMER_BASE;
}
static inline S5P644X_WATCHDOG * S5P644X_GetBase_WATCHDOG(void)
{
	return (S5P644X_WATCHDOG *)ELFIN_WATCHDOG_BASE;
}
static inline S5P644X_I2C * S5P644X_GetBase_I2C(void)
{
	return (S5P644X_I2C *)ELFIN_I2C_BASE;
}
static inline S5P644X_I2S * S5P644X_GetBase_I2S(void)
{
	return (S5P644X_I2S *)ELFIN_I2S_BASE;
}
static inline S5P644X_GPIO * S5P644X_GetBase_GPIO(void)
{
	return (S5P644X_GPIO *)ELFIN_GPIO_BASE;
}
static inline S3C2410_ADC * S3C2410_GetBase_ADC(void)
{
	return (S3C2410_ADC *)ELFIN_ADC_BASE;
}
static inline S5P644X_SPI * S5P644X_GetBase_SPI(void)
{
	return (S5P644X_SPI *)ELFIN_SPI_BASE;
}

#else /* #ifndef __ASSEMBLY__ */

/* LCD controller */
#define LCDBGCON_OFFSET		0x5c

#endif /* #ifndef __ASSEMBLY__ */

/* PENDING BIT */
#define BIT_EINT0			(0x1)
#define BIT_EINT1			(0x1<<1)
#define BIT_EINT2			(0x1<<2)
#define BIT_EINT3			(0x1<<3)
#define BIT_EINT4_7			(0x1<<4)
#define BIT_EINT8_23			(0x1<<5)
#define BIT_BAT_FLT			(0x1<<7)
#define BIT_TICK			(0x1<<8)
#define BIT_WDT				(0x1<<9)
#define BIT_TIMER0			(0x1<<10)
#define BIT_TIMER1			(0x1<<11)
#define BIT_TIMER2			(0x1<<12)
#define BIT_TIMER3			(0x1<<13)
#define BIT_TIMER4			(0x1<<14)
#define BIT_UART2			(0x1<<15)
#define BIT_LCD				(0x1<<16)
#define BIT_DMA0			(0x1<<17)
#define BIT_DMA1			(0x1<<18)
#define BIT_DMA2			(0x1<<19)
#define BIT_DMA3			(0x1<<20)
#define BIT_SDI				(0x1<<21)
#define BIT_SPI0			(0x1<<22)
#define BIT_UART1			(0x1<<23)
#define BIT_USBH			(0x1<<26)
#define BIT_IIC				(0x1<<27)
#define BIT_UART0			(0x1<<28)
#define BIT_SPI1			(0x1<<29)
#define BIT_RTC				(0x1<<30)
#define BIT_ADC				(0x1<<31)
#define BIT_ALLMSK			(0xFFFFFFFF)

#endif /*__S5P6442_H__*/
