/*
 * (C) Copyright 2007
 * Byungjae Lee, Samsung Erectronics, bjlee@samsung.com.
 *      - only support for S3C6400
 *  $Id: s5p6440.h,v 1.1 2009/03/10 07:11:39 charles Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/************************************************
 * NAME	    : s5p6440.h
 *
 * Based on S5P6440 User's manual Rev 0.0
 ************************************************/

#ifndef __S5P6440_H__
#define __S5P6440_H__

#ifndef CONFIG_S5P6440
#define CONFIG_S5P6440		1
#endif

#define S5P64XX_UART_CHANNELS	3
#define S5P64XX_SPI_CHANNELS	2

#include <asm/hardware.h>

#ifndef __ASSEMBLY__
typedef enum {
	S5P64XX_UART0,
	S5P64XX_UART1,
	S5P64XX_UART2,
	S5P64XX_UART3,
} S5P64XX_UARTS_NR;

#include <s5p64x0.h>
#endif

#define BIT0 			0x00000001
#define BIT1 			0x00000002
#define BIT2 			0x00000004
#define BIT3 			0x00000008
#define BIT4 			0x00000010
#define BIT5 			0x00000020
#define BIT6			0x00000040
#define BIT7			0x00000080
#define BIT8			0x00000100
#define BIT9			0x00000200
#define BIT10			0x00000400
#define BIT11			0x00000800
#define BIT12			0x00001000
#define BIT13			0x00002000
#define BIT14			0x00004000
#define BIT15			0x00008000
#define BIT16			0x00010000
#define BIT17			0x00020000
#define BIT18			0x00040000
#define BIT19			0x00080000
#define BIT20			0x00100000
#define BIT21			0x00200000
#define BIT22			0x00400000
#define BIT23			0x00800000
#define BIT24			0x01000000
#define BIT25			0x02000000
#define BIT26			0x04000000
#define BIT27			0x08000000
#define BIT28			0x10000000
#define BIT29			0x20000000
#define BIT30			0x40000000
#define BIT31			0x80000000

#define ROM_BASE0		0x00000000      /* base address of rom bank 0 */
#define ROM_BASE1		0x04000000      /* base address of rom bank 1 */
#define DRAM_BASE0		0x20000000      /* base address of dram bank 0 */
#define DRAM_BASE1		0x40000000      /* base address of dram bank 1 */


/* S5P6440 device base addresses */
#define ELFIN_DMA_BASE		0xE9000000
#define ELFIN_LCD_BASE		0xEE000000
#define ELFIN_USB_HOST_BASE	0xED100000
#define ELFIN_I2C_BASE		0xEC100000
#define ELFIN_I2S_BASE		0xF2000000
#define ELFIN_ADC_BASE		0xF3000000
#define ELFIN_SPI_BASE		0xEC400000
#define ELFIN_HSMMC_0_BASE	0xED800000
#define ELFIN_HSMMC_1_BASE	0xED900000
#define ELFIN_HSMMC_2_BASE	0xEDA00000

#define ELFIN_CLOCK_POWER_BASE	0xE0100000

/* Clock & Power Controller for mDirac3*/
#define APLL_LOCK_OFFSET	0x00
#define MPLL_LOCK_OFFSET	0x04
#define EPLL_LOCK_OFFSET	0x08
#define APLL_CON_OFFSET		0x0C
#define MPLL_CON_OFFSET		0x10
#define EPLL_CON_OFFSET		0x14
#define EPLL_CON_K_OFFSET	0x18
#define CLK_SRC0_OFFSET		0x1C
#define CLK_SRC1_OFFSET		0x10C
#define CLK_DIV0_OFFSET		0x20
#define CLK_DIV1_OFFSET		0x24
#define CLK_DIV2_OFFSET		0x28
#define CLK_DIV3_OFFSET		0x40
#define CLK_OUT_OFFSET		0x2C
#define HCLK_0_GATE_OFFSET	0x30
#define PCLK_GATE_OFFSET	0x34
#define SCLK_0_GATE_OFFSET	0x38
#define MEM_0_GATE_OFFSET 	0x3C
#define HCLK_1_GATE_OFFSET	0x44
#define SCLK_1_GATE_OFFSET	0x48

#define AHB_CON0_OFFSET		0x100

#define SW_RST_OFFSET		0x114
#define SYS_ID_OFFSET		0x118
#define SYS_OTHERS_OFFSET		0x11C

#define MEM_CFG_STAT_OFFSET	0x12C
#define EMA_ACCESS_CON_OFFSET 0x130
#define EMA_CONFIG0_OFFSET  0x200
#define EMA_CONFIG1_OFFSET  0x204
#define EMA_CONFIG2_OFFSET  0x208
#define EMA_CONFIG3_OFFSET  0x20C
#define EMA_CONFIG4_OFFSET  0x210
#define EMA_CONFIG5_OFFSET  0x214
#define EMA_CONFIG6_OFFSET  0x218
#define EMA_CONFIG7_OFFSET  0x21C
#define EMA_CONFIG8_OFFSET  0x220
#define EMA_CONFIG9_OFFSET  0x224
#define EMA_CONFIG10_OFFSET  0x228
#define EMA_CONFIG11_OFFSET  0x22C
#define EMA_CONFIG12_OFFSET  0x230

#define PWR_CFG_OFFSET		0x804
#define EINT_MASK_OFFSET	0x808

#define STOP_CFG_OFFSET		0x814
#define SLEEP_CFG_OFFSET	0x818
#define OSC_FREQ_OFFSET		0x820
#define OSC_STABLE_OFFSET	0x824
#define PWR_STABLE_OFFSET	0x828

#define MTC_STABLE_OFFSET	0x830
#define OTHERS_OFFSET		0x900
#define RST_STAT_OFFSET		0x904
#define WAKEUP_STAT_OFFSET	0x908

#define INF_REG0_OFFSET		0xA00
#define INF_REG1_OFFSET		0xA04
#define INF_REG2_OFFSET		0xA08
#define INF_REG3_OFFSET		0xA0C

/* System Clock register setting value */

/* For Clock source 0 */

#define APLL_SEL_ENABLE		(1 << 0)
#define MPLL_SEL_ENABLE		(1 << 1)
#define EPLL_SEL_ENABLE		(1 << 2)
#define VSEL_E_ENABLE		(1 << 3)
#define VSEL_M_ENABLE		(1 << 4)
#define MMC0_SEL_MOUT_ENABLE	(0 << 18)
#define MMC0_SEL_DOUT_ENABLE	(1 << 18)
#define MMC0_SEL_FOUT_ENABLE	(2 << 18)
#define MMC1_SEL_MOUT_ENABLE	(0 << 20)
#define MMC1_SEL_DOUT_ENABLE	(1 << 20)
#define MMC1_SEL_FOUT_ENABLE	(2 << 20)

#define APLL_LOCK_REG		__REG(ELFIN_CLOCK_POWER_BASE+APLL_LOCK_OFFSET)
#define MPLL_LOCK_REG		__REG(ELFIN_CLOCK_POWER_BASE+MPLL_LOCK_OFFSET)
#define EPLL_LOCK_REG		__REG(ELFIN_CLOCK_POWER_BASE+EPLL_LOCK_OFFSET)
#define APLL_CON_REG		__REG(ELFIN_CLOCK_POWER_BASE+APLL_CON_OFFSET)
#define MPLL_CON_REG		__REG(ELFIN_CLOCK_POWER_BASE+MPLL_CON_OFFSET)
#define EPLL_CON0_REG		__REG(ELFIN_CLOCK_POWER_BASE+EPLL_CON_OFFSET)
#define EPLL_CON1_REG		__REG(ELFIN_CLOCK_POWER_BASE+EPLL_CON_K_OFFSET)
#define CLK_SRC0_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC0_OFFSET)
#define CLK_SRC1_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_SRC1_OFFSET)
#define CLK_DIV0_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV0_OFFSET)
#define CLK_DIV1_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV1_OFFSET)
#define CLK_DIV2_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV2_OFFSET)
#define CLK_DIV3_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_DIV3_OFFSET)
#define CLK_OUT_REG		__REG(ELFIN_CLOCK_POWER_BASE+CLK_OUT_OFFSET)
#define HCLK_0_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+HCLK_0_GATE_OFFSET)
#define PCLK_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+PCLK_GATE_OFFSET)
#define SCLK_0_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+SCLK_0_GATE_OFFSET)
#define MEM_0_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+MEM_0_GATE_OFFSET)
#define HCLK_1_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+HCLK_1_GATE_OFFSET)
#define SCLK_1_GATE_REG		__REG(ELFIN_CLOCK_POWER_BASE+SCLK_1_GATE_OFFSET)
#define AHB_CON0_REG		__REG(ELFIN_CLOCK_POWER_BASE+AHB_CON0_OFFSET)
#define SW_RST_REG		__REG(ELFIN_CLOCK_POWER_BASE+SW_RST_OFFSET)
#define SYS_ID_REG		__REG(ELFIN_CLOCK_POWER_BASE+SYS_ID_OFFSET)
#define MEM_CFG_STAT_REG	__REG(ELFIN_CLOCK_POWER_BASE+MEM_CFG_STAT_OFFSET)
#define EMA_ACCESS_CON_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_ACCESS_CON_OFFSET)
#define EMA_CONFIG0_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG0_OFFSET)
#define EMA_CONFIG1_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG1_OFFSET)
#define EMA_CONFIG2_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG2_OFFSET)
#define EMA_CONFIG3_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG3_OFFSET)
#define EMA_CONFIG4_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG4_OFFSET)
#define EMA_CONFIG5_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG5_OFFSET)
#define EMA_CONFIG6_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG6_OFFSET)
#define EMA_CONFIG7_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG7_OFFSET)
#define EMA_CONFIG8_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG8_OFFSET)
#define EMA_CONFIG9_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG9_OFFSET)
#define EMA_CONFIG10_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG10_OFFSET)
#define EMA_CONFIG11_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG11_OFFSET)
#define EMA_CONFIG12_REG  __REG(ELFIN_CLOCK_POWER_BASE+EMA_CONFIG12_OFFSET)
#define PWR_CFG_REG		__REG(ELFIN_CLOCK_POWER_BASE+PWR_CFG_OFFSET)
#define EINT_MASK_REG		__REG(ELFIN_CLOCK_POWER_BASE+EINT_MASK_OFFSET)
#define STOP_CFG_REG		__REG(ELFIN_CLOCK_POWER_BASE+STOP_CFG_OFFSET)
#define SLEEP_CFG_REG		__REG(ELFIN_CLOCK_POWER_BASE+SLEEP_CFG_OFFSET)
#define OSC_FREQ_REG		__REG(ELFIN_CLOCK_POWER_BASE+OSC_FREQ_OFFSET)
#define OSC_STABLE_REG		__REG(ELFIN_CLOCK_POWER_BASE+OSC_STABLE_OFFSET)
#define PWR_STABLE_REG		__REG(ELFIN_CLOCK_POWER_BASE+PWR_STABLE_OFFSET)
#define OTHERS_REG		__REG(ELFIN_CLOCK_POWER_BASE+OTHERS_OFFSET)
#define RST_STAT_REG		__REG(ELFIN_CLOCK_POWER_BASE+RST_STAT_OFFSET)
#define WAKEUP_STAT_REG		__REG(ELFIN_CLOCK_POWER_BASE+WAKEUP_STAT_OFFSET)
#define INF_REG0_REG		__REG(ELFIN_CLOCK_POWER_BASE+INF_REG0_OFFSET)
#define INF_REG1_REG		__REG(ELFIN_CLOCK_POWER_BASE+INF_REG1_OFFSET)
#define INF_REG2_REG		__REG(ELFIN_CLOCK_POWER_BASE+INF_REG2_OFFSET)
#define INF_REG3_REG		__REG(ELFIN_CLOCK_POWER_BASE+INF_REG3_OFFSET)

#define APLL_LOCK		(ELFIN_CLOCK_POWER_BASE+APLL_LOCK_OFFSET)
#define MPLL_LOCK		(ELFIN_CLOCK_POWER_BASE+MPLL_LOCK_OFFSET)
#define EPLL_LOCK		(ELFIN_CLOCK_POWER_BASE+EPLL_LOCK_OFFSET)
#define APLL_CON		(ELFIN_CLOCK_POWER_BASE+APLL_CON_OFFSET)
#define MPLL_CON		(ELFIN_CLOCK_POWER_BASE+MPLL_CON_OFFSET)
#define EPLL_CON0		(ELFIN_CLOCK_POWER_BASE+EPLL_CON0_OFFSET)
#define EPLL_CON1		(ELFIN_CLOCK_POWER_BASE+EPLL_CON1_OFFSET)
#define CLK_SRC0		(ELFIN_CLOCK_POWER_BASE+CLK_SRC0_OFFSET)
#define CLK_SRC1		(ELFIN_CLOCK_POWER_BASE+CLK_SRC1_OFFSET)
#define CLK_DIV0		(ELFIN_CLOCK_POWER_BASE+CLK_DIV0_OFFSET)
#define CLK_DIV1		(ELFIN_CLOCK_POWER_BASE+CLK_DIV1_OFFSET)
#define CLK_DIV2		(ELFIN_CLOCK_POWER_BASE+CLK_DIV2_OFFSET)
#define CLK_DIV3		(ELFIN_CLOCK_POWER_BASE+CLK_DIV3_OFFSET)
#define CLK_OUT		(ELFIN_CLOCK_POWER_BASE+CLK_OUT_OFFSET)
#define HCLK_0_GATE		(ELFIN_CLOCK_POWER_BASE+HCLK_0_GATE_OFFSET)
#define PCLK_GATE		(ELFIN_CLOCK_POWER_BASE+PCLK_GATE_OFFSET)
#define SCLK_0_GATE		(ELFIN_CLOCK_POWER_BASE+SCLK_0_GATE_OFFSET)
#define MEM_0_GATE		(ELFIN_CLOCK_POWER_BASE+MEM_0_GATE_OFFSET)
#define HCLK_1_GATE		(ELFIN_CLOCK_POWER_BASE+HCLK_1_GATE_OFFSET)
#define SCLK_1_GATE		(ELFIN_CLOCK_POWER_BASE+SCLK_1_GATE_OFFSET)
#define AHB_CON0		(ELFIN_CLOCK_POWER_BASE+AHB_CON0_OFFSET)
#define SW_RST		(ELFIN_CLOCK_POWER_BASE+SW_RST_OFFSET)
#define SYS_ID		(ELFIN_CLOCK_POWER_BASE+SYS_ID_OFFSET)
#define MEM_CFG_STAT	(ELFIN_CLOCK_POWER_BASE+MEM_CFG_STAT_OFFSET)
#define EMA_ACCESS_CON  (ELFIN_CLOCK_POWER_BASE+EMA_ACCESS_CON_OFFSET)
#define EMA_CONFIG0  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG0_OFFSET)
#define EMA_CONFIG1  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG1_OFFSET)
#define EMA_CONFIG2  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG2_OFFSET)
#define EMA_CONFIG3  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG3_OFFSET)
#define EMA_CONFIG4  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG4_OFFSET)
#define EMA_CONFIG5  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG5_OFFSET)
#define EMA_CONFIG6  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG6_OFFSET)
#define EMA_CONFIG7  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG7_OFFSET)
#define EMA_CONFIG8  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG8_OFFSET)
#define EMA_CONFIG9  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG9_OFFSET)
#define EMA_CONFIG10  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG10_OFFSET)
#define EMA_CONFIG11  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG11_OFFSET)
#define EMA_CONFIG12  (ELFIN_CLOCK_POWER_BASE+EMA_CONFIG12_OFFSET)
#define PWR_CFG		(ELFIN_CLOCK_POWER_BASE+PWR_CFG_OFFSET)
#define EINT_MASK		(ELFIN_CLOCK_POWER_BASE+EINT_MASK_OFFSET)
#define STOP_CFG		(ELFIN_CLOCK_POWER_BASE+STOP_CFG_OFFSET)
#define SLEEP_CFG		(ELFIN_CLOCK_POWER_BASE+SLEEP_CFG_OFFSET)
#define OSC_FREQ		(ELFIN_CLOCK_POWER_BASE+OSC_FREQ_OFFSET)
#define OSC_STABLE		(ELFIN_CLOCK_POWER_BASE+OSC_STABLE_OFFSET)
#define PWR_STABLE		(ELFIN_CLOCK_POWER_BASE+PWR_STABLE_OFFSET)
#define OTHERS		(ELFIN_CLOCK_POWER_BASE+OTHERS_OFFSET)
#define RST_STAT		(ELFIN_CLOCK_POWER_BASE+RST_STAT_OFFSET)
#define WAKEUP_STAT		(ELFIN_CLOCK_POWER_BASE+WAKEUP_STAT_OFFSET)
#define INF_REG0		(ELFIN_CLOCK_POWER_BASE+INF_REG0_OFFSET)
#define INF_REG1		(ELFIN_CLOCK_POWER_BASE+INF_REG1_OFFSET)
#define INF_REG2		(ELFIN_CLOCK_POWER_BASE+INF_REG2_OFFSET)
#define INF_REG3		(ELFIN_CLOCK_POWER_BASE+INF_REG3_OFFSET)

/*
 * GPIO
 */
#define ELFIN_GPIO_BASE		0xE0308000

#define GPACON_OFFSET		0x00
#define GPADAT_OFFSET		0x04
#define GPAPUD_OFFSET		0x08
#define GPACONSLP_OFFSET	0x0C
#define GPAPUDSLP_OFFSET	0x10

#define GPBCON_OFFSET		0x20
#define GPBDAT_OFFSET		0x04
#define GPBPUD_OFFSET		0x08
#define GPBCONSLP_OFFSET	0x0C
#define GPBPUDSLP_OFFSET	0x30

#define GPCCON_OFFSET		0x40
#define GPCDAT_OFFSET		0x44
#define GPCPUD_OFFSET		0x48
#define GPCCONSLP_OFFSET	0x4C
#define GPCPUDSLP_OFFSET	0x50

#define GPFCON_OFFSET		0xA0
#define GPFDAT_OFFSET		0xA4
#define GPFPUD_OFFSET		0xA8
#define GPFCONSLP_OFFSET	0xAC
#define GPFPUDSLP_OFFSET	0xB0

#define GPGCON_OFFSET		0xC0
#define GPGDAT_OFFSET		0xC4
#define GPGPUD_OFFSET		0xC8
#define GPGCONSLP_OFFSET	0xCC
#define GPGPUDSLP_OFFSET	0xD0

#define GPHCON0_OFFSET		0xE0
#define GPHCON1_OFFSET		0xE4
#define GPHDAT_OFFSET		0xE8
#define GPHPUD_OFFSET		0xEC
#define GPHCONSLP_OFFSET	0xF0
#define GPHPUDSLP_OFFSET	0xF4

#define GPICON_OFFSET		0x100
#define GPIDAT_OFFSET		0x104
#define GPIPUD_OFFSET		0x108
#define GPICONSLP_OFFSET	0x10C
#define GPIPUDSLP_OFFSET	0x110

#define GPJCON_OFFSET		0x120
#define GPJDAT_OFFSET		0x124
#define GPJPUD_OFFSET		0x128
#define GPJCONSLP_OFFSET	0x12C
#define GPJPUDSLP_OFFSET	0x130

#define SPCON_OFFSET		0x1A0
#define MEM0DRVCON_OFFSET	0x1D0
#define MEM1DRVCON_OFFSET	0x1D4

#define GPNCON_OFFSET		0x830
#define GPNDAT_OFFSET		0x834
#define GPNPUD_OFFSET		0x838

#define GPPCON_OFFSET		0x160
#define GPPDAT_OFFSET		0x164
#define GPPPUD_OFFSET		0x168
#define GPPCONSLP_OFFSET	0x16C
#define GPPPUDSLP_OFFSET	0x170
#define GPPCON_GPS_OFFSET	0x174

#define GPRCON0_OFFSET		0x290
#define GPRCON1_OFFSET		0x294
#define GPRDAT_OFFSET		0x298
#define GPRPUD_OFFSET		0x29C
#define GPRCONSLP_OFFSET	0x2A0
#define GPRPUDSLP_OFFSET	0x2A4

#define EINTPEND_OFFSET		0x924

#define GPACON_REG		__REG(ELFIN_GPIO_BASE+GPACON_OFFSET)
#define GPADAT_REG		__REG(ELFIN_GPIO_BASE+GPADAT_OFFSET)
#define GPAPUD_REG		__REG(ELFIN_GPIO_BASE+GPAPUD_OFFSET)
#define GPACONSLP_REG		__REG(ELFIN_GPIO_BASE+GPACONSLP_OFFSET)
#define GPAPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPAPUDSLP_OFFSET)

#define GPBCON_REG		__REG(ELFIN_GPIO_BASE+GPBCON_OFFSET)
#define GPBDAT_REG		__REG(ELFIN_GPIO_BASE+GPBDAT_OFFSET)
#define GPBPUD_REG		__REG(ELFIN_GPIO_BASE+GPBPUD_OFFSET)
#define GPBCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPBCONSLP_OFFSET)
#define GPBPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPBPUDSLP_OFFSET)

#define GPCCON_REG		__REG(ELFIN_GPIO_BASE+GPCCON_OFFSET)
#define GPCDAT_REG		__REG(ELFIN_GPIO_BASE+GPCDAT_OFFSET)
#define GPCPUD_REG		__REG(ELFIN_GPIO_BASE+GPCPUD_OFFSET)
#define GPCCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPCCONSLP_OFFSET)
#define GPCPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPCPUDSLP_OFFSET)

#define GPFCON_REG		__REG(ELFIN_GPIO_BASE+GPFCON_OFFSET)
#define GPFDAT_REG		__REG(ELFIN_GPIO_BASE+GPFDAT_OFFSET)
#define GPFPUD_REG		__REG(ELFIN_GPIO_BASE+GPFPUD_OFFSET)
#define GPFCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPFCONSLP_OFFSET)
#define GPFPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPFPUDSLP_OFFSET)

#define GPGCON_REG		__REG(ELFIN_GPIO_BASE+GPGCON_OFFSET)
#define GPGDAT_REG		__REG(ELFIN_GPIO_BASE+GPGDAT_OFFSET)
#define GPGPUD_REG		__REG(ELFIN_GPIO_BASE+GPGPUD_OFFSET)
#define GPGCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPGCONSLP_OFFSET)
#define GPGPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPGPUDSLP_OFFSET)

#define GPHCON0_REG		__REG(ELFIN_GPIO_BASE+GPHCON0_OFFSET)
#define GPHCON1_REG		__REG(ELFIN_GPIO_BASE+GPHCON1_OFFSET)
#define GPHDAT_REG		__REG(ELFIN_GPIO_BASE+GPHDAT_OFFSET)
#define GPHPUD_REG		__REG(ELFIN_GPIO_BASE+GPHPUD_OFFSET)
#define GPHCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPHCONSLP_OFFSET)
#define GPHPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPHPUDSLP_OFFSET)

#define GPICON_REG		__REG(ELFIN_GPIO_BASE+GPICON_OFFSET)
#define GPIDAT_REG		__REG(ELFIN_GPIO_BASE+GPIDAT_OFFSET)
#define GPIPUD_REG		__REG(ELFIN_GPIO_BASE+GPIPUD_OFFSET)
#define GPICONSLP_REG		__REG(ELFIN_GPIO_BASE+GPICONSLP_OFFSET)
#define GPIPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPIPUDSLP_OFFSET)

#define GPJCON_REG		__REG(ELFIN_GPIO_BASE+GPJCON_OFFSET)
#define GPJDAT_REG		__REG(ELFIN_GPIO_BASE+GPJDAT_OFFSET)
#define GPJPUD_REG		__REG(ELFIN_GPIO_BASE+GPJPUD_OFFSET)
#define GPJCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPJCONSLP_OFFSET)
#define GPJPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPJPUDSLP_OFFSET)

#define GPNCON_REG		__REG(ELFIN_GPIO_BASE+GPNCON_OFFSET)
#define GPNDAT_REG		__REG(ELFIN_GPIO_BASE+GPNDAT_OFFSET)
#define GPNPUD_REG		__REG(ELFIN_GPIO_BASE+GPNPUD_OFFSET)

#define GPPCON_REG		__REG(ELFIN_GPIO_BASE+GPPCON_OFFSET)
#define GPPDAT_REG		__REG(ELFIN_GPIO_BASE+GPPDAT_OFFSET)
#define GPPPUD_REG		__REG(ELFIN_GPIO_BASE+GPPPUD_OFFSET)
#define GPPCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPPCONSLP_OFFSET)
#define GPPPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPPPUDSLP_OFFSET)
#define GPPCON_GPS_REG		__REG(ELFIN_GPIO_BASE+GPPCON_GPS_OFFSET)

#define GPRCON0_REG		__REG(ELFIN_GPIO_BASE+GPRCON0_OFFSET)
#define GPRCON1_REG		__REG(ELFIN_GPIO_BASE+GPRCON1_OFFSET)
#define GPRDAT_REG		__REG(ELFIN_GPIO_BASE+GPRDAT_OFFSET)
#define GPRPUD_REG		__REG(ELFIN_GPIO_BASE+GPRPUD_OFFSET)
#define GPRCONSLP_REG		__REG(ELFIN_GPIO_BASE+GPRCONSLP_OFFSET)
#define GPRPUDSLP_REG		__REG(ELFIN_GPIO_BASE+GPRPUDSLP_OFFSET)

#define GPACON		(ELFIN_GPIO_BASE+GPACON_OFFSET)
#define GPADAT		(ELFIN_GPIO_BASE+GPADAT_OFFSET)
#define GPAPUD		(ELFIN_GPIO_BASE+GPAPUD_OFFSET)
#define GPACONSLP	(ELFIN_GPIO_BASE+GPACONSLP_OFFSET)
#define GPAPUDSLP	(ELFIN_GPIO_BASE+GPAPUDSLP_OFFSET)

#define GPBCON		(ELFIN_GPIO_BASE+GPBCON_OFFSET)
#define GPBDAT		(ELFIN_GPIO_BASE+GPBDAT_OFFSET)
#define GPBPUD		(ELFIN_GPIO_BASE+GPBPUD_OFFSET)
#define GPBCONSLP	(ELFIN_GPIO_BASE+GPBCONSLP_OFFSET)
#define GPBPUDSLP	(ELFIN_GPIO_BASE+GPBPUDSLP_OFFSET)

#define GPCCON		(ELFIN_GPIO_BASE+GPCCON_OFFSET)
#define GPCDAT		(ELFIN_GPIO_BASE+GPCDAT_OFFSET)
#define GPCPUD		(ELFIN_GPIO_BASE+GPCPUD_OFFSET)
#define GPCCONSLP	(ELFIN_GPIO_BASE+GPCCONSLP_OFFSET)
#define GPCPUDSLP	(ELFIN_GPIO_BASE+GPCPUDSLP_OFFSET)

#define GPFCON		(ELFIN_GPIO_BASE+GPFCON_OFFSET)
#define GPFDAT		(ELFIN_GPIO_BASE+GPFDAT_OFFSET)
#define GPFPUD		(ELFIN_GPIO_BASE+GPFPUD_OFFSET)
#define GPFCONSLP	(ELFIN_GPIO_BASE+GPFCONSLP_OFFSET)
#define GPFPUDSLP	(ELFIN_GPIO_BASE+GPFPUDSLP_OFFSET)

#define GPGCON		(ELFIN_GPIO_BASE+GPGCON_OFFSET)
#define GPGDAT		(ELFIN_GPIO_BASE+GPGDAT_OFFSET)
#define GPGPUD		(ELFIN_GPIO_BASE+GPGPUD_OFFSET)
#define GPGCONSLP	(ELFIN_GPIO_BASE+GPGCONSLP_OFFSET)
#define GPGPUDSLP	(ELFIN_GPIO_BASE+GPGPUDSLP_OFFSET)

#define GPHCON0		(ELFIN_GPIO_BASE+GPHCON0_OFFSET)
#define GPHCON1		(ELFIN_GPIO_BASE+GPHCON1_OFFSET)
#define GPHDAT		(ELFIN_GPIO_BASE+GPHDAT_OFFSET)
#define GPHPUD		(ELFIN_GPIO_BASE+GPHPUD_OFFSET)
#define GPHCONSLP	(ELFIN_GPIO_BASE+GPHCONSLP_OFFSET)
#define GPHPUDSLP	(ELFIN_GPIO_BASE+GPHPUDSLP_OFFSET)

#define GPICON		(ELFIN_GPIO_BASE+GPICON_OFFSET)
#define GPIDAT		(ELFIN_GPIO_BASE+GPIDAT_OFFSET)
#define GPIPUD		(ELFIN_GPIO_BASE+GPIPUD_OFFSET)
#define GPICONSLP	(ELFIN_GPIO_BASE+GPICONSLP_OFFSET)
#define GPIPUDSLP	(ELFIN_GPIO_BASE+GPIPUDSLP_OFFSET)

#define GPJCON		(ELFIN_GPIO_BASE+GPJCON_OFFSET)
#define GPJDAT		(ELFIN_GPIO_BASE+GPJDAT_OFFSET)
#define GPJPUD		(ELFIN_GPIO_BASE+GPJPUD_OFFSET)
#define GPJCONSLP	(ELFIN_GPIO_BASE+GPJCONSLP_OFFSET)
#define GPJPUDSLP	(ELFIN_GPIO_BASE+GPJPUDSLP_OFFSET)

#define GPNCON		(ELFIN_GPIO_BASE+GPNCON_OFFSET)
#define GPNDAT		(ELFIN_GPIO_BASE+GPNDAT_OFFSET)
#define GPNPUD		(ELFIN_GPIO_BASE+GPNPUD_OFFSET)

#define GPPCON		(ELFIN_GPIO_BASE+GPPCON_OFFSET)
#define GPPDAT		(ELFIN_GPIO_BASE+GPPDAT_OFFSET)
#define GPPPUD		(ELFIN_GPIO_BASE+GPPPUD_OFFSET)
#define GPPCONSLP	(ELFIN_GPIO_BASE+GPPCONSLP_OFFSET)
#define GPPPUDSLP	(ELFIN_GPIO_BASE+GPPPUDSLP_OFFSET)
#define GPPCON_GPS		(ELFIN_GPIO_BASE+GPPCON_GPS_OFFSET)

#define GPRCON0		(ELFIN_GPIO_BASE+GPRCON0_OFFSET)
#define GPRCON1		(ELFIN_GPIO_BASE+GPRCON1_OFFSET)
#define GPRDAT		(ELFIN_GPIO_BASE+GPRDAT_OFFSET)
#define GPRPUD		(ELFIN_GPIO_BASE+GPRPUD_OFFSET)
#define GPRCONSLP	(ELFIN_GPIO_BASE+GPRCONSLP_OFFSET)
#define GPRPUDSLP	(ELFIN_GPIO_BASE+GPRPUDSLP_OFFSET)

/*
 * Memory controller
 */
#define ELFIN_SROM_BASE		0xE7000000

#define SROM_BW_REG		__REG(ELFIN_SROM_BASE+0x0)
#define SROM_BC0_REG		__REG(ELFIN_SROM_BASE+0x4)
#define SROM_BC1_REG		__REG(ELFIN_SROM_BASE+0x8)
#define SROM_BC2_REG		__REG(ELFIN_SROM_BASE+0xC)
#define SROM_BC3_REG		__REG(ELFIN_SROM_BASE+0x10)
#define SROM_BC4_REG		__REG(ELFIN_SROM_BASE+0x14)
#define SROM_BC5_REG		__REG(ELFIN_SROM_BASE+0x18)

/*
 * SDRAM Controller
 */
#define ELFIN_DMC0_BASE		0xE6000000

#define CONCONTROL_OFFSET 	0x00
#define MEMCONTROL_OFFSET 	0x04
#define MEMCONFIG0_OFFSET 	0x08
#define MEMCONFIG1_OFFSET 	0x0C
#define DIRECTCMD_OFFSET 	0x10
#define PRECHCONFIG_OFFSET 	0x14
#define PHYCONTROL0_OFFSET 	0x18
#define PHYCONTROL1_OFFSET 	0x1C
#define PHYCONTROL2_OFFSET 	0x20
#define PWRDNCONFIG_OFFSET 	0x28
#define TIMINGAREF_OFFSET 	0x30
#define TIMINGROW_OFFSET 	0x34
#define TIMINGDATA_OFFSET 	0x38
#define TIMINGPOWER_OFFSET 	0x3C
#define PHYSTATUS_OFFSET 	0x40
#define CHIP0STATUS_OFFSET 	0x48
#define CHIP1STATUS_OFFSET 	0x4C
#define AREFSTATUS_OFFSET 	0x50
#define MRSTATUS_OFFSET 	0x54
#define PHYTEST0_OFFSET 	0x58
#define PHYTEST1_OFFSET 	0x5C
#define QOSCONTROL0_OFFSET 	0x60
#define QOSCONFIG0_OFFSET 	0x64
#define QOSCONTROL1_OFFSET 	0x68
#define QOSCONFIG1_OFFSET 	0x6C
#define QOSCONTROL2_OFFSET 	0x70
#define QOSCONFIG2_OFFSET 	0x74
#define QOSCONTROL3_OFFSET 	0x78
#define QOSCONFIG3_OFFSET 	0x7C
#define QOSCONTROL4_OFFSET 	0x80
#define QOSCONFIG4_OFFSET 	0x84
#define QOSCONTROL5_OFFSET 	0x88
#define QOSCONFIG5_OFFSET 	0x8C
#define QOSCONTROL6_OFFSET 	0x90
#define QOSCONFIG6_OFFSET 	0x94
#define QOSCONTROL7_OFFSET 	0x98
#define QOSCONFIG7_OFFSET 	0x9C
#define QOSCONTROL8_OFFSET 	0xA0
#define QOSCONFIG8_OFFSET 	0xA4
#define QOSCONTROL9_OFFSET 	0xA8
#define QOSCONFIG9_OFFSET 	0xAC
#define QOSCONTROL10_OFFSET 	0xB0
#define QOSCONFIG10_OFFSET 	0xB4
#define QOSCONTROL11_OFFSET 	0xB8
#define QOSCONFIG11_OFFSET 	0xBC
#define QOSCONTROL12_OFFSET 	0xC0
#define QOSCONFIG12_OFFSET 	0xC4
#define QOSCONTROL13_OFFSET 	0xC8
#define QOSCONFIG13_OFFSET 	0xCC
#define QOSCONTROL14_OFFSET 	0xD0
#define QOSCONFIG14_OFFSET 	0xD4
#define QOSCONTROL15_OFFSET 	0xD8
#define QOSCONFIG15_OFFSET 	0xDC

/*
 * HS MMC Interface
 */
#define ELFIN_HSMMC_BASE	0xED800000

#define HM_SYSAD		(0x00)	/* SDI control */
#define HM_BLKSIZE		(0x04)	/* Host buffer boundary and transfer Block Size */
#define HM_BLKCNT		(0x06)	/* Block Count for current transfer */
#define HM_ARGUMENT		(0x08)	/* Command Argument */
#define HM_TRNMOD		(0x0c)	/* Transfer Mode setting */
#define HM_CMDREG		(0x0e)	/* Command Register */
#define HM_RSPREG0		(0x10)	/* Response 0 */
#define HM_RSPREG1		(0x14)	/* Response 1 */
#define HM_RSPREG2		(0x18)	/* Response 2 */
#define HM_RSPREG3		(0x1c)	/* Response 3 */
#define HM_BDATA		(0x20)	/* Buffer Data */
#define HM_PRNSTS		(0x24)	/* Present State */
#define HM_HOSTCTL		(0x28)	/* Host Control */
#define HM_PWRCON		(0x29)	/* Power Control */
#define HM_BLKGAP		(0x2a)	/* Block Gap control */
#define HM_WAKCON		(0x2b)	/* Wakeup Control */
#define HM_CLKCON		(0x2c)	/* Clock Control */
#define HM_TIMEOUTCON		(0x2e)	/* Time Out Control */
#define HM_SWRST		(0x2f)	/* Software Reset */
#define HM_NORINTSTS		(0x30)	/* Normal Interrupt Status */
#define HM_ERRINTSTS		(0x32)	/* Error Interrupt Status */
#define HM_NORINTSTSEN		(0x34)	/* Normal Interrupt Status Enable */
#define HM_ERRINTSTSEN		(0x36)	/* Error Interrupt Status Enable */
#define HM_NORINTSIGEN		(0x38)	/* Normal Interrupt Signal Enable */
#define HM_ERRINTSIGEN		(0x3a)	/* Error Interrupt Signal Enable */
#define HM_ACMD12ERRSTS		(0x3c)	/* Auto CMD12 Error Status */
#define HM_CAPAREG		(0x40)	/* Capability */
#define HM_MAXCURR		(0x48)	/* Maximum Current capacity */
#define HM_CONTROL2		(0x80)	/* Control 2 */
#define HM_CONTROL3		(0x84)	/* Control 3 */
#define HM_CONTROL4		(0x8c)	/* Control 4 */
#define HM_HCVER		(0xfe)	/* Host Controller Version */

/*
 * Nand flash controller
 */
#define ELFIN_NAND_BASE		0xE7100000

#define NFCONF_OFFSET           0x00
#define NFCONT_OFFSET           0x04
#define NFCMMD_OFFSET           0x08
#define NFADDR_OFFSET           0x0c
#define NFDATA_OFFSET		0x10
#define NFMECCDATA0_OFFSET      0x14
#define NFMECCDATA1_OFFSET      0x18
#define NFSECCDATA0_OFFSET      0x1c
#define NFSBLK_OFFSET           0x20
#define NFEBLK_OFFSET           0x24
#define NFSTAT_OFFSET           0x28
#define NFESTAT0_OFFSET         0x2c
#define NFESTAT1_OFFSET         0x30
#define NFMECC0_OFFSET          0x34
#define NFMECC1_OFFSET          0x38
#define NFSECC_OFFSET           0x3c
#define NFMLCBITPT_OFFSET       0x40
/* new registers in S5P6440 for 8/12/16 ECC */
#define NFECCCONF_OFFSET	0x20000 /* ECC configuration */
#define NFECCCONT_OFFSET	0x20020 /* ECC control */
#define NFECCSTAT_OFFSET	0x20030 /* ECC status */
#define NFECCSECSTAT0_OFFSET	0x20040 /* ECC sector status */
#define NFECCPRGECC0_OFFSET	0x20090 /* ECC parity code0 for page program */
#define NFECCPRGECC1_OFFSET	0x20094 /* ECC parity code1 for page program */
#define NFECCPRGECC2_OFFSET	0x20098 /* ECC parity code2 for page program */
#define NFECCPRGECC3_OFFSET	0x2009C /* ECC parity code3 for page program */
#define NFECCPRGECC4_OFFSET	0x200A0 /* ECC parity code4 for page program */
#define NFECCPRGECC5_OFFSET	0x200A4 /* ECC parity code5 for page program */
#define NFECCPRGECC6_OFFSET	0x200A8 /* ECC parity code6 for page program */
#define NFMLCECCERL0_OFFSET	0x200C0 /* ECC error byte location0 */
#define NFMLCECCERL1_OFFSET	0x200C4 /* ECC error byte location1 */
#define NFMLCECCERL2_OFFSET	0x200C8 /* ECC error byte location2 */
#define NFMLCECCERL3_OFFSET	0x200CC /* ECC error byte location3 */
#define NFMLCECCERL4_OFFSET	0x200D0 /* ECC error byte location4 */
#define NFMLCECCERL5_OFFSET	0x200D4 /* ECC error byte location5 */
#define NFMLCECCERL6_OFFSET	0x200D8 /* ECC error byte location6 */
#define NFMLCECCERL7_OFFSET	0x200DC /* ECC error byte location7 */
#define NFMLCECCERP0_OFFSET	0x200F0 /* ECC error bit pattern0 */
#define NFMLCECCERP1_OFFSET	0x200F4 /* ECC error bit pattern1 */
#define NFMLCECCERP2_OFFSET	0x200F8 /* ECC error bit pattern2 */
#define NFMLCECCERP3_OFFSET	0x200FC /* ECC error bit pattern3 */
#define NFECCCONECC0_OFFSET	0x20110 /* ECC parity conversion code0 */
#define NFECCCONECC1_OFFSET	0x20114 /* ECC parity conversion code1 */
#define NFECCCONECC2_OFFSET	0x20118 /* ECC parity conversion code2 */
#define NFECCCONECC3_OFFSET	0x2011C /* ECC parity conversion code3 */
#define NFECCCONECC4_OFFSET	0x20120 /* ECC parity conversion code4 */
#define NFECCCONECC5_OFFSET	0x20124 /* ECC parity conversion code5 */
#define NFECCCONECC6_OFFSET	0x20128 /* ECC parity conversion code6 */

#define NFCONF		(ELFIN_NAND_BASE+NFCONF_OFFSET)
#define NFCONT		(ELFIN_NAND_BASE+NFCONT_OFFSET)
#define NFCMMD		(ELFIN_NAND_BASE+NFCMMD_OFFSET)
#define NFADDR		(ELFIN_NAND_BASE+NFADDR_OFFSET)
#define NFDATA		(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFMECCDATA0	(ELFIN_NAND_BASE+NFMECCDATA0_OFFSET)
#define NFMECCDATA1	(ELFIN_NAND_BASE+NFMECCDATA1_OFFSET)
#define NFSECCDATA0	(ELFIN_NAND_BASE+NFSECCDATA0_OFFSET)
#define NFSBLK		(ELFIN_NAND_BASE+NFSBLK_OFFSET)
#define NFEBLK		(ELFIN_NAND_BASE+NFEBLK_OFFSET)
#define NFSTAT		(ELFIN_NAND_BASE+NFSTAT_OFFSET)
#define NFESTAT0	(ELFIN_NAND_BASE+NFESTAT0_OFFSET)
#define NFESTAT1	(ELFIN_NAND_BASE+NFESTAT1_OFFSET)
#define NFMECC0 	(ELFIN_NAND_BASE+NFMECC0_OFFSET)
#define NFMECC1 	(ELFIN_NAND_BASE+NFMECC1_OFFSET)
#define NFSECC		(ELFIN_NAND_BASE+NFSECC_OFFSET)
#define NFMLCBITPT	(ELFIN_NAND_BASE+NFMLCBITPT_OFFSET)

#define NFECCCONF	(ELFIN_NAND_BASE+NFECCCONF_OFFSET)
#define NFECCCONT	(ELFIN_NAND_BASE+NFECCCONT_OFFSET)
#define NFECCSTAT	(ELFIN_NAND_BASE+NFECCSTAT_OFFSET)
#define NFECCSECSTAT0	(ELFIN_NAND_BASE+NFECCSECSTAT0_OFFSET)
#define NFECCPRGECC0	(ELFIN_NAND_BASE+NFECCPRGECC0_OFFSET)
#define NFECCPRGECC1	(ELFIN_NAND_BASE+NFECCPRGECC1_OFFSET)
#define NFECCPRGECC2	(ELFIN_NAND_BASE+NFECCPRGECC2_OFFSET)
#define NFECCPRGECC3	(ELFIN_NAND_BASE+NFECCPRGECC3_OFFSET)
#define NFECCPRGECC4	(ELFIN_NAND_BASE+NFECCPRGECC4_OFFSET)
#define NFECCPRGECC5	(ELFIN_NAND_BASE+NFECCPRGECC5_OFFSET)
#define NFECCPRGECC6	(ELFIN_NAND_BASE+NFECCPRGECC6_OFFSET)
#define NFMLCECCERL0	(ELFIN_NAND_BASE+NFMLCECCERL0_OFFSET)
#define NFMLCECCERL1	(ELFIN_NAND_BASE+NFMLCECCERL1_OFFSET)
#define NFMLCECCERL2	(ELFIN_NAND_BASE+NFMLCECCERL2_OFFSET)
#define NFMLCECCERL3	(ELFIN_NAND_BASE+NFMLCECCERL3_OFFSET)
#define NFMLCECCERL4	(ELFIN_NAND_BASE+NFMLCECCERL4_OFFSET)
#define NFMLCECCERL5	(ELFIN_NAND_BASE+NFMLCECCERL5_OFFSET)
#define NFMLCECCERL6	(ELFIN_NAND_BASE+NFMLCECCERL6_OFFSET)
#define NFMLCECCERL7	(ELFIN_NAND_BASE+NFMLCECCERL7_OFFSET)
#define NFMLCECCERP0	(ELFIN_NAND_BASE+NFMLCECCERP0_OFFSET)
#define NFMLCECCERP1	(ELFIN_NAND_BASE+NFMLCECCERP1_OFFSET)
#define NFMLCECCERP2	(ELFIN_NAND_BASE+NFMLCECCERP2_OFFSET)
#define NFMLCECCERP3	(ELFIN_NAND_BASE+NFMLCECCERP3_OFFSET)
#define NFECCCONECC0	(ELFIN_NAND_BASE+NFECCCONECC0_OFFSET)
#define NFECCCONECC1	(ELFIN_NAND_BASE+NFECCCONECC1_OFFSET)
#define NFECCCONECC2	(ELFIN_NAND_BASE+NFECCCONECC2_OFFSET)
#define NFECCCONECC3	(ELFIN_NAND_BASE+NFECCCONECC3_OFFSET)
#define NFECCCONECC4	(ELFIN_NAND_BASE+NFECCCONECC4_OFFSET)
#define NFECCCONECC5	(ELFIN_NAND_BASE+NFECCCONECC5_OFFSET)
#define NFECCCONECC6	(ELFIN_NAND_BASE+NFECCCONECC6_OFFSET)

#define NFCONF_REG		__REG(ELFIN_NAND_BASE+NFCONF_OFFSET)
#define NFCONT_REG		__REG(ELFIN_NAND_BASE+NFCONT_OFFSET)
#define NFCMD_REG		__REG(ELFIN_NAND_BASE+NFCMMD_OFFSET)
#define NFADDR_REG           	__REG(ELFIN_NAND_BASE+NFADDR_OFFSET)
#define NFDATA_REG          	__REG(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFDATA8_REG          	__REGb(ELFIN_NAND_BASE+NFDATA_OFFSET)
#define NFMECCDATA0_REG     	__REG(ELFIN_NAND_BASE+NFMECCDATA0_OFFSET)
#define NFMECCDATA1_REG     	__REG(ELFIN_NAND_BASE+NFMECCDATA1_OFFSET)
#define NFSECCDATA0_REG      	__REG(ELFIN_NAND_BASE+NFSECCDATA0_OFFSET)
#define NFSBLK_REG          	__REG(ELFIN_NAND_BASE+NFSBLK_OFFSET)
#define NFEBLK_REG           	__REG(ELFIN_NAND_BASE+NFEBLK_OFFSET)
#define NFSTAT_REG           	__REG(ELFIN_NAND_BASE+NFSTAT_OFFSET)
#define NFESTAT0_REG         	__REG(ELFIN_NAND_BASE+NFESTAT0_OFFSET)
#define NFESTAT1_REG         	__REG(ELFIN_NAND_BASE+NFESTAT1_OFFSET)
#define NFMECC0_REG          	__REG(ELFIN_NAND_BASE+NFMECC0_OFFSET)
#define NFMECC1_REG          	__REG(ELFIN_NAND_BASE+NFMECC1_OFFSET)
#define NFSECC_REG           	__REG(ELFIN_NAND_BASE+NFSECC_OFFSET)
#define NFMLCBITPT_REG         	__REG(ELFIN_NAND_BASE+NFMLCBITPT_OFFSET)

#define NFCONF_ECC_MLC		(1<<24)
#define NFCONT_ECC_ENC		(1<<18)
#define NFCONT_WP		(1<<16)
#define NFCONT_MECCLOCK		(1<<7)
#define NFCONT_SECCLOCK		(1<<6)
#define NFCONT_INITMECC		(1<<5)
#define NFCONT_INITSECC		(1<<4)
#define NFCONT_INITECC		(NFCONT_INITMECC | NFCONT_INITSECC)
#define NFCONT_CS_ALT		(1<<1)
#define NFCONT_CS		(1<<1)
#define NFSTAT_ECCENCDONE	(1<<7)
#define NFSTAT_ECCDECDONE	(1<<6)
#define NFSTAT_RnB		(1<<0)
#define NFESTAT0_ECCBUSY	(1<<31)

#define NFECCCONF_MSGLENGTH(x)		(x<<16)
#define NFECCCONF_MSGLENGTH_MSK		(0x3ff)
#define NFECCCONF_ECCTYPE_DIS		(0x0)
#define NFECCCONF_ECCTYPE_MSK		(0xf)
#define NFECCCONF_ECCTYPE_8_512		(0x3)
#define NFECCCONF_ECCTYPE_12_512	(0x4)
#define NFECCCONF_ECCTYPE_16_512	(0x5)

#define NFECCCONT_ENCINT		(1<<25)
#define NFECCCONT_DECINT		(1<<24)
#define NFECCCONT_ECCENC		(1<<16)
#define NFECCCONT_ECCDEC		(0<<16)
#define NFECCCONT_INITECC		(1<<2)
#define NFECCCONT_RESETECC		(1<<0)

#define NFECCSTAT_BUSY			(1<<31)
#define NFECCSTAT_ENC_DONE		(1<<25)
#define NFECCSTAT_DEC_DONE		(1<<24)
#define NFECCSTAT_FREE_PAGE		(1<<8)


/*************************************************************
 * OneNAND Controller
 *************************************************************/

/*
 * S5P6440 SFRs
 */
#define ONENAND_REG_MEM_CFG		(0x000)
#define ONENAND_REG_BURST_LEN		(0x010)
#define ONENAND_REG_MEM_RESET		(0x020)
#define ONENAND_REG_INT_ERR_STAT	(0x030)
#define ONENAND_REG_INT_ERR_MASK	(0x040)
#define ONENAND_REG_INT_ERR_ACK		(0x050)
#define ONENAND_REG_ECC_ERR_STAT	(0x060)
#define ONENAND_REG_MANUFACT_ID		(0x070)
#define ONENAND_REG_DEVICE_ID		(0x080)
#define ONENAND_REG_DATA_BUF_SIZE	(0x090)
#define ONENAND_REG_BOOT_BUF_SIZE	(0x0A0)
#define ONENAND_REG_BUF_AMOUNT		(0x0B0)
#define ONENAND_REG_TECH		(0x0C0)
#define ONENAND_REG_FBA_WIDTH		(0x0D0)
#define ONENAND_REG_FPA_WIDTH		(0x0E0)
#define ONENAND_REG_FSA_WIDTH		(0x0F0)
#define ONENAND_REG_REVISION		(0x100)
#define ONENAND_REG_DATARAM0		(0x110)
#define ONENAND_REG_DATARAM1		(0x120)
#define ONENAND_REG_SYNC_MODE		(0x130)
#define ONENAND_REG_TRANS_SPARE		(0x140)
#define ONENAND_REG_LOCK_BIT		(0x150)
#define ONENAND_REG_DBS_DFS_WIDTH	(0x160)
#define ONENAND_REG_PAGE_CNT		(0x170)
#define ONENAND_REG_ERR_PAGE_ADDR	(0x180)
#define ONENAND_REG_BURST_RD_LAT	(0x190)
#define ONENAND_REG_INT_PIN_ENABLE	(0x1A0)
#define ONENAND_REG_INT_MON_CYC		(0x1B0)
#define ONENAND_REG_ACC_CLOCK		(0x1C0)
#define ONENAND_REG_SLOW_RD_PATH	(0x1D0)
#define ONENAND_REG_ERR_BLK_ADDR	(0x1E0)
#define ONENAND_REG_FLASH_VER_ID	(0x1F0)
#define ONENAND_REG_FLASH_AUX_CNTRL	(0x300)

/*
 * S5P6440 SFR values
 */
#define ONENAND_MEM_CFG_SYNC_READ	(1 << 15)
#define ONENAND_MEM_CFG_BRL_7		(7 << 12)
#define ONENAND_MEM_CFG_BRL_6		(6 << 12)
#define ONENAND_MEM_CFG_BRL_5		(5 << 12)
#define ONENAND_MEM_CFG_BRL_4		(4 << 12)
#define ONENAND_MEM_CFG_BRL_3		(3 << 12)
#define ONENAND_MEM_CFG_BRL_10		(2 << 12)
#define ONENAND_MEM_CFG_BRL_9		(1 << 12)
#define ONENAND_MEM_CFG_BRL_8		(0 << 12)
#define ONENAND_MEM_CFG_BRL_SHIFT	(12)
#define ONENAND_MEM_CFG_BL_1K		(5 << 9)
#define ONENAND_MEM_CFG_BL_32		(4 << 9)
#define ONENAND_MEM_CFG_BL_16		(3 << 9)
#define ONENAND_MEM_CFG_BL_8		(2 << 9)
#define ONENAND_MEM_CFG_BL_4		(1 << 9)
#define ONENAND_MEM_CFG_BL_CONT		(0 << 9)
#define ONENAND_MEM_CFG_BL_SHIFT	(9)
#define ONENAND_MEM_CFG_NO_ECC		(1 << 8)
#define ONENAND_MEM_CFG_RDY_HIGH	(1 << 7)
#define ONENAND_MEM_CFG_INT_HIGH	(1 << 6)
#define ONENAND_MEM_CFG_IOBE		(1 << 5)
#define ONENAND_MEM_CFG_RDY_CONF	(1 << 4)
#define ONENAND_MEM_CFG_HF		(1 << 2)
#define ONENAND_MEM_CFG_WM_SYNC		(1 << 1)
#define ONENAND_MEM_CFG_BWPS_UNLOCK	(1 << 0)

#define ONENAND_BURST_LEN_CONT		(0)
#define ONENAND_BURST_LEN_4		(4)
#define ONENAND_BURST_LEN_8		(8)
#define ONENAND_BURST_LEN_16		(16)

#define ONENAND_MEM_RESET_WARM		(0x1)
#define ONENAND_MEM_RESET_COLD		(0x2)
#define ONENAND_MEM_RESET_HOT		(0x3)

#define ONENAND_INT_ERR_CACHE_OP_ERR	(1 << 13)
#define ONENAND_INT_ERR_RST_CMP		(1 << 12)
#define ONENAND_INT_ERR_RDY_ACT		(1 << 11)
#define ONENAND_INT_ERR_INT_ACT		(1 << 10)
#define ONENAND_INT_ERR_UNSUP_CMD	(1 << 9)
#define ONENAND_INT_ERR_LOCKED_BLK	(1 << 8)
#define ONENAND_INT_ERR_BLK_RW_CMP	(1 << 7)
#define ONENAND_INT_ERR_ERS_CMP		(1 << 6)
#define ONENAND_INT_ERR_PGM_CMP		(1 << 5)
#define ONENAND_INT_ERR_LOAD_CMP	(1 << 4)
#define ONENAND_INT_ERR_ERS_FAIL	(1 << 3)
#define ONENAND_INT_ERR_PGM_FAIL	(1 << 2)
#define ONENAND_INT_ERR_INT_TO		(1 << 1)
#define ONENAND_INT_ERR_LD_FAIL_ECC_ERR	(1 << 0)

#define ONENAND_DEVICE_DENSITY_SHIFT	(4)
#define ONENAND_DEVICE_IS_DDP		(1 << 3)
#define ONENAND_DEVICE_IS_DEMUX		(1 << 2)
#define ONENAND_DEVICE_VCC_MASK		(0x3)
#define ONENAND_DEVICE_DENSITY_128Mb	(0x000)
#define ONENAND_DEVICE_DENSITY_256Mb	(0x001)
#define ONENAND_DEVICE_DENSITY_512Mb	(0x002)
#define ONENAND_DEVICE_DENSITY_1Gb	(0x003)
#define ONENAND_DEVICE_DENSITY_2Gb	(0x004)
#define ONENAND_DEVICE_DENSITY_4Gb	(0x005)

#define ONENAND_SYNC_MODE_RM_SYNC	(1 << 1)
#define ONENAND_SYNC_MODE_WM_SYNC	(1 << 0)

#define ONENAND_TRANS_SPARE_TSRF_INC	(1 << 0)

#define ONENAND_INT_PIN_ENABLE		(1 << 0)

#define ONENAND_ACC_CLOCK_266_133	(0x5)
#define ONENAND_ACC_CLOCK_166_83	(0x3)
#define ONENAND_ACC_CLOCK_134_67	(0x3)
#define ONENAND_ACC_CLOCK_100_50	(0x2)
#define ONENAND_ACC_CLOCK_60_30		(0x2)

#define ONENAND_FLASH_AUX_WD_DISABLE	(1 << 0)

/*
 * Datain values for mapped commands
 */
#define ONENAND_DATAIN_ERASE_STATUS	(0x00)
#define ONENAND_DATAIN_ERASE_MULTI	(0x01)
#define ONENAND_DATAIN_ERASE_SINGLE	(0x03)
#define ONENAND_DATAIN_ERASE_VERIFY	(0x15)
#define ONENAND_DATAIN_UNLOCK_START	(0x08)
#define ONENAND_DATAIN_UNLOCK_END	(0x09)
#define ONENAND_DATAIN_LOCK_START	(0x0A)
#define ONENAND_DATAIN_LOCK_END		(0x0B)
#define ONENAND_DATAIN_LOCKTIGHT_START	(0x0C)
#define ONENAND_DATAIN_LOCKTIGHT_END	(0x0D)
#define ONENAND_DATAIN_UNLOCK_ALL	(0x0E)
#define ONENAND_DATAIN_COPYBACK_SRC	(0x1000)
#define ONENAND_DATAIN_COPYBACK_DST	(0x2000)
#define ONENAND_DATAIN_ACCESS_OTP	(0x12)
#define ONENAND_DATAIN_ACCESS_MAIN	(0x14)
#define ONENAND_DATAIN_PIPELINE_READ	(0x4000)
#define ONENAND_DATAIN_PIPELINE_WRITE	(0x4100)
#define ONENAND_DATAIN_RMW_LOAD		(0x10)
#define ONENAND_DATAIN_RMW_MODIFY	(0x11)

/*
 * Device ID Register F001h (R)
 */
#define ONENAND_DEVICE_DENSITY_SHIFT	(4)
#define ONENAND_DEVICE_IS_DDP		(1 << 3)
#define ONENAND_DEVICE_IS_DEMUX		(1 << 2)
#define ONENAND_DEVICE_VCC_MASK		(0x3)

/*
 * Version ID Register F002h (R)
 */
#define ONENAND_VERSION_PROCESS_SHIFT	(8)

/*
 * Start Address 1 F100h (R/W)
 */
#define ONENAND_DDP_SHIFT		(15)
#define ONENAND_DDP_CHIP0		(0)
#define ONENAND_DDP_CHIP1		(1 << ONENAND_DDP_SHIFT)

/*
 * Start Buffer Register F200h (R/W)
 */
#define ONENAND_BSA_MASK		(0x03)
#define ONENAND_BSA_SHIFT		(8)
#define ONENAND_BSA_BOOTRAM		(0 << 2)
#define ONENAND_BSA_DATARAM0		(2 << 2)
#define ONENAND_BSA_DATARAM1		(3 << 2)
#define ONENAND_BSC_MASK		(0x03)

/*
 * Command Register F220h (R/W)
 */
#define ONENAND_CMD_READ		(0x00)
#define ONENAND_CMD_READOOB		(0x13)
#define ONENAND_CMD_PROG		(0x80)
#define ONENAND_CMD_PROGOOB		(0x1A)
#define ONENAND_CMD_UNLOCK		(0x23)
#define ONENAND_CMD_LOCK		(0x2A)
#define ONENAND_CMD_LOCK_TIGHT		(0x2C)
#define ONENAND_CMD_UNLOCK_ALL		(0x27)
#define ONENAND_CMD_ERASE		(0x94)
#define ONENAND_CMD_RESET		(0xF0)
#define ONENAND_CMD_OTP_ACCESS		(0x65)
#define ONENAND_CMD_READID		(0x90)
#define ONENAND_CMD_STARTADDR1		(0xE0)
#define ONENAND_CMD_WP_STATUS		(0xE1)
#define ONENAND_CMD_PIPELINE_READ	(0x01)
#define ONENAND_CMD_PIPELINE_WRITE	(0x81)

/*
 * Command Mapping for S3C6400 OneNAND Controller
 */
#define ONENAND_AHB_ADDR		(0x20000000)
#define ONENAND_DUMMY_ADDR		(0x20400000)
#define ONENAND_CMD_SHIFT		(24)
#define ONENAND_CMD_MAP_00		(0x0)
#define ONENAND_CMD_MAP_01		(0x1)
#define ONENAND_CMD_MAP_10		(0x2)
#define ONENAND_CMD_MAP_11		(0x3)
#define ONENAND_CMD_MAP_FF		(0xF)

/*
 * Mask for Mapping table
 */
#define ONENAND_MEM_ADDR_MASK		(0xffffff)
#define ONENAND_DDP_SHIFT_1Gb		(21)
#define ONENAND_DDP_SHIFT_2Gb		(22)
#define ONENAND_DDP_SHIFT_4Gb		(23)
#define ONENAND_FBA_SHIFT		(12)
#define ONENAND_FPA_SHIFT		(6)
#define ONENAND_FSA_SHIFT		(4)
#define ONENAND_FBA_MASK_128Mb		(0xff)
#define ONENAND_FBA_MASK_256Mb		(0x1ff)
#define ONENAND_FBA_MASK_512Mb		(0x1ff)
#define ONENAND_FBA_MASK_1Gb_DDP	(0x1ff)
#define ONENAND_FBA_MASK_1Gb		(0x3ff)
#define ONENAND_FBA_MASK_2Gb_DDP	(0x3ff)
#define ONENAND_FBA_MASK_2Gb		(0x7ff)
#define ONENAND_FBA_MASK_4Gb_DDP	(0x7ff)
#define ONENAND_FBA_MASK_4Gb		(0xfff)
#define ONENAND_FPA_MASK		(0x3f)
#define ONENAND_FSA_MASK		(0x3)

/*
 * System Configuration 1 Register F221h (R, R/W)
 */
#define ONENAND_SYS_CFG1_SYNC_READ	(1 << 15)
#define ONENAND_SYS_CFG1_BRL_7		(7 << 12)
#define ONENAND_SYS_CFG1_BRL_6		(6 << 12)
#define ONENAND_SYS_CFG1_BRL_5		(5 << 12)
#define ONENAND_SYS_CFG1_BRL_4		(4 << 12)
#define ONENAND_SYS_CFG1_BRL_3		(3 << 12)
#define ONENAND_SYS_CFG1_BRL_10		(2 << 12)
#define ONENAND_SYS_CFG1_BRL_9		(1 << 12)
#define ONENAND_SYS_CFG1_BRL_8		(0 << 12)
#define ONENAND_SYS_CFG1_BRL_SHIFT	(12)
#define ONENAND_SYS_CFG1_BL_32		(4 << 9)
#define ONENAND_SYS_CFG1_BL_16		(3 << 9)
#define ONENAND_SYS_CFG1_BL_8		(2 << 9)
#define ONENAND_SYS_CFG1_BL_4		(1 << 9)
#define ONENAND_SYS_CFG1_BL_CONT	(0 << 9)
#define ONENAND_SYS_CFG1_BL_SHIFT	(9)
#define ONENAND_SYS_CFG1_NO_ECC		(1 << 8)
#define ONENAND_SYS_CFG1_RDY		(1 << 7)
#define ONENAND_SYS_CFG1_INT		(1 << 6)
#define ONENAND_SYS_CFG1_IOBE		(1 << 5)
#define ONENAND_SYS_CFG1_RDY_CONF	(1 << 4)

/*
 * Controller Status Register F240h (R)
 */
#define ONENAND_CTRL_ONGO		(1 << 15)
#define ONENAND_CTRL_LOCK		(1 << 14)
#define ONENAND_CTRL_LOAD		(1 << 13)
#define ONENAND_CTRL_PROGRAM		(1 << 12)
#define ONENAND_CTRL_ERASE		(1 << 11)
#define ONENAND_CTRL_ERROR		(1 << 10)
#define ONENAND_CTRL_RSTB		(1 << 7)
#define ONENAND_CTRL_OTP_L		(1 << 6)
#define ONENAND_CTRL_OTP_BL		(1 << 5)

/*
 * Interrupt Status Register F241h (R)
 */
#define ONENAND_INT_MASTER		(1 << 15)
#define ONENAND_INT_READ		(1 << 7)
#define ONENAND_INT_WRITE		(1 << 6)
#define ONENAND_INT_ERASE		(1 << 5)
#define ONENAND_INT_RESET		(1 << 4)
#define ONENAND_INT_CLEAR		(0 << 0)

/*
 * NAND Flash Write Protection Status Register F24Eh (R)
 */
#define ONENAND_WP_US			(1 << 2)
#define ONENAND_WP_LS			(1 << 1)
#define ONENAND_WP_LTS			(1 << 0)

/*
 * ECC Status Register FF00h (R)
 */
#define ONENAND_ECC_1BIT		(1 << 0)
#define ONENAND_ECC_1BIT_ALL		(0x5555)
#define ONENAND_ECC_2BIT		(1 << 1)
#define ONENAND_ECC_2BIT_ALL		(0xAAAA)

/*
 * One-Time Programmable (OTP)
 */
#define ONENAND_OTP_LOCK_OFFSET		(14)

/*************************************************************
 * End of OneNAND Controller
 *************************************************************/


/*
 * Interrupt
 */
#define ELFIN_VIC0_BASE_ADDR		(0xE4000000)
#define ELFIN_VIC1_BASE_ADDR		(0xE4100000)
#define oINTMOD				(0x0C)		// VIC INT SELECT (IRQ or FIQ)
#define oINTUNMSK			(0x10)		// VIC INT EN (Unmask by writing 1)
#define oINTMSK				(0x14)		// VIC INT EN CLEAR (Mask by writing 1)
#define oINTSUBMSK			(0x1C)		// VIC SOFT INT CLEAR
#define oVECTADDR			(0xF00)		// VIC ADDRESS



/*
 * Watchdog timer
 */
#define ELFIN_WATCHDOG_BASE		0xEA200000

#define WTCON_REG			__REG(0xEA200004)
#define WTDAT_REG			__REG(0xEA200008)
#define WTCNT_REG			__REG(0xEA20000C)



/*
 * UART
 */
#define ELFIN_UART_BASE		0xEC005000

#define ELFIN_UART0_OFFSET	0x0000
#define ELFIN_UART1_OFFSET	0x0400
#define ELFIN_UART2_OFFSET	0x0800
#define ELFIN_UART3_OFFSET	0x0c00

#ifdef CONFIG_SERIAL1
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART0_OFFSET)
#elif defined(CONFIG_SERIAL2)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART1_OFFSET)
#elif defined(CONFIG_SERIAL3)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART2_OFFSET)
#elif defined(CONFIG_SERIAL4)
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART3_OFFSET)
#else
#define ELFIN_UART_CONSOLE_BASE (ELFIN_UART_BASE + ELFIN_UART0_OFFSET)
#endif

#define ULCON_OFFSET		0x00
#define UCON_OFFSET		0x04
#define UFCON_OFFSET		0x08
#define UMCON_OFFSET		0x0C
#define UTRSTAT_OFFSET		0x10
#define UERSTAT_OFFSET		0x14
#define UFSTAT_OFFSET		0x18
#define UMSTAT_OFFSET		0x1C
#define UTXH_OFFSET		0x20
#define URXH_OFFSET		0x24
#define UBRDIV_OFFSET		0x28
#define UDIVSLOT_OFFSET		0x2C
#define UINTP_OFFSET		0x30
#define UINTSP_OFFSET		0x34
#define UINTM_OFFSET		0x38

#define ULCON0_REG		__REG(0xEC005000)
#define UCON0_REG		__REG(0xEC005004)
#define UFCON0_REG		__REG(0xEC005008)
#define UMCON0_REG		__REG(0xEC00500C)
#define UTRSTAT0_REG		__REG(0xEC005010)
#define UERSTAT0_REG		__REG(0xEC005014)
#define UFSTAT0_REG		__REG(0xEC005018)
#define UMSTAT0_REG		__REG(0xEC00501c)
#define UTXH0_REG		__REG(0xEC005020)
#define URXH0_REG		__REG(0xEC005024)
#define UBRDIV0_REG		__REG(0xEC005028)
#define UDIVSLOT0_REG		__REG(0xEC00502c)
#define UINTP0_REG		__REG(0xEC005030)
#define UINTSP0_REG		__REG(0xEC005034)
#define UINTM0_REG		__REG(0xEC005038)

#define ULCON1_REG		__REG(0xEC005400)
#define UCON1_REG		__REG(0xEC005404)
#define UFCON1_REG		__REG(0xEC005408)
#define UMCON1_REG		__REG(0xEC00540C)
#define UTRSTAT1_REG		__REG(0xEC005410)
#define UERSTAT1_REG		__REG(0xEC005414)
#define UFSTAT1_REG		__REG(0xEC005418)
#define UMSTAT1_REG		__REG(0xEC00541c)
#define UTXH1_REG		__REG(0xEC005420)
#define URXH1_REG		__REG(0xEC005424)
#define UBRDIV1_REG		__REG(0xEC005428)
#define UDIVSLOT1_REG		__REG(0xEC00542c)
#define UINTP1_REG		__REG(0xEC005430)
#define UINTSP1_REG		__REG(0xEC005434)
#define UINTM1_REG		__REG(0xEC005438)

#define UTRSTAT_TX_EMPTY	BIT2
#define UTRSTAT_RX_READY	BIT0
#define UART_ERR_MASK		0xF


/*
 * PWM timer
 */
#define ELFIN_TIMER_BASE	0xEA000000

#define TCFG0_REG		__REG(0xEA000000)
#define TCFG1_REG		__REG(0xEA000004)
#define TCON_REG			__REG(0xEA000008)
#define TCNTB0_REG		__REG(0xEA00000c)
#define TCMPB0_REG		__REG(0xEA000010)
#define TCNTO0_REG		__REG(0xEA000014)
#define TCNTB1_REG		__REG(0xEA000018)
#define TCMPB1_REG		__REG(0xEA00001c)
#define TCNTO1_REG		__REG(0xEA000020)
#define TCNTB2_REG		__REG(0xEA000024)
#define TCMPB2_REG		__REG(0xEA000028)
#define TCNTO2_REG		__REG(0xEA00002c)
#define TCNTB3_REG		__REG(0xEA000030)
#define TCMPB3_REG		__REG(0xEA000034)
#define TCNTO3_REG		__REG(0xEA000038)
#define TCNTB4_REG		__REG(0xEA00003c)
#define TCNTO4_REG		__REG(0xEA000040)

/* Fields */
#define fTCFG0_DZONE		Fld(8,16)       /* the dead zone length (= timer 0) */
#define fTCFG0_PRE1		Fld(8,8)        /* prescaler value for time 2,3,4 */
#define fTCFG0_PRE0		Fld(8,0)        /* prescaler value for time 0,1 */
#define fTCFG1_MUX4		Fld(4,16)
/* bits */
#define TCFG0_DZONE(x)		FInsrt((x), fTCFG0_DZONE)
#define TCFG0_PRE1(x)		FInsrt((x), fTCFG0_PRE1)
#define TCFG0_PRE0(x)		FInsrt((x), fTCFG0_PRE0)
#define TCON_4_AUTO		(1 << 22)       /* auto reload on/off for Timer 4 */
#define TCON_4_UPDATE		(1 << 21)       /* manual Update TCNTB4 */
#define TCON_4_ONOFF		(1 << 20)       /* 0: Stop, 1: start Timer 4 */
#define COUNT_4_ON		(TCON_4_ONOFF*1)
#define COUNT_4_OFF		(TCON_4_ONOFF*0)
#define TCON_3_AUTO		(1 << 19)       /* auto reload on/off for Timer 3 */
#define TIMER3_ATLOAD_ON	(TCON_3_AUTO*1)
#define TIMER3_ATLAOD_OFF	FClrBit(TCON, TCON_3_AUTO)
#define TCON_3_INVERT		(1 << 18)       /* 1: Inverter on for TOUT3 */
#define TIMER3_IVT_ON		(TCON_3_INVERT*1)
#define TIMER3_IVT_OFF		(FClrBit(TCON, TCON_3_INVERT))
#define TCON_3_MAN		(1 << 17)       /* manual Update TCNTB3,TCMPB3 */
#define TIMER3_MANUP		(TCON_3_MAN*1)
#define TIMER3_NOP		(FClrBit(TCON, TCON_3_MAN))
#define TCON_3_ONOFF		(1 << 16)       /* 0: Stop, 1: start Timer 3 */
#define TIMER3_ON		(TCON_3_ONOFF*1)
#define TIMER3_OFF		(FClrBit(TCON, TCON_3_ONOFF))
/* macros */
#define GET_PRESCALE_TIMER4(x)	FExtr((x), fTCFG0_PRE1)
#define GET_DIVIDER_TIMER4(x)	FExtr((x), fTCFG1_MUX4)

/*
 * RTC Controller
 */
#define ELFIN_RTC_BASE		0x7e005000

#define RTCCON_REG		__REG(0x7e005040)
#define TICNT_REG		__REG(0x7e005044)
#define RTCALM_REG		__REG(0x7e005050)
#define ALMSEC_REG		__REG(0x7e005054)
#define ALMMIN_REG		__REG(0x7e005058)
#define ALMHOUR_REG		__REG(0x7e00505c)
#define ALMDATE_REG		__REG(0x7e005060)
#define ALMMON_REG		__REG(0x7e005064)
#define ALMYEAR_REG		__REG(0x7e005068)
#define BCDSEC_REG		__REG(0x7e005070)
#define BCDMIN_REG		__REG(0x7e005074)
#define BCDHOUR_REG		__REG(0x7e005078)
#define BCDDATE_REG		__REG(0x7e00507c)
#define BCDDAY_REG		__REG(0x7e005080)
#define BCDMON_REG		__REG(0x7e005084)
#define BCDYEAR_REG		__REG(0x7e005088)

/*
 * USB2.0 HS OTG (Chapter 26)
 */
#define USBOTG_LINK_BASE	(0xED100000)
#define USBOTG_PHY_BASE		(0xED200000)

/* Core Global Registers */
#define S3C_OTG_GOTGCTL		(USBOTG_LINK_BASE + 0x000)	/* OTG Control & Status */
#define S3C_OTG_GOTGINT		(USBOTG_LINK_BASE + 0x004)	/* OTG Interrupt */
#define S3C_OTG_GAHBCFG		(USBOTG_LINK_BASE + 0x008)	/* Core AHB Configuration */
#define S3C_OTG_GUSBCFG		(USBOTG_LINK_BASE + 0x00C)	/* Core USB Configuration */
#define S3C_OTG_GRSTCTL		(USBOTG_LINK_BASE + 0x010)	/* Core Reset */
#define S3C_OTG_GINTSTS		(USBOTG_LINK_BASE + 0x014)	/* Core Interrupt */
#define S3C_OTG_GINTMSK		(USBOTG_LINK_BASE + 0x018)	/* Core Interrupt Mask */
#define S3C_OTG_GRXSTSR		(USBOTG_LINK_BASE + 0x01C)	/* Receive Status Debug Read/Status Read */
#define S3C_OTG_GRXSTSP		(USBOTG_LINK_BASE + 0x020)	/* Receive Status Debug Pop/Status Pop */
#define S3C_OTG_GRXFSIZ		(USBOTG_LINK_BASE + 0x024)	/* Receive FIFO Size */
#define S3C_OTG_GNPTXFSIZ	(USBOTG_LINK_BASE + 0x028)	/* Non-Periodic Transmit FIFO Size */
#define S3C_OTG_GNPTXSTS	(USBOTG_LINK_BASE + 0x02C)	/* Non-Periodic Transmit FIFO/Queue Status */

#define S3C_OTG_HPTXFSIZ	(USBOTG_LINK_BASE + 0x100)	/* Host Periodic Transmit FIFO Size */
#define S3C_OTG_DPTXFSIZ1	(USBOTG_LINK_BASE + 0x104)	/* Device Periodic Transmit FIFO-1 Size */
#define S3C_OTG_DPTXFSIZ2	(USBOTG_LINK_BASE + 0x108)	/* Device Periodic Transmit FIFO-2 Size */
#define S3C_OTG_DPTXFSIZ3	(USBOTG_LINK_BASE + 0x10C)	/* Device Periodic Transmit FIFO-3 Size */
#define S3C_OTG_DPTXFSIZ4	(USBOTG_LINK_BASE + 0x110)	/* Device Periodic Transmit FIFO-4 Size */
#define S3C_OTG_DPTXFSIZ5	(USBOTG_LINK_BASE + 0x114)	/* Device Periodic Transmit FIFO-5 Size */
#define S3C_OTG_DPTXFSIZ6	(USBOTG_LINK_BASE + 0x118)	/* Device Periodic Transmit FIFO-6 Size */
#define S3C_OTG_DPTXFSIZ7	(USBOTG_LINK_BASE + 0x11C)	/* Device Periodic Transmit FIFO-7 Size */
#define S3C_OTG_DPTXFSIZ8	(USBOTG_LINK_BASE + 0x120)	/* Device Periodic Transmit FIFO-8 Size */
#define S3C_OTG_DPTXFSIZ9	(USBOTG_LINK_BASE + 0x124)	/* Device Periodic Transmit FIFO-9 Size */
#define S3C_OTG_DPTXFSIZ10	(USBOTG_LINK_BASE + 0x128)	/* Device Periodic Transmit FIFO-10 Size */
#define S3C_OTG_DPTXFSIZ11	(USBOTG_LINK_BASE + 0x12C)	/* Device Periodic Transmit FIFO-11 Size */
#define S3C_OTG_DPTXFSIZ12	(USBOTG_LINK_BASE + 0x130)	/* Device Periodic Transmit FIFO-12 Size */
#define S3C_OTG_DPTXFSIZ13	(USBOTG_LINK_BASE + 0x134)	/* Device Periodic Transmit FIFO-13 Size */
#define S3C_OTG_DPTXFSIZ14	(USBOTG_LINK_BASE + 0x138)	/* Device Periodic Transmit FIFO-14 Size */
#define S3C_OTG_DPTXFSIZ15	(USBOTG_LINK_BASE + 0x13C)	/* Device Periodic Transmit FIFO-15 Size */

/* Host Global Registers */
#define S3C_OTG_HCFG		(USBOTG_LINK_BASE + 0x400)	/* Host Configuration */
#define S3C_OTG_HFIR		(USBOTG_LINK_BASE + 0x404)	/* Host Frame Interval */
#define S3C_OTG_HFNUM		(USBOTG_LINK_BASE + 0x408)	/* Host Frame Number/Frame Time Remaining */
#define S3C_OTG_HPTXSTS		(USBOTG_LINK_BASE + 0x410)	/* Host Periodic Transmit FIFO/Queue Status */
#define S3C_OTG_HAINT		(USBOTG_LINK_BASE + 0x414)	/* Host All Channels Interrupt */
#define S3C_OTG_HAINTMSK	(USBOTG_LINK_BASE + 0x418)	/* Host All Channels Interrupt Mask */

/* Host Port Control & Status Registers */
#define S3C_OTG_HPRT		(USBOTG_LINK_BASE + 0x440)	/* Host Port Control & Status */

/* Host Channel-Specific Registers */
#define S3C_OTG_HCCHAR0		(USBOTG_LINK_BASE + 0x500)	/* Host Channel-0 Characteristics */
#define S3C_OTG_HCSPLT0		(USBOTG_LINK_BASE + 0x504)	/* Host Channel-0 Split Control */
#define S3C_OTG_HCINT0		(USBOTG_LINK_BASE + 0x508)	/* Host Channel-0 Interrupt */
#define S3C_OTG_HCINTMSK0	(USBOTG_LINK_BASE + 0x50C)	/* Host Channel-0 Interrupt Mask */
#define S3C_OTG_HCTSIZ0		(USBOTG_LINK_BASE + 0x510)	/* Host Channel-0 Transfer Size */
#define S3C_OTG_HCDMA0		(USBOTG_LINK_BASE + 0x514)	/* Host Channel-0 DMA Address */


/* Device Global Registers */
#define S3C_OTG_DCFG		(USBOTG_LINK_BASE + 0x800)	/* Device Configuration */
#define S3C_OTG_DCTL		(USBOTG_LINK_BASE + 0x804)	/* Device Control */
#define S3C_OTG_DSTS		(USBOTG_LINK_BASE + 0x808)	/* Device Status */
#define S3C_OTG_DIEPMSK 	(USBOTG_LINK_BASE + 0x810)	/* Device IN Endpoint Common Interrupt Mask */
#define S3C_OTG_DOEPMSK 	(USBOTG_LINK_BASE + 0x814)	/* Device OUT Endpoint Common Interrupt Mask */
#define S3C_OTG_DAINT		(USBOTG_LINK_BASE + 0x818)	/* Device All Endpoints Interrupt */
#define S3C_OTG_DAINTMSK	(USBOTG_LINK_BASE + 0x81C)	/* Device All Endpoints Interrupt Mask */
#define S3C_OTG_DTKNQR1 	(USBOTG_LINK_BASE + 0x820)	/* Device IN Token Sequence Learning Queue Read 1 */
#define S3C_OTG_DTKNQR2 	(USBOTG_LINK_BASE + 0x824)	/* Device IN Token Sequence Learning Queue Read 2 */
#define S3C_OTG_DVBUSDIS	(USBOTG_LINK_BASE + 0x828)	/* Device VBUS Discharge Time */
#define S3C_OTG_DVBUSPULSE	(USBOTG_LINK_BASE + 0x82C)	/* Device VBUS Pulsing Time */
#define S3C_OTG_DTKNQR3 	(USBOTG_LINK_BASE + 0x830)	/* Device IN Token Sequence Learning Queue Read 3 */
#define S3C_OTG_DTKNQR4 	(USBOTG_LINK_BASE + 0x834)	/* Device IN Token Sequence Learning Queue Read 4 */

/* Device Logical IN Endpoint-Specific Registers */
#define S3C_OTG_DIEPCTL0	(USBOTG_LINK_BASE + 0x900)	/* Device IN Endpoint 0 Control */
#define S3C_OTG_DIEPINT0	(USBOTG_LINK_BASE + 0x908)	/* Device IN Endpoint 0 Interrupt */
#define S3C_OTG_DIEPTSIZ0	(USBOTG_LINK_BASE + 0x910)	/* Device IN Endpoint 0 Transfer Size */
#define S3C_OTG_DIEPDMA0	(USBOTG_LINK_BASE + 0x914)	/* Device IN Endpoint 0 DMA Address */

/* Device Logical OUT Endpoint-Specific Registers */
#define S3C_OTG_DOEPCTL0	(USBOTG_LINK_BASE + 0xB00)	/* Device OUT Endpoint 0 Control */
#define S3C_OTG_DOEPINT0	(USBOTG_LINK_BASE + 0xB08)	/* Device OUT Endpoint 0 Interrupt */
#define S3C_OTG_DOEPTSIZ0	(USBOTG_LINK_BASE + 0xB10)	/* Device OUT Endpoint 0 Transfer Size */
#define S3C_OTG_DOEPDMA0	(USBOTG_LINK_BASE + 0xB14)	/* Device OUT Endpoint 0 DMA Address */

/* Power & clock gating registers */
#define S3C_OTG_PCGCCTRL	(USBOTG_LINK_BASE + 0xE00)

/* Endpoint FIFO address */
#define S3C_OTG_EP0_FIFO	(USBOTG_LINK_BASE + 0x1000)



/* OTG PHY CORE REGISTERS */
#define S3C_OTG_PHYPWR		(USBOTG_PHY_BASE+0x00)
#define S3C_OTG_PHYCTRL		(USBOTG_PHY_BASE+0x04)
#define S3C_OTG_RSTCON		(USBOTG_PHY_BASE+0x08)

/* USB Global Interrupt Status register(GINTSTS) setting value */
#define GINTSTS_WkUpInt		(1<<31)
#define GINTSTS_OEPInt		(1<<19)
#define GINTSTS_IEPInt		(1<<18)
#define GINTSTS_EnumDone	(1<<13)
#define GINTSTS_USBRst		(1<<12)
#define GINTSTS_USBSusp		(1<<11)
#define GINTSTS_RXFLvl		(1<<4)

/* include common stuff */
#ifndef __ASSEMBLY__
static inline S5P64XX_MEMCTL * S5P64XX_GetBase_MEMCTL(void)
{
	return (S5P64XX_MEMCTL *)(ELFIN_DMC0_BASE);
}
static inline S5P64XX_USB_HOST * S5P64XX_GetBase_USB_HOST(void)
{
	return (S5P64XX_USB_HOST *)ELFIN_USB_HOST_BASE;
}
static inline S5P64XX_INTERRUPT * S5P64XX_GetBase_INTERRUPT(void)
{
	return (S5P64XX_INTERRUPT *)ELFIN_VIC0_BASE_ADDR;
}
static inline S5P64XX_DMAS * S5P64XX_GetBase_DMAS(void)
{
	return (S5P64XX_DMAS *)ELFIN_DMA_BASE;
}
static inline S5P64XX_CLOCK_POWER * S5P64XX_GetBase_CLOCK_POWER(void)
{
	return (S5P64XX_CLOCK_POWER *)ELFIN_CLOCK_POWER_BASE;
}
static inline S5P64XX_LCD * S5P64XX_GetBase_LCD(void)
{
	return (S5P64XX_LCD *)ELFIN_LCD_BASE;
}
/*
static inline S3C2410_NAND * S3C2410_GetBase_NAND(void)
{
	return (S3C2410_NAND *)ELFIN_NAND_BASE;
}
*/
static inline S5P64XX_UART * S5P64XX_GetBase_UART(S5P64XX_UARTS_NR nr)
{
//	return (S5P64XX_UART *)(ELFIN_UART_BASE + (nr * 0x4000));
	return (S5P64XX_UART *)(ELFIN_UART_BASE + (nr*0x400));
}
static inline S5P64XX_TIMERS * S5P64XX_GetBase_TIMERS(void)
{
	return (S5P64XX_TIMERS *)ELFIN_TIMER_BASE;
}
/*
static inline S5P64XX_USB_DEVICE * S5P64XX_GetBase_USB_DEVICE(void)
{
	return (S5P64XX_USB_DEVICE *)ELFIN_USB_DEVICE_BASE;
}
*/
static inline S5P64XX_WATCHDOG * S5P64XX_GetBase_WATCHDOG(void)
{
	return (S5P64XX_WATCHDOG *)ELFIN_WATCHDOG_BASE;
}
static inline S5P64XX_I2C * S5P64XX_GetBase_I2C(void)
{
	return (S5P64XX_I2C *)ELFIN_I2C_BASE;
}
static inline S5P64XX_I2S * S5P64XX_GetBase_I2S(void)
{
	return (S5P64XX_I2S *)ELFIN_I2S_BASE;
}
static inline S5P64XX_GPIO * S5P64XX_GetBase_GPIO(void)
{
	return (S5P64XX_GPIO *)ELFIN_GPIO_BASE;
}
static inline S5P64XX_RTC * S5P64XX_GetBase_RTC(void)
{
	return (S5P64XX_RTC *)ELFIN_RTC_BASE;
}
static inline S3C2410_ADC * S3C2410_GetBase_ADC(void)
{
	return (S3C2410_ADC *)ELFIN_ADC_BASE;
}
static inline S5P64XX_SPI * S5P64XX_GetBase_SPI(void)
{
	return (S5P64XX_SPI *)ELFIN_SPI_BASE;
}
#if 0
static inline S3C2410_SDI * S3C2410_GetBase_SDI(void)
{
	return (S3C2410_SDI *)ELFIN_SDI_BASE;
}
#endif
#else /* #ifndef __ASSEMBLY__ */

/* watchdog */
#define WTCON_OFFSET		0x00

/* LCD controller */
#define LCDBGCON_OFFSET		0x5c

#endif /* #ifndef __ASSEMBLY__ */

/* PENDING BIT */
#define BIT_EINT0		(0x1)
#define BIT_EINT1		(0x1<<1)
#define BIT_EINT2		(0x1<<2)
#define BIT_EINT3		(0x1<<3)
#define BIT_EINT4_7		(0x1<<4)
#define BIT_EINT8_23		(0x1<<5)
#define BIT_BAT_FLT		(0x1<<7)
#define BIT_TICK		(0x1<<8)
#define BIT_WDT			(0x1<<9)
#define BIT_TIMER0		(0x1<<10)
#define BIT_TIMER1		(0x1<<11)
#define BIT_TIMER2		(0x1<<12)
#define BIT_TIMER3		(0x1<<13)
#define BIT_TIMER4		(0x1<<14)
#define BIT_UART2		(0x1<<15)
#define BIT_LCD			(0x1<<16)
#define BIT_DMA0		(0x1<<17)
#define BIT_DMA1		(0x1<<18)
#define BIT_DMA2		(0x1<<19)
#define BIT_DMA3		(0x1<<20)
#define BIT_SDI			(0x1<<21)
#define BIT_SPI0		(0x1<<22)
#define BIT_UART1		(0x1<<23)
#define BIT_USBH		(0x1<<26)
#define BIT_IIC			(0x1<<27)
#define BIT_UART0		(0x1<<28)
#define BIT_SPI1		(0x1<<29)
#define BIT_RTC			(0x1<<30)
#define BIT_ADC			(0x1<<31)
#define BIT_ALLMSK		(0xFFFFFFFF)

#endif /*__S5P6440_H__*/
