;------------------------------------------------------------------------------
;
;  Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
;  Use of this source code is subject to the terms of the Microsoft end-user
;  license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
;  If you did not accept the terms of the EULA, you are not authorized to use
;  this source code. For a copy of the EULA, please see the LICENSE.RTF on your
;  install media.
;
;------------------------------------------------------------------------------
;
;   File:  startup.s
;
;   Kernel startup routine for Samsung SMDKV210 board. Hardware is
;   initialized in boot loader - so there isn't much code at all.
;
;------------------------------------------------------------------------------

        INCLUDE     kxarm.h
        INCLUDE     register_map.inc
        INCLUDE     image_cfg.inc

        IMPORT      System_EnableBP
        IMPORT      CPUWakeupFromSleep
        IMPORT      CPUWakeupFromDeepIdle        
        IMPORT      KernelStart



;------------------------------------------------------------------------------
;	Macro For VFP
;------------------------------------------------------------------------------
VFPEnable	EQU		0x40000000


        TEXTAREA
        
;------------------------------------------------------------------------------
;
;    StartUp Entry
;
;    Main entry point for CPU initialization.
;
;------------------------------------------------------------------------------

    LEAF_ENTRY      StartUp

        b        ResetHandler                ; Jump over Power-Off code

HandlerUndef
        b        HandlerUndef

HandlerSWI
        b        HandlerSWI

HandlerPabort
        b        HandlerPabort

HandlerDabort
        b        HandlerDabort

HandlerReserved
        b        HandlerReserved

HandlerIRQ
        b        HandlerIRQ

HandlerFIQ
        b        HandlerFIQ

;------------------------------------------------------------------------------
;    End of StartUp
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
;
;    ResetHandler Function
;
;    Reset Exception Handler
;
;------------------------------------------------------------------------------

ResetHandler

	
;------------------------------------
;	DeepIdle
;	(WakeUp Processing)
;------------------------------------
        ldr     r0, =RST_STAT
        ldr     r1, [r0]
        and     r1, r1, #BP_DIDLE_WAKEUP
        cmp     r1, #BP_DIDLE_WAKEUP
        bne     Check_Wake_from_sleep    		; is not DeepIdle WakeUp      

	bl 	CPUWakeupFromDeepIdle

Check_Wake_from_sleep

;------------------------------------
;    Power Management Routine
;    (WakeUp Processing)
;------------------------------------
        ldr     r0, =RST_STAT
        ldr     r1, [r0]
        and     r1, r1, #BP_SLEEP_WAKEUP
        cmp     r1, #BP_SLEEP_WAKEUP
        bne     BringUp_WinCE_from_Reset                ; Normal Mode Booting

        bl       CPUWakeupFromSleep

BringUp_WinCE_from_Reset

;------------------------------------
;    Flush TLB, Invalidate ICache, DCache
;------------------------------------

        mov     r0, #0
        mcr     p15, 0, r0, c8, c7, 0                   ; flush both TLB
        mcr     p15, 0, r0, c7, c5, 0                   ; invalidate instruction cache
        mcr     p15, 0, r0, c7, c6, 2                   ; invalidate data cache for Cortex by shin...0819

;------------------------------------
;    Enable Branch Prediction
;------------------------------------
        bl      System_EnableBP

;------------------------------------
;    Jump to KernelStart
;------------------------------------
        add     r0, pc, #g_oalAddressTable - (. + 8)
        bl      KernelStart                       
        b       .                                       ; Should not be here...

        INCLUDE    oemaddrtab_cfg.inc
        
        ENTRY_END

;------------------------------------------------------------------------------
;    End of ResetHandler
;------------------------------------------------------------------------------


        END

