//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// -----------------------------------------------------------------------------
//
//      THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//      ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
//      THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//      PARTICULAR PURPOSE.
//
// -----------------------------------------------------------------------------
#include <windows.h>
#include <bsp.h>
#ifdef _IROM_SDMMC_
#include <hsmmcdrv.h>
#endif

VOID BSPPowerOff()
{

    volatile RTC_REG *pRTCReg;

    OALMSG(TRUE, (TEXT("++BSPPowerOff()\n")));

    pRTCReg = (RTC_REG*)OALPAtoVA(BASE_REG_PA_RTC, FALSE);

    // RTC Control Disable
    pRTCReg->RTCCON = 0x0;            // Subclk 32768 Hz, No Reset, Merged BCD counter, XTAL 2^-15, Control Disable

    OALMSG(TRUE, (TEXT("--BSPPowerOff()\n")));
}


VOID BSPPowerOn()
{


#ifdef _IROM_SDMMC_
    OALMSG(TRUE, (TEXT("++BSPPowerOn()\n")));
	while(!SDHC_INIT())
	{
	}
    OALMSG(TRUE, (TEXT("--BSPPowerOn()\n")));

#else
    volatile NAND_REG *pNANDReg;

// enable rtc
	 volatile RTC_REG *pRTCReg;
    pRTCReg = (RTC_REG*)OALPAtoVA(BASE_REG_PA_RTC, FALSE);
    pRTCReg->RTCCON = 0x1;  
//----------------------

    OALMSG(TRUE, (TEXT("++BSPPowerOn()\n")));

    pNANDReg = (NAND_REG *)OALPAtoVA(BASE_REG_PA_NFCON, FALSE);

    pNANDReg->NFCONF = (NAND_TACLS  <<  12) | (NAND_TWRPH0 <<  8) | (NAND_TWRPH1 <<  4);
    pNANDReg->NFCONT = (0<<17)|(0<<16)|(0<<10)|(0<<9)|(0<<8)|(1<<7)|(1<<6)|(1<<5)|(1<<4)|(0x3<<1)|(1<<0);
    pNANDReg->NFSTAT = (1<<4);

    OALMSG(TRUE, (TEXT("--BSPPowerOn()\n")));

#endif    
}

void BSPConfigGPIOforPowerOff(void)
{
    //volatile GPIO_REG *pGPIOReg;

    OALMSG(TRUE, (TEXT("++BSPConfigGPIOforPowerOff()\n")));

    OALMSG(TRUE, (TEXT("--BSPConfigGPIOforPowerOff()\n")));
}

