//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// -----------------------------------------------------------------------------
//
//      THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//      ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
//      THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//      PARTICULAR PURPOSE.
//  
// -----------------------------------------------------------------------------
#include <windows.h>
#include <bsp.h>
#include <kitl_cfg.h>
#include <devload.h>
#include <usbdbgser.h>
#include <usbdbgrndis.h>

//------------------------------------------------------------------------------
//
// Platform entry point for KITL. Called when KITLIoctl (IOCTL_KITL_STARTUP, ...) is called.
//

BOOL OEMKitlStartup(void)
{
    OAL_KITL_ARGS KITLArgs;
    OAL_KITL_ARGS *pKITLArgs = NULL;	
    BSP_ARGS *pArgs = (BSP_ARGS*)IMAGE_SHARE_ARGS_UA_START;
	char szDevName[OAL_KITL_ID_SIZE] = { 0,};

    if( pArgs->bKITLBoot == FALSE )
    {
        KITLOutputDebugString("KITL was not enabled by the bootloader\r\n");
        return FALSE;
    }

    KITLOutputDebugString ("[KITL] KITL is enable\r\n");

	if(pArgs->KITLType == OAL_KITL_TYPE_SERIAL )
    {
        memset(&KITLArgs, 0, sizeof(OAL_KITL_ARGS));
        
        KITLArgs.flags |= OAL_KITL_FLAGS_ENABLED;

        KITLArgs.devLoc.IfcType     = Internal;
        KITLArgs.devLoc.BusNumber   = 0;
        KITLArgs.devLoc.PhysicalLoc = (PVOID)BASE_REG_PA_USBOTG_LINK;
        KITLArgs.devLoc.LogicalLoc  = (DWORD)KITLArgs.devLoc.PhysicalLoc;

        pKITLArgs = &KITLArgs;

        pKITLArgs->flags |= OAL_KITL_FLAGS_POLL; 
		memcpy ((void *)szDevName, (void *)("V210USBSerial"), strlen("V210USBSerial")+1);
    }
	else if(pArgs->KITLType == OAL_KITL_TYPE_ETH )
    {
        memset(&KITLArgs, 0, sizeof(OAL_KITL_ARGS));
        
        KITLArgs.flags |= (OAL_KITL_FLAGS_ENABLED | OAL_KITL_FLAGS_VMINI);// | OAL_KITL_FLAGS_DHCP);
        KITLArgs.devLoc.IfcType     = InterfaceTypeUndefined;
        KITLArgs.devLoc.BusNumber   = 0;
        KITLArgs.devLoc.PhysicalLoc = (PVOID)BASE_REG_PA_USBOTG_LINK;
        KITLArgs.devLoc.LogicalLoc  = (DWORD)KITLArgs.devLoc.PhysicalLoc;
		KITLArgs.devLoc.Pin  = IRQ_OTG;
		KITLArgs.mac[0] = 0x1234; // it is not used. just fill it as not 0x0 
		KITLArgs.mac[1] = 0x1234; 
		KITLArgs.mac[2] = 0x1234;
		KITLArgs.ipAddress = 0x6501fea9; // default 169.254.1.101
		KITLArgs.ipMask = 0x00ffffff; // default 255.255.255.0
		KITLArgs.ipRoute = 0x0001fea9; // default 169.254.1.0

        pKITLArgs = &KITLArgs;

        pKITLArgs->flags |= OAL_KITL_FLAGS_POLL ; 
		memcpy ((void *)szDevName, (void *)("V210USBRndis"), strlen("V210USBRndis")+1);
    }

	

	KITLOutputDebugString ("[KITL]Wait for Connection\r\n");
    if(OALKitlInit ((LPCSTR)szDevName, pKITLArgs, g_kitlDevices) == FALSE)
    {
        KITLOutputDebugString("OALKitlInit was failed\r\n");
        return FALSE;
    }
    else
    {
        KITLOutputDebugString("KITL was initialized successfully\r\n");
        return TRUE;
    }
}   
    

//------------------------------------------------------------------------------
//
//  Function:  OALGetTickCount
//
//  This function is called by some KITL libraries to obtain relative time
//  since device boot. It is mostly used to implement timeout in network
//  protocol.
//
UINT32 OALGetTickCount()
{
    return OEMKitlGetSecs () * 1000;
}


DWORD OEMKitlGetSecs (void)
{
    SYSTEMTIME st;
    DWORD dwRet;
    static DWORD dwBias;
    static DWORD dwLastTime;

    OEMGetRealTime( &st );
    dwRet = ((60UL * (60UL * (24UL * (31UL * st.wMonth + st.wDay) + st.wHour) + st.wMinute)) + st.wSecond);
    dwBias = dwRet;

    if (dwRet < dwLastTime)
    {
        KITLOutputDebugString("[KITL] Time went backwards (or wrapped): cur: %u, last %u\n", dwRet,dwLastTime);
    }

    dwLastTime = dwRet;

    return (dwRet);
}

//------------------------------------------------------------------------------
//
//  Function:  OEMKitlIoctl
//
//  This function is called by some KITL libraries to process platform specific
//  KITL IoCtl calls.
//
BOOL OEMKitlIoctl (DWORD code, VOID * pInBuffer, DWORD inSize, VOID * pOutBuffer, DWORD outSize, DWORD * pOutSize)
{
    BOOL fRet = FALSE;

    switch (code) {
        case IOCTL_HAL_INITREGISTRY:
            OALKitlInitRegistry();
            break;
        default:
            fRet = OALIoCtlVBridge (code, pInBuffer, inSize, pOutBuffer, outSize, pOutSize);
    }
    return fRet;
}


//------------------------------------------------------------------------------
//
//  Function:  OALKitlInitRegistry
//
//  This function is called during the initialization process to allow the
//  OAL to denote devices which are being used by the KITL connection
//  and thus shouldn't be touched during the OS initialization process.  The
//  OAL provides this information via the registry.
//

VOID OALKitlInitRegistry()
{
    HKEY Key;
    DWORD Status;
    DWORD Disposition;
    DEVICE_LOCATION devLoc;

    // Get KITL device location
    if (!OALKitlGetDevLoc(&devLoc))
        goto CleanUp;

    if (devLoc.LogicalLoc == BASE_REG_PA_USBOTG_LINK)
    {
        // Disable the UsbFn driver since it is used for KITL
        //

        Status = NKRegCreateKeyEx(HKEY_LOCAL_MACHINE, L"Drivers\\BuiltIn\\USBFN", 0, NULL, 0, 0, NULL, &Key, &Disposition);

        if (Status == ERROR_SUCCESS)
        {
            Disposition = DEVFLAGS_NOLOAD;
            // Set Flags value to indicate no loading of driver for this device
            Status = NKRegSetValueEx(Key, DEVLOAD_FLAGS_VALNAME, 0, DEVLOAD_FLAGS_VALTYPE, (PBYTE)&Disposition, sizeof(Disposition));
        }

        // Close the registry key.
        NKRegCloseKey(Key);

        if (Status != ERROR_SUCCESS)
        {
            KITLOutputDebugString("OALKitlInitRegistry: failed to set \"no load\" key for Usbfn drvier.\r\n");
            goto CleanUp;
        }

        KITLOutputDebugString("INFO: USB being used for KITL - disabling Usbfn drvier...\r\n");
    }

CleanUp:
    return;
}


