;------------------------------------------------------------------------------
;
;  File:  memory_cfg.inc
;
;  This file is used to define g_oalAddressTable. This table is passed to
;  KernelStart to estabilish physical to virtual memory mapping. This table
;  is used also in IOMEM OAL module to map between physical and virtual
;  memory addresses via OALPAtoVA/OALVAtoPA functions.
;
;------------------------------------------------------------------------------

; Export Definition

        EXPORT  g_oalAddressTable[DATA]

;------------------------------------------------------------------------------
;
; TABLE FORMAT
;       cached address, physical address, size
;------------------------------------------------------------------------------
 
g_oalAddressTable
        ; Define only used IP Block in OAL 
        ; and comment which sw module this IP block will be used in

        DCD	DRAM_BASE_CA_START,             DRAM_BASE_PA_START,		    128 ; 128 MB DRAM
        DCD DRAM0_BASE_CA_START,            DRAM0_BASE_PA_START,        128 ; 128 MB DRAM on DMC0        
        DCD	BASE_REG_CA_CHIPID,             BASE_REG_PA_CHIPID, 	    43  ; 43 MB SFR
        ; PA: 0xE000_0000 (CHIP_ID)  -  VA: 0x9000_0000
    	;   		~ 
    	; PA: 0xE2A0_0000 (I2S2)     -  VA: 0x92A0_0000
        DCD	BASE_REG_CA_SROM, 	            BASE_REG_PA_SROM,           	1
        DCD	BASE_REG_CA_CFCON, 	            BASE_REG_PA_CFCON,          	1
        DCD	BASE_REG_CA_SECSS, 	            BASE_REG_PA_SECSS, 	            1   ; SECSS        
        DCD	BASE_REG_CA_SDMMC0,             BASE_REG_PA_SDMMC0, 	        5   ; SDMMC/TSI
        DCD	BASE_REG_CA_USBOTG_LINK,        BASE_REG_PA_USBOTG_LINK,        4   ; USB OTG/USB HOST
        DCD BASE_REG_CA_MSBM,               BASE_REG_PA_MSBM, 	            2   ; MODEM
        DCD	BASE_REG_CA_AUDIO_SS,           BASE_REG_PA_AUDIO_SS, 	        16  ; AUDIO_SS
        DCD	BASE_REG_CA_DMC0,               BASE_REG_PA_DMC0, 	            1   ; DMC0
        DCD	BASE_REG_CA_AXI_MSYS,           BASE_REG_PA_AXI_MSYS, 	        3   ; AXI_MSYS/AXI_MSFR/AXI_VSYS
        DCD	BASE_REG_CA_DMC1,               BASE_REG_PA_DMC1, 	            2   ; DMC1/TZPC0/SDM/MFC/ASYNC_AXI_APBIF
        DCD	BASE_REG_CA_SDM,                BASE_REG_PA_SDM, 	            2   ; SDM, MFC
        DCD	BASE_REG_CA_ASYNC_MFC_VSYS0,    BASE_REG_PA_ASYNC_MFC_VSYS0, 	8   ; SDM, MFC
        DCD	BASE_REG_CA_VIC0,               BASE_REG_PA_VIC0, 	            4   ; VIC
        DCD	BASE_REG_CA_TZIC0,              BASE_REG_PA_TZIC0, 	            4   ; TZIC
        DCD BASE_REG_CA_FIMG_3DSE,          BASE_REG_PA_FIMG_3DSE, 	        16  ; 3D
        DCD BASE_REG_CA_FIMD,               BASE_REG_PA_FIMD, 	            3   ; FIMD/MIE
        DCD BASE_REG_CA_TVENC,              BASE_REG_PA_TVENC, 	            3   ; TVENC/VP/MIXER
        DCD BASE_REG_CA_HDMISS,             BASE_REG_PA_HDMISS, 	        1   ; HDMI_LINK
        DCD	BASE_REG_CA_MDMA,               BASE_REG_PA_MDMA, 	            2   ; SDMA, MDMA
        DCD	BASE_REG_CA_AXI_LSYS,           BASE_REG_PA_AXI_LSYS,	        1   ; AXI_LSYS
        DCD	BASE_REG_CA_DSIM,               BASE_REG_PA_DSIM,	            2   ; DISM, CSIS
        DCD	BASE_REG_CA_AXI_DSYS,           BASE_REG_PA_AXI_DSYS,	        9   ; AXI_DSYS, AXI_DSFR, I2C_HDMI_PHY,
        DCD	BASE_REG_CA_ROTATOR,            BASE_REG_PA_ROTATOR, 	        1   ; Rotator
        DCD	BASE_REG_CA_FIMC0,              BASE_REG_PA_FIMC0,	            3   ; FIMC0, FIMC1, FIMC2
        DCD BASE_REG_CA_JPEG,               BASE_REG_PA_JPEG, 	            2   ; JPEG/IPC
        DCD BASE_REG_CA_ONENAND_IF,         BASE_REG_PA_ONENAND_IF,         2   ; OneNAND Interface
        DCD BASE_REG_CA_ONENAND_MS,         BASE_REG_PA_ONENAND_MS,         2   ; OneNAND Microsequencer
        DCD BASE_REG_CA_ONENAND_CS,         BASE_REG_PA_ONENAND_CS,         2   ; OneNAND Control Registers
        DCD BASE_REG_CA_ONENAND_RSV,        BASE_REG_PA_ONENAND_RSV,        2   ; OneNAND Reserved
        DCD BASE_REG_CA_NFCON,              BASE_REG_PA_NFCON, 	            1   ; NFCON

		DCD BASE_REG_CA_PCM2,				BASE_REG_PA_PCM2,				1	; PCM2
		
        ;PA Extra DMC1: 0x48000000    - VA:0x99600000  Size: 0x06A00000(106MB)
        DCD DRAM_EXTRA_BASE_CA_START,       DRAM_EXTRA_BASE_PA_START, 	    74;106 ; Extra DMC1;106 ; Extra DMC1

       DCD DRAM_DM9000_BASE_CA_START,         DRAM_DM9000_BASE_PA_START,         32   ; CSn1   SROM(SRAM/ROM) BANK 1 -> DM9000A 
        DCD 0x00000000, 0x00000000, 0    ; End of Table

;------------------------------------------------------------------------------

        END
